#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-1zgiALp0iRaB08u1wcb4pq
key:                  trifecta-2.1.4-1zgiALp0iRaB08u1wcb4pq
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  a77c3cf896aab859ca7c37c08cf8627c
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-1zgiALp0iRaB08u1wcb4pq
depends:
    ansi-terminal-1.0.2-JYusxb73OETHD3sHArHcs array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-5FAgjTnNFnWBsxnY7RCdD4
    blaze-html-0.9.2.0-FdgXo84MQ5nJDnaCr5A0hJ
    blaze-markup-0.8.3.0-FTbVLvi8ymwA66L8hkAPCp bytestring-0.11.5.3
    charset-0.3.12-882E07bDL3325mUo50AyIx
    comonad-5.0.9-HhbbzCqu8yXCinyU8dzPDS containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-67T8ljqQPus9cQqAud2gP7
    ghc-prim-0.9.1 hashable-1.4.6.0-YmGjGgSp1PCYD264OAOUA
    indexed-traversable-0.1.4-LQVPMqdYEtI3MQSrB8OBIc
    lens-5.3.2-3x6i1OAeQ2c8gg8RvgTRSW mtl-2.2.2
    parsers-0.12.12-Jb1JLVdBILrAfqQNBOQVJe
    prettyprinter-1.7.1-DU2dJrN5bRm6Aoduk8wHMr
    prettyprinter-ansi-terminal-1.1.3-7KCj1mL67LzLqfzn0Ykct6
    profunctors-5.6.3-31Z97EsBcOl3NoMlhVYNxE
    reducers-3.12.5-KyOkhkdoEBN7bqjKYxsD2R transformers-0.5.6.2
    unordered-containers-0.2.20-7E9U8fDCyyE7V5F5vC663n
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

