#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-E8TtXbBQdKRAKJp4SmgsTR
key:                  trifecta-2.1.4-E8TtXbBQdKRAKJp4SmgsTR
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  d9e2eb32a7876746c94cd00af8196712
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-E8TtXbBQdKRAKJp4SmgsTR
depends:
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-3BvkKG3rmZ5F6dgS70Rje7
    blaze-html-0.9.2.0-IDybBwOqjaeDYYIVGdUmMh
    blaze-markup-0.8.3.0-BiOu39W6ZqkIuEgphwproy bytestring-0.11.5.3
    charset-0.3.12-8pFhWVxspJZAMhSA1L3U40
    comonad-5.0.9-ElYJ8dJHwQS2Hj5UoiqgAW containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-AEyS1fE9L4RIn3mDI7a9Oe
    ghc-prim-0.9.1 hashable-1.4.6.0-8MG0S5dfyXU6lRGLMgbs1l
    indexed-traversable-0.1.4-1hTsLhK6E4tI5A8Ow8lBff
    lens-5.3.2-2XqN7dz4nG34Xtk8WfM3fs mtl-2.2.2
    parsers-0.12.12-LCstr1OOarbKBmGQCnwBvJ
    prettyprinter-1.7.1-1bGrHmHQilYFdKnOhsKcRi
    prettyprinter-ansi-terminal-1.1.3-YFnQxSjmLFCvcICXGVVkT
    profunctors-5.6.3-1MRdcva7iD2KhEGv1D037x
    reducers-3.12.5-H0aqeoW7H0FJQj5sieEtKO transformers-0.5.6.2
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

