#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-1fene7DD28cBsGHSyrkRB2
key:                  trifecta-2.1.4-1fene7DD28cBsGHSyrkRB2
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  c5b65b761d5a5d35057d799ced36471f
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-1fene7DD28cBsGHSyrkRB2
depends:
    ansi-terminal-1.0.2-Bnl76ueL4Li3NnUVLDNwn4 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-FdvYzjGZ959q5AWVftoiu
    blaze-html-0.9.2.0-FBLNV7ZdEiX1CRroFdfhP1
    blaze-markup-0.8.3.0-ErSrRvmFiTqgYHgGjH7r3 bytestring-0.11.5.3
    charset-0.3.12-21vkCEcaIymDcAMuHmZN74
    comonad-5.0.9-E1C1l9NBaFSECExeDkOqzn containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-8FyEm8XQsxBAuq1pGjETBu
    ghc-prim-0.9.1 hashable-1.4.6.0-HNsjIjcKtfz4EPsBV3Crzv
    indexed-traversable-0.1.4-LEIrmfAgnpb6NsyAYoysCc
    lens-5.3.2-DlnMzXp6T2vRa3tLj6rdI mtl-2.2.2
    parsers-0.12.12-JgEvWL84uirF9ZC5kawQtq
    prettyprinter-1.7.1-KHTd6ELn8JD9j39b7JIrXU
    prettyprinter-ansi-terminal-1.1.3-1UfbVX11m0EFNFdqWdhwHG
    profunctors-5.6.3-3xdK71w5Rem1LIyDn6Gpns
    reducers-3.12.5-INB0cOt6shPFIU81Cfhf3o transformers-0.5.6.2
    unordered-containers-0.2.20-2t1vPVJZrFoJrApu3o7oBM
    utf8-string-1.0.2-LtGEIYPp5RR87I6rMd4Fpy

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

