#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-8TtQTZkdYslH2oDhIiaBek
key:                  trifecta-2.1.4-8TtQTZkdYslH2oDhIiaBek
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  852db6a51d28f1b7bb886776c392bcdd
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-8TtQTZkdYslH2oDhIiaBek
depends:
    ansi-terminal-1.0.2-LCUEwZc5qNZJRy74Vr4a1h array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-CyyXjLOhYIdJGqQMifnVAh
    blaze-html-0.9.2.0-HtuITEJLeBV807zyf9AYJy
    blaze-markup-0.8.3.0-6IdQvNChVYMC2rukwZbaTG bytestring-0.11.5.3
    charset-0.3.12-JO3ysdDJDEgCYAnX5f6M3c
    comonad-5.0.9-6DHx4ahgZyk978E28fgJLO containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-90ohzvVgKPWCWAbZHMxAId
    ghc-prim-0.9.1 hashable-1.4.7.0-GgneweRn8eTKcMM4X3n956
    indexed-traversable-0.1.4-7gBVHmZFzpQ83JoiKc0FfD
    lens-5.3.2-Do7BRGZKCykCgu16LW7xBK mtl-2.2.2
    parsers-0.12.12-ihqet4fuoxFRlRUwFGy3H
    prettyprinter-1.7.1-HSfe9r3toGeG5iYKvTbBEv
    prettyprinter-ansi-terminal-1.1.3-HBd0HlPB5W983yTXobQ0Tw
    profunctors-5.6.3-57Vii8lsGjb8Sv8yDru9Nj
    reducers-3.12.5-Km53029FpTm3ffz6HajjvX transformers-0.5.6.2
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    utf8-string-1.0.2-Kx3GnjsHBwcIRYSetT14kb

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

