#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 unicode-data
version:              0.5.0
visibility:           public
id:                   unicode-data-0.5.0-ArJmF5GCsYG4BVOJrLDPRl
key:                  unicode-data-0.5.0-ArJmF5GCsYG4BVOJrLDPRl
license:              Apache-2.0
copyright:            2020 Composewell Technologies and Contributors
maintainer:           streamly@composewell.com
author:               Composewell Technologies and Contributors
stability:            Experimental
homepage:             http://github.com/composewell/unicode-data
synopsis:             Access Unicode Character Database (UCD)
description:
    @unicode-data@ provides Haskell APIs to efficiently access the
    <https://www.unicode.org/ucd/ Unicode character database> (UCD).
    Performance is the primary goal in the design of this package.

    The Haskell data structures are generated programmatically from the UCD files.
    The latest Unicode version supported by this library is
    @<https://www.unicode.org/versions/Unicode15.0.0/ 15.0.0>@.

category:             Data,Text,Unicode
abi:                  fade56d1eb09c553a021e289e7346981
exposed:              True
exposed-modules:
    Unicode.Char Unicode.Char.Case Unicode.Char.Case.Compat
    Unicode.Char.General Unicode.Char.General.Blocks
    Unicode.Char.General.Compat Unicode.Char.Identifiers
    Unicode.Char.Normalization Unicode.Char.Numeric
    Unicode.Char.Numeric.Compat Unicode.Internal.Bits
    Unicode.Internal.Char.Blocks Unicode.Internal.Char.CaseFolding
    Unicode.Internal.Char.DerivedCoreProperties
    Unicode.Internal.Char.DerivedNumericValues
    Unicode.Internal.Char.PropList
    Unicode.Internal.Char.SpecialCasing.LowerCaseMapping
    Unicode.Internal.Char.SpecialCasing.TitleCaseMapping
    Unicode.Internal.Char.SpecialCasing.UpperCaseMapping
    Unicode.Internal.Char.UnicodeData.CombiningClass
    Unicode.Internal.Char.UnicodeData.Compositions
    Unicode.Internal.Char.UnicodeData.Decomposable
    Unicode.Internal.Char.UnicodeData.DecomposableK
    Unicode.Internal.Char.UnicodeData.Decompositions
    Unicode.Internal.Char.UnicodeData.DecompositionsK
    Unicode.Internal.Char.UnicodeData.DecompositionsK2
    Unicode.Internal.Char.UnicodeData.GeneralCategory
    Unicode.Internal.Char.UnicodeData.SimpleLowerCaseMapping
    Unicode.Internal.Char.UnicodeData.SimpleTitleCaseMapping
    Unicode.Internal.Char.UnicodeData.SimpleUpperCaseMapping
    Unicode.Internal.Char.Version Unicode.Internal.Division
    Unicode.Internal.Unfold

import-dirs:          /usr/lib/ghc-9.4.8/site-local/unicode-data-0.5.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/unicode-data-0.5.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/unicode-data-0.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-unicode-data
hs-libraries:         HSunicode-data-0.5.0-ArJmF5GCsYG4BVOJrLDPRl
depends:              base-4.17.2.1
haddock-interfaces:
    /usr/share/doc/haskell-unicode-data/html/unicode-data.haddock

haddock-html:         /usr/share/doc/haskell-unicode-data/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

