#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 uniplate
version:              1.6.13
visibility:           public
id:                   uniplate-1.6.13-CgB8Qq2Mn9TKcBV0Vvv0Wg
key:                  uniplate-1.6.13-CgB8Qq2Mn9TKcBV0Vvv0Wg
license:              BSD-3-Clause
copyright:            Neil Mitchell 2006-2020
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/uniplate#readme
synopsis:             Help writing simple, concise and fast generic operations.
description:
    Uniplate is library for writing simple and concise generic operations.
    Uniplate has similar goals to the original Scrap Your Boilerplate work,
    but is substantially simpler and faster.

    To get started with Uniplate you should import one of the three following
    modules:

    * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
    Most users should start by importing this module.

    * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
    with substantially higher performance (around 5 times), but requires writing
    instance declarations.

    * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
    by Uniplate. Both the above two modules re-export this module.

    In addition, some users may want to make use of the following modules:

    * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.

    * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.

    * "Data.Generics.Compos" - users transitioning from the Compos library.

    * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
    to avoid getting instance conflicts.

category:             Generics
abi:                  432e8e5280994711ef82eff0725c1555
exposed:              True
exposed-modules:
    Data.Generics.Biplate Data.Generics.Compos Data.Generics.PlateData
    Data.Generics.PlateDirect Data.Generics.PlateTypeable
    Data.Generics.SYB Data.Generics.Str Data.Generics.Uniplate
    Data.Generics.Uniplate.Data Data.Generics.Uniplate.Data.Instances
    Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
    Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
    Data.Generics.Uniplate.Zipper Data.Generics.UniplateOn
    Data.Generics.UniplateStr Data.Generics.UniplateStrOn

hidden-modules:
    Data.Generics.Uniplate.Internal.Data
    Data.Generics.Uniplate.Internal.DataOnlyOperations
    Data.Generics.Uniplate.Internal.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/uniplate-1.6.13
library-dirs:         /usr/lib/ghc-9.4.8/site-local/uniplate-1.6.13
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/uniplate-1.6.13
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uniplate
hs-libraries:         HSuniplate-1.6.13-CgB8Qq2Mn9TKcBV0Vvv0Wg
depends:
    base-4.17.2.1 containers-0.6.7 ghc-prim-0.9.1
    hashable-1.4.5.0-EdCBZmCkEma7WCMhhvMdNf
    syb-0.7.3-8GhIGJRTl8LHsLkHRBNJ0N
    unordered-containers-0.2.20-KWLixwBKCEK6ORqUSVo2CW

haddock-interfaces:   /usr/share/doc/haskell-uniplate/html/uniplate.haddock
haddock-html:         /usr/share/doc/haskell-uniplate/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

