#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vector-binary-instances
version:              0.2.5.2
visibility:           public
id:                   vector-binary-instances-0.2.5.2-I0yM0ITYm1WGwWrsWxnuA6
key:                  vector-binary-instances-0.2.5.2-I0yM0ITYm1WGwWrsWxnuA6
license:              BSD-3-Clause
maintainer:
    dons00@gmail.com, bos@serpentine.com, Ben Gamari <ben@smart-cactus.org>

author:               Don Stewart
stability:            Experimental
homepage:             https://github.com/bos/vector-binary-instances
synopsis:             Instances of Data.Binary for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
    .
    Try the cereal-vector package if you are looking for Data.Serialize
    instances.

category:             Data
abi:                  2c8744dfb50b814e649e74cebef09c68
exposed:              True
exposed-modules:      Data.Vector.Binary
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/vector-binary-instances-0.2.5.2

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/vector-binary-instances-0.2.5.2

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/vector-binary-instances-0.2.5.2

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector-binary-instances
hs-libraries:         HSvector-binary-instances-0.2.5.2-I0yM0ITYm1WGwWrsWxnuA6
depends:
    base-4.17.2.1 binary-0.8.9.1 vector-0.13.2.0-L6HpF7nmtGm1K7R40olL6U

haddock-interfaces:
    /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock

haddock-html:         /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

