!
! Copyright Intel Corporation.
! 
! This software and the related documents are Intel copyrighted materials, and
! your use of them is governed by the express license under which they were
! provided to you (License). Unless the License provides otherwise, you may
! not use, modify, copy, publish, distribute, disclose or transmit this
! software or the related documents without Intel's prior written permission.
! 
! This software and the related documents are provided as is, with no express
! or implied warranties, other than those that are expressly stated in the
! License.
!
! Copyright (C) by Argonne National Laboratory
! 
! 				  COPYRIGHT
! 
! The following is a notice of limited availability of the code, and disclaimer
! which must be included in the prologue of the code and in all source listings
! of the code.
! 
! Copyright Notice
! 1998--2020, Argonne National Laboratory
! 
! Permission is hereby granted to use, reproduce, prepare derivative works, and
! to redistribute to others.  This software was authored by:
! 
! Mathematics and Computer Science Division
! Argonne National Laboratory, Argonne IL 60439
! 
! (and)
! 
! Department of Computer Science
! University of Illinois at Urbana-Champaign
! 
! 
! 			      GOVERNMENT LICENSE
! 
! Portions of this material resulted from work developed under a U.S.
! Government Contract and are subject to the following license: the Government
! is granted for itself and others acting on its behalf a paid-up, nonexclusive,
! irrevocable worldwide license in this computer software to reproduce, prepare
! derivative works, and perform publicly and display publicly.
! 
! 				  DISCLAIMER
! 
! This computer code material was prepared, in part, as an account of work
! sponsored by an agency of the United States Government.  Neither the United
! States, nor the University of Chicago, nor any of their employees, makes any
! warranty express or implied, or assumes any legal liability or responsibility
! for the accuracy, completeness, or usefulness of any information, apparatus,
! product, or process disclosed, or represents that its use would not infringe
! privately owned rights.
! 
! 			   EXTERNAL CONTRIBUTIONS
! 
! Portions of this code have been contributed under the above license by:
! 
!  * Intel Corporation
!  * Cray
!  * IBM Corporation
!  * Microsoft Corporation
!  * Mellanox Technologies Ltd.
!  * DataDirect Networks.
!  * Oak Ridge National Laboratory
!  * Sun Microsystems, Lustre group
!  * Dolphin Interconnect Solutions Inc.
!  * Institut Polytechnique de Bordeaux
!
!     
!

module mpi_c_interface_glue

use, intrinsic :: iso_c_binding, only : c_char, C_NULL_CHAR

implicit none

public :: MPIR_Fortran_string_f2c
public :: MPIR_Fortran_string_c2f

public :: MPII_Comm_copy_attr_f08_proxy
public :: MPIR_Comm_delete_attr_f08_proxy
public :: MPIR_Type_copy_attr_f08_proxy
public :: MPIR_Type_delete_attr_f08_proxy
public :: MPIR_Win_copy_attr_f08_proxy
public :: MPIR_Win_delete_attr_f08_proxy
public :: MPII_Keyval_set_proxy
public :: MPIR_Grequest_set_lang_fortran

public :: MPII_Op_set_f08

! Bind to C's enum MPIR_Attr_type in mpir_attr_generic.h
enum, bind(C)
    enumerator :: MPIR_ATTR_PTR  = 0
    enumerator :: MPIR_ATTR_AINT = 1
    enumerator :: MPIR_ATTR_INT  = 3
end enum

interface

subroutine MPII_Keyval_set_proxy(keyval, attr_copy_proxy, attr_delete_proxy) bind(C, name="MPII_Keyval_set_proxy")
    use :: iso_c_binding, only : c_int, c_funptr
    integer(c_int), value, intent(in) :: keyval
    type(c_funptr), value, intent(in) :: attr_copy_proxy, attr_delete_proxy
    ! The subroutine is implemented in attrutil.c on the C side
end subroutine MPII_Keyval_set_proxy


subroutine MPII_Op_set_f08(op) bind(C, name="MPII_Op_set_f08")
    use :: mpi_c_interface_types, only : c_Op
    integer(c_Op), value, intent(in) :: op
end subroutine MPII_Op_set_f08

! Just need to tag the lang is Fortran, so it is fine to bind to *_lang_f77
subroutine MPIR_Grequest_set_lang_fortran(request) bind(C, name="MPII_Grequest_set_lang_f77")
    use :: mpi_c_interface_types, only : c_Request
    integer(c_Request), value, intent(in) :: request
    ! The subroutine is implemented in mpir_request.c on the C side
end subroutine MPIR_Grequest_set_lang_fortran

end interface

contains

! Copy Fortran string to C charater array, assuming the C array is one-char
! longer for the terminating null char.
! fstring : the Fortran input string
! cstring : the C output string (with memory already allocated)
subroutine MPIR_Fortran_string_f2c(fstring, cstring)
    implicit none
    character(len=*), intent(in) :: fstring
    character(kind=c_char), intent(out) :: cstring(:)
    integer :: i, j
    logical :: met_non_blank

    ! Trim the leading and trailing blank characters
    j = 1
    met_non_blank = .false.
    do i = 1, len_trim(fstring)
        if (met_non_blank) then
            cstring(j) = fstring(i:i)
            j = j + 1
        else if (fstring(i:i) /= ' ') then
            met_non_blank = .true.
            cstring(j) = fstring(i:i)
            j = j + 1
        end if
    end do

    cstring(j) = C_NULL_CHAR
end subroutine MPIR_Fortran_string_f2c

! Copy C charater array to Fortran string
subroutine MPIR_Fortran_string_c2f(cstring, fstring)
    implicit none
    character(kind=c_char), intent(in) :: cstring(:)
    character(len=*), intent(out) :: fstring
    integer :: i, j, length

    i = 1
    do while (cstring(i) /= C_NULL_CHAR)
        fstring(i:i) = cstring(i)
        i = i + 1
    end do

    ! Zero out the trailing characters
    length = len(fstring)
    do j = i, length
        fstring(j:j) = ' '
    end do
end subroutine MPIR_Fortran_string_c2f

function MPII_Comm_copy_attr_f08_proxy (user_function, oldcomm, comm_keyval, extra_state, &
        attr_type, attribute_val_in, attribute_val_out, flag) result(ierror) bind(c)

    use :: iso_c_binding, only : c_int, c_intptr_t
    use :: mpi_f08, only : MPI_ADDRESS_KIND, MPI_Comm, MPI_Comm_copy_attr_function
    use :: mpi_c_interface_types, only : c_Comm

    implicit none

    procedure (MPI_Comm_copy_attr_function)          :: user_function
    integer(c_Comm), value, intent(in)               :: oldcomm
    integer(c_int), value, intent(in)                :: comm_keyval
    integer(c_intptr_t), value, intent(in)           :: extra_state
    integer(kind(MPIR_ATTR_AINT)), value, intent(in) :: attr_type ! Only used in C proxy
    integer(c_intptr_t), value, intent(in)           :: attribute_val_in
    integer(c_intptr_t), intent(out)                 :: attribute_val_out
    integer(c_int), intent(out)                      :: flag
    integer(c_int)                                   :: ierror

    type(MPI_Comm)            :: oldcomm_f
    integer                   :: comm_keyval_f
    integer(MPI_ADDRESS_KIND) :: extra_state_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_in_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_out_f
    logical                   :: flag_f
    integer                   :: ierror_f

    oldcomm_f%MPI_VAL   = oldcomm
    comm_keyval_f       = comm_keyval
    attribute_val_in_f  = attribute_val_in
    extra_state_f       = extra_state

    call user_function(oldcomm_f, comm_keyval_f, extra_state_f, attribute_val_in_f, attribute_val_out_f, flag_f, ierror_f)

    attribute_val_out = attribute_val_out_f
    flag = merge(1, 0, flag_f)
    ierror = ierror_f

end function MPII_Comm_copy_attr_f08_proxy

function MPIR_Comm_delete_attr_f08_proxy (user_function, comm, comm_keyval, attr_type, &
        attribute_val, extra_state) result(ierror) bind(c)
    use :: iso_c_binding, only : c_int, c_intptr_t
    use :: mpi_f08, only : MPI_ADDRESS_KIND, MPI_Comm, MPI_Comm_delete_attr_function
    use :: mpi_c_interface_types, only : c_Comm

    implicit none

    procedure (MPI_Comm_delete_attr_function)        :: user_function
    integer(c_Comm), value, intent(in)               :: comm
    integer(c_int), value, intent(in)                :: comm_keyval
    integer(kind(MPIR_ATTR_AINT)), value, intent(in) :: attr_type ! Only used in C proxy
    integer(c_intptr_t), value, intent(in)           :: attribute_val
    integer(c_intptr_t), value, intent(in)           :: extra_state
    integer(c_int)                                   :: ierror

    type(MPI_Comm)            :: comm_f
    integer                   :: comm_keyval_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_f
    integer(MPI_ADDRESS_KIND) :: extra_state_f
    integer                   :: ierror_f

    comm_f%MPI_VAL  = comm
    comm_keyval_f   = comm_keyval
    attribute_val_f = attribute_val
    extra_state_f   = extra_state

    call user_function(comm_f, comm_keyval_f, attribute_val_f, extra_state_f, ierror_f)

    ierror = ierror_f

end function MPIR_Comm_delete_attr_f08_proxy

function MPIR_Type_copy_attr_f08_proxy (user_function, oldtype, type_keyval, extra_state, &
        attr_type, attribute_val_in, attribute_val_out, flag) result(ierror) bind(c)

    use :: iso_c_binding, only : c_int, c_intptr_t
    use :: mpi_f08, only : MPI_ADDRESS_KIND, MPI_Datatype, MPI_Type_copy_attr_function
    use :: mpi_c_interface_types, only : c_Datatype

    implicit none

    procedure (MPI_Type_copy_attr_function)          :: user_function
    integer(c_Datatype), value, intent(in)           :: oldtype
    integer(c_int), value, intent(in)                :: type_keyval
    integer(c_intptr_t), value, intent(in)           :: extra_state
    integer(kind(MPIR_ATTR_AINT)), value, intent(in) :: attr_type
    integer(c_intptr_t), value, intent(in)           :: attribute_val_in
    integer(c_intptr_t), intent(out)                 :: attribute_val_out
    integer(c_int), intent(out)                      :: flag
    integer(c_int)                                   :: ierror

    type(MPI_Datatype)        :: oldtype_f
    integer                   :: type_keyval_f
    integer(MPI_ADDRESS_KIND) :: extra_state_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_in_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_out_f
    logical                   :: flag_f
    integer                   :: ierror_f

    oldtype_f%MPI_VAL   = oldtype
    type_keyval_f       = type_keyval
    attribute_val_in_f  = attribute_val_in
    extra_state_f       = extra_state

    call user_function(oldtype_f, type_keyval_f, extra_state_f, attribute_val_in_f, attribute_val_out_f, flag_f, ierror_f)

    attribute_val_out = attribute_val_out_f
    flag = merge(1, 0, flag_f)
    ierror = ierror_f

end function MPIR_Type_copy_attr_f08_proxy

function MPIR_Type_delete_attr_f08_proxy (user_function, type, type_keyval, attr_type, &
        attribute_val, extra_state) result(ierror) bind(c)
    use :: iso_c_binding, only : c_int, c_intptr_t
    use :: mpi_f08, only : MPI_ADDRESS_KIND, MPI_Datatype, MPI_Type_delete_attr_function
    use :: mpi_c_interface_types, only : c_Datatype

    implicit none

    procedure (MPI_Type_delete_attr_function)        :: user_function
    integer(c_Datatype), value, intent(in)           :: type
    integer(c_int), value, intent(in)                :: type_keyval
    integer(kind(MPIR_ATTR_AINT)), value, intent(in) :: attr_type ! Only used in C proxy
    integer(c_intptr_t), value, intent(in)           :: attribute_val
    integer(c_intptr_t), value, intent(in)           :: extra_state
    integer(c_int)                                   :: ierror

    type(MPI_Datatype)        :: type_f
    integer                   :: type_keyval_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_f
    integer(MPI_ADDRESS_KIND) :: extra_state_f
    integer                   :: ierror_f

    type_f%MPI_VAL  = type
    type_keyval_f   = type_keyval
    attribute_val_f = attribute_val
    extra_state_f   = extra_state

    call user_function(type_f, type_keyval_f, attribute_val_f, extra_state_f, ierror_f)

    ierror = ierror_f

end function MPIR_Type_delete_attr_f08_proxy

function MPIR_Win_copy_attr_f08_proxy (user_function, oldwin, win_keyval, extra_state, &
        attr_type, attribute_val_in, attribute_val_out, flag) result(ierror) bind(c)

    use :: iso_c_binding, only : c_int, c_intptr_t
    use :: mpi_f08, only : MPI_ADDRESS_KIND, MPI_Win, MPI_Win_copy_attr_function
    use :: mpi_c_interface_types, only : c_Win

    implicit none

    procedure (MPI_Win_copy_attr_function)           :: user_function
    integer(c_Win), value, intent(in)                :: oldwin
    integer(c_int), value, intent(in)                :: win_keyval
    integer(c_intptr_t), value, intent(in)           :: extra_state
    integer(kind(MPIR_ATTR_AINT)), value, intent(in) :: attr_type ! Only used in C proxy
    integer(c_intptr_t), value, intent(in)           :: attribute_val_in
    integer(c_intptr_t), intent(out)                 :: attribute_val_out
    integer(c_int), intent(out)                      :: flag
    integer(c_int)                                   :: ierror

    type(MPI_Win)             :: oldwin_f
    integer                   :: win_keyval_f
    integer(MPI_ADDRESS_KIND) :: extra_state_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_in_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_out_f
    logical                   :: flag_f
    integer                   :: ierror_f

    oldwin_f%MPI_VAL   = oldwin
    win_keyval_f       = win_keyval
    attribute_val_in_f  = attribute_val_in
    extra_state_f       = extra_state

    call user_function(oldwin_f, win_keyval_f, extra_state_f, attribute_val_in_f, attribute_val_out_f, flag_f, ierror_f)

    attribute_val_out = attribute_val_out_f
    flag = merge(1, 0, flag_f)
    ierror = ierror_f

end function MPIR_Win_copy_attr_f08_proxy

function MPIR_Win_delete_attr_f08_proxy (user_function, win, win_keyval, attr_type, &
        attribute_val, extra_state) result(ierror) bind(c)
    use :: iso_c_binding, only : c_int, c_intptr_t
    use :: mpi_f08, only : MPI_ADDRESS_KIND, MPI_Win, MPI_Win_delete_attr_function
    use :: mpi_c_interface_types, only : c_Win

    implicit none

    procedure (MPI_Win_delete_attr_function)         :: user_function
    integer(c_Win), value, intent(in)                :: win
    integer(c_int), value, intent(in)                :: win_keyval
    integer(kind(MPIR_ATTR_AINT)), value, intent(in) :: attr_type ! Only used in C proxy
    integer(c_intptr_t), value, intent(in)           :: attribute_val
    integer(c_intptr_t), value, intent(in)           :: extra_state
    integer(c_int)                                   :: ierror

    type(MPI_Win)             :: win_f
    integer                   :: win_keyval_f
    integer(MPI_ADDRESS_KIND) :: attribute_val_f
    integer(MPI_ADDRESS_KIND) :: extra_state_f
    integer                   :: ierror_f

    win_f%MPI_VAL  = win
    win_keyval_f   = win_keyval
    attribute_val_f = attribute_val
    extra_state_f   = extra_state

    call user_function(win_f, win_keyval_f, attribute_val_f, extra_state_f, ierror_f)

    ierror = ierror_f

end function MPIR_Win_delete_attr_f08_proxy

end module mpi_c_interface_glue
