/*******************************************************************************
* Copyright (C) 2014 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER

#ifndef COMPUTEDOTPRODUCT_HPP
#define COMPUTEDOTPRODUCT_HPP

#include "Vector.hpp"
#include "UsmUtil.hpp"

sycl::event ComputeDotProduct(
    const local_int_t n, const Vector & x, const Vector & y,
    double * result, double & time_allreduce, sycl::queue & main_queue,
    const std::vector<sycl::event> &deps = {});

sycl::event ComputeDotProductLocal(const local_int_t n, const Vector & x, const Vector & y,
    double * result, sycl::queue & main_queue, const std::vector<sycl::event> &deps = {});

#endif // COMPUTEDOTPRODUCT_HPP
