from.helpers import LoopSolution,estimate_profitability
def aggregate_estimations(objective_fn,solution,reestimate_time_for_aggregated):
 target_estimations=solution.regions
 baseline_estimations=solution.host_estimations
 to_be_aggregated={}
 for row,data in target_estimations.items():
  if not row.aggregated:continue
  try:
   curr_est=data.estimation
  except KeyError:
   continue
  if not curr_est:
   continue
  agg=to_be_aggregated.get(row.aggregated)
  if not agg:
   agg=LoopSolution()
   agg.is_aggregated=True
   agg.is_profitable=False
   agg.is_offloaded=False
   agg.is_too_small=True
   agg.is_marked_up=False
   agg.base_time=0
   agg.fractional_time=0
   agg.estimation={'is_offload_candidate':True,'does_fit':True,'regions':[{'measured_row':row.aggregated,'children':{},}],}
   agg.estimation_idx=None
  device=None
  if device is None:
   device=curr_est['device']
   agg.estimation['device']=device
  elif device!=curr_est['device']:
   continue
  for curr_row_est in curr_est['regions']:
   if curr_row_est['measured_row']==row:
    break
  else:
   continue
  agg.is_profitable|=data.is_profitable
  agg.is_offloaded|=data.is_offloaded
  agg.is_too_small&=data.is_too_small
  agg.is_marked_up|=data.is_marked_up
  agg.base_time+=data.base_time
  agg.fractional_time+=data.fractional_time
  to_be_aggregated[row.aggregated]=agg
  device.aggregate_estimations(agg.estimation['regions'][0],curr_row_est)
 for agg_row,agg_solution in to_be_aggregated.items():
  agg_est=agg_solution.estimation
  agg_row_est=agg_est['regions'][0]
  agg_est['device'].update_aggregated_estimation(agg_row_est,reestimate_time_for_aggregated)
  agg_solution.gain,agg_solution.speed_up=next(estimate_profitability(objective_fn,[agg_row],baseline_estimations,[agg_row_est]))
  target_estimations[agg_row]=agg_solution
