# Default installation path: <oneccl_root>/lib/cmake/oneCCL/
#
# Copyright Intel Corporation.
# 
# This software and the related documents are Intel copyrighted materials, and
# your use of them is governed by the express license under which they were
# provided to you (License). Unless the License provides otherwise, you may
# not use, modify, copy, publish, distribute, disclose or transmit this
# software or the related documents without Intel's prior written permission.
# 
# This software and the related documents are provided as is, with no express
# or implied warranties, other than those that are expressly stated in the
# License.
#
get_filename_component(_oneccl_root "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_oneccl_root "${_oneccl_root}/../../../" ABSOLUTE)

if ("$ENV{CCL_CONFIGURATION}" STREQUAL "cpu")
    include(CheckCXXCompilerFlag)
    check_cxx_compiler_flag("-fsycl" _fsycl_option)
    if (_fsycl_option)
        message(STATUS "STATUS: -fsycl not supported for CCL_CONFIGURATION=cpu")
    endif()

    get_filename_component(_oneccl_headers "${_oneccl_root}/include" ABSOLUTE)
    get_filename_component(_oneccl_lib "${_oneccl_root}/lib/ccl/cpu/lib/libccl.so" ABSOLUTE)
else()
    get_filename_component(_oneccl_headers "${_oneccl_root}/include" ABSOLUTE)
    get_filename_component(_oneccl_lib "${_oneccl_root}/lib/libccl.so" ABSOLUTE)
endif()

if (EXISTS "${_oneccl_headers}" AND EXISTS "${_oneccl_lib}")
    if (NOT TARGET oneCCL)
        add_library(oneCCL SHARED IMPORTED)
        set_target_properties(oneCCL PROPERTIES
                             INTERFACE_INCLUDE_DIRECTORIES "${_oneccl_headers}"
                             IMPORTED_LOCATION "${_oneccl_lib}")
        unset(_oneccl_headers)
        unset(_oneccl_lib)

        find_package(MPI QUIET)
        if (NOT MPI_FOUND)
            message(STATUS "oneCCL: MPI is not found")
        else()
            set_target_properties(oneCCL PROPERTIES INTERFACE_LINK_LIBRARIES MPI::MPI_CXX)
            message(STATUS "oneCCL: MPI found")
        endif()
    endif()
else()
    if (NOT EXISTS "${_oneccl_headers}")
        message(STATUS "oneCCL: headers do not exist - ${_oneccl_headers}")
    endif()
    if (NOT EXISTS "${_oneccl_lib}")
        message(STATUS "oneCCL: lib do not exist - ${_oneccl_lib}")
    endif()
    set(oneCCL_FOUND FALSE)
endif()
