# Copyright (C) 2024 Intel Corporation
# SPDX-License-Identifier: MIT

from dataclasses import dataclass, field
from typing import Dict, List, Any, Callable



@dataclass
class SystemInformation:
    processor_features: Dict[str, Dict[str, any]] = field(default_factory=dict)
    system_features: Dict[str, Any] = field(default_factory=dict)
    uncore_units: Dict[str, Any] = field(default_factory=dict)
    ref_tsc: int = 0
    unique_core_types: List[str] = field(default_factory=list)
    has_modules: bool = False
    has_die: bool = False
    qpi_link_speed: float = None

def default_aggregation_levels():
    from mpp.core.views import ViewAggregationLevel
    return [ViewAggregationLevel.SYSTEM, ViewAggregationLevel.SOCKET, ViewAggregationLevel.DIE,
            ViewAggregationLevel.CORE, ViewAggregationLevel.THREAD, ViewAggregationLevel.UNCORE]

@dataclass
class ApiArgs:
    from mpp.core.views import ViewAggregationLevel
    from mpp.core.types import EventInfoDataFrame
    from mpp.core.types import VerboseLevel

    system_information: SystemInformation = field(default_factory=SystemInformation)
    event_info: EventInfoDataFrame = None
    event_reader: Callable = None
    collector: str = 'EMON' # to be changed based on the where the input data comes from (EMON, PCM, etc.)

    # view information
    retire_latency: bool = False
    aggregation_levels: List[ViewAggregationLevel] = field(default_factory=default_aggregation_levels)
    metric_file_map: Dict[str, str] = field(default_factory=dict)
    metric_computer_map: Dict[str, 'MetricComputer'] = None # optional arg, metric_file_map is preferred

    # output information
    is_parallel: bool = False
    no_detail_views: bool = False
    percentile: int = None
    output_directory: str = ''
    output_prefix: str = ''
    output_writers: List['OutputWriter'] = field(default_factory=list)

    unit_filters: dict = field(default_factory=dict)

    verbose: bool = VerboseLevel.INFO
