# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT

from typing import NewType

import pandas as pd

from mpp.core.types import SummaryViewDataFrameColumns

StatisticsDataFrame = NewType('StatisticsDataFrame', pd.DataFrame)


class StatisticsDataFrameColumns:
    MIN = SummaryViewDataFrameColumns.MIN
    MAX = SummaryViewDataFrameColumns.MAX
    COUNT = 'count'
    SUM = 'sum'
    PERCENTILE = SummaryViewDataFrameColumns.PERCENTILE
    VARIATION = SummaryViewDataFrameColumns.VARIATION
    DESCRIPTION = SummaryViewDataFrameColumns.DESCRIPTION
    COLUMNS = [MIN, MAX, PERCENTILE, COUNT, SUM, VARIATION, DESCRIPTION]