/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaCoverageEnabledConfiguration
extends CoverageEnabledConfiguration {
    private ClassFilter[] myCoveragePatterns;
    private boolean myIsMergeWithPreviousResults = false;
    private String mySuiteToMergeWith;
    @NonNls
    private static final String COVERAGE_PATTERN_ELEMENT_NAME = "pattern";
    @NonNls
    private static final String COVERAGE_MERGE_ATTRIBUTE_NAME = "merge";
    @NonNls
    private static final String COVERAGE_MERGE_SUITE_ATT_NAME = "merge_suite";

    public JavaCoverageEnabledConfiguration(RunConfigurationBase configuration) {
        super(configuration, (CoverageRunner)Objects.requireNonNull((IDEACoverageRunner)CoverageRunner.getInstance(IDEACoverageRunner.class)));
    }

    public void downloadReport(@NotNull TargetEnvironment environment, @NotNull ProgressIndicator indicator) throws IOException {
        String coverageFilePath;
        if (environment == null) {
            JavaCoverageEnabledConfiguration.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            JavaCoverageEnabledConfiguration.$$$reportNull$$$0(1);
        }
        if ((coverageFilePath = this.getCoverageFilePath()) != null) {
            Path path = Paths.get(coverageFilePath, new String[0]);
            TargetEnvironmentFunctions.downloadFromTarget((TargetEnvironment)environment, (Path)path, (ProgressIndicator)indicator);
        }
    }

    @Nullable
    public static JavaCoverageEnabledConfiguration getFrom(@NotNull RunConfigurationBase<?> configuration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        if (configuration == null) {
            JavaCoverageEnabledConfiguration.$$$reportNull$$$0(2);
        }
        if ((coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getOrCreate(configuration)) instanceof JavaCoverageEnabledConfiguration) {
            return (JavaCoverageEnabledConfiguration)coverageEnabledConfiguration;
        }
        return null;
    }

    public void appendCoverageArgument(@NotNull CoverageSuite suite, SimpleJavaParameters javaParameters) {
        CoverageRunner runner;
        if (suite == null) {
            JavaCoverageEnabledConfiguration.$$$reportNull$$$0(3);
        }
        if ((runner = suite.getRunner()) instanceof JavaCoverageRunner) {
            JavaCoverageRunner javaCoverageRunner = (JavaCoverageRunner)runner;
            String path = suite.getCoverageDataFileName();
            assert (path != null);
            String sourceMapPath = null;
            if (JavaCoverageEngine.isSourceMapNeeded(this.getConfiguration())) {
                sourceMapPath = JavaCoverageEnabledConfiguration.getSourceMapPath(path);
            }
            String[] patterns = this.getPatterns();
            String[] excludePatterns = this.getExcludePatterns();
            Project project = this.getConfiguration().getProject();
            CoverageLogger.logStarted((CoverageRunner)runner, (boolean)suite.isBranchCoverage(), (boolean)suite.isCoverageByTestEnabled(), (int)(patterns == null ? 0 : patterns.length), (int)(excludePatterns == null ? 0 : excludePatterns.length));
            javaCoverageRunner.appendCoverageArgument(new File(path).getAbsolutePath(), patterns, excludePatterns, javaParameters, suite.isCoverageByTestEnabled(), suite.isBranchCoverage(), sourceMapPath, project);
        }
    }

    public static String getSourceMapPath(String coverageDataFilePath) {
        return coverageDataFilePath + ".sourceMap";
    }

    public ClassFilter @Nullable [] getCoveragePatterns() {
        return this.myCoveragePatterns;
    }

    public String @Nullable [] getPatterns() {
        return this.getPatterns(true);
    }

    public String @Nullable [] getExcludePatterns() {
        return this.getPatterns(false);
    }

    private String @Nullable [] getPatterns(boolean include) {
        if (this.myCoveragePatterns != null) {
            ArrayList<String> patterns = new ArrayList<String>();
            for (ClassFilter coveragePattern : this.myCoveragePatterns) {
                if (coveragePattern == null || !coveragePattern.isEnabled() || coveragePattern.isInclude() != include) continue;
                patterns.add(coveragePattern.getPattern());
            }
            return ArrayUtilRt.toStringArray(patterns);
        }
        return null;
    }

    public void setCoveragePatterns(ClassFilter[] coveragePatterns) {
        this.myCoveragePatterns = coveragePatterns;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myIsMergeWithPreviousResults = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_MERGE_ATTRIBUTE_NAME));
        this.mySuiteToMergeWith = element.getAttributeValue(COVERAGE_MERGE_SUITE_ATT_NAME);
        List children = element.getChildren(COVERAGE_PATTERN_ELEMENT_NAME);
        if (!children.isEmpty()) {
            this.myCoveragePatterns = new ClassFilter[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element e = (Element)children.get(i);
                this.myCoveragePatterns[i] = JavaCoverageEnabledConfiguration.createClassFilter(e);
                String val = e.getAttributeValue("value");
                if (val == null) continue;
                this.myCoveragePatterns[i].setPattern(val);
            }
        }
    }

    public static ClassFilter createClassFilter(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        return filter;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        IDEACoverageRunner ideaRunner;
        CoverageRunner coverageRunner;
        super.writeExternal(element);
        if (this.myIsMergeWithPreviousResults) {
            element.setAttribute(COVERAGE_MERGE_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (this.myIsMergeWithPreviousResults && this.mySuiteToMergeWith != null) {
            element.setAttribute(COVERAGE_MERGE_SUITE_ATT_NAME, this.mySuiteToMergeWith);
        }
        if ((coverageRunner = this.getCoverageRunner()) != null && (ideaRunner = (IDEACoverageRunner)((Object)CoverageRunner.EP_NAME.findExtension(IDEACoverageRunner.class))) != null && coverageRunner.getId().equals(ideaRunner.getId())) {
            element.removeAttribute("runner");
        }
        if (this.myCoveragePatterns != null) {
            for (ClassFilter pattern : this.myCoveragePatterns) {
                if (pattern == null) continue;
                @NonNls Element patternElement = new Element(COVERAGE_PATTERN_ELEMENT_NAME);
                pattern.writeExternal(patternElement);
                element.addContent(patternElement);
            }
        }
    }

    public void setUpCoverageFilters(@Nullable String className, @Nullable String packageName) {
        if (this.getCoveragePatterns() == null) {
            String pattern = null;
            if (!StringUtil.isEmpty((String)className)) {
                int index = className.lastIndexOf(46);
                if (index >= 0) {
                    pattern = className.substring(0, index);
                }
            } else if (packageName != null) {
                pattern = packageName;
            }
            if (!StringUtil.isEmpty((String)pattern)) {
                this.setCoveragePatterns(new ClassFilter[]{new ClassFilter(pattern + ".*")});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/configurations/coverage/JavaCoverageEnabledConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadReport";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCoverageArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

