/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleExecutionErrorHandler {
    public static final Pattern UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN = Pattern.compile("Gradle version .* is required.*");
    public static final Pattern DOWNLOAD_GRADLE_DISTIBUTION_ERROR_PATTERN = Pattern.compile("The specified Gradle distribution .* does not exist.");
    public static final Pattern MISSING_METHOD_PATTERN = Pattern.compile("org.gradle.api.internal.MissingMethodException: Could not find method (.*?) .*");
    public static final Pattern ERROR_LOCATION_IN_FILE_PATTERN = Pattern.compile("(?:Build|Settings) file '(.*)' line: ([\\d]+)");
    public static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("(?:Build|Settings) file '(.*)'");
    private final Throwable myOriginError;
    private final ExternalSystemException myFriendlyError;
    private Pair<Throwable, String> myRootCauseAndLocation;

    public GradleExecutionErrorHandler(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        if (error == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(1);
        }
        this.myOriginError = error;
        this.myFriendlyError = this.getUserFriendlyError(error, projectPath, buildFilePath);
    }

    public ExternalSystemException getUserFriendlyError() {
        return this.myFriendlyError;
    }

    public Throwable getRootCause() {
        if (this.myRootCauseAndLocation == null) {
            this.myRootCauseAndLocation = GradleExecutionErrorHandler.getRootCauseAndLocation(this.myOriginError);
        }
        return (Throwable)this.myRootCauseAndLocation.first;
    }

    public String getLocation() {
        if (this.myRootCauseAndLocation == null) {
            this.myRootCauseAndLocation = GradleExecutionErrorHandler.getRootCauseAndLocation(this.myOriginError);
        }
        return (String)this.myRootCauseAndLocation.second;
    }

    @Nullable
    private ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        Throwable errorCause;
        if (error == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(2);
        }
        if (projectPath == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(3);
        }
        if (error instanceof ExternalSystemException) {
            return (ExternalSystemException)error;
        }
        if (this.myRootCauseAndLocation == null) {
            this.myRootCauseAndLocation = GradleExecutionErrorHandler.getRootCauseAndLocation(error);
        }
        if (this.myRootCauseAndLocation.first instanceof FileNotFoundException && (errorCause = error.getCause()) instanceof IllegalArgumentException && DOWNLOAD_GRADLE_DISTIBUTION_ERROR_PATTERN.matcher(errorCause.getMessage()).matches()) {
            return GradleExecutionErrorHandler.createUserFriendlyError(errorCause.getMessage(), null, new String[0]);
        }
        return null;
    }

    @NotNull
    public static Pair<Throwable, String> getRootCauseAndLocation(@NotNull Throwable error) {
        if (error == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(4);
        }
        Throwable rootCause = error;
        String location = null;
        while (true) {
            Throwable cause;
            if (location == null) {
                location = GradleExecutionErrorHandler.getLocationFrom(rootCause);
            }
            if ((cause = rootCause.getCause()) == null || cause == rootCause || cause.getMessage() == null && !(cause instanceof StackOverflowError)) break;
            rootCause = cause;
        }
        if (location == null) {
            location = GradleExecutionErrorHandler.searchForLocationInStacks(error);
        }
        Pair pair = Pair.create((Object)rootCause, (Object)location);
        if (pair == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Nullable
    public static String getLocationFrom(@NotNull Throwable error) {
        String location;
        String errorToString;
        if (error == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(6);
        }
        if ((errorToString = error.toString()).contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    @Nullable
    private static String searchForLocationInStacks(@NotNull Throwable error) {
        if (error == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(7);
        }
        Throwable current = error;
        while (true) {
            String location;
            if ((location = GradleExecutionErrorHandler.getLocationFromStack(current)) != null) {
                return location;
            }
            Throwable cause = current.getCause();
            if (cause == null || cause == current) break;
            current = cause;
        }
        return null;
    }

    @Nullable
    private static String getLocationFromStack(@NotNull Throwable error) {
        StackTraceElement scriptFrame;
        if (error == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(8);
        }
        if ((scriptFrame = (StackTraceElement)ContainerUtil.find((Object[])error.getStackTrace(), element -> {
            String fileName = element.getFileName();
            return fileName != null && (fileName.endsWith(".gradle") || fileName.endsWith(".gradle.kts"));
        })) != null) {
            return "Build file '" + scriptFrame.getFileName() + "' line: " + scriptFrame.getLineNumber();
        }
        return null;
    }

    @NotNull
    public static ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        Object newMsg;
        if (msg == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(9);
        }
        if (quickFixes == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(10);
        }
        if (!((String)(newMsg = msg)).isEmpty() && Character.isLowerCase(((String)newMsg).charAt(0))) {
            newMsg = "Cause: " + (String)newMsg;
        }
        if (!StringUtil.isEmpty((String)location) && (pair = GradleExecutionErrorHandler.getErrorLocation(location)) != null) {
            return new LocationAwareExternalSystemException((String)newMsg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
        }
        return new ExternalSystemException((String)newMsg, null, quickFixes);
    }

    @Nullable
    public static Pair<String, Integer> getErrorLocation(@NotNull String location) {
        Matcher matcher;
        if (location == null) {
            GradleExecutionErrorHandler.$$$reportNull$$$0(11);
        }
        if ((matcher = ERROR_LOCATION_IN_FILE_PATTERN.matcher(location)).matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionErrorHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionErrorHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCauseAndLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRootCauseAndLocation";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchForLocationInStacks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFromStack";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUserFriendlyError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

