/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi.cheminfo;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiRadical;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnarinchi.CtabVersion;
import io.github.dan2097.jnarinchi.ReactionFileFormat;
import io.github.dan2097.jnarinchi.RinchiInput;
import io.github.dan2097.jnarinchi.RinchiInputComponent;
import io.github.dan2097.jnarinchi.cheminfo.MdlReactionUtils;
import io.github.dan2097.jnarinchi.cheminfo.StereoUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MdlReactionWriter {
    private static final String LINE_SEPARATOR = "\n";
    private static final String RDFILE_LINE_1_RDFILE = "$RDFILE 1";
    private static final String RDFILE_LINE_2_DATM = "$DATM";
    private static final String RDFILE_LINE_3_RFMT = "$RFMT";
    private static final String RXN_HEADER_LINE_1_RXN = "$RXN";
    private static final String RXN_HEADER_LINE_2_REACTION_NAME = "";
    private static final String RXN_HEADER_LINE_3_PROGRAM = "      JNA-RIN  ";
    private static final String RXN_HEADER_LINE_4_COMMENT = "";
    private static final String MOLFILE_MOL = "$MOL";
    private static final String MOLFILE_HEADER_LINE_2_PROGRAM = "  JNA-RIN ";
    private static final String MOLFILE_HEADER_LINE_3_COMMENT = "";
    private static final String MOLFILE_M_END = "M  END";
    private static final DateTimeFormatter DATE_TIME_FORMATTER_RDFILE = DateTimeFormatter.ofPattern("MM/dd/yy HH:mm");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_RXN = DateTimeFormatter.ofPattern("MMddyyyyHHmm");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_MOLFILE = DateTimeFormatter.ofPattern("MMddyyHHmm");
    private final ReactionFileFormat format;
    private final CtabVersion ctabVersion = CtabVersion.V2000;
    private final boolean checkParityAccordingAtomNumbering = true;

    public MdlReactionWriter() {
        this(ReactionFileFormat.RD);
    }

    public MdlReactionWriter(ReactionFileFormat format) {
        this.format = format;
    }

    public String rinchiInputToFileText(RinchiInput rInp) {
        return new MdlReactionWriterInstance(rInp).write();
    }

    public ReactionFileFormat getFormat() {
        return this.format;
    }

    public CtabVersion getCtabVersion() {
        return this.ctabVersion;
    }

    private class MdlReactionWriterInstance {
        private final RinchiInput rInput;
        private final StringBuilder stringBuilder = new StringBuilder();
        private final List<RinchiInputComponent> reagents = new ArrayList<RinchiInputComponent>();
        private final List<RinchiInputComponent> products = new ArrayList<RinchiInputComponent>();
        private final List<RinchiInputComponent> agents = new ArrayList<RinchiInputComponent>();

        MdlReactionWriterInstance(RinchiInput rInput) {
            if (rInput == null) {
                throw new IllegalArgumentException("RinchiInput is null!");
            }
            this.rInput = rInput;
        }

        String write() {
            int i;
            this.analyzeComponents();
            if (MdlReactionWriter.this.format == ReactionFileFormat.RD || MdlReactionWriter.this.format == ReactionFileFormat.AUTO) {
                this.addRdFileHeader();
            }
            this.addRxnHeader();
            this.addInteger(this.reagents.size(), 3);
            this.addInteger(this.products.size(), 3);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            for (i = 0; i < this.reagents.size(); ++i) {
                this.addRinchiInputComponent(this.reagents.get(i), "Reagent " + (i + 1));
            }
            for (i = 0; i < this.products.size(); ++i) {
                this.addRinchiInputComponent(this.products.get(i), "Product " + (i + 1));
            }
            if (MdlReactionWriter.this.format == ReactionFileFormat.RD || MdlReactionWriter.this.format == ReactionFileFormat.AUTO) {
                for (i = 0; i < this.agents.size(); ++i) {
                    this.addRinchiInputComponentAsAgent(this.agents.get(i), i, "Agent " + (i + 1));
                }
            }
            return this.stringBuilder.toString();
        }

        private void addRinchiInputComponent(RinchiInputComponent ric, String moleculeName) {
            this.addMolHeader(moleculeName);
            this.addCtabBlockV2000(ric);
            this.addPropertyBlock(ric);
            this.stringBuilder.append(MdlReactionWriter.MOLFILE_M_END);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addRinchiInputComponentAsAgent(RinchiInputComponent ric, int agentIndex, String moleculeName) {
            this.stringBuilder.append("$DTYPE RXN:VARIATION(1):AGENT(").append(agentIndex + 1).append("):MOL(1):MOLSTRUCTURE");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append("$DATUM $MFMT");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(moleculeName);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(MdlReactionWriter.MOLFILE_HEADER_LINE_2_PROGRAM);
            this.stringBuilder.append(LocalDateTime.now().format(DATE_TIME_FORMATTER_MOLFILE));
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append("");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.addCtabBlockV2000(ric);
            this.addPropertyBlock(ric);
            this.stringBuilder.append(MdlReactionWriter.MOLFILE_M_END);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addMolHeader(String moleculeName) {
            this.stringBuilder.append(MdlReactionWriter.MOLFILE_MOL);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(moleculeName);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(MdlReactionWriter.MOLFILE_HEADER_LINE_2_PROGRAM);
            this.stringBuilder.append(LocalDateTime.now().format(DATE_TIME_FORMATTER_MOLFILE));
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append("");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addRdFileHeader() {
            this.stringBuilder.append(MdlReactionWriter.RDFILE_LINE_1_RDFILE);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(MdlReactionWriter.RDFILE_LINE_2_DATM);
            this.stringBuilder.append("    ");
            this.stringBuilder.append(LocalDateTime.now().format(DATE_TIME_FORMATTER_RDFILE));
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(MdlReactionWriter.RDFILE_LINE_3_RFMT);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addRxnHeader() {
            this.stringBuilder.append(MdlReactionWriter.RXN_HEADER_LINE_1_RXN);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append("");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append(MdlReactionWriter.RXN_HEADER_LINE_3_PROGRAM);
            this.stringBuilder.append(LocalDateTime.now().format(DATE_TIME_FORMATTER_RXN));
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            this.stringBuilder.append("");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addCtabBlockV2000(RinchiInputComponent ric) {
            int i;
            this.addInteger(ric.getAtoms().size(), 3);
            this.addInteger(ric.getBonds().size(), 3);
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            Map<InchiAtom, InchiStereoParity> parities = StereoUtils.getAtomParities(ric, true);
            if (parities.isEmpty()) {
                this.stringBuilder.append("  0");
            } else {
                this.stringBuilder.append("  1");
            }
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("999");
            this.stringBuilder.append(" ").append((Object)CtabVersion.V2000);
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            for (i = 0; i < ric.getAtoms().size(); ++i) {
                InchiStereoParity parity = parities.get(ric.getAtom(i));
                this.addAtomLine(ric.getAtom(i), parity);
            }
            for (i = 0; i < ric.getBonds().size(); ++i) {
                this.addBondLine(ric.getBond(i), ric);
            }
        }

        private void addAtomLine(InchiAtom atom, InchiStereoParity parity) {
            this.addDouble(atom.getX());
            this.addDouble(atom.getY());
            this.addDouble(atom.getZ());
            this.stringBuilder.append(" ");
            this.addString(atom.getElName());
            this.stringBuilder.append(" 0");
            if (atom.getRadical() == InchiRadical.DOUBLET) {
                this.stringBuilder.append("  4");
            } else {
                this.addInteger(this.getOldCtabChargeCoding(atom.getCharge()), 3);
            }
            if (parity != null) {
                switch (parity) {
                    case ODD: {
                        this.stringBuilder.append("  1");
                        break;
                    }
                    case EVEN: {
                        this.stringBuilder.append("  2");
                        break;
                    }
                    case UNKNOWN: {
                        this.stringBuilder.append("  3");
                        break;
                    }
                    default: {
                        this.stringBuilder.append("  0");
                    }
                }
            }
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addBondLine(InchiBond bond, RinchiInputComponent ric) {
            int firstAt = ric.getAtoms().indexOf(bond.getStart()) + 1;
            int secondAt = ric.getAtoms().indexOf(bond.getEnd()) + 1;
            if (this.isWedgeEndAtSecondAtom(bond.getStereo())) {
                this.addInteger(secondAt, 3);
                this.addInteger(firstAt, 3);
            } else {
                this.addInteger(firstAt, 3);
                this.addInteger(secondAt, 3);
            }
            this.addInteger(this.getBondMdlBondCode(bond), 3);
            this.addInteger(this.getBondMdlStereoCode(bond), 3);
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append("  0");
            this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
        }

        private void addPropertyBlock(RinchiInputComponent ric) {
            int k;
            int atIndex;
            int i;
            int curSet;
            int numSets;
            List<Integer> atomList = this.getAtomsWithCharge(ric);
            if (!atomList.isEmpty()) {
                numSets = atomList.size() / 8;
                for (curSet = 0; curSet < numSets; ++curSet) {
                    this.stringBuilder.append("M  CHG  8");
                    for (i = 0; i < 8; ++i) {
                        atIndex = atomList.get(curSet * 8 + i);
                        this.addInteger(atIndex + 1, 4);
                        this.addInteger(ric.getAtom(atIndex).getCharge(), 4);
                    }
                    this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
                }
                k = atomList.size() % 8;
                this.stringBuilder.append("M  CHG");
                this.addInteger(k, 3);
                for (i = 0; i < k; ++i) {
                    atIndex = atomList.get(numSets * 8 + i);
                    this.addInteger(atIndex + 1, 4);
                    this.addInteger(ric.getAtom(atIndex).getCharge(), 4);
                }
                this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            }
            if (!(atomList = this.getAtomsWithIsotope(ric)).isEmpty()) {
                numSets = atomList.size() / 8;
                for (curSet = 0; curSet < numSets; ++curSet) {
                    this.stringBuilder.append("M  ISO  8");
                    for (i = 0; i < 8; ++i) {
                        atIndex = atomList.get(curSet * 8 + i);
                        this.addInteger(atIndex + 1, 4);
                        this.addInteger(ric.getAtom(atIndex).getIsotopicMass(), 4);
                    }
                    this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
                }
                k = atomList.size() % 8;
                this.stringBuilder.append("M  ISO");
                this.addInteger(k, 3);
                for (i = 0; i < k; ++i) {
                    atIndex = atomList.get(numSets * 8 + i);
                    this.addInteger(atIndex + 1, 4);
                    this.addInteger(ric.getAtom(atIndex).getIsotopicMass(), 4);
                }
                this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            }
            if (!(atomList = this.getAtomsWithRadical(ric)).isEmpty()) {
                int radCode;
                numSets = atomList.size() / 8;
                for (curSet = 0; curSet < numSets; ++curSet) {
                    this.stringBuilder.append("M  RAD  8");
                    for (i = 0; i < 8; ++i) {
                        atIndex = atomList.get(curSet * 8 + i);
                        this.addInteger(atIndex + 1, 4);
                        radCode = this.getRadicalMdlCode(ric.getAtom(atIndex).getRadical());
                        this.addInteger(radCode, 4);
                    }
                    this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
                }
                k = atomList.size() % 8;
                this.stringBuilder.append("M  RAD");
                this.addInteger(k, 3);
                for (i = 0; i < k; ++i) {
                    atIndex = atomList.get(numSets * 8 + i);
                    this.addInteger(atIndex + 1, 4);
                    radCode = this.getRadicalMdlCode(ric.getAtom(atIndex).getRadical());
                    this.addInteger(radCode, 4);
                }
                this.stringBuilder.append(MdlReactionWriter.LINE_SEPARATOR);
            }
        }

        private List<Integer> getAtomsWithCharge(RinchiInputComponent ric) {
            ArrayList<Integer> atomList = new ArrayList<Integer>();
            for (int i = 0; i < ric.getAtoms().size(); ++i) {
                if (ric.getAtom(i).getCharge() == 0) continue;
                atomList.add(i);
            }
            return atomList;
        }

        private List<Integer> getAtomsWithIsotope(RinchiInputComponent ric) {
            ArrayList<Integer> atomList = new ArrayList<Integer>();
            for (int i = 0; i < ric.getAtoms().size(); ++i) {
                if (ric.getAtom(i).getIsotopicMass() == 0) continue;
                atomList.add(i);
            }
            return atomList;
        }

        private List<Integer> getAtomsWithRadical(RinchiInputComponent ric) {
            ArrayList<Integer> atomList = new ArrayList<Integer>();
            for (int i = 0; i < ric.getAtoms().size(); ++i) {
                if (ric.getAtom(i).getRadical() == InchiRadical.NONE) continue;
                atomList.add(i);
            }
            return atomList;
        }

        private int getRadicalMdlCode(InchiRadical inchiRadical) {
            switch (inchiRadical) {
                case SINGLET: {
                    return 1;
                }
                case DOUBLET: {
                    return 2;
                }
                case TRIPLET: {
                    return 3;
                }
            }
            return 0;
        }

        private int getBondMdlBondCode(InchiBond bond) {
            switch (bond.getType()) {
                case DOUBLE: {
                    return 2;
                }
                case TRIPLE: {
                    return 3;
                }
                case ALTERN: {
                    return 4;
                }
            }
            return 1;
        }

        private int getBondMdlStereoCode(InchiBond bond) {
            if (bond.getStereo() != null) {
                return this.inchiBondStereoToMDLStereoCode(bond.getStereo());
            }
            return 0;
        }

        private int inchiBondStereoToMDLStereoCode(InchiBondStereo inchiBoStereo) {
            switch (inchiBoStereo) {
                case SINGLE_1UP: 
                case SINGLE_2UP: {
                    return 1;
                }
                case SINGLE_1EITHER: 
                case SINGLE_2EITHER: {
                    return 4;
                }
                case SINGLE_1DOWN: 
                case SINGLE_2DOWN: {
                    return 6;
                }
                case DOUBLE_EITHER: {
                    return 3;
                }
            }
            return 0;
        }

        private boolean isWedgeEndAtSecondAtom(InchiBondStereo inchiBoStereo) {
            if (inchiBoStereo == null) {
                return false;
            }
            return inchiBoStereo == InchiBondStereo.SINGLE_2UP || inchiBoStereo == InchiBondStereo.SINGLE_2DOWN || inchiBoStereo == InchiBondStereo.SINGLE_2EITHER;
        }

        private void analyzeComponents() {
            for (RinchiInputComponent ric : this.rInput.getComponents()) {
                switch (ric.getRole()) {
                    case REAGENT: {
                        this.reagents.add(ric);
                        break;
                    }
                    case PRODUCT: {
                        this.products.add(ric);
                        break;
                    }
                    case AGENT: {
                        this.agents.add(ric);
                    }
                }
            }
        }

        private void addString(String vStr) {
            int fixedSpace = 3;
            int nEmptySpaces = 3 - vStr.length();
            if (nEmptySpaces < 0) {
                this.stringBuilder.append(vStr.substring(3));
            } else {
                this.stringBuilder.append(vStr);
                for (int i = 0; i < nEmptySpaces; ++i) {
                    this.stringBuilder.append(" ");
                }
            }
        }

        private void addInteger(int value, int fixedSpace) {
            this.addNumber(Integer.toString(value), fixedSpace);
        }

        private void addDouble(Double value) {
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                this.addNumber(MdlReactionUtils.MDL_NUMBER_FORMAT.format(0.0), 10);
            } else {
                this.addNumber(MdlReactionUtils.MDL_NUMBER_FORMAT.format(value), 10);
            }
        }

        private void addNumber(String numberAsString, int fixedSpace) {
            if (numberAsString.length() > fixedSpace) {
                numberAsString = "0";
            }
            int nEmptySpaces = fixedSpace - numberAsString.length();
            for (int i = 0; i < nEmptySpaces; ++i) {
                this.stringBuilder.append(" ");
            }
            this.stringBuilder.append(numberAsString);
        }

        private int getOldCtabChargeCoding(int charge) {
            switch (charge) {
                case 3: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case -1: {
                    return 5;
                }
                case -2: {
                    return 6;
                }
                case -3: {
                    return 7;
                }
            }
            return 0;
        }
    }
}

