/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.BS;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.writers.MOLWriter;
import org.jmol.api.Interface;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.JmolWriter;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

public class PropertyManager
implements JmolPropertyManager {
    Viewer vwr;
    private Map<String, Integer> map = new Hashtable<String, Integer>();
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "{*}", "ligandInfo", "<atom selection>", "{*}", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "", "", "", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "{*}", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "<width=www,height=hhh>", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "pointGroupInfo", "<atom selection>", "(visible)", "fileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", "", "isosurfaceInfo", "", "", "isosurfaceData", "", "", "consoleText", "", "", "JSpecView", "<key>", "", "scriptQueueInfo", "", "", "nmrInfo", "<elementSymbol> or 'all' or 'shifts'", "all", "variableInfo", "<name>", "all", "domainInfo", "<atom selection>", "{visible}", "validationInfo", "<atom selection>", "{visible}", "service", "<hashTable>", "", "CIFInfo", "<filename>", "", "modelkitInfo", "<key>", "data", "unitcellInfo", "", ""};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    private static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_LIGAND_INFO = 7;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_FILE_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_MOUSE_INFO = 34;
    private static final int PROP_ISOSURFACE_INFO = 35;
    private static final int PROP_ISOSURFACE_DATA = 36;
    private static final int PROP_CONSOLE_TEXT = 37;
    private static final int PROP_JSPECVIEW = 38;
    private static final int PROP_SCRIPT_QUEUE_INFO = 39;
    private static final int PROP_NMR_INFO = 40;
    private static final int PROP_VAR_INFO = 41;
    private static final int PROP_DOM_INFO = 42;
    private static final int PROP_VAL_INFO = 43;
    private static final int PROP_SERVICE = 44;
    private static final int PROP_CIF_INFO = 45;
    private static final int PROP_MODELKIT_INFO = 46;
    private static final int PROP_UNITCELL_INFO = 47;
    private static final int PROP_COUNT = 48;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu", "minimizationInfo"};

    @Override
    public void setViewer(Viewer vwr) {
        this.vwr = vwr;
        int i = 0;
        int p = 0;
        while (i < propertyTypes.length) {
            if (propertyTypes[i].length() > 0) {
                this.map.put(propertyTypes[i].toLowerCase(), p);
            }
            i += 3;
            ++p;
        }
    }

    @Override
    public int getPropertyNumber(String infoType) {
        Integer n = this.map.get(infoType == null ? "" : infoType.toLowerCase());
        return n == null ? -1 : n;
    }

    @Override
    public String getDefaultPropertyParam(int propID) {
        return propID < 0 ? "" : propertyTypes[propID * 3 + 2];
    }

    @Override
    public boolean checkPropertyParameter(String name) {
        int propID = this.getPropertyNumber(name);
        String type = PropertyManager.getParamType(propID);
        return type.length() > 0 && type != atomExpression;
    }

    @Override
    public Object getProperty(String returnType, String infoType, Object paramInfo) {
        Object info;
        if (propertyTypes.length != 144) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 144);
        }
        if (infoType.indexOf(".") >= 0 || infoType.indexOf("[") >= 0) {
            SV[] args = this.getArguments(infoType);
            Object h = this.getPropertyAsObject(args[0].asString(), paramInfo, null);
            info = this.extractProperty(h, args, 1, null, false);
        } else {
            info = this.getPropertyAsObject(infoType, paramInfo, returnType);
        }
        if (returnType == null) {
            return info;
        }
        boolean requestedReadable = returnType.equalsIgnoreCase("readable");
        if (requestedReadable) {
            String string = returnType = PropertyManager.isReadableAsString(infoType) ? "String" : "JSON";
        }
        if (returnType.equalsIgnoreCase("String")) {
            return info == null ? "" : info.toString();
        }
        if (requestedReadable) {
            return Escape.toReadable(infoType, info);
        }
        if (returnType.equalsIgnoreCase("JSON")) {
            return SV.safeJSON(infoType, info);
        }
        return info;
    }

    private SV[] getArguments(String propertyName) {
        String lc = propertyName.toLowerCase();
        int pt = -1;
        if (propertyName.indexOf(34) >= 0 || propertyName.indexOf(39) >= 0) {
            propertyName = this.fixSelectQuotes(propertyName);
        }
        while (true) {
            int pt3;
            ++pt;
            if ((pt = lc.indexOf("[select ", pt)) < 0) break;
            int pt2 = lc.indexOf(" where ", pt);
            int pt2b = lc.indexOf(" wherein ", pt);
            if (pt2b > 0 && pt2b < pt2) {
                pt2 = pt2b;
            }
            if ((pt3 = lc.indexOf("][select ", pt)) < 0) {
                pt3 = lc.lastIndexOf("]");
            }
            if ((pt2b = lc.indexOf("[", pt)) >= 0 && pt2b < pt3) {
                pt2 = pt2b;
            }
            if (pt2 < 0 || pt2 > pt3) continue;
            propertyName = propertyName.substring(0, pt + 1) + propertyName.substring(pt + 1, pt3).replace('.', '\u0001').replace('[', '\u0002').replace(']', '\u0003') + propertyName.substring(pt3);
        }
        propertyName = PT.rep(PT.rep(propertyName.replace(']', '\u0000').replace('[', '\u0000'), "..", "\u0004").replace('.', '\u0000').replace('\u0001', '.').replace('\u0002', '[').replace('\u0003', ']'), "\u0004", "..");
        propertyName = PT.rep(propertyName, "\u0000\u0000", "\u0000");
        String[] names = PT.split(PT.trim(propertyName, "\u0000"), "\u0000");
        SV[] args = new SV[names.length];
        for (int i = 0; i < names.length; ++i) {
            int n;
            args[i] = names[i].startsWith("'") || names[i].startsWith("\"") ? SV.newS(PT.trim(names[i], "'\"")) : ((n = PT.parseInt(names[i])) == Integer.MIN_VALUE ? SV.newS(names[i]) : SV.newI(n));
        }
        return args;
    }

    private String fixSelectQuotes(String propertyName) {
        char[] a = propertyName.toCharArray();
        boolean inQuotes = false;
        boolean inQuotes1 = false;
        boolean inQuotes2 = false;
        int i = a.length;
        while (--i >= 0) {
            switch (a[i]) {
                case '\'': {
                    if (inQuotes2) break;
                    inQuotes1 = !inQuotes;
                    inQuotes = inQuotes1;
                    break;
                }
                case '\"': {
                    if (inQuotes1) break;
                    inQuotes2 = !inQuotes;
                    inQuotes = inQuotes2;
                    break;
                }
                case '.': {
                    if (!inQuotes) break;
                    a[i] = '\u0001';
                    break;
                }
                case '[': {
                    if (!inQuotes) break;
                    a[i] = 2;
                    break;
                }
                case ']': {
                    if (!inQuotes) break;
                    a[i] = 3;
                }
            }
        }
        propertyName = new String(a);
        return propertyName;
    }

    @Override
    public Object extractProperty(Object prop, Object args, int ptr, Lst<Object> v2, boolean isCompiled) {
        if (ptr < 0) {
            args = this.getArguments((String)args);
            ptr = 0;
        }
        if (ptr >= ((SV[])args).length) {
            return prop;
        }
        if (!isCompiled) {
            SV[] svargs = args = this.compileSelect(args);
            int n = svargs.length;
            for (int i = ptr; i < n; ++i) {
                if (svargs[i].tok != 1275082241) continue;
                SV[] a = new SV[i + 1];
                for (int p = 0; p <= i; ++p) {
                    a[p] = svargs[p];
                }
                prop = this.extractProperty(prop, a, ptr, null, true);
                while (++i < n) {
                    a[a.length - 1] = svargs[i];
                    prop = this.extractProperty(prop, a, a.length - 1, null, true);
                }
                return prop;
            }
            args = svargs;
        }
        SV arg = args[ptr++];
        Object property = SV.oValue(prop);
        switch (arg.tok) {
            case 2: {
                int pt = arg.intValue - 1;
                if (property instanceof Lst) {
                    Lst v = (Lst)property;
                    if (pt < 0) {
                        pt += v.size();
                    }
                    return pt >= 0 && pt < v.size() ? this.extractProperty(v.get(pt), args, ptr, null, true) : "";
                }
                if (property instanceof M3) {
                    M3 m = (M3)property;
                    float[][] f = new float[][]{{m.m00, m.m01, m.m02}, {m.m10, m.m11, m.m12}, {m.m20, m.m21, m.m22}};
                    if (pt < 0) {
                        pt += 3;
                    }
                    return pt >= 0 && pt < 3 ? this.extractProperty(f, args, --ptr, null, true) : "";
                }
                if (property instanceof M4) {
                    M4 m = (M4)property;
                    float[][] f = new float[][]{{m.m00, m.m01, m.m02, m.m03}, {m.m10, m.m11, m.m12, m.m13}, {m.m20, m.m21, m.m22, m.m23}, {m.m30, m.m31, m.m32, m.m33}};
                    if (pt < 0) {
                        pt += 4;
                    }
                    return pt >= 0 && pt < 4 ? this.extractProperty(f, args, --ptr, null, true) : "";
                }
                if (AU.isAI(property)) {
                    int[] ilist = (int[])property;
                    if (pt < 0) {
                        pt += ilist.length;
                    }
                    return pt >= 0 && pt < ilist.length ? Integer.valueOf(ilist[pt]) : "";
                }
                if (AU.isAD(property)) {
                    double[] dlist = (double[])property;
                    if (pt < 0) {
                        pt += dlist.length;
                    }
                    return pt >= 0 && pt < dlist.length ? Double.valueOf(dlist[pt]) : "";
                }
                if (AU.isAF(property)) {
                    float[] flist = (float[])property;
                    if (pt < 0) {
                        pt += flist.length;
                    }
                    return pt >= 0 && pt < flist.length ? Float.valueOf(flist[pt]) : "";
                }
                if (AU.isAII(property)) {
                    int[][] iilist = (int[][])property;
                    if (pt < 0) {
                        pt += iilist.length;
                    }
                    return pt >= 0 && pt < iilist.length ? this.extractProperty(iilist[pt], args, ptr, null, true) : "";
                }
                if (AU.isAFF(property)) {
                    float[][] fflist = (float[][])property;
                    if (pt < 0) {
                        pt += fflist.length;
                    }
                    return pt >= 0 && pt < fflist.length ? this.extractProperty(fflist[pt], args, ptr, null, true) : "";
                }
                if (AU.isAS(property)) {
                    String[] slist = (String[])property;
                    if (pt < 0) {
                        pt += slist.length;
                    }
                    return pt >= 0 && pt < slist.length ? slist[pt] : "";
                }
                if (!(property instanceof Object[])) break;
                Object[] olist = (Object[])property;
                if (pt < 0) {
                    pt += olist.length;
                }
                return pt >= 0 && pt < olist.length ? olist[pt] : "";
            }
            case 4: 
            case 1275082241: {
                if (property instanceof Map) {
                    boolean wasV2;
                    boolean havePunctuation;
                    int i;
                    String key;
                    Map h = (Map)property;
                    boolean asMap = false;
                    boolean asArray = false;
                    boolean isCaseSensitive = false;
                    Lst keys = arg.tok == 1275082241 ? (Lst)((Object[])arg.value)[0] : null;
                    T[] whereArgs = null;
                    if (arg.tok == 1275082241) {
                        isCaseSensitive = true;
                        whereArgs = (T[])((Object[])arg.value)[1];
                        key = arg.myName;
                        boolean bl = asArray = key.indexOf(";") >= 0;
                        if (key.contains("**")) {
                            boolean isAll = keys.size() == 0;
                            String newKey = "";
                            for (Map.Entry e : h.entrySet()) {
                                String k = (String)e.getKey();
                                int n = i = isAll ? 1 : keys.size();
                                block12: while (--i >= 0) {
                                    if (!isAll && !PT.isLike(k, (String)keys.get(i))) continue;
                                    Object o = e.getValue();
                                    boolean isList = false;
                                    switch (o instanceof SV ? ((SV)o).tok : 0) {
                                        case 7: {
                                            isList = true;
                                            o = ((SV)o).getList();
                                            break;
                                        }
                                        case 6: 
                                        case 14: {
                                            o = ((SV)o).getMap();
                                            break;
                                        }
                                        default: {
                                            if (o instanceof Map || (isList = o instanceof Lst)) break;
                                            if (isList || whereArgs == null) continue block12;
                                            Hashtable<String, SV> map = new Hashtable<String, SV>();
                                            map.put("key", SV.newS(k));
                                            map.put("value", (SV)e.getValue());
                                            if (!this.vwr.checkSelect(map, whereArgs)) continue block12;
                                            newKey = newKey + "," + k;
                                            continue block12;
                                        }
                                    }
                                    if (isList) {
                                        if (v2 == null) {
                                            v2 = new Lst();
                                        }
                                        Lst olst = (Lst)o;
                                        int n2 = olst.size();
                                        for (int j = 0; j < n2; ++j) {
                                            o = olst.get(j);
                                            if (!(o instanceof SV) || (o = ((SV)o).getMap()) == null || whereArgs != null && !this.vwr.checkSelect((Map)o, whereArgs)) continue;
                                            v2.addLast(o);
                                        }
                                        return v2;
                                    }
                                    if (whereArgs != null && !this.vwr.checkSelect((Map)o, whereArgs)) continue;
                                    newKey = newKey + "," + k;
                                }
                            }
                            if (newKey.length() == 0) {
                                return new Lst();
                            }
                            key = newKey.substring(1);
                            asMap = !asArray;
                            keys = null;
                        } else if (whereArgs != null && !this.vwr.checkSelect((Map)property, whereArgs)) {
                            return "";
                        }
                    } else {
                        key = arg.asString();
                        if (key.equalsIgnoreCase("keys")) {
                            Lst<String> lst = new Lst<String>();
                            for (String k : h.keySet()) {
                                lst.addLast(k);
                            }
                            return this.extractProperty(lst, args, ptr, null, true);
                        }
                    }
                    boolean bl = havePunctuation = asArray || key.indexOf(",") >= 0 || key.indexOf(";") >= 0;
                    if (isCaseSensitive && !havePunctuation) {
                        havePunctuation = true;
                        key = key + ",";
                    }
                    boolean isWild = asArray || key.startsWith("*") || key.endsWith("*") || havePunctuation;
                    boolean bl2 = wasV2 = v2 != null;
                    if (isWild) {
                        if (!wasV2) {
                            v2 = new Lst();
                        }
                        if (!asArray && (keys == null ? key.length() == 1 : keys.size() == 0)) {
                            if (ptr == args.length) {
                                if (!wasV2) {
                                    return property;
                                }
                                v2.addLast(property);
                                return v2;
                            }
                            return this.extractProperty(property, args, ptr, v2, true);
                        }
                    }
                    if (key.contains("**")) {
                        key = PT.rep(key, "**", "*");
                    }
                    if (isWild && !havePunctuation) {
                        key = key + ",";
                    }
                    if (asMap || asArray || key.contains(",")) {
                        Hashtable<String, Object> mapNew = new Hashtable<String, Object>();
                        if (keys != null && keys.size() == 0) {
                            keys = null;
                            key = "*";
                        }
                        asArray |= arg.index == 1;
                        if (keys == null) {
                            String[] tokens = PT.split(key, ",");
                            i = tokens.length;
                            while (--i >= 0) {
                                PropertyManager.getMapSubset(h, tokens[i], mapNew, asArray ? v2 : null);
                            }
                        } else {
                            for (int i2 = 0; i2 < keys.size(); ++i2) {
                                key = (String)keys.get(i2);
                                String index = null;
                                int pta = key.indexOf(91);
                                if (pta > 0 && key.endsWith("]")) {
                                    index = key.substring(pta + 1, key.length() - 1);
                                    key = key.substring(0, pta);
                                    index = PT.trim(index, "'\"");
                                } else {
                                    pta = key.indexOf(".");
                                    if (pta >= 0) {
                                        index = key.substring(pta + 1);
                                        key = key.substring(0, pta);
                                    }
                                }
                                int v2len0 = v2.size();
                                PropertyManager.getMapSubset(h, key, mapNew, asArray ? v2 : null);
                                if (index == null) continue;
                                int j = v2.size();
                                while (--j >= v2len0) {
                                    Object v = v2.get(j);
                                    if (!(v instanceof SV)) continue;
                                    SV sv = (SV)v;
                                    Map<String, SV> m = sv.getMap();
                                    if (m != null) {
                                        v = m.get(index);
                                    } else {
                                        int p = PT.parseInt(index);
                                        Lst<SV> l = sv.getList();
                                        v = p >= 0 && p < l.size() ? l.get(p) : null;
                                    }
                                    if (v == null) {
                                        v2.removeItemAt(j);
                                        continue;
                                    }
                                    v2.set(j, v);
                                }
                            }
                        }
                        if (asMap && !wasV2) {
                            return mapNew;
                        }
                        if (ptr == args.length) {
                            if (!asArray) {
                                if (!wasV2) {
                                    return mapNew;
                                }
                                v2.addLast(mapNew);
                            }
                            return v2;
                        }
                        return this.extractProperty(mapNew, args, ptr, wasV2 ? v2 : null, true);
                    }
                    return (key = this.checkMap(h, key, isWild, v2, args, ptr, isCaseSensitive)) != null && !isWild ? this.extractProperty(h.get(key), args, ptr, null, true) : (!isWild ? "" : (wasV2 ? v2 : v2));
                }
                if (!(property instanceof Lst)) break;
                Lst v = (Lst)property;
                if (v2 == null) {
                    v2 = new Lst();
                }
                --ptr;
                boolean isList = false;
                for (int pt = 0; pt < v.size(); ++pt) {
                    Object o = v.get(pt);
                    if (!(o instanceof Map) && !(isList = o instanceof Lst) && (!(o instanceof SV) || ((SV)o).getMap() == null && !(isList = ((SV)o).getList() != null))) continue;
                    if (isList || arg.index == 1) {
                        Object ret = this.extractProperty(o, args, ptr, null, true);
                        if (ret == "") continue;
                        v2.addLast(ret);
                        continue;
                    }
                    this.extractProperty(o, args, ptr, v2, true);
                }
                return v2;
            }
        }
        return prop;
    }

    private static void getMapSubset(Map<String, ?> h, String key, Map<String, Object> h2, Lst<Object> v2) {
        Object val;
        if (key.startsWith("\"") || key.startsWith("'")) {
            key = PT.trim(key, "\"'");
        }
        if ((val = h.get(key)) != null) {
            if (v2 == null) {
                h2.put(key, val);
            } else {
                v2.addLast(val);
            }
            return;
        }
        for (Map.Entry<String, ?> e : h.entrySet()) {
            String k = e.getKey();
            if (!PT.isLike(k, key)) continue;
            if (v2 == null) {
                h2.put(k, e.getValue());
                continue;
            }
            v2.addLast(e.getValue());
        }
    }

    private SV[] compileSelect(SV[] args) {
        SV[] argsNew = null;
        int i = args.length;
        while (--i >= 0) {
            String ext;
            int pt;
            if (args[i].tok != 4) continue;
            String key = (String)args[i].value;
            String ucKey = key.toUpperCase();
            if (ucKey.startsWith("WHERE")) {
                key = "SELECT * " + key;
                ucKey = key.toUpperCase();
            }
            if (!ucKey.startsWith("SELECT ")) continue;
            if (argsNew == null) {
                argsNew = (SV[])AU.arrayCopyObject(args, args.length);
            }
            if ((ucKey = (key = key.substring(6).trim()).toUpperCase()).startsWith("WHERE ") || ucKey.startsWith("WHEREIN ")) {
                key = "* " + key;
                ucKey = key.toUpperCase();
            }
            String string = (pt = ucKey.indexOf(" WHEREIN ")) < 0 ? "" : (ext = key.indexOf(";") >= 0 ? ";**" : ",**");
            if (pt < 0) {
                pt = ucKey.indexOf(" WHERE ");
            }
            String select = key.substring(0, pt < 0 ? key.length() : pt).trim();
            int index = 0;
            if (select.startsWith("(") && select.endsWith(")")) {
                select = select.substring(1, select.length() - 1) + ";";
            } else if (select.startsWith("[") && select.endsWith("]")) {
                select = select.substring(1, select.length() - 1);
                index = 1;
            }
            if (pt < 0) {
                argsNew[i] = SV.newV(1275082241, new Object[]{this.getKeys(select), null});
                argsNew[i].myName = select;
                argsNew[i].index = index;
                continue;
            }
            select = select + ext;
            String exp = key.substring(pt + 6 + ext.length()).trim();
            T[] list = this.vwr.compileExpr(exp);
            Object[] o = new Object[]{this.getKeys(select), list};
            argsNew[i] = SV.newV(1275082241, o);
            argsNew[i].index = index;
            argsNew[i].myName = select;
        }
        return argsNew == null ? args : argsNew;
    }

    private Lst<String> getKeys(String select) {
        Lst<String> keys = new Lst<String>();
        select = PT.rep(PT.rep(select, "**", "*"), ";", ",") + ",";
        int pt0 = 0;
        int pt1 = -1;
        while ((pt1 = select.indexOf(",", pt1 + 1)) >= 0) {
            if (pt1 <= pt0) continue;
            String key = select.substring(pt0, pt1);
            if (key.equals("*")) {
                if (keys.size() != 0) continue;
                return keys;
            }
            keys.addLast(key);
            pt0 = pt1 + 1;
        }
        return keys;
    }

    private String checkMap(Map<String, ?> h, String key, boolean isWild, Lst<Object> v2, Object args, int ptr, boolean isCaseSensitive) {
        boolean isOK;
        boolean bl = isOK = v2 == null && h.containsKey(key);
        if (!isOK) {
            boolean hasSemi = key.contains(";");
            String[] keys = hasSemi ? PT.split(key, ";") : null;
            String lckey = isWild && !isCaseSensitive ? key.toLowerCase() : null;
            for (String k : h.keySet()) {
                if (hasSemi) {
                    int i = keys.length;
                    while (--i >= 0) {
                        key = keys[i];
                        if (key.length() != 0) {
                            if (isCaseSensitive) {
                                if (PT.isLike(k, key)) break;
                            } else {
                                String string = lckey = key.indexOf("*") >= 0 ? key.toLowerCase() : null;
                                if (this.checkKey(k, key, lckey)) break;
                            }
                        }
                        key = null;
                    }
                    if (key == null) {
                        continue;
                    }
                } else if (!isCaseSensitive ? !this.checkKey(k, key, lckey) : !PT.isLike(k, key)) continue;
                if (v2 == null) {
                    return k;
                }
                v2.addLast(this.extractProperty(h.get(k), args, ptr, null, true));
                if (isWild || hasSemi) continue;
                return null;
            }
        }
        return isOK ? key : null;
    }

    private boolean checkKey(String k, String key, String lckey) {
        return k.equalsIgnoreCase(key) || lckey != null && PT.isLike(k.toLowerCase(), lckey);
    }

    private static String getPropertyName(int propID) {
        return propID < 0 ? "" : propertyTypes[propID * 3];
    }

    private static String getParamType(int propID) {
        return propID < 0 ? "" : propertyTypes[propID * 3 + 1];
    }

    private static boolean isReadableAsString(String infoType) {
        int i = readableTypes.length;
        while (--i >= 0) {
            if (!infoType.equalsIgnoreCase(readableTypes[i])) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyAsObject(String infoType, Object paramInfo, String returnType) {
        boolean iHaveParameter;
        if (infoType.equals("tokenList")) {
            return T.getTokensLike((String)paramInfo);
        }
        Object myParam = null;
        int pt = infoType.indexOf("#");
        if (pt > 0) {
            myParam = new Object[]{infoType.substring(pt + 1), paramInfo};
            infoType = infoType.substring(0, pt);
        }
        int id = this.getPropertyNumber(infoType);
        boolean bl = iHaveParameter = myParam != null || paramInfo != null && paramInfo != "";
        if (myParam == null) {
            myParam = iHaveParameter ? paramInfo : this.getDefaultPropertyParam(id);
        }
        switch (id) {
            case 47: {
                return this.getUnitCellInfo();
            }
            case 46: {
                return this.vwr.getModelkitPropertySafely(myParam.toString());
            }
            case 0: {
                return this.getAppletInfo();
            }
            case 5: {
                return this.getAnimationInfo();
            }
            case 14: {
                return this.getAllAtomInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 24: {
                return this.vwr.getModelSetAuxiliaryInfoForAtoms(myParam);
            }
            case 15: {
                return this.getAllBondInfo(myParam);
            }
            case 25: {
                return this.getBoundBoxInfo();
            }
            case 10: {
                return this.vwr.tm.fixedRotationCenter;
            }
            case 16: {
                return this.getAllChainInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 37: {
                return this.vwr.getProperty("DATA_API", "consoleText", null);
            }
            case 26: {
                return this.vwr.getDataObj(myParam.toString(), null, -1);
            }
            case 33: {
                return this.vwr.getErrorMessageUn();
            }
            case 28: {
                return this.vwr.evaluateExpression(myParam.toString());
            }
            case 20: {
                return this.vwr.getModelExtract(myParam, true, false, "MOL");
            }
            case 32: {
                return PropertyManager.getFileInfo(this.vwr.getFileData(), myParam.toString());
            }
            case 45: {
                return this.vwr.readCifData(myParam.toString(), null);
            }
            case 1: {
                return this.vwr.fm.getFullPathName(false);
            }
            case 2: {
                return this.vwr.getFileHeader();
            }
            case 3: 
            case 4: {
                return iHaveParameter ? this.vwr.getFileAsString3(myParam.toString(), true, null) : this.vwr.getCurrentFileAsString("prop");
            }
            case 27: {
                String params = myParam.toString().toLowerCase();
                return this.getImage(params, params.indexOf("g64") < 0 && params.indexOf("base64") < 0 && (returnType == null || returnType.equalsIgnoreCase("java")));
            }
            case 35: {
                return this.vwr.getShapeProperty(24, "info");
            }
            case 36: {
                return this.vwr.getShapeProperty(24, "data");
            }
            case 40: {
                return this.vwr.getNMRCalculation().getInfo(myParam.toString());
            }
            case 41: {
                return this.getVariables(myParam.toString());
            }
            case 21: {
                return this.vwr.getStatusChanged(myParam.toString());
            }
            case 22: {
                return this.vwr;
            }
            case 38: {
                return this.vwr.getJspecViewProperties(myParam);
            }
            case 7: {
                return this.getLigandInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 9: {
                return this.getMeasurementInfo();
            }
            case 29: {
                return this.vwr.getMenu(myParam.toString());
            }
            case 23: {
                return this.vwr.sm.messageQueue;
            }
            case 30: {
                return this.vwr.getMinimizationInfo();
            }
            case 6: {
                return this.getModelInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 18: {
                return this.getMoleculeInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 34: {
                return this.getMouseInfo();
            }
            case 11: {
                return this.vwr.tm.getOrientationInfo();
            }
            case 31: {
                return this.vwr.ms.getPointGroupInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 17: {
                return this.getAllPolymerInfo(this.vwr.getAtomBitSet(myParam));
            }
            case 39: {
                return this.vwr.getScriptQueueInfo();
            }
            case 8: {
                return this.getShapeInfo();
            }
            case 19: {
                return this.vwr.getStateInfo3(myParam.toString(), 0, 0);
            }
            case 12: {
                return M3.newM3(this.vwr.tm.matrixRotate);
            }
            case 42: {
                return this.getAnnotationInfo(myParam, 1073741925);
            }
            case 43: {
                return this.getAnnotationInfo(myParam, 1073742189);
            }
            case 44: {
                myParam = SV.oValue(myParam);
                Map info = myParam instanceof Map ? (Map)myParam : null;
                return info == null ? null : this.vwr.sm.processService(info);
            }
        }
        Object[] data = new String[48];
        for (int i = 0; i < 48; ++i) {
            String paramType = PropertyManager.getParamType(i);
            String paramDefault = this.getDefaultPropertyParam(i);
            String name = PropertyManager.getPropertyName(i);
            data[i] = name.length() == 0 || name.charAt(0) == 'X' ? "" : name + (paramType != "" ? " " + PropertyManager.getParamType(i) + (paramDefault != "" ? " #default: " + this.getDefaultPropertyParam(i) : "") : "");
        }
        Arrays.sort(data);
        SB info = new SB();
        info.append("getProperty ERROR\n").append(infoType).append("?\nOptions include:\n");
        for (int i = 0; i < 48; ++i) {
            if (((String)data[i]).length() <= 0) continue;
            info.append("\n getProperty ").append((String)data[i]);
        }
        return info.toString();
    }

    private Object getUnitCellInfo() {
        SymmetryInterface uc = this.vwr.getCurrentUnitCell();
        return uc == null ? "" : uc.getUnitCellInfoMap();
    }

    private Object getImage(String params, boolean asBytes) {
        int height = -1;
        int width = -1;
        int pt = params.indexOf("height=");
        if (pt >= 0) {
            height = PT.parseInt(params.substring(pt + 7));
        }
        if ((pt = params.indexOf("width=")) >= 0) {
            width = PT.parseInt(params.substring(pt + 6));
        }
        if (width < 0 && height < 0) {
            width = -1;
            height = -1;
        } else if (width < 0) {
            width = height;
        } else {
            height = width;
        }
        String type = "JPG";
        if (params.indexOf("type=") >= 0) {
            type = PT.getTokens(PT.replaceWithCharacter(params.substring(params.indexOf("type=") + 5), ";,", ' '))[0];
        }
        String[] errMsg = new String[1];
        byte[] bytes = this.vwr.getImageAsBytes(type.toUpperCase(), width, height, -1, errMsg);
        return errMsg[0] != null ? errMsg[0] : (asBytes ? new BArray(bytes) : Base64.getBase64(bytes).toString());
    }

    private Object getVariables(String name) {
        return name.toLowerCase().equals("all") ? this.vwr.g.getAllVariables() : this.vwr.evaluateExpressionAsVariable(name);
    }

    static Object getFileInfo(Object objHeader, String type) {
        boolean haveType;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (objHeader == null) {
            return ht;
        }
        boolean bl = haveType = type != null && type.length() > 0;
        if (objHeader instanceof Map) {
            return haveType ? ((Map)objHeader).get(type) : objHeader;
        }
        String[] lines = PT.split((String)objHeader, "\n");
        if (lines.length == 0 || lines[0].length() < 7 || lines[0].charAt(6) != ' ' || !lines[0].substring(0, 6).equals(lines[0].substring(0, 6).toUpperCase())) {
            ht.put("fileHeader", (String)objHeader);
            return ht;
        }
        String keyLast = "";
        SB sb = new SB();
        if (haveType) {
            type = type.toUpperCase();
        }
        String key = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() < 12) continue;
            key = line.substring(0, 6).trim();
            String cont = line.substring(7, 10).trim();
            if (key.equals("REMARK")) {
                key = key + cont;
            }
            if (!key.equals(keyLast)) {
                if (haveType && keyLast.equals(type)) {
                    return sb.toString();
                }
                if (!haveType) {
                    ht.put(keyLast, sb.toString());
                    sb = new SB();
                }
                keyLast = key;
            }
            if (haveType && !key.equals(type)) continue;
            sb.append(line).appendC('\n');
        }
        if (!haveType) {
            ht.put(keyLast, sb.toString());
        }
        if (haveType) {
            return key.equals(type) ? sb.toString() : "";
        }
        return ht;
    }

    public Lst<Map<String, Object>> getMoleculeInfo(Object atomExpression) {
        BS bsAtoms = this.vwr.getAtomBitSet(atomExpression);
        JmolMolecule[] molecules = this.vwr.ms.getMolecules();
        Lst<Map<String, Object>> V = new Lst<Map<String, Object>>();
        BS bsTemp = new BS();
        for (int i = 0; i < molecules.length; ++i) {
            bsTemp = BSUtil.copy(bsAtoms);
            JmolMolecule m = molecules[i];
            bsTemp.and(m.atomList);
            if (bsTemp.length() <= 0) continue;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("mf", m.getMolecularFormula(true, null, false));
            info.put("number", m.moleculeIndex + 1);
            info.put("modelNumber", this.vwr.ms.getModelNumberDotted(m.modelIndex));
            info.put("numberInModel", m.indexInModel + 1);
            info.put("nAtoms", m.ac);
            info.put("nElements", m.nElements);
            V.addLast((Map<String, Object>)info);
        }
        return V;
    }

    @Override
    public Map<String, Object> getModelInfo(Object atomExpression) {
        BS bsModels = this.vwr.ms.getModelBS(this.vwr.getAtomBitSet(atomExpression), false);
        ModelSet m = this.vwr.ms;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("modelSetName", m.modelSetName);
        info.put("modelIndex", this.vwr.am.cmi);
        info.put("modelCount", m.mc);
        info.put("isTainted", m.tainted != null);
        info.put("canSkipLoad", m.canSkipLoad);
        info.put("modelSetHasVibrationVectors", m.modelSetHasVibrationVectors());
        if (m.modelSetProperties != null) {
            info.put("modelSetProperties", m.modelSetProperties);
        }
        info.put("modelCountSelected", bsModels.cardinality());
        info.put("modelsSelected", bsModels);
        Lst vModels = new Lst();
        m.getMolecules();
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            Float energy;
            Hashtable<String, Object> model = new Hashtable<String, Object>();
            model.put("_ipt", i);
            model.put("num", m.getModelNumber(i));
            model.put("file_model", m.getModelNumberDotted(i));
            model.put("name", m.getModelName(i));
            String s = m.getModelTitle(i);
            if (s != null) {
                model.put("title", s);
            }
            if ((s = m.getModelFileName(i)) != null) {
                model.put("file", s);
            }
            if ((s = (String)m.getInfo(i, "modelID")) != null) {
                model.put("id", s);
            }
            model.put("vibrationVectors", this.vwr.modelHasVibrationVectors(i));
            Model mi = m.am[i];
            model.put("atomCount", mi.act);
            model.put("bondCount", mi.getBondCount());
            model.put("groupCount", mi.getGroupCount());
            model.put("moleculeCount", mi.moleculeCount);
            if (mi.isBioModel) {
                model.put("polymerCount", ((BioModel)mi).getBioPolymerCount());
            }
            model.put("chainCount", m.getChainCountInModelWater(i, true));
            if (mi.properties != null) {
                model.put("modelProperties", mi.properties);
            }
            if ((energy = (Float)m.getInfo(i, "Energy")) != null) {
                model.put("energy", energy);
            }
            model.put("atomCount", mi.act);
            vModels.addLast(model);
            i = bsModels.nextSetBit(i + 1);
        }
        info.put("models", vModels);
        return info;
    }

    @Override
    public Map<String, Object> getLigandInfo(Object atomExpression) {
        BS bsAtoms = this.vwr.getAtomBitSet(atomExpression);
        BS bsSolvent = this.vwr.getAtomBitSet("solvent");
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        Lst ligands = new Lst();
        info.put("ligands", ligands);
        ModelSet ms = this.vwr.ms;
        BS bsExclude = BSUtil.copyInvert(bsAtoms, ms.ac);
        bsExclude.or(bsSolvent);
        Node[] atoms = ms.at;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            if (atoms[i].group.isProtein() || atoms[i].group.isDna() || atoms[i].group.isRna()) {
                atoms[i].group.setAtomBitsAndClear(bsExclude, bsAtoms);
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        BS[] bsModelAtoms = new BS[ms.mc];
        int i2 = ms.mc;
        while (--i2 >= 0) {
            bsModelAtoms[i2] = this.vwr.getModelUndeletedAtomsBitSet(i2);
            bsModelAtoms[i2].andNot(bsExclude);
        }
        JmolMolecule[] molList = JmolMolecule.getMolecules(atoms, bsModelAtoms, null, bsExclude);
        for (int i3 = 0; i3 < molList.length; ++i3) {
            BS bs = molList[i3].atomList;
            Hashtable<String, String> ligand = new Hashtable<String, String>();
            ligands.addLast(ligand);
            ligand.put("atoms", Escape.eBS(bs));
            String names = "";
            String sep = "";
            Group lastGroup = null;
            int iChainLast = 0;
            String sChainLast = null;
            String reslist = "";
            String model = "";
            int resnolast = Integer.MAX_VALUE;
            int resnofirst = Integer.MAX_VALUE;
            int j = bs.nextSetBit(0);
            while (j >= 0) {
                Node atom = atoms[j];
                if (lastGroup != ((Atom)atom).group) {
                    lastGroup = ((Atom)atom).group;
                    int resno = ((Atom)atom).getResno();
                    int chain = ((Atom)atom).getChainID();
                    if (resnolast != resno - 1) {
                        if (reslist.length() != 0 && resnolast != resnofirst) {
                            reslist = reslist + "-" + resnolast;
                        }
                        chain = -1;
                        resnofirst = resno;
                    }
                    model = "/" + ms.getModelNumberDotted(((Atom)atom).mi);
                    if (iChainLast != 0 && chain != iChainLast) {
                        reslist = reslist + ":" + sChainLast + model;
                    }
                    if (chain == -1) {
                        reslist = reslist + " " + resno;
                    }
                    resnolast = resno;
                    iChainLast = ((Atom)atom).getChainID();
                    sChainLast = ((Atom)atom).getChainIDStr();
                    names = names + sep + ((Atom)atom).getGroup3(false);
                    sep = "-";
                }
                j = bs.nextSetBit(j + 1);
            }
            reslist = reslist + (resnofirst == resnolast ? "" : "-" + resnolast) + (iChainLast == 0 ? "" : ":" + sChainLast) + model;
            ligand.put("groupNames", names);
            ligand.put("residueList", reslist.substring(1));
        }
        return info;
    }

    @Override
    public String getAtomData(String atomExpression, String type, boolean allTrajectories) {
        String exp;
        if (!atomExpression.startsWith("{")) {
            atomExpression = "{" + atomExpression + "}";
        }
        boolean isUser = type.toLowerCase().startsWith("user:");
        boolean isProp = type.toLowerCase().startsWith("property_");
        if (allTrajectories && !isUser && !isProp) {
            type = type.toUpperCase();
        }
        String string = isProp ? "%{" + type + "}" : (isUser ? type.substring(5) : (type.equals("xyzrn") ? "%-2e %8.3x %8.3y %8.3z %4.2[vdw] 1 [%n]%r.%a#%i" : (type.equals("xyzvib") ? "%-2e %10.5x %10.5y %10.5z %10.5vx %10.5vy %10.5vz" : (type.equals("pdb") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (type.equals("xyz") ? "%-2e %10.5x %10.5y %10.5z" : (exp = type.equals("cfi") ? "print '$CFI from Jmol" + Viewer.getJmolVersion() + "\n'+{selected}.count + ' ' + {selected}.bonds.count + '\n'   + {selected}.format('%10.0[atomno] %10.0[elemno] %10.4[xyz]')  + {selected}.bonds.format('%i1 %i2') + '\n' + {selected}.bonds.format('%ORDER')" : null))))));
        if (exp == null) {
            return this.getModelExtract(this.vwr.getAtomBitSet(atomExpression), false, false, type.toUpperCase(), allTrajectories);
        }
        if (exp.startsWith("print")) {
            if (!atomExpression.equals("selected")) {
                exp = PT.rep(exp, "selected", atomExpression.substring(1, atomExpression.length() - 1));
            }
            return this.vwr.runScriptCautiously(exp);
        }
        if (exp.indexOf("label") < 0) {
            exp = atomExpression + ".label(\"" + exp + "\").lines";
        } else if (!atomExpression.equals("selected")) {
            exp = PT.rep(exp, "selected", atomExpression.substring(1, atomExpression.length() - 1));
        }
        return (String)this.vwr.evaluateExpression(exp);
    }

    @Override
    public String getModelExtract(BS bs, boolean doTransform, boolean isModelKit, String type, boolean allTrajectories) {
        Quat q;
        if (bs.nextSetBit(0) < 0) {
            return "";
        }
        String uc = type.toUpperCase();
        if (PT.isOneOf(uc, ";CIF;QCJSON;XSF;PWMAT;")) {
            return this.getModel(uc, bs, null, null);
        }
        if (uc.equals("PWSLAB")) {
            return this.getModel("PWMAT", bs, new Object[]{"slab"}, null);
        }
        if (uc.equals("SCIF")) {
            return this.getModel("CIF", bs, null, null);
        }
        if (uc.equals("CIFP1")) {
            return this.getModel("CIF", bs, new Object[]{"P1"}, null);
        }
        if (uc.equals("CML")) {
            return this.getModelCml(bs, Integer.MAX_VALUE, true, doTransform, allTrajectories);
        }
        if (uc.equals("PDB") || uc.equals("PQR")) {
            return this.getPdbAtomData(bs, null, uc.equals("PQR"), doTransform, allTrajectories);
        }
        boolean asV3000 = uc.equals("V3000");
        boolean asSDF = uc.equals("SDF");
        boolean noAromatic = uc.equals("MOL");
        boolean asXYZVIB = !doTransform && uc.equals("XYZVIB");
        boolean asXYZRN = uc.equals("XYZRN");
        boolean isXYZ = uc.startsWith("XYZ");
        boolean asJSON = uc.equals("JSON") || uc.equals("CD");
        SB mol = new SB();
        ModelSet ms = this.vwr.ms;
        BS bsModels = this.vwr.ms.getModelBS(bs, true);
        boolean is2D = "2D".equals(this.vwr.getModelInfo("dimension"));
        Atom[] atoms = ms.at;
        BS bsAtoms = BSUtil.copy(bs);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (doTransform && atoms[i].isDeleted()) {
                bsAtoms.clear(i);
            }
            i = bs.nextSetBit(i + 1);
        }
        if (!asXYZVIB && bsAtoms.isEmpty()) {
            return "";
        }
        BS bsBonds = PropertyManager.getCovalentBondsForAtoms(ms.bo, ms.bondCount, bsAtoms);
        boolean isOK = true;
        if (ms.trajectory != null && !allTrajectories) {
            ms.trajectory.selectDisplayed(bsModels);
        }
        Quat quat = q = doTransform ? this.vwr.tm.getRotationQ() : null;
        if (isXYZ) {
            this.writeXYZ(mol, bsAtoms, bsModels, q, asXYZVIB, asXYZRN);
        } else {
            String title = this.vwr.ms.getFrameTitle(bsModels.nextSetBit(0));
            title = title != null ? title.replace('\n', ' ') : (isModelKit ? "Jmol Model Kit" : FileManager.fixDOSName(this.vwr.fm.getFullPathName(false)));
            MOLWriter mw = ((MOLWriter)Interface.getInterface("org.jmol.adapter.writers.MOLWriter", this.vwr, "write")).setViewer(this.vwr);
            if (asSDF) {
                mol = new SB();
                int i2 = bsModels.nextSetBit(0);
                while (i2 >= 0) {
                    BS bsTemp = BSUtil.copy(bsAtoms);
                    bsTemp.and(ms.getModelAtomBitSetIncludingDeleted(i2, false));
                    bsBonds = PropertyManager.getCovalentBondsForAtoms(ms.bo, ms.bondCount, bsTemp);
                    isOK = mw.addMolFile(title, i2, mol, bsTemp, bsBonds, false, false, noAromatic, q, is2D);
                    if (isOK) {
                        i2 = bsModels.nextSetBit(i2 + 1);
                        continue;
                    }
                    break;
                }
            } else {
                isOK = mw.addMolFile(title, -1, mol, bsAtoms, bsBonds, asV3000, asJSON, noAromatic, q, is2D);
            }
        }
        return isOK ? mol.toString() : "ERROR: Too many atoms or bonds -- use V3000 format.";
    }

    private void writeXYZ(SB mol, BS bsAtoms, BS bsModels, Quat q, boolean asXYZVIB, boolean asXYZRN) {
        ModelSet ms = this.vwr.ms;
        Atom[] atoms = ms.at;
        LabelToken[] tokensXYZ = LabelToken.compile(this.vwr, asXYZRN ? "%-2e _XYZ_ %4.2[vdw] 1 [%n]%r.%a#%i\n" : "%-2e _XYZ_\n", '\u0000', null);
        LabelToken[] tokensVib = asXYZVIB ? LabelToken.compile(this.vwr, "%-2e _XYZ_ %12.5vx %12.5vy %12.5vz\n", '\u0000', null) : null;
        P3 ptTemp = new P3();
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            BS bsTemp = BSUtil.copy(bsAtoms);
            bsTemp.and(ms.getModelAtomBitSetIncludingDeleted(i, false));
            if (!bsTemp.isEmpty()) {
                mol.appendI(bsTemp.cardinality()).appendC('\n');
                Properties props = ms.am[i].properties;
                mol.append("Model[" + (i + 1) + "]: ");
                if (ms.frameTitles[i] != null && ms.frameTitles[i].length() > 0) {
                    mol.append(ms.frameTitles[i].replace('\n', ' '));
                } else if (props == null) {
                    mol.append("Jmol " + Viewer.getJmolVersion());
                } else {
                    SB sb = new SB();
                    Enumeration<?> e = props.propertyNames();
                    String path = null;
                    while (e.hasMoreElements()) {
                        String propertyName = (String)e.nextElement();
                        if (propertyName.equals(".PATH")) {
                            path = props.getProperty(propertyName);
                            continue;
                        }
                        sb.append(";").append(propertyName).append("=").append(props.getProperty(propertyName));
                    }
                    if (path != null) {
                        sb.append(";PATH=").append(path);
                    }
                    path = sb.substring(sb.length() > 0 ? 1 : 0);
                    mol.append(path.replace('\n', ' '));
                }
                mol.appendC('\n');
                Object[] o = new Object[]{ptTemp};
                int j = bsTemp.nextSetBit(0);
                while (j >= 0) {
                    String s = LabelToken.formatLabelAtomArray(this.vwr, atoms[j], asXYZVIB && ms.getVibration(j, false) != null ? tokensVib : tokensXYZ, '\u0000', null, ptTemp);
                    ms.getPointTransf(i, atoms[j], q, ptTemp);
                    s = PT.rep(s, "_XYZ_", PT.sprintf("%12.5p %12.5p %12.5p", "p", o));
                    mol.append(s);
                    j = bsTemp.nextSetBit(j + 1);
                }
            }
            i = bsModels.nextSetBit(i + 1);
        }
    }

    private String getModel(String type, BS bs, Object[] data, OC out) {
        JmolWriter writer = (JmolWriter)Interface.getInterface("org.jmol.adapter.writers." + type + "Writer", this.vwr, "script");
        writer.set(this.vwr, out, data);
        return writer.write(bs);
    }

    private static BS getCovalentBondsForAtoms(Bond[] bonds, int bondCount, BS bsAtoms) {
        BS bsBonds = new BS();
        for (int i = 0; i < bondCount; ++i) {
            Bond bond = bonds[i];
            if (bond == null || !bsAtoms.get(bond.atom1.i) || !bsAtoms.get(bond.atom2.i) || !bond.isCovalent()) continue;
            bsBonds.set(i);
        }
        return bsBonds;
    }

    @Override
    public String getChimeInfo(int tok, BS bs) {
        switch (tok) {
            case 1073741982: {
                SB sb = new SB();
                this.vwr.getChimeMessenger().getAllChimeInfo(sb);
                return sb.appendC('\n').toString().substring(1);
            }
            case 1073741863: {
                return this.getBasePairInfo(bs);
            }
        }
        return this.getChimeInfoA(this.vwr.ms.at, tok, bs);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private String getChimeInfoA(Atom[] atoms, int tok, BS bs) {
        info = new SB().append("\n");
        s = "";
        clast = null;
        glast = null;
        modelLast = -1;
        n = 0;
        if (bs != null) {
            i = bs.nextSetBit(0);
            block10: while (i >= 0) {
                a = atoms[i];
                switch (tok) {
                    case 1113589787: {
                        s = a.getInfo();
                        ** break;
                    }
                    case 1153433601: {
                        s = "" + a.getAtomNumber();
                        ** break;
                    }
                    case 1086324742: {
                        s = a.getGroup3(false);
                        ** break;
                    }
                    case 1073742120: 
                    case 1086324743: 
                    case 1086324744: 
                    case 1086326788: {
                        id = a.getChainID();
                        v0 = s = id == 0 ? " " : a.getChainIDStr();
                        if (id >= 300) {
                            s = PT.esc(s);
                        }
                        switch (tok) {
                            case 1073742120: {
                                s = "[" + a.getGroup3(false) + "]" + a.group.getSeqcodeString() + ":" + s;
                                ** break;
                            }
                            case 1086324743: 
                            case 1086324744: {
                                if (a.mi != modelLast) {
                                    info.appendC('\n');
                                    n = 0;
                                    modelLast = a.mi;
                                    info.append("Model " + a.getModelNumber());
                                    glast = null;
                                    clast = null;
                                }
                                if (a.group.chain != clast) {
                                    info.appendC('\n');
                                    n = 0;
                                    clast = a.group.chain;
                                    info.append("Chain " + s + ":\n");
                                    glast = null;
                                }
                                if ((g = a.group) == glast) break;
                                glast = g;
                                if (tok == 1086324743) {
                                    info.append(a.getGroup1('?'));
                                    break;
                                }
                                if (n++ % 5 == 0 && n > 1) {
                                    info.appendC('\n');
                                }
                                PT.leftJustify(info, "          ", "[" + a.getGroup3(false) + "]" + a.getResno() + " ");
                                break;
                            }
lbl59:
                            // 2 sources

                            default: lbl-1000:
                            // 4 sources

                            {
                                if (info.indexOf("\n" + s + "\n") >= 0) break;
                                info.append(s).appendC('\n');
                            }
                        }
                        i = bs.nextSetBit(i + 1);
                        continue block10;
                    }
                    default: {
                        return "";
                    }
                }
            }
        }
        if (tok == 1086324744) {
            info.appendC('\n');
        }
        return info.toString().substring(1);
    }

    @Override
    public String getModelFileInfo(BS frames) {
        ModelSet ms = this.vwr.ms;
        SB sb = new SB();
        for (int i = 0; i < ms.mc; ++i) {
            if (frames != null && !frames.get(i)) continue;
            String s = "[\"" + ms.getModelNumberDotted(i) + "\"] = ";
            sb.append("\n\nfile").append(s).append(PT.esc(ms.getModelFileName(i)));
            String id = (String)ms.getInfo(i, "modelID");
            if (id != null) {
                sb.append("\nid").append(s).append(PT.esc(id));
            }
            sb.append("\ntitle").append(s).append(PT.esc(ms.getModelTitle(i)));
            sb.append("\nname").append(s).append(PT.esc(ms.getModelName(i)));
            sb.append("\ntype").append(s).append(PT.esc(ms.getModelFileType(i)));
        }
        return sb.toString();
    }

    public Lst<Map<String, Object>> getAllAtomInfo(BS bs) {
        Lst<Map<String, Object>> V = new Lst<Map<String, Object>>();
        P3 ptTemp = new P3();
        int imodel = -1;
        SymmetryInterface ucell = null;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            int mi = this.vwr.ms.at[i].getModelIndex();
            if (mi != imodel) {
                ucell = this.vwr.ms.getUnitCell(mi);
                imodel = mi;
            }
            V.addLast(this.getAtomInfoLong(i, ptTemp, ucell));
            i = bs.nextSetBit(i + 1);
        }
        return V;
    }

    private Map<String, Object> getAtomInfoLong(int i, P3 ptTemp, SymmetryInterface ucell) {
        ModelSet ms = this.vwr.ms;
        Atom atom = ms.at[i];
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        ms.getAtomIdentityInfo(i, info, ptTemp);
        info.put("element", ms.getElementName(i));
        info.put("elemno", ms.at[i].getElementNumber());
        info.put("x", Float.valueOf(atom.x));
        info.put("y", Float.valueOf(atom.y));
        info.put("z", Float.valueOf(atom.z));
        if (ucell != null) {
            ptTemp.setT(atom);
            ucell.toFractional(ptTemp, true);
            info.put("fx", Float.valueOf(ptTemp.x));
            info.put("fy", Float.valueOf(ptTemp.y));
            info.put("fz", Float.valueOf(ptTemp.z));
        }
        info.put("coord", P3.newP(atom));
        if (ms.vibrations != null && ms.vibrations[i] != null) {
            ms.vibrations[i].getInfo(info);
        }
        info.put("bondCount", atom.getCovalentBondCount());
        info.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        info.put("model", atom.getModelNumberForLabel());
        String shape = atom.atomPropertyString(this.vwr, 0x40C0000C);
        if (shape != null) {
            info.put("shape", shape);
        }
        info.put("visible", atom.checkVisible());
        info.put("clickabilityFlags", atom.clickabilityFlags);
        info.put("visibilityFlags", atom.shapeVisibilityFlags);
        info.put("spacefill", Float.valueOf(atom.getRadius()));
        String strColor = Escape.escapeColor(this.vwr.gdata.getColorArgbOrGray(atom.colixAtom));
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", atom.colixAtom);
        boolean isTranslucent = C.isColixTranslucent(atom.colixAtom);
        if (isTranslucent) {
            info.put("translucent", isTranslucent);
        }
        info.put("formalCharge", atom.getFormalCharge());
        info.put("partialCharge", Float.valueOf(atom.getPartialCharge()));
        float d = (float)atom.getSurfaceDistance100() / 100.0f;
        if (d >= 0.0f) {
            info.put("surfaceDistance", Float.valueOf(d));
        }
        if (ms.am[atom.mi].isBioModel) {
            info.put("resname", atom.getGroup3(false));
            char insCode = atom.group.getInsertionCode();
            int seqNum = atom.getResno();
            if (seqNum > 0) {
                info.put("resno", seqNum);
            }
            if (insCode != '\u0000') {
                info.put("insertionCode", "" + insCode);
            }
            info.put("name", ms.at[i].getAtomName());
            info.put("chain", atom.getChainIDStr());
            info.put("atomID", atom.atomID);
            info.put("groupID", atom.group.groupID);
            if (atom.altloc != '\u0000') {
                info.put("altLocation", "" + atom.altloc);
            }
            info.put("structure", atom.group.getProteinStructureType().getId());
            info.put("polymerLength", atom.group.getBioPolymerLength());
            info.put("occupancy", atom.getOccupancy100());
            int temp = atom.getBfactor100();
            info.put("temp", temp / 100);
        }
        return info;
    }

    public Lst<Map<String, Object>> getAllBondInfo(Object bsOrArray) {
        Lst<Map<String, Object>> v;
        block6: {
            P3 ptTemp;
            Bond[] bonds;
            int bondCount;
            block7: {
                block5: {
                    v = new Lst<Map<String, Object>>();
                    ModelSet ms = this.vwr.ms;
                    bondCount = ms.bondCount;
                    bonds = ms.bo;
                    if (bsOrArray instanceof String) {
                        bsOrArray = this.vwr.getAtomBitSet(bsOrArray);
                    }
                    ptTemp = new P3();
                    if (!(bsOrArray instanceof BS[])) break block5;
                    BS bs1 = ((BS[])bsOrArray)[0];
                    BS bs2 = ((BS[])bsOrArray)[1];
                    for (int i = 0; i < bondCount; ++i) {
                        if (bonds[i] == null) continue;
                        int ia = bonds[i].atom1.i;
                        int ib = bonds[i].atom2.i;
                        if ((!bs1.get(ia) || !bs2.get(ib)) && (!bs2.get(ia) || !bs1.get(ib))) continue;
                        v.addLast(this.getBondInfo(i, ptTemp));
                    }
                    break block6;
                }
                if (!(bsOrArray instanceof BondSet)) break block7;
                BS bs1 = (BS)bsOrArray;
                int i = bs1.nextSetBit(0);
                while (i >= 0 && i < bondCount) {
                    if (bonds[i] != null) {
                        v.addLast(this.getBondInfo(i, ptTemp));
                    }
                    i = bs1.nextSetBit(i + 1);
                }
                break block6;
            }
            if (!(bsOrArray instanceof BS)) break block6;
            BS bs1 = (BS)bsOrArray;
            int thisAtom = bs1.cardinality() == 1 ? bs1.nextSetBit(0) : -1;
            for (int i = 0; i < bondCount; ++i) {
                if (bonds[i] == null || !(thisAtom >= 0 ? bonds[i].atom1.i == thisAtom || bonds[i].atom2.i == thisAtom : bs1.get(bonds[i].atom1.i) && bs1.get(bonds[i].atom2.i))) continue;
                v.addLast(this.getBondInfo(i, ptTemp));
            }
        }
        return v;
    }

    private Map<String, Object> getBondInfo(int i, P3 ptTemp) {
        Bond bond = this.vwr.ms.bo[i];
        Atom atom1 = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("_bpt", i);
        Hashtable<String, Object> infoA = new Hashtable<String, Object>();
        this.vwr.ms.getAtomIdentityInfo(atom1.i, infoA, ptTemp);
        Hashtable<String, Object> infoB = new Hashtable<String, Object>();
        this.vwr.ms.getAtomIdentityInfo(atom2.i, infoB, ptTemp);
        info.put("atom1", infoA);
        info.put("atom2", infoB);
        info.put("jmol_order", "0x" + Integer.toHexString(bond.getBondType()));
        info.put("edge_type", bond.getBondType());
        info.put("order", Float.valueOf(Edge.getBondOrderNumberFromOrder(bond.getBondType())));
        info.put("type", Edge.getBondOrderNameFromOrder(bond.getBondType()));
        info.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        info.put("length_Ang", Float.valueOf(atom1.distance(atom2)));
        info.put("visible", bond.shapeVisibilityFlags != 0);
        String strColor = Escape.escapeColor(this.vwr.gdata.getColorArgbOrGray(bond.colix));
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", Integer.valueOf(bond.colix));
        if (C.isColixTranslucent(bond.colix)) {
            info.put("translucent", Boolean.TRUE);
        }
        return info;
    }

    public Map<String, Lst<Map<String, Object>>> getAllChainInfo(BS bs) {
        Hashtable<String, Lst<Map<String, Object>>> finalInfo = new Hashtable<String, Lst<Map<String, Object>>>();
        Lst modelVector = new Lst();
        int modelCount = this.vwr.ms.mc;
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Lst<Map<String, Lst<Map<String, Object>>>> info = this.getChainInfo(i, bs);
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", Integer.valueOf(i));
            modelInfo.put("chains", info);
            modelVector.addLast(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    private Lst<Map<String, Lst<Map<String, Object>>>> getChainInfo(int modelIndex, BS bs) {
        Model model = this.vwr.ms.am[modelIndex];
        int nChains = model.getChainCount(true);
        Lst<Map<String, Lst<Map<String, Object>>>> infoChains = new Lst<Map<String, Lst<Map<String, Object>>>>();
        P3 ptTemp = new P3();
        for (int i = 0; i < nChains; ++i) {
            Chain chain = model.getChainAt(i);
            Lst<Map<String, Object>> infoChain = new Lst<Map<String, Object>>();
            int nGroups = chain.groupCount;
            Hashtable<String, Lst<Map<String, Object>>> arrayName = new Hashtable<String, Lst<Map<String, Object>>>();
            for (int igroup = 0; igroup < nGroups; ++igroup) {
                Group group = chain.groups[igroup];
                if (!bs.get(group.firstAtomIndex)) continue;
                infoChain.addLast(group.getGroupInfo(igroup, ptTemp));
            }
            if (infoChain.isEmpty()) continue;
            arrayName.put("residues", infoChain);
            infoChains.addLast((Map<String, Lst<Map<String, Object>>>)arrayName);
        }
        return infoChains;
    }

    private Map<String, Lst<Map<String, Object>>> getAllPolymerInfo(BS bs) {
        Hashtable<String, Lst<Map<String, Object>>> info = new Hashtable<String, Lst<Map<String, Object>>>();
        if (this.vwr.ms.bioModelset != null) {
            this.vwr.ms.bioModelset.getAllPolymerInfo(bs, info);
        }
        return info;
    }

    private String getBasePairInfo(BS bs) {
        SB info = new SB();
        Lst<Bond> vHBonds = new Lst<Bond>();
        this.vwr.ms.calcRasmolHydrogenBonds(bs, bs, vHBonds, true, 1, false, null);
        int i = vHBonds.size();
        while (--i >= 0) {
            Bond b = (Bond)vHBonds.get(i);
            PropertyManager.getAtomResidueInfo(info, b.atom1);
            info.append(" - ");
            PropertyManager.getAtomResidueInfo(info, b.atom2);
            info.append("\n");
        }
        return info.toString();
    }

    private static void getAtomResidueInfo(SB info, Atom atom) {
        info.append("[").append(atom.getGroup3(false)).append("]").append(atom.group.getSeqcodeString()).append(":");
        int id = atom.getChainID();
        info.append(id == 0 ? " " : atom.getChainIDStr());
    }

    private Map<String, Object> getAppletInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("htmlName", this.vwr.htmlName);
        info.put("syncId", this.vwr.syncId);
        info.put("fullName", this.vwr.fullName);
        info.put("codeBase", "" + Viewer.appletCodeBase);
        if (this.vwr.isApplet) {
            info.put("documentBase", Viewer.appletDocumentBase);
            info.put("registry", this.vwr.sm.getRegistryInfo());
        }
        info.put("version", JC.version);
        info.put("date", JC.date);
        info.put("javaVendor", Viewer.strJavaVendor);
        info.put("javaVersion", Viewer.strJavaVersion + (!Viewer.isJS ? "" : (this.vwr.isWebGL ? "(WebGL)" : "(HTML5)")));
        info.put("operatingSystem", Viewer.strOSName);
        return info;
    }

    private Map<String, Object> getAnimationInfo() {
        AnimationManager am = this.vwr.am;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("firstModelIndex", am.firstFrameIndex);
        info.put("lastModelIndex", am.lastFrameIndex);
        info.put("animationDirection", am.animationDirection);
        info.put("currentDirection", am.currentDirection);
        info.put("displayModelIndex", am.cmi);
        if (am.animationFrames != null) {
            info.put("isMovie", Boolean.TRUE);
            info.put("frames", Escape.eAI(am.animationFrames));
            info.put("currentAnimationFrame", am.caf);
        }
        info.put("displayModelNumber", this.vwr.getModelNumberDotted(am.cmi));
        info.put("displayModelName", am.cmi >= 0 ? this.vwr.getModelName(am.cmi) : "");
        info.put("animationFps", am.animationFps);
        info.put("animationReplayMode", T.nameOf(am.animationReplayMode));
        info.put("firstFrameDelay", Float.valueOf(am.firstFrameDelay));
        info.put("lastFrameDelay", Float.valueOf(am.lastFrameDelay));
        info.put("animationOn", am.animationOn);
        info.put("animationPaused", am.animationPaused);
        return info;
    }

    private Map<String, Object> getBoundBoxInfo() {
        P3[] pts = this.vwr.ms.getBoxInfo(null, 1.0f).getBoundBoxPoints(true);
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("center", P3.newP(pts[0]));
        info.put("vector", V3.newV(pts[1]));
        info.put("corner0", P3.newP(pts[2]));
        info.put("corner1", P3.newP(pts[3]));
        return info;
    }

    private Map<String, Object> getShapeInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        SB commands = new SB();
        Shape[] shapes = this.vwr.shm.shapes;
        if (shapes != null) {
            for (int i = 0; i < 37; ++i) {
                Shape shape = shapes[i];
                if (shape == null) continue;
                String shapeType = JC.shapeClassBases[i];
                Object shapeDetail = shape.getShapeDetail();
                if (shapeDetail == null) continue;
                info.put(shapeType, shapeDetail);
            }
        }
        if (commands.length() > 0) {
            info.put("shapeCommands", commands.toString());
        }
        return info;
    }

    private SV getAnnotationInfo(Object atomExpression, int type) {
        BS bsAtoms = this.vwr.getAtomBitSet(atomExpression);
        int iModel = this.vwr.ms.getModelBS(bsAtoms, false).nextSetBit(0);
        if (iModel < 0) {
            return null;
        }
        Map<String, Object> modelinfo = this.vwr.ms.getModelAuxiliaryInfo(iModel);
        SV objAnn = (SV)modelinfo.get(type == 1073741925 ? "domains" : "validation");
        if (objAnn == null || objAnn.tok != 6) {
            return null;
        }
        this.vwr.getAnnotationParser(false).initializeAnnotation(objAnn, type, iModel);
        return objAnn.mapGet("_list");
    }

    private Lst<Map<String, Object>> getMeasurementInfo() {
        return (Lst)this.vwr.getShapeProperty(6, "info");
    }

    /*
     * WARNING - void declaration
     */
    private Object getMouseInfo() {
        if (!this.vwr.haveDisplay) {
            return null;
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        Lst<void> list = new Lst<void>();
        ActionManager am = this.vwr.acm;
        for (Object object : am.b.getBindings().values()) {
            void var5_5;
            if (object instanceof Boolean) continue;
            if (AU.isAI(object)) {
                int[] binding = (int[])object;
                String[] stringArray = new String[]{Binding.getMouseActionName(binding[0], false), ActionManager.getActionName(binding[1])};
            }
            list.addLast(var5_5);
        }
        info.put("bindings", list);
        info.put("bindingName", am.b.name);
        info.put("actionNames", ActionManager.actionNames);
        info.put("actionInfo", ActionManager.actionInfo);
        info.put("bindingInfo", PT.split(am.getBindingInfo(null), "\n"));
        return info;
    }

    @Override
    public String getPdbAtomData(BS bs, OC out, boolean isPQR, boolean doTransform, boolean allTrajectories) {
        if (this.vwr.ms.ac == 0 || bs.nextSetBit(0) < 0) {
            return "";
        }
        return this.getModel("PDB", bs, new Object[]{isPQR, doTransform, allTrajectories}, out);
    }

    @Override
    public String getPdbData(int modelIndex, String type, BS bsSelected, Object[] parameters, OC out, boolean addStructure) {
        if (this.vwr.ms.isJmolDataFrame(modelIndex)) {
            modelIndex = this.vwr.ms.getJmolDataSourceFrame(modelIndex);
        }
        if (modelIndex < 0) {
            return "";
        }
        Model model = this.vwr.ms.am[modelIndex];
        boolean isPDB = model.isBioModel;
        if (parameters == null && !isPDB) {
            return null;
        }
        if (out == null) {
            out = this.vwr.getOutputChannel(null, null);
        }
        SB pdbCONECT = new SB();
        boolean isDraw = type.indexOf("draw") >= 0;
        boolean isSpin = type.indexOf("spin") >= 0;
        BS bsAtoms = null;
        BS bsWritten = new BS();
        char ctype = '\u0000';
        this.vwr.ms.getLabeler();
        LabelToken[] tokens = LabelToken.compile(this.vwr, "ATOM  %-6i%4a%1A%3.-3n %1c%4R%1E   ", '\u0000', null);
        if (parameters == null) {
            ctype = type.length() > 11 && type.indexOf("quaternion ") >= 0 ? (char)type.charAt(11) : (char)'R';
            ((BioModel)model).getPdbData(type, ctype, isDraw, bsSelected, out, tokens, pdbCONECT, bsWritten);
            bsAtoms = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
        } else {
            bsAtoms = (BS)parameters[0];
            float[] dataX = (float[])parameters[1];
            float[] dataY = (float[])parameters[2];
            float[] dataZ = (float[])parameters[3];
            boolean haveY = dataY != null;
            boolean haveZ = dataZ != null;
            P3 minXYZ = (P3)parameters[4];
            P3 maxXYZ = (P3)parameters[5];
            P3 factors = (P3)parameters[6];
            P3 center = (P3)parameters[7];
            String format = (String)parameters[8];
            String[] properties = (String[])parameters[9];
            float pdbFactor = ((Number)parameters[10]).floatValue();
            boolean isPDBFormat = factors != null && format == null;
            Atom[] atoms = this.vwr.ms.at;
            if (isPDBFormat) {
                out.append("REMARK   6 Jmol PDB-encoded data: ").append(type).append("; for model " + modelIndex + "; Jmol ").append(Viewer.getJmolVersion()).append("; ").append(this.vwr.apiPlatform.getDateFormat(null)).append("\n");
                out.append("REMARK   6 Jmol data").append(" min = ").append(Escape.eP(minXYZ)).append(" max = ").append(Escape.eP(maxXYZ)).append(" unScaledXyz = xyz * ").append(Escape.eP(factors)).append(" + ").append(Escape.eP(center));
                if (pdbFactor != 1.0f) {
                    out.append("pdbfactor = " + pdbFactor);
                }
                out.append(";\n");
                String atomNames = null;
                int i = bsAtoms.nextSetBit(0);
                while (i >= 0) {
                    String name = "" + atoms[i].getAtomName();
                    if (atomNames != null || name.length() > 4) {
                        if (atomNames == null) {
                            atomNames = "";
                            i = -1;
                        } else {
                            atomNames = atomNames + " " + name;
                        }
                    }
                    i = bsAtoms.nextSetBit(i + 1);
                }
                if (atomNames != null) {
                    out.append("REMARK   6 Jmol atom names").append(atomNames).append("\n");
                }
                String resNames = null;
                int i2 = bsAtoms.nextSetBit(0);
                while (i2 >= 0) {
                    String name = "" + atoms[i2].getGroup3(true);
                    if (resNames != null || name.length() > 3) {
                        if (resNames == null) {
                            resNames = "";
                            i2 = -1;
                        } else {
                            resNames = resNames + " " + name;
                        }
                    }
                    i2 = bsAtoms.nextSetBit(i2 + 1);
                }
                if (resNames != null) {
                    out.append("REMARK   6 Jmol residue names").append(resNames).append("\n");
                }
                if (!isSpin) {
                    for (i2 = 0; i2 < properties.length; ++i2) {
                        if (properties[i2] == null) continue;
                        out.append("REMARK   6 Jmol property ").append(properties[i2]).append(";\n");
                    }
                }
            }
            String strExtra = "";
            Atom atomLast = null;
            P3 ptTemp = new P3();
            if (!isPDBFormat) {
                if (format == null) {
                    format = "%-5i %-10s %-13.5f " + (haveZ ? "%-13.5f %-13.5f" : (haveY ? "%-13.5f" : ""));
                }
                format = format + "\n";
            }
            int i = bsAtoms.nextSetBit(0);
            int n = 0;
            while (i >= 0) {
                float z;
                float x = dataX[n];
                float y = haveY ? dataY[n] : 0.0f;
                float f = z = haveZ ? dataZ[n] : 0.0f;
                if (!(Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z))) {
                    Atom a = atoms[i];
                    if (isPDBFormat) {
                        int pt;
                        String line = LabelToken.formatLabelAtomArray(this.vwr, a, tokens, '\u0000', null, ptTemp);
                        while (line.charAt(16) != ' ' && (pt = line.lastIndexOf(32, 16)) >= 0) {
                            line = line.substring(0, pt - 1) + line.substring(pt);
                        }
                        out.append(line);
                        if (isPDB) {
                            bsWritten.set(i);
                        }
                        out.append(PT.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %-2s    %s\n", "ssF", new Object[]{a.getElementSymbolIso(false).toUpperCase(), strExtra, new float[]{x, y, z, 0.0f}}));
                        if (isPDB && atomLast != null && atomLast.group.getBioPolymerIndexInModel() == a.group.getBioPolymerIndexInModel()) {
                            pdbCONECT.append("CONECT").append(PT.formatStringI("%5i", "i", atomLast.getAtomNumber())).append(PT.formatStringI("%5i", "i", a.getAtomNumber())).appendC('\n');
                        }
                    } else if (haveZ) {
                        out.append(PT.sprintf(format, "isF", new Object[]{a.getAtomNumber(), a.getAtomName(), new float[]{x, y, z}}));
                    } else if (haveY) {
                        out.append(PT.sprintf(format, "isF", new Object[]{a.getAtomNumber(), a.getAtomName(), new float[]{x, y}}));
                    } else {
                        out.append(PT.sprintf(format, "isF", new Object[]{a.getAtomNumber(), a.getAtomName(), new float[]{x}}));
                    }
                    atomLast = a;
                }
                i = bsAtoms.nextSetBit(i + 1);
                ++n;
            }
        }
        out.append(pdbCONECT.toString());
        if (isDraw) {
            return out.toString();
        }
        bsSelected.and(bsAtoms);
        if (isPDB && addStructure) {
            out.append("\n\n" + this.vwr.ms.getProteinStructureState(bsWritten, ctype == 'R' ? 4138 : 1073742086));
        }
        return out.toString();
    }

    @Override
    public String getModelCml(BS bs, int atomsMax, boolean addBonds, boolean doTransform, boolean allTrajectories) {
        return this.getModel("CML", bs, new Object[]{atomsMax, addBonds, doTransform, allTrajectories}, null);
    }

    @Override
    public String fixJMEFormalCharges(BS bsAtoms, String jme) {
        String jmeAtom;
        boolean haveCharges = false;
        if (bsAtoms == null) {
            return jme;
        }
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = this.vwr.ms.at[i];
            if (a.getFormalCharge() != 0) {
                haveCharges = true;
                break;
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        if (!haveCharges) {
            return jme;
        }
        int[][] map = this.vwr.getSmilesMatcher().getMapForJME(jme, this.vwr.ms.at, bsAtoms);
        if (map == null) {
            return jme;
        }
        int[] jmeMap = map[0];
        int[] jmolMap = map[1];
        String[] tokens = PT.getTokens(jme);
        int nAtoms = PT.parseInt(tokens[0]);
        int[] mapjj = new int[nAtoms];
        int i2 = jmeMap.length;
        while (--i2 >= 0) {
            mapjj[jmeMap[i2]] = jmolMap[i2] + 1;
        }
        int ipt = 0;
        for (int pt = 2; pt < tokens.length && PT.parseInt(jmeAtom = tokens[pt]) == Integer.MIN_VALUE; pt += 3) {
            Atom a;
            String elem;
            jmeAtom = PT.replaceAllCharacters(jmeAtom, "+-", "");
            if (!(elem = (a = this.vwr.ms.at[mapjj[ipt++] - 1]).getElementSymbol()).equals(jmeAtom)) {
                return jme;
            }
            int charge = a.getFormalCharge();
            if (charge == 0) continue;
            tokens[pt] = jmeAtom + (charge > 0 ? "+" : "-") + (Math.abs(charge) > 1 ? "" + Math.abs(charge) : "");
        }
        return PT.join(tokens, ' ', 0);
    }

    public static String getSDFDateLine(String version, boolean is2d) {
        SB mol = SB.newS((version + "          ").substring(0, 10));
        Calendar c = Calendar.getInstance();
        int cMM = c.get(2);
        int cDD = c.get(5);
        int cYYYY = c.get(1);
        int cHH = c.get(11);
        int cmm = c.get(12);
        PT.rightJustify(mol, "00", "" + (1 + cMM));
        PT.rightJustify(mol, "00", "" + cDD);
        mol.append(("" + cYYYY).substring(2, 4));
        PT.rightJustify(mol, "00", "" + cHH);
        PT.rightJustify(mol, "00", "" + cmm);
        mol.append(is2d ? "2" : "3").append("D 1   1.00000     0.00000     0");
        mol.append("\n");
        return mol.toString();
    }
}

