/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.readline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.completer.FileNameCompleter;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyModule(name={"Readline"})
public class Readline {
    private static final boolean DEBUG = false;
    private static final Logger LOG = LoggerFactory.getLogger(Readline.class);
    public static final char ESC_KEY_CODE = '\u001b';

    public static void load(Ruby runtime) {
        Readline.createReadline(runtime);
    }

    public static void createReadline(Ruby runtime) {
        ConsoleHolder holder = new ConsoleHolder();
        RubyModule mReadline = runtime.defineModule("Readline");
        mReadline.dataWrapStruct((Object)holder);
        mReadline.defineAnnotatedMethods(Readline.class);
        mReadline.setConstant("COMPLETION_CASE_FOLD", runtime.getNil(), true);
        IRubyObject hist = runtime.getObject().callMethod(runtime.getCurrentContext(), "new");
        mReadline.setConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule((IRubyObject)runtime.getEnumerable());
        hist.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        mReadline.setConstant("VERSION", (IRubyObject)runtime.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby runtime, final ConsoleHolder holder) {
        ConsoleReader readline;
        try {
            Terminal terminal = TerminalFactory.create();
            readline = holder.readline = new ConsoleReader(null, runtime.getInputStream(), (OutputStream)runtime.getOutputStream(), terminal);
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        readline.setHistoryEnabled(false);
        readline.setPaginationEnabled(true);
        readline.setBellEnabled(true);
        if (holder.currentCompletor == null) {
            holder.currentCompletor = new RubyFileNameCompletor();
        }
        readline.addCompleter(holder.currentCompletor);
        readline.setHistory(holder.history);
        readline.addTriggeredAction('\u001b', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    holder.readline.beep();
                }
                catch (IOException ex) {
                    LOG.debug((Throwable)ex);
                }
            }
        });
        RubyModule Readline2 = runtime.getModule("Readline");
        BlockCallback callback = new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] iRubyObjects, Block block) {
                LOG.debug("finalizing readline (console) backend", new Object[0]);
                try {
                    holder.readline.close();
                }
                catch (Exception ex) {
                    LOG.debug("failed to close console reader:", (Throwable)ex);
                }
                try {
                    holder.readline.getTerminal().restore();
                }
                catch (Exception ex) {
                    LOG.debug("failed to restore terminal:", (Throwable)ex);
                }
                return context.nil;
            }
        };
        Block block = CallBlock.newCallClosure((IRubyObject)Readline2, (RubyModule)Readline2, (Signature)Signature.NO_ARGUMENTS, (BlockCallback)callback, (ThreadContext)runtime.getCurrentContext());
        Readline2.addFinalizer((IRubyObject)RubyProc.newProc((Ruby)runtime, (Block)block, (Block.Type)block.type));
    }

    public static History getHistory(ConsoleHolder holder) {
        return holder.history;
    }

    public static ConsoleHolder getHolder(Ruby runtime) {
        return (ConsoleHolder)runtime.getModule("Readline").dataGetStruct();
    }

    public static ConsoleHolder getHolderWithReadline(Ruby runtime) {
        ConsoleHolder holder = Readline.getHolder(runtime);
        if (holder.readline == null) {
            Readline.initReadline(runtime, holder);
        }
        return holder;
    }

    public static void setCompletor(ConsoleHolder holder, Completer completor) {
        if (holder.readline != null) {
            holder.readline.removeCompleter(holder.currentCompletor);
        }
        holder.currentCompletor = completor;
        if (holder.readline != null) {
            holder.readline.addCompleter(holder.currentCompletor);
        }
    }

    public static Completer getCompletor(ConsoleHolder holder) {
        return holder.currentCompletor;
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv) {
        return Readline.readlineImpl(context, "", false);
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv, IRubyObject prompt) {
        return Readline.readlineImpl(context, prompt.toString(), false);
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv, IRubyObject prompt, IRubyObject addHistory) {
        return Readline.readlineImpl(context, prompt.toString(), addHistory.isTrue());
    }

    private static IRubyObject readlineImpl(ThreadContext context, String prompt, boolean addHistory) {
        String line;
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        holder.readline.setExpandEvents(false);
        try {
            holder.readline.getTerminal().setEchoEnabled(false);
            line = holder.readline.readLine(prompt);
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        finally {
            holder.readline.getTerminal().setEchoEnabled(true);
        }
        if (line == null) {
            return context.nil;
        }
        if (addHistory) {
            holder.readline.getHistory().add((CharSequence)line);
        }
        ByteList bytes = new ByteList(line.getBytes(), runtime.getDefaultExternalEncoding());
        return RubyString.newString((Ruby)runtime, (ByteList)bytes);
    }

    @JRubyMethod(name={"input="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setInput(ThreadContext context, IRubyObject recv, IRubyObject input) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"output="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setOutput(ThreadContext context, IRubyObject recv, IRubyObject output) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"basic_word_break_characters="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_basic_word_break_character(IRubyObject recv, IRubyObject achar) {
        Ruby runtime = recv.getRuntime();
        if (!achar.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + achar.getMetaClass() + " into String");
        }
        ProcCompleter.setDelimiter(achar.convertToString().toString());
        return achar;
    }

    @JRubyMethod(name={"basic_word_break_characters"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_basic_word_break_character(IRubyObject recv) {
        return recv.getRuntime().newString(ProcCompleter.getDelimiter());
    }

    @JRubyMethod(name={"completion_proc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_completion_proc(IRubyObject recv) {
        Completer completer = Readline.getCompletor(Readline.getHolder(recv.getRuntime()));
        if (completer instanceof ProcCompleter) {
            return ((ProcCompleter)completer).proc;
        }
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject recv, IRubyObject proc) {
        if (!proc.respondsTo("call")) {
            throw recv.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(recv.getRuntime()), new ProcCompleter(proc));
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"get_screen_size"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_screen_size(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        IRubyObject[] ary = new IRubyObject[]{runtime.newFixnum(holder.readline.getTerminal().getHeight()), runtime.newFixnum(holder.readline.getTerminal().getWidth())};
        return RubyArray.newArray((Ruby)runtime, (IRubyObject[])ary);
    }

    @JRubyMethod(name={"set_screen_size"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_screen_size(ThreadContext context, IRubyObject recv, IRubyObject height, IRubyObject width) {
        int h = height.convertToInteger().getIntValue();
        int w = width.convertToInteger().getIntValue();
        ConsoleHolder holder = Readline.getHolderWithReadline(context.runtime);
        return recv;
    }

    @JRubyMethod(name={"line_buffer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_line_buffer(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return Readline.newString(runtime, cb.buffer);
    }

    @JRubyMethod(name={"point"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_point(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime.newFixnum(cb.cursor);
    }

    @JRubyMethod(name={"refresh_line"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_refresh_line(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.runtime;
        ConsoleHolder holder = Readline.getHolderWithReadline(runtime);
        try {
            holder.readline.redrawLine();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return context.nil;
    }

    @JRubyMethod(name={"basic_quote_characters"}, module=true)
    public static IRubyObject basic_quote_characters(ThreadContext context, IRubyObject recv) {
        return context.nil;
    }

    @JRubyMethod(name={"basic_quote_characters="}, module=true)
    public static IRubyObject set_basic_quote_characters(ThreadContext context, IRubyObject recv, IRubyObject chars) {
        Readline.warn(context, recv, "Readline.basic_quote_characters= not implemented");
        return context.nil;
    }

    @JRubyMethod(name={"filename_quote_characters"}, module=true)
    public static IRubyObject filename_quote_characters(ThreadContext context, IRubyObject recv) {
        return context.nil;
    }

    @JRubyMethod(name={"filename_quote_characters="}, module=true)
    public static IRubyObject set_filename_quote_characters(ThreadContext context, IRubyObject recv, IRubyObject chars) {
        Readline.warn(context, recv, "Readline.filename_quote_characters= not implemented");
        return context.nil;
    }

    @JRubyMethod(name={"completer_quote_characters"}, module=true)
    public static IRubyObject completer_quote_characters(ThreadContext context, IRubyObject recv) {
        return context.nil;
    }

    @JRubyMethod(name={"completer_quote_characters="}, module=true)
    public static IRubyObject set_completer_quote_characters(ThreadContext context, IRubyObject recv, IRubyObject chars) {
        Readline.warn(context, recv, "Readline.completer_quote_characters= not implemented");
        return context.nil;
    }

    @JRubyMethod(name={"completer_word_break_characters"}, module=true)
    public static IRubyObject completer_word_break_characters(ThreadContext context, IRubyObject recv) {
        return context.nil;
    }

    @JRubyMethod(name={"completer_word_break_characters="}, module=true)
    public static IRubyObject set_completer_word_break_characters(ThreadContext context, IRubyObject recv, IRubyObject chars) {
        Readline.warn(context, recv, "Readline.completer_word_break_characters= not implemented");
        return context.nil;
    }

    @JRubyMethod(name={"completion_append_character"}, module=true)
    public static IRubyObject completion_append_character(ThreadContext context, IRubyObject recv) {
        ConsoleHolder holder = Readline.getHolderWithReadline(context.runtime);
        CompletionHandler handler = holder.readline.getCompletionHandler();
        if (handler instanceof CandidateListCompletionHandler && ((CandidateListCompletionHandler)handler).getPrintSpaceAfterFullCompletion()) {
            return RubyString.newString((Ruby)context.runtime, (String)" ");
        }
        return context.nil;
    }

    @JRubyMethod(name={"completion_append_character="}, module=true)
    public static IRubyObject set_completion_append_character(ThreadContext context, IRubyObject recv, IRubyObject achar) {
        ConsoleHolder holder = Readline.getHolderWithReadline(context.runtime);
        CompletionHandler handler = holder.readline.getCompletionHandler();
        if (achar == context.nil) {
            Readline.setPrintSpaceAfterCompletion(handler, false);
        } else {
            IRubyObject c = achar.convertToString().op_aref(context, (IRubyObject)context.runtime.newFixnum(0));
            if (c == context.nil) {
                Readline.setPrintSpaceAfterCompletion(handler, false);
            } else if (c.convertToString().getByteList().charAt(0) == ' ') {
                Readline.setPrintSpaceAfterCompletion(handler, true);
            } else {
                Readline.warn(context, recv, "Readline.completion_append_character '" + c + "' not supported");
            }
        }
        return context.nil;
    }

    private static void setPrintSpaceAfterCompletion(CompletionHandler handler, boolean print) {
        if (handler instanceof CandidateListCompletionHandler) {
            ((CandidateListCompletionHandler)handler).setPrintSpaceAfterFullCompletion(print);
        }
    }

    @JRubyMethod(name={"completion_case_fold"}, module=true)
    public static IRubyObject completion_case_fold(ThreadContext context, IRubyObject recv) {
        return context.runtime.getModule("Readline").getConstant("COMPLETION_CASE_FOLD");
    }

    @JRubyMethod(name={"completion_case_fold="}, module=true)
    public static IRubyObject set_completion_case_fold(ThreadContext context, IRubyObject recv, IRubyObject fold) {
        context.runtime.getModule("Readline").setConstant("COMPLETION_CASE_FOLD", fold, true);
        return fold;
    }

    @JRubyMethod(name={"emacs_editing_mode", "emacs_editing_mode?"}, module=true)
    public static IRubyObject emacs_editing_mode(ThreadContext context, IRubyObject recv) {
        return context.nil;
    }

    @JRubyMethod(name={"vi_editing_mode", "vi_editing_mode?"}, module=true)
    public static IRubyObject vi_editing_mode(ThreadContext context, IRubyObject recv) {
        return context.nil;
    }

    private static RubyString newString(Ruby runtime, CharSequence str) {
        if (str instanceof RubyString) {
            return (RubyString)str;
        }
        RubyString s = RubyString.newString((Ruby)runtime, (CharSequence)str);
        s.setTaint(true);
        return s;
    }

    private static void warn(ThreadContext context, IRubyObject recv, CharSequence str) {
        recv.callMethod(context, "warn", (IRubyObject)RubyString.newString((Ruby)context.runtime, (CharSequence)str));
    }

    public static class RubyFileNameCompletor
    extends FileNameCompleter {
        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(32);
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            return index + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompleter
    implements Completer {
        final IRubyObject proc;
        static String[] delimiters = new String[]{" ", "\t", "\n", "\"", "\\", "'", "`", "@", "$", ">", "<", "=", ";", "|", "&", "{", "("};

        public ProcCompleter(IRubyObject proc) {
            this.proc = proc;
        }

        public static String getDelimiter() {
            StringBuilder str = new StringBuilder(delimiters.length);
            for (String delimiter : delimiters) {
                str.append(delimiter);
            }
            return str.toString();
        }

        public static void setDelimiter(String delimiter) {
            ArrayList<String> list = new ArrayList<String>();
            CharBuffer buf = CharBuffer.wrap(delimiter);
            while (buf.hasRemaining()) {
                list.add(String.valueOf(buf.get()));
            }
            delimiters = list.toArray(new String[list.size()]);
        }

        private int wordIndexOf(String buffer) {
            int index = 0;
            for (String c : delimiters) {
                index = buffer.lastIndexOf(c);
                if (index == -1) continue;
                return index;
            }
            return index;
        }

        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            Ruby runtime;
            ThreadContext context;
            IRubyObject result;
            int index = this.wordIndexOf(buffer = buffer.substring(0, cursor));
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            if (!((result = this.proc.callMethod(context = (runtime = this.proc.getRuntime()).getCurrentContext(), "call", (IRubyObject)runtime.newString(buffer))) instanceof RubyArray)) {
                result = result.callMethod(context, "to_a");
            }
            if (result instanceof List) {
                List list = (List)result;
                for (int i = 0; i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject recv, IRubyObject[] lines) {
            ConsoleHolder holder = Readline.getHolder(recv.getRuntime());
            for (int i = 0; i < lines.length; ++i) {
                RubyString line = lines[i].convertToString();
                holder.history.add((CharSequence)line.getUnicodeValue());
            }
            return recv;
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            if (holder.history.isEmpty()) {
                return runtime.getNil();
            }
            return Readline.newString(runtime, holder.history.removeLast());
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            RubyArray histList = runtime.newArray(holder.history.size());
            ListIterator historyIterator = holder.history.entries();
            while (historyIterator.hasNext()) {
                History.Entry nextEntry = (History.Entry)historyIterator.next();
                histList.append((IRubyObject)Readline.newString(runtime, nextEntry.value()));
            }
            return histList;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject recv) {
            return recv.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject recv, IRubyObject index) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i = index.convertToInteger().getIntValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                return Readline.newString(runtime, holder.history.get(i));
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject recv, IRubyObject index, IRubyObject val) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i = index.convertToInteger().getIntValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                holder.history.set(i, (CharSequence)val.asJavaString());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i);
            }
            return runtime.getNil();
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            if (holder.history.isEmpty()) {
                return runtime.getNil();
            }
            try {
                return Readline.newString(runtime, holder.history.removeFirst());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("history shift error");
            }
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            return runtime.newFixnum(holder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject recv) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            return runtime.newBoolean(holder.history.isEmpty());
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject recv, IRubyObject index) {
            Ruby runtime = recv.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime);
            int i = RubyNumeric.num2int((IRubyObject)index);
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                return Readline.newString(runtime, holder.history.remove(i));
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject each(ThreadContext context, IRubyObject recv, Block block) {
            ConsoleHolder holder = Readline.getHolder(context.runtime);
            Iterator i = holder.history.iterator();
            while (i.hasNext()) {
                block.yield(context, (IRubyObject)Readline.newString(context.runtime, ((History.Entry)i.next()).value()));
            }
            return recv;
        }

        @JRubyMethod(name={"clear"})
        public static IRubyObject clear(ThreadContext context, IRubyObject recv, Block block) {
            ConsoleHolder holder = Readline.getHolder(context.runtime);
            holder.history.clear();
            return context.nil;
        }

        @Deprecated
        public static IRubyObject s_hist_each(IRubyObject recv, Block block) {
            return HistoryMethods.each(recv.getRuntime().getCurrentContext(), recv, block);
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        volatile transient Completer currentCompletor;
        public final History history = new MemoryHistory();
    }
}

