/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.id.uuid.UuidValueGenerator;
import org.hibernate.models.spi.ModelsContext;

public class UuidGeneratorAnnotation
implements UuidGenerator {
    private UuidGenerator.Style style;
    private final Class<? extends UuidValueGenerator> algorithm;

    public UuidGeneratorAnnotation(ModelsContext modelContext) {
        this.style = UuidGenerator.Style.AUTO;
        this.algorithm = UuidValueGenerator.class;
    }

    public UuidGeneratorAnnotation(UuidGenerator annotation, ModelsContext modelContext) {
        this.style = annotation.style();
        this.algorithm = annotation.algorithm();
    }

    public UuidGeneratorAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.style = (UuidGenerator.Style)((Object)attributeValues.get("style"));
        this.algorithm = (Class)attributeValues.get("algorithm");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return UuidGenerator.class;
    }

    @Override
    public UuidGenerator.Style style() {
        return this.style;
    }

    @Override
    public Class<? extends UuidValueGenerator> algorithm() {
        return this.algorithm;
    }

    public void style(UuidGenerator.Style value) {
        this.style = value;
    }
}

