/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.sql.results.graph.FetchOptions;

public interface EntityDiscriminatorMapping
extends DiscriminatorMapping,
FetchOptions {
    public static final String DISCRIMINATOR_ROLE_NAME = "{discriminator}";
    public static final String LEGACY_DISCRIMINATOR_NAME = "class";

    public static boolean matchesRoleName(String name) {
        return DISCRIMINATOR_ROLE_NAME.equals(name) || LEGACY_DISCRIMINATOR_NAME.equalsIgnoreCase(name);
    }

    @Override
    default public String getPartName() {
        return DISCRIMINATOR_ROLE_NAME;
    }

    @Override
    default public String getFetchableName() {
        return this.getPartName();
    }

    public boolean hasPhysicalColumn();

    @Override
    default public int getFetchableKey() {
        return -2;
    }

    @Override
    default public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    default public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    default public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }
}

