/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.model;

import io.smallrye.openapi.model.BaseExtensibleModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public final class Extensions {
    public static final String PRIVATE_EXT_PREFIX = "x-smallrye-private-";
    private static final String EXT_PROFILE_PREFIX = "x-smallrye-profile-";

    private Extensions() {
    }

    private static Map<String, Object> extensions(Extensible<?> extensible) {
        Map<String, Object> extensions = extensible instanceof BaseExtensibleModel ? ((BaseExtensibleModel)extensible).getAllExtensions() : extensible.getExtensions();
        return extensions == null ? Collections.emptyMap() : extensions;
    }

    private static Set<String> extensionNames(Extensible<?> extensible) {
        return Set.copyOf(Extensions.extensions(extensible).keySet());
    }

    private static <T> T get(Extensible<?> extensible, String name, Class<T> type) {
        Object value = extensible instanceof BaseExtensibleModel ? ((BaseExtensibleModel)extensible).getExtension(name) : Extensions.extensions(extensible).get(name);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    private static <T> void set(Extensible<?> extensible, String name, T value) {
        if (value != null) {
            extensible.addExtension(name, value);
        } else {
            extensible.removeExtension(name);
        }
    }

    public static Set<String> getProfiles(Extensible<?> extensible) {
        HashSet<String> profiles = new HashSet<String>(2);
        for (String name : Extensions.extensionNames(extensible)) {
            if (!name.startsWith(EXT_PROFILE_PREFIX)) continue;
            profiles.add(name.substring(EXT_PROFILE_PREFIX.length()));
        }
        return profiles;
    }

    public static void removeProfiles(Extensible<?> extensible) {
        for (String name : Extensions.extensionNames(extensible)) {
            if (!name.startsWith(EXT_PROFILE_PREFIX)) continue;
            extensible.removeExtension(name);
        }
    }

    public static String getName(Extensible<?> extensible) {
        return Extensions.get(extensible, "x-smallrye-private-name", String.class);
    }

    public static void setName(Extensible<?> extensible, String name) {
        Extensions.set(extensible, "x-smallrye-private-name", name);
    }

    public static boolean isHidden(Extensible<?> extensible) {
        return Boolean.TRUE.equals(Extensions.get(extensible, "x-smallrye-private-hidden", Boolean.class));
    }

    public static void setHidden(Extensible<?> extensible, Boolean hidden) {
        Extensions.set(extensible, "x-smallrye-private-hidden", hidden);
    }

    public static String getResponseCode(APIResponse response) {
        return Extensions.get(response, "x-smallrye-private-response-code", String.class);
    }

    public static void setResponseCode(APIResponse response, String responseCode) {
        Extensions.set(response, "x-smallrye-private-response-code", responseCode);
    }

    public static Boolean getRequiredDefault(RequestBody requestBody) {
        return Extensions.get(requestBody, "x-smallrye-private-required-default", Boolean.class);
    }

    public static void setRequiredDefault(RequestBody requestBody, Boolean requiredDefault) {
        Extensions.set(requestBody, "x-smallrye-private-required-default", requiredDefault);
    }

    public static boolean getIsRequiredSet(RequestBody requestBody) {
        return Boolean.TRUE.equals(Extensions.get(requestBody, "x-smallrye-private-is-required-set", Boolean.class));
    }

    public static void setIsRequiredSet(RequestBody requestBody, Boolean requiredDefault) {
        Extensions.set(requestBody, "x-smallrye-private-is-required-set", requiredDefault);
    }

    public static String getParamRef(Parameter parameter) {
        return Extensions.get(parameter, "x-smallrye-private-param-ref", String.class);
    }

    public static void setParamRef(Parameter parameter, AnnotationTarget source) {
        String ref = Extensions.createUniqueAnnotationTargetRef(source);
        Extensions.set(parameter, "x-smallrye-private-param-ref", ref);
    }

    public static String getMethodRef(Operation operation) {
        return Extensions.get(operation, "x-smallrye-private-method-ref", String.class);
    }

    public static void setMethodRef(Operation operation, ClassInfo resourceClass, MethodInfo method) {
        String ref = Extensions.createUniqueMethodReference(resourceClass, method);
        Extensions.set(operation, "x-smallrye-private-method-ref", ref);
    }

    public static List<Schema> getTypeObservers(Schema schema) {
        return Extensions.get(schema, "x-smallrye-private-schema-type-observers", List.class);
    }

    public static void setTypeObservers(Schema schema, List<Schema> observers) {
        Extensions.set(schema, "x-smallrye-private-schema-type-observers", observers);
    }

    public static boolean isPrivateExtension(String name) {
        return name.startsWith(PRIVATE_EXT_PREFIX);
    }

    public static <E> E getPrivateExtension(Extensible<?> extensible, String name, Class<E> type) {
        return Extensions.get(extensible, PRIVATE_EXT_PREFIX + name, type);
    }

    public static void setPrivateExtension(Extensible<?> extensible, String name, Object value) {
        extensible.addExtension(PRIVATE_EXT_PREFIX + name, value);
    }

    private static String createUniqueAnnotationTargetRef(AnnotationTarget annotationTarget) {
        switch (annotationTarget.kind()) {
            case FIELD: {
                return Extensions.createUniqueFieldRef(annotationTarget.asField());
            }
            case METHOD: {
                ClassInfo classInfo = annotationTarget.asMethod().declaringClass();
                return Extensions.createUniqueMethodReference(classInfo, annotationTarget.asMethod());
            }
            case METHOD_PARAMETER: {
                return Extensions.createUniqueMethodParameterRef(annotationTarget.asMethodParameter());
            }
        }
        return null;
    }

    private static String createUniqueFieldRef(FieldInfo fieldInfo) {
        ClassInfo classInfo = fieldInfo.declaringClass();
        return "f" + classInfo.hashCode() + "_" + fieldInfo.hashCode();
    }

    private static String createUniqueMethodReference(ClassInfo classInfo, MethodInfo methodInfo) {
        return "m" + classInfo.hashCode() + "_" + methodInfo.hashCode();
    }

    private static String createUniqueMethodParameterRef(MethodParameterInfo methodParameter) {
        MethodInfo methodInfo = methodParameter.method();
        ClassInfo classInfo = methodInfo.declaringClass();
        return "p" + classInfo.hashCode() + "_" + methodInfo.hashCode() + "_" + methodParameter.position();
    }
}

