/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.creator.Modifier;
import io.quarkus.gizmo2.creator.ModifierLocation;
import java.util.List;

public enum AccessLevel implements Modifier
{
    PRIVATE(2),
    PACKAGE_PRIVATE(0),
    PROTECTED(4),
    PUBLIC(1);

    private final int mask;
    public static final List<AccessLevel> values;

    private AccessLevel(int mask) {
        this.mask = mask;
    }

    @Override
    public boolean validIn(ModifierLocation location) {
        return location.supports(this);
    }

    @Override
    public int mask() {
        return this.mask;
    }

    public static AccessLevel of(int bits) {
        int hob = Integer.highestOneBit(bits & AccessLevel.fullMask());
        return switch (hob) {
            case 4 -> PROTECTED;
            case 2 -> PRIVATE;
            case 1 -> PUBLIC;
            default -> PACKAGE_PRIVATE;
        };
    }

    public static int fullMask() {
        return 7;
    }

    static {
        values = List.of(AccessLevel.values());
    }
}

