/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.Element;

public class MechanismConfiguration {
    static final AttributeDefinition<String> USERNAME = AttributeDefinition.builder((Enum)Attribute.USERNAME, null, String.class).serializer(AttributeSerializer.SECRET).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> PASSWORD = AttributeDefinition.builder((Enum)Attribute.PASSWORD, null, String.class).serializer(AttributeSerializer.SECRET).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> REALM = AttributeDefinition.builder((Enum)Attribute.REALM, null, String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SASL_MECHANISM = AttributeDefinition.builder((Enum)Attribute.SASL_MECHANISM, null, String.class).immutable().autoPersist(false).build();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MechanismConfiguration.class, new AttributeDefinition[]{USERNAME, PASSWORD, REALM, SASL_MECHANISM});
    }

    public MechanismConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public String username() {
        return (String)this.attributes.attribute(USERNAME).get();
    }

    public char[] password() {
        return Util.toCharArray((String)((String)this.attributes.attribute(PASSWORD).get()));
    }

    public String realm() {
        return (String)this.attributes.attribute(REALM).get();
    }

    public String saslMechanism() {
        return (String)this.attributes.attribute(SASL_MECHANISM).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    static String serializeMechanism(String mechanism) {
        if (mechanism == null) {
            return null;
        }
        switch (mechanism) {
            case "PLAIN": {
                return Element.AUTH_PLAIN.getLocalName();
            }
            case "DIGEST-MD5": {
                return Element.AUTH_DIGEST.getLocalName();
            }
            case "EXTERNAL": {
                return Element.AUTH_EXTERNAL.getLocalName();
            }
        }
        throw new CacheConfigurationException("Invalid sasl mechanism");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MechanismConfiguration that = (MechanismConfiguration)o;
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public String toString() {
        return "MechanismConfiguration{attributes=" + String.valueOf(this.attributes) + "}";
    }
}

