/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RemoteAnalyticsConfiguration {
    private int timeoutMs;
    private String endpointData;
    private boolean sendOss;
    private boolean sendPro;
    private String writeKey;
    private List<ExtensionName> extensions;

    public static RemoteAnalyticsConfiguration fromYaml(Map<String, Object> loaded) {
        RemoteAnalyticsConfiguration remoteAnalyticsConfiguration = new RemoteAnalyticsConfiguration();
        remoteAnalyticsConfiguration.setTimeoutMs(NumberUtils.toInt((String)String.valueOf(loaded.get("timeoutMs"))));
        remoteAnalyticsConfiguration.setEndpointData(String.valueOf(loaded.get("endpointData")));
        remoteAnalyticsConfiguration.setSendOss(BooleanUtils.toBoolean((String)String.valueOf(loaded.get("sendOss"))));
        remoteAnalyticsConfiguration.setSendPro(BooleanUtils.toBoolean((String)String.valueOf(loaded.get("sendPro"))));
        remoteAnalyticsConfiguration.setWriteKey(String.valueOf(loaded.get("writeKey")));
        remoteAnalyticsConfiguration.setExtensions(new ArrayList<ExtensionName>());
        Object extensions = loaded.get("extensions");
        if (extensions instanceof List) {
            for (Object extension : (List)extensions) {
                if (!(extension instanceof Map)) continue;
                Object displayName = ((Map)extension).get("displayName");
                Object manifestName = ((Map)extension).get("manifestName");
                remoteAnalyticsConfiguration.getExtensions().add(new ExtensionName(String.valueOf(manifestName), String.valueOf(displayName)));
            }
        }
        return remoteAnalyticsConfiguration;
    }

    @Generated
    public RemoteAnalyticsConfiguration() {
    }

    @Generated
    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    @Generated
    public String getEndpointData() {
        return this.endpointData;
    }

    @Generated
    public boolean isSendOss() {
        return this.sendOss;
    }

    @Generated
    public boolean isSendPro() {
        return this.sendPro;
    }

    @Generated
    public String getWriteKey() {
        return this.writeKey;
    }

    @Generated
    public List<ExtensionName> getExtensions() {
        return this.extensions;
    }

    @Generated
    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Generated
    public void setEndpointData(String endpointData) {
        this.endpointData = endpointData;
    }

    @Generated
    public void setSendOss(boolean sendOss) {
        this.sendOss = sendOss;
    }

    @Generated
    public void setSendPro(boolean sendPro) {
        this.sendPro = sendPro;
    }

    @Generated
    public void setWriteKey(String writeKey) {
        this.writeKey = writeKey;
    }

    @Generated
    public void setExtensions(List<ExtensionName> extensions) {
        this.extensions = extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteAnalyticsConfiguration)) {
            return false;
        }
        RemoteAnalyticsConfiguration other = (RemoteAnalyticsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeoutMs() != other.getTimeoutMs()) {
            return false;
        }
        if (this.isSendOss() != other.isSendOss()) {
            return false;
        }
        if (this.isSendPro() != other.isSendPro()) {
            return false;
        }
        String this$endpointData = this.getEndpointData();
        String other$endpointData = other.getEndpointData();
        if (this$endpointData == null ? other$endpointData != null : !this$endpointData.equals(other$endpointData)) {
            return false;
        }
        String this$writeKey = this.getWriteKey();
        String other$writeKey = other.getWriteKey();
        if (this$writeKey == null ? other$writeKey != null : !this$writeKey.equals(other$writeKey)) {
            return false;
        }
        List<ExtensionName> this$extensions = this.getExtensions();
        List<ExtensionName> other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoteAnalyticsConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeoutMs();
        result = result * 59 + (this.isSendOss() ? 79 : 97);
        result = result * 59 + (this.isSendPro() ? 79 : 97);
        String $endpointData = this.getEndpointData();
        result = result * 59 + ($endpointData == null ? 43 : $endpointData.hashCode());
        String $writeKey = this.getWriteKey();
        result = result * 59 + ($writeKey == null ? 43 : $writeKey.hashCode());
        List<ExtensionName> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemoteAnalyticsConfiguration(timeoutMs=" + this.getTimeoutMs() + ", endpointData=" + this.getEndpointData() + ", sendOss=" + this.isSendOss() + ", sendPro=" + this.isSendPro() + ", writeKey=" + this.getWriteKey() + ", extensions=" + this.getExtensions() + ")";
    }

    @Generated
    public static final class Fields {
        public static final String timeoutMs = "timeoutMs";
        public static final String endpointData = "endpointData";
        public static final String sendOss = "sendOss";
        public static final String sendPro = "sendPro";
        public static final String writeKey = "writeKey";
        public static final String extensions = "extensions";
    }

    public static class ExtensionName {
        private String manifestName;
        private String displayName;

        @Generated
        public String getManifestName() {
            return this.manifestName;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtensionName)) {
                return false;
            }
            ExtensionName other = (ExtensionName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$manifestName = this.getManifestName();
            String other$manifestName = other.getManifestName();
            if (this$manifestName == null ? other$manifestName != null : !this$manifestName.equals(other$manifestName)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExtensionName;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $manifestName = this.getManifestName();
            result = result * 59 + ($manifestName == null ? 43 : $manifestName.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RemoteAnalyticsConfiguration.ExtensionName(manifestName=" + this.getManifestName() + ", displayName=" + this.getDisplayName() + ")";
        }

        @Generated
        public ExtensionName(String manifestName, String displayName) {
            this.manifestName = manifestName;
            this.displayName = displayName;
        }

        @Generated
        public static final class Fields {
            public static final String manifestName = "manifestName";
            public static final String displayName = "displayName";
        }
    }
}

