/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.List;
import java.util.function.ObjIntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.reactive.publisher.impl.commands.batch.PublisherResponse;

public class KeyPublisherResponse
extends PublisherResponse {
    final Object[] extraObjects;
    final int extraSize;
    final Object[] keys;
    final int keySize;

    public KeyPublisherResponse(Object[] results, IntSet completedSegments, IntSet lostSegments, int size, boolean complete, List<PublisherHandler.SegmentResult> segmentResults, Object[] extraObjects, int extraSize, Object[] keys, int keySize) {
        super(results, completedSegments, lostSegments, size, complete, segmentResults);
        this.extraObjects = extraObjects;
        this.extraSize = extraSize;
        this.keys = keys;
        this.keySize = keySize;
    }

    public int getExtraSize() {
        return this.extraSize;
    }

    public Object[] getExtraObjects() {
        return this.extraObjects;
    }

    @Override
    public void keysForNonCompletedSegments(ObjIntConsumer consumer) {
        int size = this.segmentResults.size();
        if (size == 0) {
            return;
        }
        PublisherHandler.SegmentResult segmentResult = (PublisherHandler.SegmentResult)this.segmentResults.get(this.segmentResults.size() - 1);
        int segment = segmentResult.getSegment();
        for (int i = 0; i < this.keySize; ++i) {
            consumer.accept(this.keys[i], segment);
        }
    }

    @Override
    public String toString() {
        return "KeyPublisherResponse{size=" + this.size + ", completedSegments=" + String.valueOf(this.completedSegments) + ", lostSegments=" + String.valueOf(this.lostSegments) + ", complete=" + this.complete + ", segmentResults=" + String.valueOf(this.segmentResults) + ", extraSize=" + this.extraSize + ", keySize=" + this.keySize + "}";
    }
}

