/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.impl.Bundle;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionUtils;
import org.netbeans.modules.javafx2.editor.completion.impl.FxInstructionItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.spi.editor.completion.CompletionItem;

public class FxCopyReferenceCompleter
implements Completer,
Completer.Factory {
    private CompletionContext context;

    public FxCopyReferenceCompleter() {
    }

    FxCopyReferenceCompleter(CompletionContext context) {
        this.context = context;
    }

    public List<CompletionItem> complete() {
        Callable<String> fxNs = CompletionUtils.makeFxNamespaceCreator(this.context);
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>(2);
        FxInstructionItem inst = new FxInstructionItem("fx:reference", this.context, Bundle.FMT_fxReferenceCompletionItem(), fxNs);
        items.add(inst);
        inst = new FxInstructionItem("fx:copy", this.context, Bundle.FMT_fxCopyCompletionItem(), fxNs);
        items.add(inst);
        return items;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        switch (ctx.getType()) {
            case BEAN: 
            case CHILD_ELEMENT: 
            case PROPERTY_ELEMENT: {
                break;
            }
            default: {
                return null;
            }
        }
        String tn = ctx.getTagName();
        if (!(tn == null || "".equals(tn) || "reference".startsWith(tn = tn.toLowerCase()) || "copy".startsWith(tn))) {
            String prefix = ctx.findFxmlNsPrefix();
            if (prefix == null) {
                prefix = "fx";
            }
            if (!"reference".startsWith(tn = prefix + ":" + tn) && !"copy".startsWith(tn)) {
                return null;
            }
        }
        if (!FxCopyReferenceCompleter.matchingInstanceExists(ctx)) {
            return null;
        }
        return new FxCopyReferenceCompleter(ctx);
    }

    private static boolean matchingInstanceExists(CompletionContext ctx) {
        TypeMirror t;
        Set<String> instanceNames = ctx.getModel().getInstanceNames();
        if (instanceNames.isEmpty()) {
            return false;
        }
        FxNode parentNode = ctx.getElementParent();
        if (parentNode == null) {
            return false;
        }
        if (parentNode.getKind() == FxNode.Kind.Instance) {
            FxBean bi = ctx.getBeanInfo((FxInstance)parentNode);
            if (bi == null) {
                return true;
            }
            FxProperty def = bi.getDefaultProperty();
            if (def == null || def.getType() == null) {
                return false;
            }
            t = def.getType().resolve(ctx.getCompilationInfo());
        } else {
            if (parentNode.getKind() != FxNode.Kind.Property) {
                return false;
            }
            PropertyValue v = (PropertyValue)parentNode;
            t = v.getTypeHandle() == null ? null : v.getTypeHandle().resolve(ctx.getCompilationInfo());
        }
        if (t == null) {
            return true;
        }
        for (String n : instanceNames) {
            TypeElement instType;
            FxInstance inst = ctx.getModel().getInstance(n);
            ElementHandle<TypeElement> tHandle = inst.getJavaType();
            if (t == null) {
                return true;
            }
            if (tHandle == null || (instType = (TypeElement)tHandle.resolve(ctx.getCompilationInfo())) == null || !ctx.getCompilationInfo().getTypes().isAssignable(instType.asType(), t)) continue;
            return true;
        }
        return false;
    }
}

