/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.UpdateKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateKeyRequest
extends BmcRequest<UpdateKeyDetails> {
    private String keyId;
    private UpdateKeyDetails updateKeyDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getKeyId() {
        return this.keyId;
    }

    public UpdateKeyDetails getUpdateKeyDetails() {
        return this.updateKeyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateKeyDetails getBody$() {
        return this.updateKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().keyId(this.keyId).updateKeyDetails(this.updateKeyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",keyId=").append(String.valueOf(this.keyId));
        sb.append(",updateKeyDetails=").append(String.valueOf((Object)this.updateKeyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateKeyRequest)) {
            return false;
        }
        UpdateKeyRequest other = (UpdateKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.keyId, other.keyId) && Objects.equals((Object)this.updateKeyDetails, (Object)other.updateKeyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.updateKeyDetails == null ? 43 : this.updateKeyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateKeyRequest, UpdateKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String keyId = null;
        private UpdateKeyDetails updateKeyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder updateKeyDetails(UpdateKeyDetails updateKeyDetails) {
            this.updateKeyDetails = updateKeyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateKeyRequest o) {
            this.keyId(o.getKeyId());
            this.updateKeyDetails(o.getUpdateKeyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateKeyRequest build() {
            UpdateKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateKeyDetails body) {
            this.updateKeyDetails(body);
            return this;
        }

        public UpdateKeyRequest buildWithoutInvocationCallback() {
            UpdateKeyRequest request = new UpdateKeyRequest();
            request.keyId = this.keyId;
            request.updateKeyDetails = this.updateKeyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

