/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.text.Document;
import org.netbeans.api.lsp.SignatureInformation;
import org.netbeans.modules.java.completion.JavaTooltipTask;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.lsp.SignatureInformationCollector;
import org.openide.util.Exceptions;

public final class JavaSignatureInformationCollector
implements SignatureInformationCollector {
    public void collectSignatureInformation(Document doc, int offset, SignatureInformation.Context context, Consumer<SignatureInformation> consumer) {
        if (context == null || context.getTriggerKind() != SignatureInformation.TriggerKind.TriggerCharacter || context.getTriggerCharacter().charValue() == '(') {
            try {
                JavaTooltipTask task = JavaTooltipTask.create((int)offset, () -> false);
                ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)task);
                if (task.getTooltipData() != null && task.getTooltipSignatures() != null) {
                    Iterator it = task.getTooltipData().iterator();
                    for (int i = 0; i < task.getTooltipSignatures().size() && it.hasNext(); ++i) {
                        List params = (List)it.next();
                        String signature = (String)task.getTooltipSignatures().get(i);
                        SignatureInformationCollector.Builder builder = SignatureInformationCollector.newBuilder((String)signature, (i == task.getActiveSignatureIndex() ? 1 : 0) != 0);
                        for (int j = 0; j < params.size(); ++j) {
                            String param = (String)params.get(j);
                            builder.addParameter(param, j == task.getTooltipIndex(), null);
                        }
                        consumer.accept(builder.build());
                    }
                }
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

