/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Map;
import org.openide.filesystems.FileObject;

public class FileReferenceModification {
    private Map<FileObject, String> items;
    private boolean absolutePathLink;

    FileReferenceModification(Map<FileObject, String> items, boolean absolutePathLink) {
        this.items = items;
        this.absolutePathLink = absolutePathLink;
    }

    public boolean rename(FileObject file, String newName) {
        if (this.items.get(file) == null) {
            return false;
        }
        String item = this.items.get(file);
        if ("..".equals(item)) {
            return false;
        }
        this.items.put(file, newName);
        return true;
    }

    public String getModifiedReferencePath() {
        StringBuilder b = new StringBuilder();
        if (this.absolutePathLink) {
            b.append('/');
        }
        for (String item : this.items.values()) {
            b.append(item);
            b.append('/');
        }
        return b.deleteCharAt(b.length() - 1).toString();
    }
}

