/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.network.utils.IpAddressUtilsFilter;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class IpAddressUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    private static final RequestProcessor RP = new RequestProcessor("DNSBackgroundResolvers", 10);
    private static IpAddressUtils INSTANCE;

    IpAddressUtils() {
    }

    private static synchronized IpAddressUtils getDefault() {
        if (INSTANCE == null && (INSTANCE = (IpAddressUtils)Lookup.getDefault().lookup(IpAddressUtils.class)) == null) {
            INSTANCE = new IpAddressUtils();
        }
        return INSTANCE;
    }

    @NonNull
    public static InetAddress[] nameResolveArr(String host, int timeoutMs, IpTypePreference ipTypePref) throws InterruptedException, UnknownHostException, TimeoutException {
        if (IpAddressUtils.looksLikeIpv6Literal(host) || IpAddressUtils.looksLikeIpv4Literal(host)) {
            InetAddress addr = InetAddress.getByName(host);
            if (ipTypePref == IpTypePreference.IPV4_ONLY && addr instanceof Inet6Address) {
                throw new UnknownHostException("Mismatch between supplied literal IP address \"" + host + "\" (which is IPv6) and value of ipTypePref : " + (Object)((Object)ipTypePref));
            }
            if (ipTypePref == IpTypePreference.IPV6_ONLY && addr instanceof Inet4Address) {
                throw new UnknownHostException("Mismatch between supplied literal IP address \"" + host + "\" (which is IPv6) and value of ipTypePref : " + (Object)((Object)ipTypePref));
            }
            return new InetAddress[]{addr};
        }
        Callable<InetAddress[]> lookupTask = IpAddressUtils.getDefault().createDnsTimeoutTask(host);
        Future future = RP.submit(lookupTask);
        try {
            InetAddress[] ipAddresses = timeoutMs == 0 ? (InetAddress[])future.get() : (InetAddress[])future.get(timeoutMs, TimeUnit.MILLISECONDS);
            List<InetAddress> resultList = IpAddressUtilsFilter.filterInetAddresses(Arrays.asList(ipAddresses), ipTypePref);
            if (resultList.isEmpty()) {
                throw new UnknownHostException("A positive result was returned from name lookup for \"" + host + "\" but none that matched a filter of " + (Object)((Object)ipTypePref));
            }
            return resultList.toArray(new InetAddress[0]);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof UnknownHostException) {
                throw (UnknownHostException)cause;
            }
            Exceptions.printStackTrace((Throwable)cause);
            return new InetAddress[0];
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            throw new TimeoutException("No answer from name service within " + timeoutMs + " milliseconds when resolving \"" + host + "\"");
        }
    }

    @NonNull
    public static InetAddress nameResolve(String host, int timeoutMs, IpTypePreference ipTypePref) throws InterruptedException, UnknownHostException, TimeoutException {
        InetAddress[] ipAddresses = IpAddressUtils.nameResolveArr(host, timeoutMs, ipTypePref);
        return ipAddresses[0];
    }

    @NonNull
    public static InetAddress nameResolve(String host, int timeoutMs) throws InterruptedException, UnknownHostException, TimeoutException {
        return IpAddressUtils.nameResolve(host, timeoutMs, IpTypePreference.ANY_JDK_PREF);
    }

    public static boolean isValidIpv4Address(String ipAddressStr) {
        if (IPV4_PATTERN.matcher(ipAddressStr).matches()) {
            String[] segments = ipAddressStr.split("\\.");
            if (segments.length != 4) {
                return false;
            }
            for (String segment : segments) {
                if (segment == null || segment.length() == 0) {
                    return false;
                }
                if (segment.length() > 1 && segment.startsWith("0")) {
                    return false;
                }
                try {
                    int value = Integer.parseInt(segment);
                    if (value <= 255) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean looksLikeIpv6Literal(String ipAddressStr) {
        if (ipAddressStr == null) {
            return false;
        }
        if (ipAddressStr.length() < 3 || ipAddressStr.length() > 39) {
            return false;
        }
        if (ipAddressStr.startsWith(":") || ipAddressStr.endsWith(":")) {
            return true;
        }
        return ipAddressStr.length() >= 5 && (ipAddressStr.charAt(3) == ':' || ipAddressStr.charAt(4) == ':');
    }

    public static boolean looksLikeIpv4Literal(String ipAddressStr) {
        if (ipAddressStr == null || ipAddressStr.isEmpty()) {
            return false;
        }
        if (!IpAddressUtils.isAsciiDigit(ipAddressStr.charAt(0))) {
            return false;
        }
        int dotPos = ipAddressStr.indexOf(46);
        if (dotPos > 0 && dotPos < ipAddressStr.length() - 1 && dotPos <= 3) {
            for (int i = 0; i < dotPos; ++i) {
                if (IpAddressUtils.isAsciiDigit(ipAddressStr.charAt(i))) continue;
                return false;
            }
            return IpAddressUtils.isAsciiDigit(ipAddressStr.charAt(dotPos + 1));
        }
        return false;
    }

    public static String removeDomain(String hostname) {
        if (hostname == null) {
            return hostname;
        }
        if (IpAddressUtils.looksLikeIpv4Literal(hostname)) {
            return hostname;
        }
        int pos = hostname.indexOf(46);
        if (pos == -1) {
            return hostname;
        }
        int posColon = hostname.indexOf(58);
        if (posColon >= 0 && posColon < pos) {
            return hostname;
        }
        return hostname.substring(0, pos);
    }

    public static void removeLoopback(List<InetAddress> addresses) {
        if (addresses == null) {
            return;
        }
        Iterator<InetAddress> iterator = addresses.iterator();
        while (iterator.hasNext()) {
            InetAddress a = iterator.next();
            if (!a.isLoopbackAddress()) continue;
            iterator.remove();
        }
    }

    public static void sortIpAddresses(List<InetAddress> addresses, boolean ip4BeforeIp6) {
        IpAddressUtils.sortIpAddresses0(addresses, ip4BeforeIp6, false);
    }

    public static void sortIpAddressesShallow(List<InetAddress> addresses, boolean ip4BeforeIp6) {
        IpAddressUtils.sortIpAddresses0(addresses, ip4BeforeIp6, true);
    }

    private static void sortIpAddresses0(List<InetAddress> addresses, boolean ip4BeforeIp6, boolean shallow) {
        if (addresses != null && addresses.size() > 1) {
            addresses.sort(new InetAddressComparator(ip4BeforeIp6, shallow));
        }
    }

    private static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    Callable<InetAddress[]> createDnsTimeoutTask(String host) {
        return new DnsTimeoutTask(host);
    }

    public static enum IpTypePreference {
        IPV4_ONLY,
        IPV6_ONLY,
        ANY_IPV4_PREF,
        ANY_IPV6_PREF,
        ANY_JDK_PREF;

    }

    private static class InetAddressComparator
    implements Comparator<InetAddress> {
        private final boolean ip4BeforeIp6;
        private final boolean shallow;

        public InetAddressComparator(boolean ip4BeforeIp6, boolean shallow) {
            this.ip4BeforeIp6 = ip4BeforeIp6;
            this.shallow = shallow;
        }

        @Override
        public int compare(InetAddress a1, InetAddress a2) {
            byte[] bArr1 = a1.getAddress();
            byte[] bArr2 = a2.getAddress();
            if (a1 instanceof Inet4Address && a2 instanceof Inet6Address) {
                return this.ip4BeforeIp6 ? -1 : 1;
            }
            if (a1 instanceof Inet6Address && a2 instanceof Inet4Address) {
                return this.ip4BeforeIp6 ? 1 : -1;
            }
            if (bArr1.length != bArr2.length) {
                if (bArr1.length < bArr2.length) {
                    return this.ip4BeforeIp6 ? -1 : 1;
                }
                return this.ip4BeforeIp6 ? 1 : -1;
            }
            if (this.shallow) {
                return 0;
            }
            for (int i = 0; i < bArr1.length; ++i) {
                int x2;
                int x1 = Byte.toUnsignedInt(bArr1[i]);
                if (x1 == (x2 = Byte.toUnsignedInt(bArr2[i]))) continue;
                if (x1 < x2) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class DnsTimeoutTask
    implements Callable<InetAddress[]> {
        private final String host;

        public DnsTimeoutTask(String host) {
            this.host = host;
        }

        @Override
        public InetAddress[] call() throws UnknownHostException {
            return InetAddress.getAllByName(this.host);
        }
    }
}

