/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.options;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.ui.analyzer.PsalmCustomizerPanel;
import org.netbeans.modules.php.analysis.ui.options.PsalmOptionsPanel;
import org.netbeans.modules.php.api.util.StringUtils;

public final class ValidatorPsalmParameter {
    @NullAllowed
    private final String psalmPath;
    @NullAllowed
    private final String configuration;
    @NullAllowed
    private final String memoryLimit;

    public static ValidatorPsalmParameter create(PsalmOptionsPanel panel) {
        return new ValidatorPsalmParameter(panel);
    }

    public static ValidatorPsalmParameter create(PsalmCustomizerPanel panel) {
        return new ValidatorPsalmParameter(panel);
    }

    private ValidatorPsalmParameter() {
        this.psalmPath = null;
        this.configuration = null;
        this.memoryLimit = null;
    }

    private ValidatorPsalmParameter(PsalmOptionsPanel panel) {
        this.psalmPath = panel.getPsalmPath();
        this.configuration = panel.getPsalmConfigurationPath();
        this.memoryLimit = panel.getPsalmMemoryLimit();
    }

    private ValidatorPsalmParameter(PsalmCustomizerPanel panel) {
        this.psalmPath = StringUtils.hasText((String)panel.getPsalmPath()) ? panel.getPsalmPath() : AnalysisOptions.getInstance().getPsalmPath();
        this.configuration = panel.getConfiguration();
        this.memoryLimit = panel.getMemoryLimit();
    }

    @CheckForNull
    public String getPsalmPath() {
        return this.psalmPath;
    }

    @CheckForNull
    public String getConfiguration() {
        return this.configuration;
    }

    @CheckForNull
    public String getMemoryLimit() {
        return this.memoryLimit;
    }
}

