/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.store.subdirectory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.ShardLock;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.Store;
import org.opensearch.plugin.store.subdirectory.SubdirectoryAwareStore;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.plugins.Plugin;

public class SubdirectoryStorePlugin
extends Plugin
implements IndexStorePlugin {
    public Map<String, IndexStorePlugin.StoreFactory> getStoreFactories() {
        HashMap<String, SubdirectoryStoreFactory> map = new HashMap<String, SubdirectoryStoreFactory>();
        map.put("subdirectory_store", new SubdirectoryStoreFactory());
        return Collections.unmodifiableMap(map);
    }

    static class SubdirectoryStoreFactory
    implements IndexStorePlugin.StoreFactory {
        SubdirectoryStoreFactory() {
        }

        public Store newStore(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, Store.OnClose onClose, ShardPath shardPath) {
            return new SubdirectoryAwareStore(shardId, indexSettings, directory, shardLock, onClose, shardPath);
        }

        public Store newStore(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, Store.OnClose onClose, ShardPath shardPath, IndexStorePlugin.DirectoryFactory directoryFactory) {
            return new SubdirectoryAwareStore(shardId, indexSettings, directory, shardLock, onClose, shardPath, directoryFactory);
        }
    }
}

