/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AllowedPrincipal;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;

public class DescribeVpcEndpointServicePermissionsIterable
implements SdkIterable<DescribeVpcEndpointServicePermissionsResponse> {
    private final Ec2Client client;
    private final DescribeVpcEndpointServicePermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcEndpointServicePermissionsIterable(Ec2Client client, DescribeVpcEndpointServicePermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVpcEndpointServicePermissionsResponseFetcher();
    }

    public Iterator<DescribeVpcEndpointServicePermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AllowedPrincipal> allowedPrincipals() {
        Function<DescribeVpcEndpointServicePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowedPrincipals() != null) {
                return response.allowedPrincipals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcEndpointServicePermissionsResponseFetcher
    implements SyncPageFetcher<DescribeVpcEndpointServicePermissionsResponse> {
        private DescribeVpcEndpointServicePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointServicePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcEndpointServicePermissionsResponse nextPage(DescribeVpcEndpointServicePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointServicePermissionsIterable.this.client.describeVpcEndpointServicePermissions(DescribeVpcEndpointServicePermissionsIterable.this.firstRequest);
            }
            return DescribeVpcEndpointServicePermissionsIterable.this.client.describeVpcEndpointServicePermissions((DescribeVpcEndpointServicePermissionsRequest)((Object)DescribeVpcEndpointServicePermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

