/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.function.Callback;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.function.Decorator;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.function.Supplier;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpRequestMapper;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.config.CharCodingConfig;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.config.Http1Config;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.config.NamedElementChain;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.Http1StreamListener;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.HttpProcessors;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.bootstrap.FilterEntry;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncFilterHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.HandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.AsyncServerExpectationFilter;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.AsyncServerFilterChainElement;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpProcessor;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.LookupRegistry;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.UriPatternType;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.net.InetAddressUtils;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.net.URIAuthority;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOReactorConfig;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOReactorMetricsListener;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOSession;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOSessionListener;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Timeout;

public class AsyncServerBootstrap {
    private final List<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>> routeEntries = new ArrayList<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>>();
    private final List<FilterEntry<AsyncFilterHandler>> filters = new ArrayList<FilterEntry<AsyncFilterHandler>>();
    private String canonicalHostName;
    private HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouter;
    private LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry;
    private IOReactorConfig ioReactorConfig;
    private Http1Config http1Config;
    private CharCodingConfig charCodingConfig;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private Http1StreamListener streamListener;
    private IOReactorMetricsListener threadPoolListener;
    private BiFunction<String, URIAuthority, URIAuthority> authorityResolver;

    private AsyncServerBootstrap() {
    }

    public static AsyncServerBootstrap bootstrap() {
        return new AsyncServerBootstrap();
    }

    public final AsyncServerBootstrap setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
        return this;
    }

    public final AsyncServerBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final AsyncServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final AsyncServerBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final AsyncServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final AsyncServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connStrategy) {
        this.connStrategy = connStrategy;
        return this;
    }

    public final AsyncServerBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final AsyncServerBootstrap setTlsHandshakeTimeout(Timeout handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public final AsyncServerBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final AsyncServerBootstrap setIOReactorMetricsListener(IOReactorMetricsListener threadPoolListener) {
        this.threadPoolListener = threadPoolListener;
        return this;
    }

    public final AsyncServerBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final AsyncServerBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    @Deprecated
    public final AsyncServerBootstrap setLookupRegistry(LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final AsyncServerBootstrap setRequestRouter(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouter) {
        this.requestRouter = requestRouter;
        return this;
    }

    public final AsyncServerBootstrap setStreamListener(Http1StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final AsyncServerBootstrap setAuthorityResolver(BiFunction<String, URIAuthority, URIAuthority> authorityResolver) {
        this.authorityResolver = authorityResolver;
        return this;
    }

    public final AsyncServerBootstrap register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>(uriPattern, supplier));
        return this;
    }

    public final AsyncServerBootstrap register(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>(hostname, uriPattern, supplier));
        return this;
    }

    @Deprecated
    public final AsyncServerBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        return this.register(hostname, uriPattern, supplier);
    }

    public final <T> AsyncServerBootstrap register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    public final <T> AsyncServerBootstrap register(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(hostname, uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    @Deprecated
    public final <T> AsyncServerBootstrap registerVirtual(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        return this.register(hostname, uriPattern, requestHandler);
    }

    public final AsyncServerBootstrap addFilterBefore(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.BEFORE, name, filterHandler, existing));
        return this;
    }

    public final AsyncServerBootstrap addFilterAfter(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.AFTER, name, filterHandler, existing));
        return this;
    }

    public final AsyncServerBootstrap replaceFilter(String existing, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.REPLACE, existing, filterHandler, existing));
        return this;
    }

    public final AsyncServerBootstrap addFilterFirst(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.FIRST, name, filterHandler, null));
        return this;
    }

    public final AsyncServerBootstrap addFilterLast(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.LAST, name, filterHandler, null));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpAsyncServer create() {
        HandlerFactory<AsyncServerExchangeHandler> handlerFactory;
        HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouterCopy;
        String actualCanonicalHostName;
        String string = actualCanonicalHostName = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        if (this.lookupRegistry != null && this.requestRouter == null) {
            RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>> handlerRegistry = new RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>>(actualCanonicalHostName, () -> this.lookupRegistry != null ? this.lookupRegistry : new UriPatternMatcher());
            for (RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>> entry : this.routeEntries) {
                handlerRegistry.register(entry.uriAuthority != null ? entry.uriAuthority.getHostName() : null, (String)entry.route.pattern, (Supplier<AsyncServerExchangeHandler>)entry.route.handler);
            }
            requestRouterCopy = handlerRegistry;
        } else {
            requestRouterCopy = this.routeEntries.isEmpty() ? this.requestRouter : RequestRouter.create(new URIAuthority(actualCanonicalHostName), UriPatternType.URI_PATTERN, this.routeEntries, this.authorityResolver != null ? this.authorityResolver : RequestRouter.IGNORE_PORT_AUTHORITY_RESOLVER, this.requestRouter);
        }
        if (!this.filters.isEmpty()) {
            void var6_14;
            void var5_7;
            NamedElementChain<AsyncFilterHandler> filterChainDefinition = new NamedElementChain<AsyncFilterHandler>();
            filterChainDefinition.addLast(new TerminalAsyncServerFilter(new DefaultAsyncResponseExchangeHandlerFactory(requestRouterCopy)), StandardFilter.MAIN_HANDLER.name());
            filterChainDefinition.addFirst(new AsyncServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (FilterEntry<AsyncFilterHandler> filterEntry : this.filters) {
                switch (filterEntry.position) {
                    case AFTER: {
                        filterChainDefinition.addAfter(filterEntry.existing, (AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case BEFORE: {
                        filterChainDefinition.addBefore(filterEntry.existing, (AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case REPLACE: {
                        filterChainDefinition.replace(filterEntry.existing, (AsyncFilterHandler)filterEntry.filterHandler);
                        break;
                    }
                    case FIRST: {
                        filterChainDefinition.addFirst((AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case LAST: {
                        filterChainDefinition.addBefore(StandardFilter.MAIN_HANDLER.name(), (AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                    }
                }
            }
            NamedElementChain.Node node = filterChainDefinition.getLast();
            Object var6_13 = null;
            while (var5_7 != null) {
                AsyncServerFilterChainElement asyncServerFilterChainElement = new AsyncServerFilterChainElement((AsyncFilterHandler)var5_7.getValue(), (AsyncServerFilterChainElement)var6_14);
                NamedElementChain.Node node2 = var5_7.getPrevious();
            }
            handlerFactory = new AsyncServerFilterChainExchangeHandlerFactory((AsyncServerFilterChainElement)var6_14, this.exceptionCallback);
        } else {
            handlerFactory = new DefaultAsyncResponseExchangeHandlerFactory(requestRouterCopy, handler -> new BasicAsyncServerExpectationDecorator((AsyncServerExchangeHandler)handler, this.exceptionCallback));
        }
        ServerHttp1StreamDuplexerFactory streamHandlerFactory = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), handlerFactory, this.http1Config, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.connStrategy != null ? this.connStrategy : DefaultConnectionReuseStrategy.INSTANCE, new DefaultHttpRequestParserFactory(this.http1Config), new DefaultHttpResponseWriterFactory(this.http1Config), DefaultContentLengthStrategy.INSTANCE, DefaultContentLengthStrategy.INSTANCE, this.streamListener, this.exceptionCallback);
        ServerHttp1IOEventHandlerFactory serverHttp1IOEventHandlerFactory = new ServerHttp1IOEventHandlerFactory(streamHandlerFactory, this.tlsStrategy, this.handshakeTimeout);
        return new HttpAsyncServer((IOEventHandlerFactory)serverHttp1IOEventHandlerFactory, this.ioReactorConfig, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, this.threadPoolListener, null, null);
    }
}

