/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.vcs.log.graph.GraphCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class VcsLogMultiRepoJoiner<CommitId, Commit extends GraphCommit<CommitId>> {
    @NotNull
    public List<Commit> join(@NotNull Collection<? extends List<Commit>> logsFromRepos) {
        if (logsFromRepos == null) {
            VcsLogMultiRepoJoiner.$$$reportNull$$$0(0);
        }
        if (logsFromRepos.size() == 1) {
            List<Commit> list = logsFromRepos.iterator().next();
            if (list == null) {
                VcsLogMultiRepoJoiner.$$$reportNull$$$0(1);
            }
            return list;
        }
        int size = 0;
        for (List<Commit> repo : logsFromRepos) {
            size += repo.size();
        }
        ArrayList result = new ArrayList(size);
        HashMap<GraphCommit, Iterator> nextCommits = new HashMap<GraphCommit, Iterator>();
        for (List<Commit> log : logsFromRepos) {
            Iterator<Commit> iterator = log.iterator();
            if (!iterator.hasNext()) continue;
            nextCommits.put((GraphCommit)iterator.next(), iterator);
        }
        while (!nextCommits.isEmpty()) {
            Object lastCommit = this.findLatestCommit(nextCommits.keySet());
            Iterator iterator = (Iterator)nextCommits.get(lastCommit);
            result.add(lastCommit);
            nextCommits.remove(lastCommit);
            if (!iterator.hasNext()) continue;
            nextCommits.put((GraphCommit)iterator.next(), iterator);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            VcsLogMultiRepoJoiner.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private Commit findLatestCommit(@NotNull Set<? extends Commit> commits) {
        if (commits == null) {
            VcsLogMultiRepoJoiner.$$$reportNull$$$0(3);
        }
        long maxTimeStamp = Long.MIN_VALUE;
        GraphCommit lastCommit = null;
        for (GraphCommit commit : commits) {
            if (commit.getTimestamp() < maxTimeStamp) continue;
            maxTimeStamp = commit.getTimestamp();
            lastCommit = commit;
        }
        assert (lastCommit != null);
        GraphCommit graphCommit = lastCommit;
        if (graphCommit == null) {
            VcsLogMultiRepoJoiner.$$$reportNull$$$0(4);
        }
        return (Commit)graphCommit;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logsFromRepos";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogMultiRepoJoiner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findLatestCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLatestCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

