/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictFileStatusProvider;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.BaseRevisionStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.ChangelistsAwareLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/impl/ChangelistsLocalStatusTrackerProvider;", "Lcom/intellij/openapi/vcs/impl/BaseRevisionStatusTrackerContentLoader;", "Lcom/intellij/openapi/vcs/impl/ChangelistsAwareLocalStatusTrackerProvider;", "<init>", "()V", "isTrackedFile", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isMyTracker", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "createTracker", "intellij.platform.vcs.impl"})
final class ChangelistsLocalStatusTrackerProvider
extends BaseRevisionStatusTrackerContentLoader
implements ChangelistsAwareLocalStatusTrackerProvider {
    @NotNull
    public static final ChangelistsLocalStatusTrackerProvider INSTANCE = new ChangelistsLocalStatusTrackerProvider();

    private ChangelistsLocalStatusTrackerProvider() {
    }

    @Override
    public boolean isTrackedFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!LineStatusTrackerManager.Companion.getInstance(project).arePartialChangelistsEnabled(file)) {
            return false;
        }
        if (!super.isTrackedFile(project, file)) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus status = fileStatus;
        if (!(Intrinsics.areEqual((Object)status, (Object)FileStatus.MODIFIED) || Intrinsics.areEqual((Object)status, (Object)ChangelistConflictFileStatusProvider.MODIFIED_OUTSIDE) || Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED))) {
            return false;
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file);
        return change == null || Intrinsics.areEqual(change.getClass(), Change.class) && (change.getType() == Change.Type.MODIFICATION || change.getType() == Change.Type.MOVED) && change.getAfterRevision() instanceof CurrentContentRevision;
    }

    @Override
    public boolean isMyTracker(@NotNull LocalLineStatusTracker<?> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return tracker instanceof ChangelistsLocalLineStatusTracker;
    }

    @Override
    @Nullable
    public LocalLineStatusTracker<?> createTracker(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return ChangelistsLocalLineStatusTracker.Companion.createTracker(project, document2, file);
    }
}

