/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoImportQuickFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    private final List<ImportCandidateHolder> myImports;
    private final String myInitialName;
    private final boolean myUseQualifiedImport;
    @NotNull
    private final Class<? extends PsiReference> myReferenceType;
    private boolean myExpended;

    public AutoImportQuickFix(@NotNull PsiElement node, @NotNull Class<? extends PsiReference> referenceType, @NotNull String name, boolean qualify) {
        if (node == null) {
            AutoImportQuickFix.$$$reportNull$$$0(0);
        }
        if (referenceType == null) {
            AutoImportQuickFix.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AutoImportQuickFix.$$$reportNull$$$0(2);
        }
        this(node, referenceType, name, qualify, Collections.emptyList());
    }

    private AutoImportQuickFix(@NotNull PsiElement node, @NotNull Class<? extends PsiReference> referenceType, @NotNull String name, boolean qualify, @NotNull Collection<ImportCandidateHolder> candidates) {
        if (node == null) {
            AutoImportQuickFix.$$$reportNull$$$0(3);
        }
        if (referenceType == null) {
            AutoImportQuickFix.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AutoImportQuickFix.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            AutoImportQuickFix.$$$reportNull$$$0(6);
        }
        super(node);
        this.myExpended = false;
        this.myReferenceType = referenceType;
        this.myInitialName = name;
        this.myUseQualifiedImport = qualify;
        this.myImports = new ArrayList<ImportCandidateHolder>(candidates);
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFile file, @Nullable PyImportElement importElement) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(8);
        }
        this.myImports.add(new ImportCandidateHolder(importable, (PsiFileSystemItem)file, importElement, null));
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(9);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(10);
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, null, path));
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(11);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(12);
        }
        this.addImport(importable, file, null, path, asName);
    }

    public void addImport(@NotNull PsiNamedElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path, @Nullable String asName) {
        if (importable == null) {
            AutoImportQuickFix.$$$reportNull$$$0(13);
        }
        if (file == null) {
            AutoImportQuickFix.$$$reportNull$$$0(14);
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, importElement, path, asName));
    }

    @NotNull
    public String getText() {
        if (this.myUseQualifiedImport) {
            String string = PyPsiBundle.message("ACT.qualify.with.module", new Object[0]);
            if (string == null) {
                AutoImportQuickFix.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (this.myImports.size() == 1) {
            String string = PyPsiBundle.message("QFIX.auto.import.import.name", this.myImports.get(0).getPresentableText());
            if (string == null) {
                AutoImportQuickFix.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = PyPsiBundle.message("QFIX.auto.import.import.this.name", new Object[0]);
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.auto.import", new Object[0]);
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public ImportFromExistingAction createAction(PsiElement element) {
        ImportFromExistingAction action = new ImportFromExistingAction(element, this.myImports, this.myInitialName, null, this.myUseQualifiedImport, false);
        action.onDone(() -> {
            this.myExpended = true;
        });
        ImportFromExistingAction importFromExistingAction = action;
        if (importFromExistingAction == null) {
            AutoImportQuickFix.$$$reportNull$$$0(19);
        }
        return importFromExistingAction;
    }

    public boolean isAvailable() {
        PsiElement element = this.getStartElement();
        if (element == null) {
            return false;
        }
        PyPsiUtils.assertValid((PsiElement)element);
        return !this.myExpended && element.isValid() && !this.myImports.isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AutoImportQuickFix.$$$reportNull$$$0(20);
        }
        if (psiFile == null) {
            AutoImportQuickFix.$$$reportNull$$$0(21);
        }
        if (startElement == null) {
            AutoImportQuickFix.$$$reportNull$$$0(22);
        }
        if (endElement == null) {
            AutoImportQuickFix.$$$reportNull$$$0(23);
        }
        this.invoke();
    }

    public void invoke() throws IncorrectOperationException {
        PsiElement startElement = this.getStartElement();
        if (startElement == null) {
            return;
        }
        PsiReference reference = this.findOriginalReference(startElement);
        if (reference == null || AutoImportQuickFix.isResolved(reference)) {
            return;
        }
        ImportFromExistingAction action = this.createAction();
        if (action != null) {
            action.execute();
        }
        this.myExpended = true;
    }

    @Nullable
    protected ImportFromExistingAction createAction() {
        return new ImportFromExistingAction(this.getStartElement(), this.myImports, this.myInitialName, null, this.myUseQualifiedImport, false);
    }

    public void sortCandidates() {
        Collections.sort(this.myImports);
    }

    @NotNull
    public List<ImportCandidateHolder> getCandidates() {
        List<ImportCandidateHolder> list = Collections.unmodifiableList(this.myImports);
        if (list == null) {
            AutoImportQuickFix.$$$reportNull$$$0(24);
        }
        return list;
    }

    public boolean hasOnlyFunctions() {
        for (ImportCandidateHolder holder : this.myImports) {
            if (holder.getImportable() instanceof PyFunction) continue;
            return false;
        }
        return true;
    }

    public boolean hasProjectImports() {
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.getStartElement().getProject());
        for (ImportCandidateHolder anImport : this.myImports) {
            PsiFileSystemItem importFile = anImport.getFile();
            VirtualFile file = importFile != null ? importFile.getVirtualFile() : null;
            if (file == null || !fileIndex.isInContent(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public AutoImportQuickFix forLocalImport() {
        return new AutoImportLocallyQuickFix(this.getStartElement(), this.myReferenceType, this.myInitialName, this.myUseQualifiedImport, this.myImports);
    }

    @NotNull
    public String getNameToImport() {
        String string = this.myInitialName;
        if (string == null) {
            AutoImportQuickFix.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public Class<? extends PsiReference> getReferenceType() {
        Class<? extends PsiReference> clazz = this.myReferenceType;
        if (clazz == null) {
            AutoImportQuickFix.$$$reportNull$$$0(26);
        }
        return clazz;
    }

    public boolean isUseQualifiedImport() {
        return this.myUseQualifiedImport;
    }

    @ApiStatus.Internal
    public static boolean isResolved(@NotNull PsiReference reference) {
        if (reference == null) {
            AutoImportQuickFix.$$$reportNull$$$0(27);
        }
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length > 0;
        }
        return reference.resolve() != null;
    }

    @ApiStatus.Internal
    @Nullable
    public PsiReference findOriginalReference(@NotNull PsiElement element) {
        if (element == null) {
            AutoImportQuickFix.$$$reportNull$$$0(28);
        }
        return (PsiReference)ContainerUtil.findInstance((Object[])element.getReferences(), this.myReferenceType);
    }

    @Nullable
    public AutoImportQuickFix getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement unresolvedRef;
        if (target == null) {
            AutoImportQuickFix.$$$reportNull$$$0(29);
        }
        if ((unresolvedRef = this.getStartElement()) == null) {
            return null;
        }
        PsiElement unresolvedRefCopy = PsiTreeUtil.findSameElementInCopy((PsiElement)unresolvedRef, (PsiFile)target);
        ArrayList<ImportCandidateHolder> candidates = new ArrayList<ImportCandidateHolder>();
        for (ImportCandidateHolder candidate : this.myImports) {
            ImportCandidateHolder importCandidateForPreview = AutoImportQuickFix.updateExistingImportElementForPreview(candidate, target);
            if (importCandidateForPreview == null) {
                return null;
            }
            candidates.add(importCandidateForPreview);
        }
        return new AutoImportQuickFix(unresolvedRefCopy, this.myReferenceType, this.myInitialName, this.myUseQualifiedImport, candidates);
    }

    @Nullable
    private static ImportCandidateHolder updateExistingImportElementForPreview(@NotNull ImportCandidateHolder candidate, @NotNull PsiFile target) {
        PyImportElement importElement;
        if (candidate == null) {
            AutoImportQuickFix.$$$reportNull$$$0(30);
        }
        if (target == null) {
            AutoImportQuickFix.$$$reportNull$$$0(31);
        }
        if ((importElement = candidate.getImportElement()) == null) {
            return candidate;
        }
        if (candidate.getImportable() == null || candidate.getFile() == null) {
            return null;
        }
        return new ImportCandidateHolder(candidate.getImportable(), candidate.getFile(), (PyImportElement)PsiTreeUtil.findSameElementInCopy((PsiElement)importElement, (PsiFile)target), candidate.getPath(), candidate.getAsName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 18, 19, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importable";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameToImport";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalReference";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateExistingImportElementForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 18, 19, 24, 25, 26 -> new IllegalStateException(string);
        };
    }

    private static class AutoImportLocallyQuickFix
    extends AutoImportQuickFix {
        private AutoImportLocallyQuickFix(@NotNull PsiElement element, @NotNull Class<? extends PsiReference> type, @NotNull String name, boolean qualify, @NotNull List<ImportCandidateHolder> imports) {
            if (element == null) {
                AutoImportLocallyQuickFix.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AutoImportLocallyQuickFix.$$$reportNull$$$0(1);
            }
            if (name == null) {
                AutoImportLocallyQuickFix.$$$reportNull$$$0(2);
            }
            if (imports == null) {
                AutoImportLocallyQuickFix.$$$reportNull$$$0(3);
            }
            super(element, type, name, qualify, imports);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.NAME.local.auto.import", new Object[0]);
            if (string == null) {
                AutoImportLocallyQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getText() {
            String string = PyPsiBundle.message("QFIX.local.auto.import.import.locally", super.getText());
            if (string == null) {
                AutoImportLocallyQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected ImportFromExistingAction createAction() {
            return new ImportFromExistingAction(this.getStartElement(), this.getCandidates(), this.getNameToImport(), null, this.isUseQualifiedImport(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$AutoImportLocallyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$AutoImportLocallyQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

