/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@ImportStatic(value={PGuards.class})
@GenerateInline(value=false)
public abstract class PrepareExceptionNode
extends Node {
    public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

    @Specialization
    static Object doException(PBaseException exc, PNone value) {
        return exc;
    }

    @Specialization(guards={"check.execute(inliningTarget, exc)"})
    static Object doException(PythonAbstractNativeObject exc, PNone value, @Bind Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check) {
        return exc;
    }

    @Specialization(guards={"check.execute(inliningTarget, exc)", "!isPNone(value)"})
    static Object doException(PBaseException exc, Object value, @Cached.Shared @Cached PyExceptionInstanceCheckNode check, @Bind Node inliningTarget) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INSTANCE_EX_MAY_NOT_HAVE_SEP_VALUE);
    }

    @Specialization(guards={"isTypeNode.execute(inliningTarget, type)", "!isPNone(value)", "!isPTuple(value)"}, limit="1")
    static Object doExceptionOrCreate(VirtualFrame frame, Object type, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached InlinedConditionProfile isInstanceProfile, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Shared(value="callCtor") @Cached CallNode callConstructor) {
        PrepareExceptionNode.checkExceptionClass(inliningTarget, type, isSubtypeNode, raiseNode);
        if (isInstanceProfile.profile(inliningTarget, isInstanceNode.executeWith(frame, value, type))) {
            return value;
        }
        Object instance = callConstructor.execute((Frame)frame, type, value);
        if (check.execute(inliningTarget, instance)) {
            return instance;
        }
        return PrepareExceptionNode.handleInstanceNotAnException(type, instance);
    }

    @Specialization(guards={"isTypeNode.execute(this, type)"}, limit="1")
    static Object doCreate(VirtualFrame frame, Object type, PNone value, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Shared(value="callCtor") @Cached CallNode callConstructor) {
        PrepareExceptionNode.checkExceptionClass(inliningTarget, type, isSubtypeNode, raiseNode);
        Object instance = callConstructor.execute((Frame)frame, type, new Object[0]);
        if (check.execute(inliningTarget, instance)) {
            return instance;
        }
        return PrepareExceptionNode.handleInstanceNotAnException(type, instance);
    }

    @Specialization(guards={"isTypeNode.execute(inliningTarget, type)"}, limit="1")
    static Object doCreateTuple(VirtualFrame frame, Object type, PTuple value, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Shared(value="callCtor") @Cached CallNode callConstructor) {
        PrepareExceptionNode.checkExceptionClass(inliningTarget, type, isSubtypeNode, raiseNode);
        Object[] args = getObjectArrayNode.execute(inliningTarget, value);
        Object instance = callConstructor.execute((Frame)frame, type, args);
        if (check.execute(inliningTarget, instance)) {
            return instance;
        }
        return PrepareExceptionNode.handleInstanceNotAnException(type, instance);
    }

    @Specialization(guards={"fallbackGuard(type, inliningTarget, isTypeNode)"}, limit="1")
    static Object doError(Object type, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXCEPTIONS_MUST_BE_CLASSES_OR_INSTANCES_DERIVING_FROM_BASE_EX, type);
    }

    static boolean fallbackGuard(Object type, Node inliningTarget, TypeNodes.IsTypeNode isTypeNode) {
        return !(type instanceof PBaseException) && !isTypeNode.execute(inliningTarget, type);
    }

    private static PBaseException handleInstanceNotAnException(Object type, Object instance) {
        return PFactory.createBaseException(PythonLanguage.get(null), PythonErrorType.TypeError, ErrorMessages.CALLING_N_SHOULD_HAVE_RETURNED_AN_INSTANCE_OF_BASE_EXCEPTION_NOT_P, new Object[]{type, instance});
    }

    private static void checkExceptionClass(Node inliningTarget, Object type, IsSubtypeNode isSubtypeNode, PRaiseNode raiseNode) {
        if (!isSubtypeNode.execute(type, (Object)PythonBuiltinClassType.PBaseException)) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXCEPTIONS_MUST_BE_CLASSES_OR_INSTANCES_DERIVING_FROM_BASE_EX, type);
        }
    }
}

