/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PosixSupportLibrary.class)
final class PosixSupportLibraryGen
extends LibraryFactory<PosixSupportLibrary> {
    private static final Class<PosixSupportLibrary> LIBRARY_CLASS = PosixSupportLibraryGen.lazyLibraryClass();
    private static final Message GET_BACKEND = new MessageImpl("getBackend", 0, false, TruffleString.class, Object.class);
    private static final Message STRERROR = new MessageImpl("strerror", 1, false, TruffleString.class, Object.class, Integer.TYPE);
    private static final Message GETPID = new MessageImpl("getpid", 2, false, Long.TYPE, Object.class);
    private static final Message UMASK = new MessageImpl("umask", 3, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message OPENAT = new MessageImpl("openat", 4, false, Integer.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message CLOSE = new MessageImpl("close", 5, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message READ = new MessageImpl("read", 6, false, PosixSupportLibrary.Buffer.class, Object.class, Integer.TYPE, Long.TYPE);
    private static final Message WRITE = new MessageImpl("write", 7, false, Long.TYPE, Object.class, Integer.TYPE, PosixSupportLibrary.Buffer.class);
    private static final Message DUP = new MessageImpl("dup", 8, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message DUP2 = new MessageImpl("dup2", 9, false, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
    private static final Message GET_INHERITABLE = new MessageImpl("getInheritable", 10, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message SET_INHERITABLE = new MessageImpl("setInheritable", 11, false, Void.TYPE, Object.class, Integer.TYPE, Boolean.TYPE);
    private static final Message PIPE = new MessageImpl("pipe", 12, false, int[].class, Object.class);
    private static final Message SELECT = new MessageImpl("select", 13, false, PosixSupportLibrary.SelectResult.class, Object.class, int[].class, int[].class, int[].class, PosixSupportLibrary.Timeval.class);
    private static final Message POLL = new MessageImpl("poll", 14, false, Boolean.TYPE, Object.class, Integer.TYPE, Boolean.TYPE, PosixSupportLibrary.Timeval.class);
    private static final Message LSEEK = new MessageImpl("lseek", 15, false, Long.TYPE, Object.class, Integer.TYPE, Long.TYPE, Integer.TYPE);
    private static final Message FTRUNCATE = new MessageImpl("ftruncate", 16, false, Void.TYPE, Object.class, Integer.TYPE, Long.TYPE);
    private static final Message TRUNCATE = new MessageImpl("truncate", 17, false, Void.TYPE, Object.class, Object.class, Long.TYPE);
    private static final Message FSYNC = new MessageImpl("fsync", 18, false, Void.TYPE, Object.class, Integer.TYPE);
    private static final Message FLOCK = new MessageImpl("flock", 19, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message FCNTL_LOCK = new MessageImpl("fcntlLock", 20, false, Void.TYPE, Object.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE);
    private static final Message GET_BLOCKING = new MessageImpl("getBlocking", 21, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message SET_BLOCKING = new MessageImpl("setBlocking", 22, false, Void.TYPE, Object.class, Integer.TYPE, Boolean.TYPE);
    private static final Message GET_TERMINAL_SIZE = new MessageImpl("getTerminalSize", 23, false, int[].class, Object.class, Integer.TYPE);
    private static final Message SYSCONF = new MessageImpl("sysconf", 24, false, Long.TYPE, Object.class, Integer.TYPE);
    private static final Message FSTATAT = new MessageImpl("fstatat", 25, false, long[].class, Object.class, Integer.TYPE, Object.class, Boolean.TYPE);
    private static final Message FSTAT = new MessageImpl("fstat", 26, false, long[].class, Object.class, Integer.TYPE);
    private static final Message STATVFS = new MessageImpl("statvfs", 27, false, long[].class, Object.class, Object.class);
    private static final Message FSTATVFS = new MessageImpl("fstatvfs", 28, false, long[].class, Object.class, Integer.TYPE);
    private static final Message UNAME = new MessageImpl("uname", 29, false, Object[].class, Object.class);
    private static final Message UNLINKAT = new MessageImpl("unlinkat", 30, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Boolean.TYPE);
    private static final Message LINKAT = new MessageImpl("linkat", 31, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message SYMLINKAT = new MessageImpl("symlinkat", 32, false, Void.TYPE, Object.class, Object.class, Integer.TYPE, Object.class);
    private static final Message MKDIRAT = new MessageImpl("mkdirat", 33, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message GETCWD = new MessageImpl("getcwd", 34, false, Object.class, Object.class);
    private static final Message CHDIR = new MessageImpl("chdir", 35, false, Void.TYPE, Object.class, Object.class);
    private static final Message FCHDIR = new MessageImpl("fchdir", 36, false, Void.TYPE, Object.class, Integer.TYPE);
    private static final Message ISATTY = new MessageImpl("isatty", 37, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message OPENDIR = new MessageImpl("opendir", 38, false, Object.class, Object.class, Object.class);
    private static final Message FDOPENDIR = new MessageImpl("fdopendir", 39, false, Object.class, Object.class, Integer.TYPE);
    private static final Message CLOSEDIR = new MessageImpl("closedir", 40, false, Void.TYPE, Object.class, Object.class);
    private static final Message READDIR = new MessageImpl("readdir", 41, false, Object.class, Object.class, Object.class);
    private static final Message REWINDDIR = new MessageImpl("rewinddir", 42, false, Void.TYPE, Object.class, Object.class);
    private static final Message DIR_ENTRY_GET_NAME = new MessageImpl("dirEntryGetName", 43, false, Object.class, Object.class, Object.class);
    private static final Message DIR_ENTRY_GET_PATH = new MessageImpl("dirEntryGetPath", 44, false, Object.class, Object.class, Object.class, Object.class);
    private static final Message DIR_ENTRY_GET_INODE = new MessageImpl("dirEntryGetInode", 45, false, Long.TYPE, Object.class, Object.class);
    private static final Message DIR_ENTRY_GET_TYPE = new MessageImpl("dirEntryGetType", 46, false, Integer.TYPE, Object.class, Object.class);
    private static final Message UTIMENSAT = new MessageImpl("utimensat", 47, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, long[].class, Boolean.TYPE);
    private static final Message FUTIMENS = new MessageImpl("futimens", 48, false, Void.TYPE, Object.class, Integer.TYPE, long[].class);
    private static final Message FUTIMES = new MessageImpl("futimes", 49, false, Void.TYPE, Object.class, Integer.TYPE, PosixSupportLibrary.Timeval[].class);
    private static final Message LUTIMES = new MessageImpl("lutimes", 50, false, Void.TYPE, Object.class, Object.class, PosixSupportLibrary.Timeval[].class);
    private static final Message UTIMES = new MessageImpl("utimes", 51, false, Void.TYPE, Object.class, Object.class, PosixSupportLibrary.Timeval[].class);
    private static final Message RENAMEAT = new MessageImpl("renameat", 52, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Object.class);
    private static final Message FACCESSAT = new MessageImpl("faccessat", 53, false, Boolean.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
    private static final Message FCHMODAT = new MessageImpl("fchmodat", 54, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Boolean.TYPE);
    private static final Message FCHMOD = new MessageImpl("fchmod", 55, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message FCHOWNAT = new MessageImpl("fchownat", 56, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Long.TYPE, Long.TYPE, Boolean.TYPE);
    private static final Message FCHOWN = new MessageImpl("fchown", 57, false, Void.TYPE, Object.class, Integer.TYPE, Long.TYPE, Long.TYPE);
    private static final Message READLINKAT = new MessageImpl("readlinkat", 58, false, Object.class, Object.class, Integer.TYPE, Object.class);
    private static final Message KILL = new MessageImpl("kill", 59, false, Void.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    private static final Message KILLPG = new MessageImpl("killpg", 60, false, Void.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    private static final Message WAITPID = new MessageImpl("waitpid", 61, false, long[].class, Object.class, Long.TYPE, Integer.TYPE);
    private static final Message ABORT = new MessageImpl("abort", 62, false, Void.TYPE, Object.class);
    private static final Message WCOREDUMP = new MessageImpl("wcoredump", 63, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message WIFCONTINUED = new MessageImpl("wifcontinued", 64, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message WIFSTOPPED = new MessageImpl("wifstopped", 65, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message WIFSIGNALED = new MessageImpl("wifsignaled", 66, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message WIFEXITED = new MessageImpl("wifexited", 67, false, Boolean.TYPE, Object.class, Integer.TYPE);
    private static final Message WEXITSTATUS = new MessageImpl("wexitstatus", 68, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message WTERMSIG = new MessageImpl("wtermsig", 69, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message WSTOPSIG = new MessageImpl("wstopsig", 70, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message GETUID = new MessageImpl("getuid", 71, false, Long.TYPE, Object.class);
    private static final Message GETEUID = new MessageImpl("geteuid", 72, false, Long.TYPE, Object.class);
    private static final Message GETGID = new MessageImpl("getgid", 73, false, Long.TYPE, Object.class);
    private static final Message GETEGID = new MessageImpl("getegid", 74, false, Long.TYPE, Object.class);
    private static final Message GETPPID = new MessageImpl("getppid", 75, false, Long.TYPE, Object.class);
    private static final Message GETPGID = new MessageImpl("getpgid", 76, false, Long.TYPE, Object.class, Long.TYPE);
    private static final Message SETPGID = new MessageImpl("setpgid", 77, false, Void.TYPE, Object.class, Long.TYPE, Long.TYPE);
    private static final Message GETPGRP = new MessageImpl("getpgrp", 78, false, Long.TYPE, Object.class);
    private static final Message GETSID = new MessageImpl("getsid", 79, false, Long.TYPE, Object.class, Long.TYPE);
    private static final Message SETSID = new MessageImpl("setsid", 80, false, Long.TYPE, Object.class);
    private static final Message GETGROUPS = new MessageImpl("getgroups", 81, false, long[].class, Object.class);
    private static final Message GETRUSAGE = new MessageImpl("getrusage", 82, false, PosixSupportLibrary.RusageResult.class, Object.class, Integer.TYPE);
    private static final Message OPENPTY = new MessageImpl("openpty", 83, false, PosixSupportLibrary.OpenPtyResult.class, Object.class);
    private static final Message CTERMID = new MessageImpl("ctermid", 84, false, TruffleString.class, Object.class);
    private static final Message SETENV = new MessageImpl("setenv", 85, false, Void.TYPE, Object.class, Object.class, Object.class, Boolean.TYPE);
    private static final Message UNSETENV = new MessageImpl("unsetenv", 86, false, Void.TYPE, Object.class, Object.class);
    private static final Message FORK_EXEC = new MessageImpl("forkExec", 87, false, Integer.TYPE, Object.class, Object[].class, Object[].class, Object.class, Object[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, int[].class);
    private static final Message EXECV = new MessageImpl("execv", 88, false, Void.TYPE, Object.class, Object.class, Object[].class);
    private static final Message SYSTEM = new MessageImpl("system", 89, false, Integer.TYPE, Object.class, Object.class);
    private static final Message MMAP = new MessageImpl("mmap", 90, false, Object.class, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE);
    private static final Message MMAP_READ_BYTE = new MessageImpl("mmapReadByte", 91, false, Byte.TYPE, Object.class, Object.class, Long.TYPE);
    private static final Message MMAP_WRITE_BYTE = new MessageImpl("mmapWriteByte", 92, false, Void.TYPE, Object.class, Object.class, Long.TYPE, Byte.TYPE);
    private static final Message MMAP_READ_BYTES = new MessageImpl("mmapReadBytes", 93, false, Integer.TYPE, Object.class, Object.class, Long.TYPE, byte[].class, Integer.TYPE);
    private static final Message MMAP_WRITE_BYTES = new MessageImpl("mmapWriteBytes", 94, false, Void.TYPE, Object.class, Object.class, Long.TYPE, byte[].class, Integer.TYPE);
    private static final Message MMAP_FLUSH = new MessageImpl("mmapFlush", 95, false, Void.TYPE, Object.class, Object.class, Long.TYPE, Long.TYPE);
    private static final Message MMAP_UNMAP = new MessageImpl("mmapUnmap", 96, false, Void.TYPE, Object.class, Object.class, Long.TYPE);
    private static final Message MMAP_GET_POINTER = new MessageImpl("mmapGetPointer", 97, false, Long.TYPE, Object.class, Object.class);
    private static final Message SEM_OPEN = new MessageImpl("semOpen", 98, false, Long.TYPE, Object.class, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message SEM_CLOSE = new MessageImpl("semClose", 99, false, Void.TYPE, Object.class, Long.TYPE);
    private static final Message SEM_UNLINK = new MessageImpl("semUnlink", 100, false, Void.TYPE, Object.class, Object.class);
    private static final Message SEM_GET_VALUE = new MessageImpl("semGetValue", 101, false, Integer.TYPE, Object.class, Long.TYPE);
    private static final Message SEM_POST = new MessageImpl("semPost", 102, false, Void.TYPE, Object.class, Long.TYPE);
    private static final Message SEM_WAIT = new MessageImpl("semWait", 103, false, Void.TYPE, Object.class, Long.TYPE);
    private static final Message SEM_TRY_WAIT = new MessageImpl("semTryWait", 104, false, Boolean.TYPE, Object.class, Long.TYPE);
    private static final Message SEM_TIMED_WAIT = new MessageImpl("semTimedWait", 105, false, Boolean.TYPE, Object.class, Long.TYPE, Long.TYPE);
    private static final Message GETPWUID = new MessageImpl("getpwuid", 106, false, PosixSupportLibrary.PwdResult.class, Object.class, Long.TYPE);
    private static final Message GETPWNAM = new MessageImpl("getpwnam", 107, false, PosixSupportLibrary.PwdResult.class, Object.class, Object.class);
    private static final Message HAS_GETPWENTRIES = new MessageImpl("hasGetpwentries", 108, false, Boolean.TYPE, Object.class);
    private static final Message GETPWENTRIES = new MessageImpl("getpwentries", 109, false, PosixSupportLibrary.PwdResult[].class, Object.class);
    private static final Message CREATE_PATH_FROM_STRING = new MessageImpl("createPathFromString", 110, false, Object.class, Object.class, TruffleString.class);
    private static final Message CREATE_PATH_FROM_BYTES = new MessageImpl("createPathFromBytes", 111, false, Object.class, Object.class, byte[].class);
    private static final Message GET_PATH_AS_STRING = new MessageImpl("getPathAsString", 112, false, TruffleString.class, Object.class, Object.class);
    private static final Message GET_PATH_AS_BYTES = new MessageImpl("getPathAsBytes", 113, false, PosixSupportLibrary.Buffer.class, Object.class, Object.class);
    private static final Message SOCKET = new MessageImpl("socket", 114, false, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message ACCEPT = new MessageImpl("accept", 115, false, PosixSupportLibrary.AcceptResult.class, Object.class, Integer.TYPE);
    private static final Message BIND = new MessageImpl("bind", 116, false, Void.TYPE, Object.class, Integer.TYPE, PosixSupportLibrary.UniversalSockAddr.class);
    private static final Message CONNECT = new MessageImpl("connect", 117, false, Void.TYPE, Object.class, Integer.TYPE, PosixSupportLibrary.UniversalSockAddr.class);
    private static final Message LISTEN = new MessageImpl("listen", 118, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message GETPEERNAME = new MessageImpl("getpeername", 119, false, PosixSupportLibrary.UniversalSockAddr.class, Object.class, Integer.TYPE);
    private static final Message GETSOCKNAME = new MessageImpl("getsockname", 120, false, PosixSupportLibrary.UniversalSockAddr.class, Object.class, Integer.TYPE);
    private static final Message SEND = new MessageImpl("send", 121, false, Integer.TYPE, Object.class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message SENDTO = new MessageImpl("sendto", 122, false, Integer.TYPE, Object.class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, PosixSupportLibrary.UniversalSockAddr.class);
    private static final Message RECV = new MessageImpl("recv", 123, false, Integer.TYPE, Object.class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message RECVFROM = new MessageImpl("recvfrom", 124, false, PosixSupportLibrary.RecvfromResult.class, Object.class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message SHUTDOWN = new MessageImpl("shutdown", 125, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message GETSOCKOPT = new MessageImpl("getsockopt", 126, false, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
    private static final Message SETSOCKOPT = new MessageImpl("setsockopt", 127, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
    private static final Message INET_ADDR = new MessageImpl("inet_addr", 128, false, Integer.TYPE, Object.class, Object.class);
    private static final Message INET_ATON = new MessageImpl("inet_aton", 129, false, Integer.TYPE, Object.class, Object.class);
    private static final Message INET_NTOA = new MessageImpl("inet_ntoa", 130, false, Object.class, Object.class, Integer.TYPE);
    private static final Message INET_PTON = new MessageImpl("inet_pton", 131, false, byte[].class, Object.class, Integer.TYPE, Object.class);
    private static final Message INET_NTOP = new MessageImpl("inet_ntop", 132, false, Object.class, Object.class, Integer.TYPE, byte[].class);
    private static final Message GETHOSTNAME = new MessageImpl("gethostname", 133, false, Object.class, Object.class);
    private static final Message GETNAMEINFO = new MessageImpl("getnameinfo", 134, false, Object[].class, Object.class, PosixSupportLibrary.UniversalSockAddr.class, Integer.TYPE);
    private static final Message GETADDRINFO = new MessageImpl("getaddrinfo", 135, false, PosixSupportLibrary.AddrInfoCursor.class, Object.class, Object.class, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Message CRYPT = new MessageImpl("crypt", 136, false, TruffleString.class, Object.class, TruffleString.class, TruffleString.class);
    private static final Message IOCTL_BYTES = new MessageImpl("ioctlBytes", 137, false, Integer.TYPE, Object.class, Integer.TYPE, Long.TYPE, byte[].class);
    private static final Message IOCTL_INT = new MessageImpl("ioctlInt", 138, false, Integer.TYPE, Object.class, Integer.TYPE, Long.TYPE, Integer.TYPE);
    private static final Message CREATE_UNIVERSAL_SOCK_ADDR_INET4 = new MessageImpl("createUniversalSockAddrInet4", 139, false, PosixSupportLibrary.UniversalSockAddr.class, Object.class, PosixSupportLibrary.Inet4SockAddr.class);
    private static final Message CREATE_UNIVERSAL_SOCK_ADDR_INET6 = new MessageImpl("createUniversalSockAddrInet6", 140, false, PosixSupportLibrary.UniversalSockAddr.class, Object.class, PosixSupportLibrary.Inet6SockAddr.class);
    private static final Message CREATE_UNIVERSAL_SOCK_ADDR_UNIX = new MessageImpl("createUniversalSockAddrUnix", 141, false, PosixSupportLibrary.UniversalSockAddr.class, Object.class, PosixSupportLibrary.UnixSockAddr.class);
    private static final PosixSupportLibraryGen INSTANCE = new PosixSupportLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private PosixSupportLibraryGen() {
        super(LIBRARY_CLASS, List.of(GET_BACKEND, STRERROR, GETPID, UMASK, OPENAT, CLOSE, READ, WRITE, DUP, DUP2, GET_INHERITABLE, SET_INHERITABLE, PIPE, SELECT, POLL, LSEEK, FTRUNCATE, TRUNCATE, FSYNC, FLOCK, FCNTL_LOCK, GET_BLOCKING, SET_BLOCKING, GET_TERMINAL_SIZE, SYSCONF, FSTATAT, FSTAT, STATVFS, FSTATVFS, UNAME, UNLINKAT, LINKAT, SYMLINKAT, MKDIRAT, GETCWD, CHDIR, FCHDIR, ISATTY, OPENDIR, FDOPENDIR, CLOSEDIR, READDIR, REWINDDIR, DIR_ENTRY_GET_NAME, DIR_ENTRY_GET_PATH, DIR_ENTRY_GET_INODE, DIR_ENTRY_GET_TYPE, UTIMENSAT, FUTIMENS, FUTIMES, LUTIMES, UTIMES, RENAMEAT, FACCESSAT, FCHMODAT, FCHMOD, FCHOWNAT, FCHOWN, READLINKAT, KILL, KILLPG, WAITPID, ABORT, WCOREDUMP, WIFCONTINUED, WIFSTOPPED, WIFSIGNALED, WIFEXITED, WEXITSTATUS, WTERMSIG, WSTOPSIG, GETUID, GETEUID, GETGID, GETEGID, GETPPID, GETPGID, SETPGID, GETPGRP, GETSID, SETSID, GETGROUPS, GETRUSAGE, OPENPTY, CTERMID, SETENV, UNSETENV, FORK_EXEC, EXECV, SYSTEM, MMAP, MMAP_READ_BYTE, MMAP_WRITE_BYTE, MMAP_READ_BYTES, MMAP_WRITE_BYTES, MMAP_FLUSH, MMAP_UNMAP, MMAP_GET_POINTER, SEM_OPEN, SEM_CLOSE, SEM_UNLINK, SEM_GET_VALUE, SEM_POST, SEM_WAIT, SEM_TRY_WAIT, SEM_TIMED_WAIT, GETPWUID, GETPWNAM, HAS_GETPWENTRIES, GETPWENTRIES, CREATE_PATH_FROM_STRING, CREATE_PATH_FROM_BYTES, GET_PATH_AS_STRING, GET_PATH_AS_BYTES, SOCKET, ACCEPT, BIND, CONNECT, LISTEN, GETPEERNAME, GETSOCKNAME, SEND, SENDTO, RECV, RECVFROM, SHUTDOWN, GETSOCKOPT, SETSOCKOPT, INET_ADDR, INET_ATON, INET_NTOA, INET_PTON, INET_NTOP, GETHOSTNAME, GETNAMEINFO, GETADDRINFO, CRYPT, IOCTL_BYTES, IOCTL_INT, CREATE_UNIVERSAL_SOCK_ADDR_INET4, CREATE_UNIVERSAL_SOCK_ADDR_INET6, CREATE_UNIVERSAL_SOCK_ADDR_UNIX));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return PosixSupportLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected PosixSupportLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected PosixSupportLibrary createDelegate(PosixSupportLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PosixSupportLibrary lib = (PosixSupportLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.getBackend(receiver);
            }
            case 1: {
                return lib.strerror(receiver, (Integer)args[offset]);
            }
            case 2: {
                return lib.getpid(receiver);
            }
            case 3: {
                return lib.umask(receiver, (Integer)args[offset]);
            }
            case 4: {
                return lib.openat(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
            }
            case 5: {
                return lib.close(receiver, (Integer)args[offset]);
            }
            case 6: {
                return lib.read(receiver, (Integer)args[offset], (Long)args[offset + 1]);
            }
            case 7: {
                return lib.write(receiver, (Integer)args[offset], (PosixSupportLibrary.Buffer)args[offset + 1]);
            }
            case 8: {
                return lib.dup(receiver, (Integer)args[offset]);
            }
            case 9: {
                return lib.dup2(receiver, (Integer)args[offset], (Integer)args[offset + 1], (Boolean)args[offset + 2]);
            }
            case 10: {
                return lib.getInheritable(receiver, (Integer)args[offset]);
            }
            case 11: {
                lib.setInheritable(receiver, (Integer)args[offset], (Boolean)args[offset + 1]);
                return null;
            }
            case 12: {
                return lib.pipe(receiver);
            }
            case 13: {
                return lib.select(receiver, (int[])args[offset], (int[])args[offset + 1], (int[])args[offset + 2], (PosixSupportLibrary.Timeval)args[offset + 3]);
            }
            case 14: {
                return lib.poll(receiver, (Integer)args[offset], (Boolean)args[offset + 1], (PosixSupportLibrary.Timeval)args[offset + 2]);
            }
            case 15: {
                return lib.lseek(receiver, (Integer)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 16: {
                lib.ftruncate(receiver, (Integer)args[offset], (Long)args[offset + 1]);
                return null;
            }
            case 17: {
                lib.truncate(receiver, args[offset], (Long)args[offset + 1]);
                return null;
            }
            case 18: {
                lib.fsync(receiver, (Integer)args[offset]);
                return null;
            }
            case 19: {
                lib.flock(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 20: {
                lib.fcntlLock(receiver, (Integer)args[offset], (Boolean)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Long)args[offset + 4], (Long)args[offset + 5]);
                return null;
            }
            case 21: {
                return lib.getBlocking(receiver, (Integer)args[offset]);
            }
            case 22: {
                lib.setBlocking(receiver, (Integer)args[offset], (Boolean)args[offset + 1]);
                return null;
            }
            case 23: {
                return lib.getTerminalSize(receiver, (Integer)args[offset]);
            }
            case 24: {
                return lib.sysconf(receiver, (Integer)args[offset]);
            }
            case 25: {
                return lib.fstatat(receiver, (Integer)args[offset], args[offset + 1], (Boolean)args[offset + 2]);
            }
            case 26: {
                return lib.fstat(receiver, (Integer)args[offset]);
            }
            case 27: {
                return lib.statvfs(receiver, args[offset]);
            }
            case 28: {
                return lib.fstatvfs(receiver, (Integer)args[offset]);
            }
            case 29: {
                return lib.uname(receiver);
            }
            case 30: {
                lib.unlinkat(receiver, (Integer)args[offset], args[offset + 1], (Boolean)args[offset + 2]);
                return null;
            }
            case 31: {
                lib.linkat(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], args[offset + 3], (Integer)args[offset + 4]);
                return null;
            }
            case 32: {
                lib.symlinkat(receiver, args[offset], (Integer)args[offset + 1], args[offset + 2]);
                return null;
            }
            case 33: {
                lib.mkdirat(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2]);
                return null;
            }
            case 34: {
                return lib.getcwd(receiver);
            }
            case 35: {
                lib.chdir(receiver, args[offset]);
                return null;
            }
            case 36: {
                lib.fchdir(receiver, (Integer)args[offset]);
                return null;
            }
            case 37: {
                return lib.isatty(receiver, (Integer)args[offset]);
            }
            case 38: {
                return lib.opendir(receiver, args[offset]);
            }
            case 39: {
                return lib.fdopendir(receiver, (Integer)args[offset]);
            }
            case 40: {
                lib.closedir(receiver, args[offset]);
                return null;
            }
            case 41: {
                return lib.readdir(receiver, args[offset]);
            }
            case 42: {
                lib.rewinddir(receiver, args[offset]);
                return null;
            }
            case 43: {
                return lib.dirEntryGetName(receiver, args[offset]);
            }
            case 44: {
                return lib.dirEntryGetPath(receiver, args[offset], args[offset + 1]);
            }
            case 45: {
                return lib.dirEntryGetInode(receiver, args[offset]);
            }
            case 46: {
                return lib.dirEntryGetType(receiver, args[offset]);
            }
            case 47: {
                lib.utimensat(receiver, (Integer)args[offset], args[offset + 1], (long[])args[offset + 2], (Boolean)args[offset + 3]);
                return null;
            }
            case 48: {
                lib.futimens(receiver, (Integer)args[offset], (long[])args[offset + 1]);
                return null;
            }
            case 49: {
                lib.futimes(receiver, (Integer)args[offset], (PosixSupportLibrary.Timeval[])args[offset + 1]);
                return null;
            }
            case 50: {
                lib.lutimes(receiver, args[offset], (PosixSupportLibrary.Timeval[])args[offset + 1]);
                return null;
            }
            case 51: {
                lib.utimes(receiver, args[offset], (PosixSupportLibrary.Timeval[])args[offset + 1]);
                return null;
            }
            case 52: {
                lib.renameat(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], args[offset + 3]);
                return null;
            }
            case 53: {
                return lib.faccessat(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], (Boolean)args[offset + 3], (Boolean)args[offset + 4]);
            }
            case 54: {
                lib.fchmodat(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], (Boolean)args[offset + 3]);
                return null;
            }
            case 55: {
                lib.fchmod(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 56: {
                lib.fchownat(receiver, (Integer)args[offset], args[offset + 1], (Long)args[offset + 2], (Long)args[offset + 3], (Boolean)args[offset + 4]);
                return null;
            }
            case 57: {
                lib.fchown(receiver, (Integer)args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
                return null;
            }
            case 58: {
                return lib.readlinkat(receiver, (Integer)args[offset], args[offset + 1]);
            }
            case 59: {
                lib.kill(receiver, (Long)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 60: {
                lib.killpg(receiver, (Long)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 61: {
                return lib.waitpid(receiver, (Long)args[offset], (Integer)args[offset + 1]);
            }
            case 62: {
                lib.abort(receiver);
                return null;
            }
            case 63: {
                return lib.wcoredump(receiver, (Integer)args[offset]);
            }
            case 64: {
                return lib.wifcontinued(receiver, (Integer)args[offset]);
            }
            case 65: {
                return lib.wifstopped(receiver, (Integer)args[offset]);
            }
            case 66: {
                return lib.wifsignaled(receiver, (Integer)args[offset]);
            }
            case 67: {
                return lib.wifexited(receiver, (Integer)args[offset]);
            }
            case 68: {
                return lib.wexitstatus(receiver, (Integer)args[offset]);
            }
            case 69: {
                return lib.wtermsig(receiver, (Integer)args[offset]);
            }
            case 70: {
                return lib.wstopsig(receiver, (Integer)args[offset]);
            }
            case 71: {
                return lib.getuid(receiver);
            }
            case 72: {
                return lib.geteuid(receiver);
            }
            case 73: {
                return lib.getgid(receiver);
            }
            case 74: {
                return lib.getegid(receiver);
            }
            case 75: {
                return lib.getppid(receiver);
            }
            case 76: {
                return lib.getpgid(receiver, (Long)args[offset]);
            }
            case 77: {
                lib.setpgid(receiver, (Long)args[offset], (Long)args[offset + 1]);
                return null;
            }
            case 78: {
                return lib.getpgrp(receiver);
            }
            case 79: {
                return lib.getsid(receiver, (Long)args[offset]);
            }
            case 80: {
                return lib.setsid(receiver);
            }
            case 81: {
                return lib.getgroups(receiver);
            }
            case 82: {
                return lib.getrusage(receiver, (Integer)args[offset]);
            }
            case 83: {
                return lib.openpty(receiver);
            }
            case 84: {
                return lib.ctermid(receiver);
            }
            case 85: {
                lib.setenv(receiver, args[offset], args[offset + 1], (Boolean)args[offset + 2]);
                return null;
            }
            case 86: {
                lib.unsetenv(receiver, args[offset]);
                return null;
            }
            case 87: {
                return lib.forkExec(receiver, (Object[])args[offset], (Object[])args[offset + 1], args[offset + 2], (Object[])args[offset + 3], (Integer)args[offset + 4], (Integer)args[offset + 5], (Integer)args[offset + 6], (Integer)args[offset + 7], (Integer)args[offset + 8], (Integer)args[offset + 9], (Integer)args[offset + 10], (Integer)args[offset + 11], (Boolean)args[offset + 12], (Boolean)args[offset + 13], (Boolean)args[offset + 14], (int[])args[offset + 15]);
            }
            case 88: {
                lib.execv(receiver, args[offset], (Object[])args[offset + 1]);
                return null;
            }
            case 89: {
                return lib.system(receiver, args[offset]);
            }
            case 90: {
                return lib.mmap(receiver, (Long)args[offset], (Integer)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Long)args[offset + 4]);
            }
            case 91: {
                return lib.mmapReadByte(receiver, args[offset], (Long)args[offset + 1]);
            }
            case 92: {
                lib.mmapWriteByte(receiver, args[offset], (Long)args[offset + 1], (Byte)args[offset + 2]);
                return null;
            }
            case 93: {
                return lib.mmapReadBytes(receiver, args[offset], (Long)args[offset + 1], (byte[])args[offset + 2], (Integer)args[offset + 3]);
            }
            case 94: {
                lib.mmapWriteBytes(receiver, args[offset], (Long)args[offset + 1], (byte[])args[offset + 2], (Integer)args[offset + 3]);
                return null;
            }
            case 95: {
                lib.mmapFlush(receiver, args[offset], (Long)args[offset + 1], (Long)args[offset + 2]);
                return null;
            }
            case 96: {
                lib.mmapUnmap(receiver, args[offset], (Long)args[offset + 1]);
                return null;
            }
            case 97: {
                return lib.mmapGetPointer(receiver, args[offset]);
            }
            case 98: {
                return lib.semOpen(receiver, args[offset], (Integer)args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
            }
            case 99: {
                lib.semClose(receiver, (Long)args[offset]);
                return null;
            }
            case 100: {
                lib.semUnlink(receiver, args[offset]);
                return null;
            }
            case 101: {
                return lib.semGetValue(receiver, (Long)args[offset]);
            }
            case 102: {
                lib.semPost(receiver, (Long)args[offset]);
                return null;
            }
            case 103: {
                lib.semWait(receiver, (Long)args[offset]);
                return null;
            }
            case 104: {
                return lib.semTryWait(receiver, (Long)args[offset]);
            }
            case 105: {
                return lib.semTimedWait(receiver, (Long)args[offset], (Long)args[offset + 1]);
            }
            case 106: {
                return lib.getpwuid(receiver, (Long)args[offset]);
            }
            case 107: {
                return lib.getpwnam(receiver, args[offset]);
            }
            case 108: {
                return lib.hasGetpwentries(receiver);
            }
            case 109: {
                return lib.getpwentries(receiver);
            }
            case 110: {
                return lib.createPathFromString(receiver, (TruffleString)args[offset]);
            }
            case 111: {
                return lib.createPathFromBytes(receiver, (byte[])args[offset]);
            }
            case 112: {
                return lib.getPathAsString(receiver, args[offset]);
            }
            case 113: {
                return lib.getPathAsBytes(receiver, args[offset]);
            }
            case 114: {
                return lib.socket(receiver, (Integer)args[offset], (Integer)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 115: {
                return lib.accept(receiver, (Integer)args[offset]);
            }
            case 116: {
                lib.bind(receiver, (Integer)args[offset], (PosixSupportLibrary.UniversalSockAddr)args[offset + 1]);
                return null;
            }
            case 117: {
                lib.connect(receiver, (Integer)args[offset], (PosixSupportLibrary.UniversalSockAddr)args[offset + 1]);
                return null;
            }
            case 118: {
                lib.listen(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 119: {
                return lib.getpeername(receiver, (Integer)args[offset]);
            }
            case 120: {
                return lib.getsockname(receiver, (Integer)args[offset]);
            }
            case 121: {
                return lib.send(receiver, (Integer)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Integer)args[offset + 4]);
            }
            case 122: {
                return lib.sendto(receiver, (Integer)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Integer)args[offset + 4], (PosixSupportLibrary.UniversalSockAddr)args[offset + 5]);
            }
            case 123: {
                return lib.recv(receiver, (Integer)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Integer)args[offset + 4]);
            }
            case 124: {
                return lib.recvfrom(receiver, (Integer)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Integer)args[offset + 4]);
            }
            case 125: {
                lib.shutdown(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 126: {
                return lib.getsockopt(receiver, (Integer)args[offset], (Integer)args[offset + 1], (Integer)args[offset + 2], (byte[])args[offset + 3], (Integer)args[offset + 4]);
            }
            case 127: {
                lib.setsockopt(receiver, (Integer)args[offset], (Integer)args[offset + 1], (Integer)args[offset + 2], (byte[])args[offset + 3], (Integer)args[offset + 4]);
                return null;
            }
            case 128: {
                return lib.inet_addr(receiver, args[offset]);
            }
            case 129: {
                return lib.inet_aton(receiver, args[offset]);
            }
            case 130: {
                return lib.inet_ntoa(receiver, (Integer)args[offset]);
            }
            case 131: {
                return lib.inet_pton(receiver, (Integer)args[offset], args[offset + 1]);
            }
            case 132: {
                return lib.inet_ntop(receiver, (Integer)args[offset], (byte[])args[offset + 1]);
            }
            case 133: {
                return lib.gethostname(receiver);
            }
            case 134: {
                return lib.getnameinfo(receiver, (PosixSupportLibrary.UniversalSockAddr)args[offset], (Integer)args[offset + 1]);
            }
            case 135: {
                return lib.getaddrinfo(receiver, args[offset], args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (Integer)args[offset + 4], (Integer)args[offset + 5]);
            }
            case 136: {
                return lib.crypt(receiver, (TruffleString)args[offset], (TruffleString)args[offset + 1]);
            }
            case 137: {
                return lib.ioctlBytes(receiver, (Integer)args[offset], (Long)args[offset + 1], (byte[])args[offset + 2]);
            }
            case 138: {
                return lib.ioctlInt(receiver, (Integer)args[offset], (Long)args[offset + 1], (Integer)args[offset + 2]);
            }
            case 139: {
                return lib.createUniversalSockAddrInet4(receiver, (PosixSupportLibrary.Inet4SockAddr)args[offset]);
            }
            case 140: {
                return lib.createUniversalSockAddrInet6(receiver, (PosixSupportLibrary.Inet6SockAddr)args[offset]);
            }
            case 141: {
                return lib.createUniversalSockAddrUnix(receiver, (PosixSupportLibrary.UnixSockAddr)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected PosixSupportLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected PosixSupportLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<PosixSupportLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.graal.python.runtime.PosixSupportLibrary", false, PosixSupportLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static final class Proxy
    extends PosixSupportLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public TruffleString getBackend(Object receiver_) {
            try {
                return (TruffleString)this.lib.send(receiver_, GET_BACKEND, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public TruffleString strerror(Object receiver_, int errorCode) {
            try {
                return (TruffleString)this.lib.send(receiver_, STRERROR, new Object[]{errorCode});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getpid(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETPID, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int umask(Object receiver_, int mask) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, UMASK, new Object[]{mask});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int openat(Object receiver_, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, OPENAT, new Object[]{dirFd, pathname, flags, mode});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int close(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, CLOSE, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.Buffer read(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.Buffer)this.lib.send(receiver_, READ, new Object[]{fd, length});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long write(Object receiver_, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, WRITE, new Object[]{fd, data});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int dup(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, DUP, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int dup2(Object receiver_, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, DUP2, new Object[]{fd, fd2, inheritable});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean getInheritable(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (Boolean)this.lib.send(receiver_, GET_INHERITABLE, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void setInheritable(Object receiver_, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SET_INHERITABLE, new Object[]{fd, inheritable});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int[] pipe(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (int[])this.lib.send(receiver_, PIPE, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.SelectResult select(Object receiver_, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.SelectResult)this.lib.send(receiver_, SELECT, new Object[]{readfds, writefds, errorfds, timeout});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean poll(Object receiver_, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            try {
                return (Boolean)this.lib.send(receiver_, POLL, new Object[]{fd, forWriting, timeout});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long lseek(Object receiver_, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, LSEEK, new Object[]{fd, offset, how});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void ftruncate(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FTRUNCATE, new Object[]{fd, length});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void truncate(Object receiver_, Object path, long length) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, TRUNCATE, new Object[]{path, length});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fsync(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FSYNC, new Object[]{fd});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void flock(Object receiver_, int fd, int operation) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FLOCK, new Object[]{fd, operation});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fcntlLock(Object receiver_, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FCNTL_LOCK, new Object[]{fd, blocking, lockType, whence, start, length});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean getBlocking(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (Boolean)this.lib.send(receiver_, GET_BLOCKING, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void setBlocking(Object receiver_, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SET_BLOCKING, new Object[]{fd, blocking});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int[] getTerminalSize(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (int[])this.lib.send(receiver_, GET_TERMINAL_SIZE, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long sysconf(Object receiver_, int name) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, SYSCONF, new Object[]{name});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long[] fstatat(Object receiver_, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            try {
                return (long[])this.lib.send(receiver_, FSTATAT, new Object[]{dirFd, pathname, followSymlinks});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long[] fstat(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (long[])this.lib.send(receiver_, FSTAT, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long[] statvfs(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            try {
                return (long[])this.lib.send(receiver_, STATVFS, new Object[]{path});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long[] fstatvfs(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return (long[])this.lib.send(receiver_, FSTATVFS, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object[] uname(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (Object[])this.lib.send(receiver_, UNAME, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void unlinkat(Object receiver_, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, UNLINKAT, new Object[]{dirFd, pathname, rmdir});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void linkat(Object receiver_, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, LINKAT, new Object[]{oldFdDir, oldPath, newFdDir, newPath, flags});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void symlinkat(Object receiver_, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SYMLINKAT, new Object[]{target, linkpathDirFd, linkpath});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void mkdirat(Object receiver_, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, MKDIRAT, new Object[]{dirFd, pathname, mode});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getcwd(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, GETCWD, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void chdir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, CHDIR, new Object[]{path});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fchdir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FCHDIR, new Object[]{fd});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isatty(Object receiver_, int fd) {
            try {
                return (Boolean)this.lib.send(receiver_, ISATTY, new Object[]{fd});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object opendir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, OPENDIR, new Object[]{path});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object fdopendir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, FDOPENDIR, new Object[]{fd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void closedir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, CLOSEDIR, new Object[]{dirStream});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object readdir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, READDIR, new Object[]{dirStream});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void rewinddir(Object receiver_, Object dirStream) {
            try {
                this.lib.send(receiver_, REWINDDIR, new Object[]{dirStream});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object dirEntryGetName(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, DIR_ENTRY_GET_NAME, new Object[]{dirEntry});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object dirEntryGetPath(Object receiver_, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, DIR_ENTRY_GET_PATH, new Object[]{dirEntry, scandirPath});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long dirEntryGetInode(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, DIR_ENTRY_GET_INODE, new Object[]{dirEntry});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int dirEntryGetType(Object receiver_, Object dirEntry) {
            try {
                return (Integer)this.lib.send(receiver_, DIR_ENTRY_GET_TYPE, new Object[]{dirEntry});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void utimensat(Object receiver_, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, UTIMENSAT, new Object[]{dirFd, pathname, timespec, followSymlinks});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void futimens(Object receiver_, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FUTIMENS, new Object[]{fd, timespec});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void futimes(Object receiver_, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FUTIMES, new Object[]{fd, timeval});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void lutimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, LUTIMES, new Object[]{filename, timeval});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void utimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, UTIMES, new Object[]{filename, timeval});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void renameat(Object receiver_, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, RENAMEAT, new Object[]{oldDirFd, oldPath, newDirFd, newPath});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean faccessat(Object receiver_, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
            try {
                return (Boolean)this.lib.send(receiver_, FACCESSAT, new Object[]{dirFd, path, mode, effectiveIds, followSymlinks});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fchmodat(Object receiver_, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FCHMODAT, new Object[]{dirFd, path, mode, followSymlinks});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fchmod(Object receiver_, int fd, int mode) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FCHMOD, new Object[]{fd, mode});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fchownat(Object receiver_, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FCHOWNAT, new Object[]{dirFd, pathname, owner, group, followSymlinks});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fchown(Object receiver_, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, FCHOWN, new Object[]{fd, owner, group});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object readlinkat(Object receiver_, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, READLINKAT, new Object[]{dirFd, path});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void kill(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, KILL, new Object[]{pid, signal});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void killpg(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, KILLPG, new Object[]{pid, signal});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long[] waitpid(Object receiver_, long pid, int options) throws PosixSupportLibrary.PosixException {
            try {
                return (long[])this.lib.send(receiver_, WAITPID, new Object[]{pid, options});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void abort(Object receiver_) {
            try {
                this.lib.send(receiver_, ABORT, new Object[0]);
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean wcoredump(Object receiver_, int status) {
            try {
                return (Boolean)this.lib.send(receiver_, WCOREDUMP, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean wifcontinued(Object receiver_, int status) {
            try {
                return (Boolean)this.lib.send(receiver_, WIFCONTINUED, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean wifstopped(Object receiver_, int status) {
            try {
                return (Boolean)this.lib.send(receiver_, WIFSTOPPED, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean wifsignaled(Object receiver_, int status) {
            try {
                return (Boolean)this.lib.send(receiver_, WIFSIGNALED, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean wifexited(Object receiver_, int status) {
            try {
                return (Boolean)this.lib.send(receiver_, WIFEXITED, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int wexitstatus(Object receiver_, int status) {
            try {
                return (Integer)this.lib.send(receiver_, WEXITSTATUS, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int wtermsig(Object receiver_, int status) {
            try {
                return (Integer)this.lib.send(receiver_, WTERMSIG, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int wstopsig(Object receiver_, int status) {
            try {
                return (Integer)this.lib.send(receiver_, WSTOPSIG, new Object[]{status});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getuid(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETUID, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long geteuid(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETEUID, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getgid(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETGID, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getegid(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETEGID, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getppid(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETPPID, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getpgid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, GETPGID, new Object[]{pid});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void setpgid(Object receiver_, long pid, long pgid) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SETPGID, new Object[]{pid, pgid});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getpgrp(Object receiver_) {
            try {
                return (Long)this.lib.send(receiver_, GETPGRP, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long getsid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, GETSID, new Object[]{pid});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long setsid(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, SETSID, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long[] getgroups(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (long[])this.lib.send(receiver_, GETGROUPS, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.RusageResult getrusage(Object receiver_, int who) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.RusageResult)this.lib.send(receiver_, GETRUSAGE, new Object[]{who});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.OpenPtyResult openpty(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.OpenPtyResult)this.lib.send(receiver_, OPENPTY, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public TruffleString ctermid(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (TruffleString)this.lib.send(receiver_, CTERMID, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void setenv(Object receiver_, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SETENV, new Object[]{name, value, overwrite});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void unsetenv(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, UNSETENV, new Object[]{name});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int forkExec(Object receiver_, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, FORK_EXEC, new Object[]{executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void execv(Object receiver_, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, EXECV, new Object[]{pathname, args});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int system(Object receiver_, Object command) {
            try {
                return (Integer)this.lib.send(receiver_, SYSTEM, new Object[]{command});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object mmap(Object receiver_, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, MMAP, new Object[]{length, prot, flags, fd, offset});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public byte mmapReadByte(Object receiver_, Object mmap, long index) throws PosixSupportLibrary.PosixException {
            try {
                return (Byte)this.lib.send(receiver_, MMAP_READ_BYTE, new Object[]{mmap, index});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void mmapWriteByte(Object receiver_, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, MMAP_WRITE_BYTE, new Object[]{mmap, index, value});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int mmapReadBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, MMAP_READ_BYTES, new Object[]{mmap, index, bytes, length});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void mmapWriteBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, MMAP_WRITE_BYTES, new Object[]{mmap, index, bytes, length});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void mmapFlush(Object receiver_, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, MMAP_FLUSH, new Object[]{mmap, offset, length});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void mmapUnmap(Object receiver_, Object mmap, long length) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, MMAP_UNMAP, new Object[]{mmap, length});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long mmapGetPointer(Object receiver_, Object mmap) {
            try {
                return (Long)this.lib.send(receiver_, MMAP_GET_POINTER, new Object[]{mmap});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long semOpen(Object receiver_, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
            try {
                return (Long)this.lib.send(receiver_, SEM_OPEN, new Object[]{name, openFlags, mode, value});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void semClose(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SEM_CLOSE, new Object[]{handle});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void semUnlink(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SEM_UNLINK, new Object[]{name});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int semGetValue(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, SEM_GET_VALUE, new Object[]{handle});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void semPost(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SEM_POST, new Object[]{handle});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void semWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SEM_WAIT, new Object[]{handle});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean semTryWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            try {
                return (Boolean)this.lib.send(receiver_, SEM_TRY_WAIT, new Object[]{handle});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean semTimedWait(Object receiver_, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
            try {
                return (Boolean)this.lib.send(receiver_, SEM_TIMED_WAIT, new Object[]{handle, deadlineNs});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.PwdResult getpwuid(Object receiver_, long uid) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.PwdResult)this.lib.send(receiver_, GETPWUID, new Object[]{uid});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.PwdResult getpwnam(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.PwdResult)this.lib.send(receiver_, GETPWNAM, new Object[]{name});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean hasGetpwentries(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, HAS_GETPWENTRIES, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.PwdResult[])this.lib.send(receiver_, GETPWENTRIES, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object createPathFromString(Object receiver_, TruffleString path) {
            try {
                return this.lib.send(receiver_, CREATE_PATH_FROM_STRING, new Object[]{path});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object createPathFromBytes(Object receiver_, byte[] path) {
            try {
                return this.lib.send(receiver_, CREATE_PATH_FROM_BYTES, new Object[]{path});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public TruffleString getPathAsString(Object receiver_, Object path) {
            try {
                return (TruffleString)this.lib.send(receiver_, GET_PATH_AS_STRING, new Object[]{path});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver_, Object path) {
            try {
                return (PosixSupportLibrary.Buffer)this.lib.send(receiver_, GET_PATH_AS_BYTES, new Object[]{path});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int socket(Object receiver_, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, SOCKET, new Object[]{domain, type, protocol});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.AcceptResult accept(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.AcceptResult)this.lib.send(receiver_, ACCEPT, new Object[]{sockfd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void bind(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, BIND, new Object[]{sockfd, addr});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void connect(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, CONNECT, new Object[]{sockfd, addr});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void listen(Object receiver_, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, LISTEN, new Object[]{sockfd, backlog});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.UniversalSockAddr)this.lib.send(receiver_, GETPEERNAME, new Object[]{sockfd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.UniversalSockAddr)this.lib.send(receiver_, GETSOCKNAME, new Object[]{sockfd});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int send(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, SEND, new Object[]{sockfd, buf, offset, len, flags});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int sendto(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, SENDTO, new Object[]{sockfd, buf, offset, len, flags, destAddr});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int recv(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, RECV, new Object[]{sockfd, buf, offset, len, flags});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            try {
                return (PosixSupportLibrary.RecvfromResult)this.lib.send(receiver_, RECVFROM, new Object[]{sockfd, buf, offset, len, flags});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void shutdown(Object receiver_, int sockfd, int how) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SHUTDOWN, new Object[]{sockfd, how});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int getsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, GETSOCKOPT, new Object[]{sockfd, level, optname, optval, optlen});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void setsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            try {
                this.lib.send(receiver_, SETSOCKOPT, new Object[]{sockfd, level, optname, optval, optlen});
                return;
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int inet_addr(Object receiver_, Object src) {
            try {
                return (Integer)this.lib.send(receiver_, INET_ADDR, new Object[]{src});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int inet_aton(Object receiver_, Object src) throws PosixSupportLibrary.InvalidAddressException {
            try {
                return (Integer)this.lib.send(receiver_, INET_ATON, new Object[]{src});
            }
            catch (PosixSupportLibrary.InvalidAddressException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object inet_ntoa(Object receiver_, int address) {
            try {
                return this.lib.send(receiver_, INET_NTOA, new Object[]{address});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public byte[] inet_pton(Object receiver_, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
            try {
                return (byte[])this.lib.send(receiver_, INET_PTON, new Object[]{family, src});
            }
            catch (PosixSupportLibrary.InvalidAddressException | PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object inet_ntop(Object receiver_, int family, byte[] src) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, INET_NTOP, new Object[]{family, src});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object gethostname(Object receiver_) throws PosixSupportLibrary.PosixException {
            try {
                return this.lib.send(receiver_, GETHOSTNAME, new Object[0]);
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object[] getnameinfo(Object receiver_, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            try {
                return (Object[])this.lib.send(receiver_, GETNAMEINFO, new Object[]{addr, flags});
            }
            catch (PosixSupportLibrary.GetAddrInfoException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver_, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            try {
                return (PosixSupportLibrary.AddrInfoCursor)this.lib.send(receiver_, GETADDRINFO, new Object[]{node, service, family, sockType, protocol, flags});
            }
            catch (PosixSupportLibrary.GetAddrInfoException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public TruffleString crypt(Object receiver_, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
            try {
                return (TruffleString)this.lib.send(receiver_, CRYPT, new Object[]{word, salt});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int ioctlBytes(Object receiver_, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, IOCTL_BYTES, new Object[]{fd, request, arg});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int ioctlInt(Object receiver_, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
            try {
                return (Integer)this.lib.send(receiver_, IOCTL_INT, new Object[]{fd, request, arg});
            }
            catch (PosixSupportLibrary.PosixException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver_, PosixSupportLibrary.Inet4SockAddr src) {
            try {
                return (PosixSupportLibrary.UniversalSockAddr)this.lib.send(receiver_, CREATE_UNIVERSAL_SOCK_ADDR_INET4, new Object[]{src});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver_, PosixSupportLibrary.Inet6SockAddr src) {
            try {
                return (PosixSupportLibrary.UniversalSockAddr)this.lib.send(receiver_, CREATE_UNIVERSAL_SOCK_ADDR_INET6, new Object[]{src});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver_, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
            try {
                return (PosixSupportLibrary.UniversalSockAddr)this.lib.send(receiver_, CREATE_UNIVERSAL_SOCK_ADDR_UNIX, new Object[]{src});
            }
            catch (PosixSupportLibrary.InvalidUnixSocketPathException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static final class Delegate
    extends PosixSupportLibrary {
        @Node.Child
        private PosixSupportLibrary delegateLibrary;

        Delegate(PosixSupportLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public TruffleString getBackend(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getBackend(delegate);
            }
            return this.delegateLibrary.getBackend(receiver_);
        }

        @Override
        public TruffleString strerror(Object receiver_, int errorCode) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).strerror(delegate, errorCode);
            }
            return this.delegateLibrary.strerror(receiver_, errorCode);
        }

        @Override
        public long getpid(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpid(delegate);
            }
            return this.delegateLibrary.getpid(receiver_);
        }

        @Override
        public int umask(Object receiver_, int mask) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).umask(delegate, mask);
            }
            return this.delegateLibrary.umask(receiver_, mask);
        }

        @Override
        public int openat(Object receiver_, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).openat(delegate, dirFd, pathname, flags, mode);
            }
            return this.delegateLibrary.openat(receiver_, dirFd, pathname, flags, mode);
        }

        @Override
        public int close(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).close(delegate, fd);
            }
            return this.delegateLibrary.close(receiver_, fd);
        }

        @Override
        public PosixSupportLibrary.Buffer read(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)6)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).read(delegate, fd, length);
            }
            return this.delegateLibrary.read(receiver_, fd, length);
        }

        @Override
        public long write(Object receiver_, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)7)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).write(delegate, fd, data);
            }
            return this.delegateLibrary.write(receiver_, fd, data);
        }

        @Override
        public int dup(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)8)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).dup(delegate, fd);
            }
            return this.delegateLibrary.dup(receiver_, fd);
        }

        @Override
        public int dup2(Object receiver_, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)9)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).dup2(delegate, fd, fd2, inheritable);
            }
            return this.delegateLibrary.dup2(receiver_, fd, fd2, inheritable);
        }

        @Override
        public boolean getInheritable(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)10)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getInheritable(delegate, fd);
            }
            return this.delegateLibrary.getInheritable(receiver_, fd);
        }

        @Override
        public void setInheritable(Object receiver_, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)11)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setInheritable(delegate, fd, inheritable);
                return;
            }
            this.delegateLibrary.setInheritable(receiver_, fd, inheritable);
        }

        @Override
        public int[] pipe(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)12)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).pipe(delegate);
            }
            return this.delegateLibrary.pipe(receiver_);
        }

        @Override
        public PosixSupportLibrary.SelectResult select(Object receiver_, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)13)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).select(delegate, readfds, writefds, errorfds, timeout);
            }
            return this.delegateLibrary.select(receiver_, readfds, writefds, errorfds, timeout);
        }

        @Override
        public boolean poll(Object receiver_, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)14)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).poll(delegate, fd, forWriting, timeout);
            }
            return this.delegateLibrary.poll(receiver_, fd, forWriting, timeout);
        }

        @Override
        public long lseek(Object receiver_, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)15)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).lseek(delegate, fd, offset, how);
            }
            return this.delegateLibrary.lseek(receiver_, fd, offset, how);
        }

        @Override
        public void ftruncate(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)16)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).ftruncate(delegate, fd, length);
                return;
            }
            this.delegateLibrary.ftruncate(receiver_, fd, length);
        }

        @Override
        public void truncate(Object receiver_, Object path, long length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)17)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).truncate(delegate, path, length);
                return;
            }
            this.delegateLibrary.truncate(receiver_, path, length);
        }

        @Override
        public void fsync(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)18)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fsync(delegate, fd);
                return;
            }
            this.delegateLibrary.fsync(receiver_, fd);
        }

        @Override
        public void flock(Object receiver_, int fd, int operation) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)19)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).flock(delegate, fd, operation);
                return;
            }
            this.delegateLibrary.flock(receiver_, fd, operation);
        }

        @Override
        public void fcntlLock(Object receiver_, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)20)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fcntlLock(delegate, fd, blocking, lockType, whence, start, length);
                return;
            }
            this.delegateLibrary.fcntlLock(receiver_, fd, blocking, lockType, whence, start, length);
        }

        @Override
        public boolean getBlocking(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)21)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getBlocking(delegate, fd);
            }
            return this.delegateLibrary.getBlocking(receiver_, fd);
        }

        @Override
        public void setBlocking(Object receiver_, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)22)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setBlocking(delegate, fd, blocking);
                return;
            }
            this.delegateLibrary.setBlocking(receiver_, fd, blocking);
        }

        @Override
        public int[] getTerminalSize(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)23)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getTerminalSize(delegate, fd);
            }
            return this.delegateLibrary.getTerminalSize(receiver_, fd);
        }

        @Override
        public long sysconf(Object receiver_, int name) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)24)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).sysconf(delegate, name);
            }
            return this.delegateLibrary.sysconf(receiver_, name);
        }

        @Override
        public long[] fstatat(Object receiver_, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)25)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fstatat(delegate, dirFd, pathname, followSymlinks);
            }
            return this.delegateLibrary.fstatat(receiver_, dirFd, pathname, followSymlinks);
        }

        @Override
        public long[] fstat(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)26)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fstat(delegate, fd);
            }
            return this.delegateLibrary.fstat(receiver_, fd);
        }

        @Override
        public long[] statvfs(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)27)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).statvfs(delegate, path);
            }
            return this.delegateLibrary.statvfs(receiver_, path);
        }

        @Override
        public long[] fstatvfs(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)28)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fstatvfs(delegate, fd);
            }
            return this.delegateLibrary.fstatvfs(receiver_, fd);
        }

        @Override
        public Object[] uname(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)29)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).uname(delegate);
            }
            return this.delegateLibrary.uname(receiver_);
        }

        @Override
        public void unlinkat(Object receiver_, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)30)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).unlinkat(delegate, dirFd, pathname, rmdir);
                return;
            }
            this.delegateLibrary.unlinkat(receiver_, dirFd, pathname, rmdir);
        }

        @Override
        public void linkat(Object receiver_, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)31)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).linkat(delegate, oldFdDir, oldPath, newFdDir, newPath, flags);
                return;
            }
            this.delegateLibrary.linkat(receiver_, oldFdDir, oldPath, newFdDir, newPath, flags);
        }

        @Override
        public void symlinkat(Object receiver_, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)32)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).symlinkat(delegate, target, linkpathDirFd, linkpath);
                return;
            }
            this.delegateLibrary.symlinkat(receiver_, target, linkpathDirFd, linkpath);
        }

        @Override
        public void mkdirat(Object receiver_, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)33)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mkdirat(delegate, dirFd, pathname, mode);
                return;
            }
            this.delegateLibrary.mkdirat(receiver_, dirFd, pathname, mode);
        }

        @Override
        public Object getcwd(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)34)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getcwd(delegate);
            }
            return this.delegateLibrary.getcwd(receiver_);
        }

        @Override
        public void chdir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)35)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).chdir(delegate, path);
                return;
            }
            this.delegateLibrary.chdir(receiver_, path);
        }

        @Override
        public void fchdir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)36)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fchdir(delegate, fd);
                return;
            }
            this.delegateLibrary.fchdir(receiver_, fd);
        }

        @Override
        public boolean isatty(Object receiver_, int fd) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)37)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isatty(delegate, fd);
            }
            return this.delegateLibrary.isatty(receiver_, fd);
        }

        @Override
        public Object opendir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)38)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).opendir(delegate, path);
            }
            return this.delegateLibrary.opendir(receiver_, path);
        }

        @Override
        public Object fdopendir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)39)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fdopendir(delegate, fd);
            }
            return this.delegateLibrary.fdopendir(receiver_, fd);
        }

        @Override
        public void closedir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)40)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).closedir(delegate, dirStream);
                return;
            }
            this.delegateLibrary.closedir(receiver_, dirStream);
        }

        @Override
        public Object readdir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)41)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readdir(delegate, dirStream);
            }
            return this.delegateLibrary.readdir(receiver_, dirStream);
        }

        @Override
        public void rewinddir(Object receiver_, Object dirStream) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)42)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).rewinddir(delegate, dirStream);
                return;
            }
            this.delegateLibrary.rewinddir(receiver_, dirStream);
        }

        @Override
        public Object dirEntryGetName(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)43)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).dirEntryGetName(delegate, dirEntry);
            }
            return this.delegateLibrary.dirEntryGetName(receiver_, dirEntry);
        }

        @Override
        public Object dirEntryGetPath(Object receiver_, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)44)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).dirEntryGetPath(delegate, dirEntry, scandirPath);
            }
            return this.delegateLibrary.dirEntryGetPath(receiver_, dirEntry, scandirPath);
        }

        @Override
        public long dirEntryGetInode(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)45)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).dirEntryGetInode(delegate, dirEntry);
            }
            return this.delegateLibrary.dirEntryGetInode(receiver_, dirEntry);
        }

        @Override
        public int dirEntryGetType(Object receiver_, Object dirEntry) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)46)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).dirEntryGetType(delegate, dirEntry);
            }
            return this.delegateLibrary.dirEntryGetType(receiver_, dirEntry);
        }

        @Override
        public void utimensat(Object receiver_, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)47)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).utimensat(delegate, dirFd, pathname, timespec, followSymlinks);
                return;
            }
            this.delegateLibrary.utimensat(receiver_, dirFd, pathname, timespec, followSymlinks);
        }

        @Override
        public void futimens(Object receiver_, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)48)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).futimens(delegate, fd, timespec);
                return;
            }
            this.delegateLibrary.futimens(receiver_, fd, timespec);
        }

        @Override
        public void futimes(Object receiver_, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)49)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).futimes(delegate, fd, timeval);
                return;
            }
            this.delegateLibrary.futimes(receiver_, fd, timeval);
        }

        @Override
        public void lutimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)50)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).lutimes(delegate, filename, timeval);
                return;
            }
            this.delegateLibrary.lutimes(receiver_, filename, timeval);
        }

        @Override
        public void utimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)51)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).utimes(delegate, filename, timeval);
                return;
            }
            this.delegateLibrary.utimes(receiver_, filename, timeval);
        }

        @Override
        public void renameat(Object receiver_, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)52)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).renameat(delegate, oldDirFd, oldPath, newDirFd, newPath);
                return;
            }
            this.delegateLibrary.renameat(receiver_, oldDirFd, oldPath, newDirFd, newPath);
        }

        @Override
        public boolean faccessat(Object receiver_, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)53)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).faccessat(delegate, dirFd, path, mode, effectiveIds, followSymlinks);
            }
            return this.delegateLibrary.faccessat(receiver_, dirFd, path, mode, effectiveIds, followSymlinks);
        }

        @Override
        public void fchmodat(Object receiver_, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)54)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fchmodat(delegate, dirFd, path, mode, followSymlinks);
                return;
            }
            this.delegateLibrary.fchmodat(receiver_, dirFd, path, mode, followSymlinks);
        }

        @Override
        public void fchmod(Object receiver_, int fd, int mode) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)55)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fchmod(delegate, fd, mode);
                return;
            }
            this.delegateLibrary.fchmod(receiver_, fd, mode);
        }

        @Override
        public void fchownat(Object receiver_, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)56)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fchownat(delegate, dirFd, pathname, owner, group, followSymlinks);
                return;
            }
            this.delegateLibrary.fchownat(receiver_, dirFd, pathname, owner, group, followSymlinks);
        }

        @Override
        public void fchown(Object receiver_, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)57)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fchown(delegate, fd, owner, group);
                return;
            }
            this.delegateLibrary.fchown(receiver_, fd, owner, group);
        }

        @Override
        public Object readlinkat(Object receiver_, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)58)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readlinkat(delegate, dirFd, path);
            }
            return this.delegateLibrary.readlinkat(receiver_, dirFd, path);
        }

        @Override
        public void kill(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)59)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).kill(delegate, pid, signal);
                return;
            }
            this.delegateLibrary.kill(receiver_, pid, signal);
        }

        @Override
        public void killpg(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)60)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).killpg(delegate, pid, signal);
                return;
            }
            this.delegateLibrary.killpg(receiver_, pid, signal);
        }

        @Override
        public long[] waitpid(Object receiver_, long pid, int options) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)61)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).waitpid(delegate, pid, options);
            }
            return this.delegateLibrary.waitpid(receiver_, pid, options);
        }

        @Override
        public void abort(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)62)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).abort(delegate);
                return;
            }
            this.delegateLibrary.abort(receiver_);
        }

        @Override
        public boolean wcoredump(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)63)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wcoredump(delegate, status);
            }
            return this.delegateLibrary.wcoredump(receiver_, status);
        }

        @Override
        public boolean wifcontinued(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)64)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wifcontinued(delegate, status);
            }
            return this.delegateLibrary.wifcontinued(receiver_, status);
        }

        @Override
        public boolean wifstopped(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)65)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wifstopped(delegate, status);
            }
            return this.delegateLibrary.wifstopped(receiver_, status);
        }

        @Override
        public boolean wifsignaled(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)66)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wifsignaled(delegate, status);
            }
            return this.delegateLibrary.wifsignaled(receiver_, status);
        }

        @Override
        public boolean wifexited(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)67)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wifexited(delegate, status);
            }
            return this.delegateLibrary.wifexited(receiver_, status);
        }

        @Override
        public int wexitstatus(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)68)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wexitstatus(delegate, status);
            }
            return this.delegateLibrary.wexitstatus(receiver_, status);
        }

        @Override
        public int wtermsig(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)69)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wtermsig(delegate, status);
            }
            return this.delegateLibrary.wtermsig(receiver_, status);
        }

        @Override
        public int wstopsig(Object receiver_, int status) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)70)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).wstopsig(delegate, status);
            }
            return this.delegateLibrary.wstopsig(receiver_, status);
        }

        @Override
        public long getuid(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)71)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getuid(delegate);
            }
            return this.delegateLibrary.getuid(receiver_);
        }

        @Override
        public long geteuid(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)72)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).geteuid(delegate);
            }
            return this.delegateLibrary.geteuid(receiver_);
        }

        @Override
        public long getgid(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)73)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getgid(delegate);
            }
            return this.delegateLibrary.getgid(receiver_);
        }

        @Override
        public long getegid(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)74)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getegid(delegate);
            }
            return this.delegateLibrary.getegid(receiver_);
        }

        @Override
        public long getppid(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)75)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getppid(delegate);
            }
            return this.delegateLibrary.getppid(receiver_);
        }

        @Override
        public long getpgid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)76)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpgid(delegate, pid);
            }
            return this.delegateLibrary.getpgid(receiver_, pid);
        }

        @Override
        public void setpgid(Object receiver_, long pid, long pgid) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)77)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setpgid(delegate, pid, pgid);
                return;
            }
            this.delegateLibrary.setpgid(receiver_, pid, pgid);
        }

        @Override
        public long getpgrp(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)78)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpgrp(delegate);
            }
            return this.delegateLibrary.getpgrp(receiver_);
        }

        @Override
        public long getsid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)79)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getsid(delegate, pid);
            }
            return this.delegateLibrary.getsid(receiver_, pid);
        }

        @Override
        public long setsid(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)80)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setsid(delegate);
            }
            return this.delegateLibrary.setsid(receiver_);
        }

        @Override
        public long[] getgroups(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)81)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getgroups(delegate);
            }
            return this.delegateLibrary.getgroups(receiver_);
        }

        @Override
        public PosixSupportLibrary.RusageResult getrusage(Object receiver_, int who) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)82)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getrusage(delegate, who);
            }
            return this.delegateLibrary.getrusage(receiver_, who);
        }

        @Override
        public PosixSupportLibrary.OpenPtyResult openpty(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)83)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).openpty(delegate);
            }
            return this.delegateLibrary.openpty(receiver_);
        }

        @Override
        public TruffleString ctermid(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)84)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).ctermid(delegate);
            }
            return this.delegateLibrary.ctermid(receiver_);
        }

        @Override
        public void setenv(Object receiver_, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)85)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setenv(delegate, name, value, overwrite);
                return;
            }
            this.delegateLibrary.setenv(receiver_, name, value, overwrite);
        }

        @Override
        public void unsetenv(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)86)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).unsetenv(delegate, name);
                return;
            }
            this.delegateLibrary.unsetenv(receiver_, name);
        }

        @Override
        public int forkExec(Object receiver_, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)87)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).forkExec(delegate, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
            }
            return this.delegateLibrary.forkExec(receiver_, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
        }

        @Override
        public void execv(Object receiver_, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)88)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).execv(delegate, pathname, args);
                return;
            }
            this.delegateLibrary.execv(receiver_, pathname, args);
        }

        @Override
        public int system(Object receiver_, Object command) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)89)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).system(delegate, command);
            }
            return this.delegateLibrary.system(receiver_, command);
        }

        @Override
        public Object mmap(Object receiver_, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)90)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmap(delegate, length, prot, flags, fd, offset);
            }
            return this.delegateLibrary.mmap(receiver_, length, prot, flags, fd, offset);
        }

        @Override
        public byte mmapReadByte(Object receiver_, Object mmap, long index) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)91)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapReadByte(delegate, mmap, index);
            }
            return this.delegateLibrary.mmapReadByte(receiver_, mmap, index);
        }

        @Override
        public void mmapWriteByte(Object receiver_, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)92)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapWriteByte(delegate, mmap, index, value);
                return;
            }
            this.delegateLibrary.mmapWriteByte(receiver_, mmap, index, value);
        }

        @Override
        public int mmapReadBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)93)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapReadBytes(delegate, mmap, index, bytes, length);
            }
            return this.delegateLibrary.mmapReadBytes(receiver_, mmap, index, bytes, length);
        }

        @Override
        public void mmapWriteBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)94)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapWriteBytes(delegate, mmap, index, bytes, length);
                return;
            }
            this.delegateLibrary.mmapWriteBytes(receiver_, mmap, index, bytes, length);
        }

        @Override
        public void mmapFlush(Object receiver_, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)95)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapFlush(delegate, mmap, offset, length);
                return;
            }
            this.delegateLibrary.mmapFlush(receiver_, mmap, offset, length);
        }

        @Override
        public void mmapUnmap(Object receiver_, Object mmap, long length) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)96)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapUnmap(delegate, mmap, length);
                return;
            }
            this.delegateLibrary.mmapUnmap(receiver_, mmap, length);
        }

        @Override
        public long mmapGetPointer(Object receiver_, Object mmap) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)97)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).mmapGetPointer(delegate, mmap);
            }
            return this.delegateLibrary.mmapGetPointer(receiver_, mmap);
        }

        @Override
        public long semOpen(Object receiver_, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)98)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semOpen(delegate, name, openFlags, mode, value);
            }
            return this.delegateLibrary.semOpen(receiver_, name, openFlags, mode, value);
        }

        @Override
        public void semClose(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)99)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semClose(delegate, handle);
                return;
            }
            this.delegateLibrary.semClose(receiver_, handle);
        }

        @Override
        public void semUnlink(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)100)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semUnlink(delegate, name);
                return;
            }
            this.delegateLibrary.semUnlink(receiver_, name);
        }

        @Override
        public int semGetValue(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)101)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semGetValue(delegate, handle);
            }
            return this.delegateLibrary.semGetValue(receiver_, handle);
        }

        @Override
        public void semPost(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)102)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semPost(delegate, handle);
                return;
            }
            this.delegateLibrary.semPost(receiver_, handle);
        }

        @Override
        public void semWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)103)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semWait(delegate, handle);
                return;
            }
            this.delegateLibrary.semWait(receiver_, handle);
        }

        @Override
        public boolean semTryWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)104)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semTryWait(delegate, handle);
            }
            return this.delegateLibrary.semTryWait(receiver_, handle);
        }

        @Override
        public boolean semTimedWait(Object receiver_, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)105)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).semTimedWait(delegate, handle, deadlineNs);
            }
            return this.delegateLibrary.semTimedWait(receiver_, handle, deadlineNs);
        }

        @Override
        public PosixSupportLibrary.PwdResult getpwuid(Object receiver_, long uid) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)106)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpwuid(delegate, uid);
            }
            return this.delegateLibrary.getpwuid(receiver_, uid);
        }

        @Override
        public PosixSupportLibrary.PwdResult getpwnam(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)107)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpwnam(delegate, name);
            }
            return this.delegateLibrary.getpwnam(receiver_, name);
        }

        @Override
        public boolean hasGetpwentries(Object receiver_) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)108)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).hasGetpwentries(delegate);
            }
            return this.delegateLibrary.hasGetpwentries(receiver_);
        }

        @Override
        public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)109)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpwentries(delegate);
            }
            return this.delegateLibrary.getpwentries(receiver_);
        }

        @Override
        public Object createPathFromString(Object receiver_, TruffleString path) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)110)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createPathFromString(delegate, path);
            }
            return this.delegateLibrary.createPathFromString(receiver_, path);
        }

        @Override
        public Object createPathFromBytes(Object receiver_, byte[] path) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)111)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createPathFromBytes(delegate, path);
            }
            return this.delegateLibrary.createPathFromBytes(receiver_, path);
        }

        @Override
        public TruffleString getPathAsString(Object receiver_, Object path) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)112)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getPathAsString(delegate, path);
            }
            return this.delegateLibrary.getPathAsString(receiver_, path);
        }

        @Override
        public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver_, Object path) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)113)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getPathAsBytes(delegate, path);
            }
            return this.delegateLibrary.getPathAsBytes(receiver_, path);
        }

        @Override
        public int socket(Object receiver_, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)114)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).socket(delegate, domain, type, protocol);
            }
            return this.delegateLibrary.socket(receiver_, domain, type, protocol);
        }

        @Override
        public PosixSupportLibrary.AcceptResult accept(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)115)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).accept(delegate, sockfd);
            }
            return this.delegateLibrary.accept(receiver_, sockfd);
        }

        @Override
        public void bind(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)116)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).bind(delegate, sockfd, addr);
                return;
            }
            this.delegateLibrary.bind(receiver_, sockfd, addr);
        }

        @Override
        public void connect(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)117)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).connect(delegate, sockfd, addr);
                return;
            }
            this.delegateLibrary.connect(receiver_, sockfd, addr);
        }

        @Override
        public void listen(Object receiver_, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)118)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).listen(delegate, sockfd, backlog);
                return;
            }
            this.delegateLibrary.listen(receiver_, sockfd, backlog);
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)119)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getpeername(delegate, sockfd);
            }
            return this.delegateLibrary.getpeername(receiver_, sockfd);
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)120)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getsockname(delegate, sockfd);
            }
            return this.delegateLibrary.getsockname(receiver_, sockfd);
        }

        @Override
        public int send(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)121)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).send(delegate, sockfd, buf, offset, len, flags);
            }
            return this.delegateLibrary.send(receiver_, sockfd, buf, offset, len, flags);
        }

        @Override
        public int sendto(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)122)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).sendto(delegate, sockfd, buf, offset, len, flags, destAddr);
            }
            return this.delegateLibrary.sendto(receiver_, sockfd, buf, offset, len, flags, destAddr);
        }

        @Override
        public int recv(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)123)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).recv(delegate, sockfd, buf, offset, len, flags);
            }
            return this.delegateLibrary.recv(receiver_, sockfd, buf, offset, len, flags);
        }

        @Override
        public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)124)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).recvfrom(delegate, sockfd, buf, offset, len, flags);
            }
            return this.delegateLibrary.recvfrom(receiver_, sockfd, buf, offset, len, flags);
        }

        @Override
        public void shutdown(Object receiver_, int sockfd, int how) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)125)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).shutdown(delegate, sockfd, how);
                return;
            }
            this.delegateLibrary.shutdown(receiver_, sockfd, how);
        }

        @Override
        public int getsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)126)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getsockopt(delegate, sockfd, level, optname, optval, optlen);
            }
            return this.delegateLibrary.getsockopt(receiver_, sockfd, level, optname, optval, optlen);
        }

        @Override
        public void setsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)127)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setsockopt(delegate, sockfd, level, optname, optval, optlen);
                return;
            }
            this.delegateLibrary.setsockopt(receiver_, sockfd, level, optname, optval, optlen);
        }

        @Override
        public int inet_addr(Object receiver_, Object src) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)128)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).inet_addr(delegate, src);
            }
            return this.delegateLibrary.inet_addr(receiver_, src);
        }

        @Override
        public int inet_aton(Object receiver_, Object src) throws PosixSupportLibrary.InvalidAddressException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)129)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).inet_aton(delegate, src);
            }
            return this.delegateLibrary.inet_aton(receiver_, src);
        }

        @Override
        public Object inet_ntoa(Object receiver_, int address) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)130)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).inet_ntoa(delegate, address);
            }
            return this.delegateLibrary.inet_ntoa(receiver_, address);
        }

        @Override
        public byte[] inet_pton(Object receiver_, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)131)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).inet_pton(delegate, family, src);
            }
            return this.delegateLibrary.inet_pton(receiver_, family, src);
        }

        @Override
        public Object inet_ntop(Object receiver_, int family, byte[] src) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)132)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).inet_ntop(delegate, family, src);
            }
            return this.delegateLibrary.inet_ntop(receiver_, family, src);
        }

        @Override
        public Object gethostname(Object receiver_) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)133)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).gethostname(delegate);
            }
            return this.delegateLibrary.gethostname(receiver_);
        }

        @Override
        public Object[] getnameinfo(Object receiver_, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)134)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getnameinfo(delegate, addr, flags);
            }
            return this.delegateLibrary.getnameinfo(receiver_, addr, flags);
        }

        @Override
        public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver_, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)135)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getaddrinfo(delegate, node, service, family, sockType, protocol, flags);
            }
            return this.delegateLibrary.getaddrinfo(receiver_, node, service, family, sockType, protocol, flags);
        }

        @Override
        public TruffleString crypt(Object receiver_, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)136)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).crypt(delegate, word, salt);
            }
            return this.delegateLibrary.crypt(receiver_, word, salt);
        }

        @Override
        public int ioctlBytes(Object receiver_, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)137)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).ioctlBytes(delegate, fd, request, arg);
            }
            return this.delegateLibrary.ioctlBytes(receiver_, fd, request, arg);
        }

        @Override
        public int ioctlInt(Object receiver_, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)138)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).ioctlInt(delegate, fd, request, arg);
            }
            return this.delegateLibrary.ioctlInt(receiver_, fd, request, arg);
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver_, PosixSupportLibrary.Inet4SockAddr src) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)139)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createUniversalSockAddrInet4(delegate, src);
            }
            return this.delegateLibrary.createUniversalSockAddrInet4(receiver_, src);
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver_, PosixSupportLibrary.Inet6SockAddr src) {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)140)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createUniversalSockAddrInet6(delegate, src);
            }
            return this.delegateLibrary.createUniversalSockAddrInet6(receiver_, src);
        }

        @Override
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver_, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
            if (PosixSupportLibraryGen.isDelegated((Library)this.delegateLibrary, (int)141)) {
                Object delegate = PosixSupportLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PosixSupportLibrary)PosixSupportLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createUniversalSockAddrUnix(delegate, src);
            }
            return this.delegateLibrary.createUniversalSockAddrUnix(receiver_, src);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(PosixSupportLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static abstract class CachedDispatch
    extends PosixSupportLibrary {
        @Node.Child
        PosixSupportLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(PosixSupportLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public TruffleString getBackend(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getBackend(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public TruffleString strerror(Object receiver_, int errorCode) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.strerror(receiver_, errorCode);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getpid(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int umask(Object receiver_, int mask) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.umask(receiver_, mask);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int openat(Object receiver_, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.openat(receiver_, dirFd, pathname, flags, mode);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int close(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.close(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.Buffer read(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.read(receiver_, fd, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long write(Object receiver_, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.write(receiver_, fd, data);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int dup(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.dup(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int dup2(Object receiver_, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.dup2(receiver_, fd, fd2, inheritable);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean getInheritable(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getInheritable(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void setInheritable(Object receiver_, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.setInheritable(receiver_, fd, inheritable);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int[] pipe(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.pipe(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.SelectResult select(Object receiver_, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.select(receiver_, readfds, writefds, errorfds, timeout);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean poll(Object receiver_, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.poll(receiver_, fd, forWriting, timeout);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long lseek(Object receiver_, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.lseek(receiver_, fd, offset, how);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void ftruncate(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.ftruncate(receiver_, fd, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void truncate(Object receiver_, Object path, long length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.truncate(receiver_, path, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fsync(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fsync(receiver_, fd);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void flock(Object receiver_, int fd, int operation) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.flock(receiver_, fd, operation);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fcntlLock(Object receiver_, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fcntlLock(receiver_, fd, blocking, lockType, whence, start, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean getBlocking(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getBlocking(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void setBlocking(Object receiver_, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.setBlocking(receiver_, fd, blocking);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int[] getTerminalSize(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getTerminalSize(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long sysconf(Object receiver_, int name) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.sysconf(receiver_, name);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long[] fstatat(Object receiver_, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.fstatat(receiver_, dirFd, pathname, followSymlinks);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long[] fstat(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.fstat(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long[] statvfs(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.statvfs(receiver_, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long[] fstatvfs(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.fstatvfs(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object[] uname(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.uname(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void unlinkat(Object receiver_, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.unlinkat(receiver_, dirFd, pathname, rmdir);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void linkat(Object receiver_, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.linkat(receiver_, oldFdDir, oldPath, newFdDir, newPath, flags);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void symlinkat(Object receiver_, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.symlinkat(receiver_, target, linkpathDirFd, linkpath);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void mkdirat(Object receiver_, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.mkdirat(receiver_, dirFd, pathname, mode);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getcwd(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getcwd(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void chdir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.chdir(receiver_, path);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fchdir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fchdir(receiver_, fd);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isatty(Object receiver_, int fd) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isatty(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object opendir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.opendir(receiver_, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object fdopendir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.fdopendir(receiver_, fd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void closedir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.closedir(receiver_, dirStream);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object readdir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readdir(receiver_, dirStream);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void rewinddir(Object receiver_, Object dirStream) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.rewinddir(receiver_, dirStream);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object dirEntryGetName(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.dirEntryGetName(receiver_, dirEntry);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object dirEntryGetPath(Object receiver_, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.dirEntryGetPath(receiver_, dirEntry, scandirPath);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long dirEntryGetInode(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.dirEntryGetInode(receiver_, dirEntry);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int dirEntryGetType(Object receiver_, Object dirEntry) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.dirEntryGetType(receiver_, dirEntry);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void utimensat(Object receiver_, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.utimensat(receiver_, dirFd, pathname, timespec, followSymlinks);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void futimens(Object receiver_, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.futimens(receiver_, fd, timespec);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void futimes(Object receiver_, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.futimes(receiver_, fd, timeval);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void lutimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.lutimes(receiver_, filename, timeval);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void utimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.utimes(receiver_, filename, timeval);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void renameat(Object receiver_, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.renameat(receiver_, oldDirFd, oldPath, newDirFd, newPath);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean faccessat(Object receiver_, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.faccessat(receiver_, dirFd, path, mode, effectiveIds, followSymlinks);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fchmodat(Object receiver_, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fchmodat(receiver_, dirFd, path, mode, followSymlinks);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fchmod(Object receiver_, int fd, int mode) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fchmod(receiver_, fd, mode);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fchownat(Object receiver_, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fchownat(receiver_, dirFd, pathname, owner, group, followSymlinks);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fchown(Object receiver_, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fchown(receiver_, fd, owner, group);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object readlinkat(Object receiver_, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readlinkat(receiver_, dirFd, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void kill(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.kill(receiver_, pid, signal);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void killpg(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.killpg(receiver_, pid, signal);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long[] waitpid(Object receiver_, long pid, int options) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.waitpid(receiver_, pid, options);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void abort(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.abort(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean wcoredump(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wcoredump(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean wifcontinued(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wifcontinued(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean wifstopped(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wifstopped(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean wifsignaled(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wifsignaled(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean wifexited(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wifexited(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int wexitstatus(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wexitstatus(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int wtermsig(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wtermsig(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int wstopsig(Object receiver_, int status) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.wstopsig(receiver_, status);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getuid(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getuid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long geteuid(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.geteuid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getgid(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getgid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getegid(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getegid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getppid(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getppid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getpgid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpgid(receiver_, pid);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void setpgid(Object receiver_, long pid, long pgid) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.setpgid(receiver_, pid, pgid);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getpgrp(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpgrp(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long getsid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getsid(receiver_, pid);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long setsid(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.setsid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long[] getgroups(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getgroups(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.RusageResult getrusage(Object receiver_, int who) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getrusage(receiver_, who);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.OpenPtyResult openpty(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.openpty(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public TruffleString ctermid(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.ctermid(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void setenv(Object receiver_, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.setenv(receiver_, name, value, overwrite);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void unsetenv(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.unsetenv(receiver_, name);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int forkExec(Object receiver_, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.forkExec(receiver_, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void execv(Object receiver_, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.execv(receiver_, pathname, args);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int system(Object receiver_, Object command) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.system(receiver_, command);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object mmap(Object receiver_, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.mmap(receiver_, length, prot, flags, fd, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public byte mmapReadByte(Object receiver_, Object mmap, long index) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.mmapReadByte(receiver_, mmap, index);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void mmapWriteByte(Object receiver_, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.mmapWriteByte(receiver_, mmap, index, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int mmapReadBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.mmapReadBytes(receiver_, mmap, index, bytes, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void mmapWriteBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.mmapWriteBytes(receiver_, mmap, index, bytes, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void mmapFlush(Object receiver_, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.mmapFlush(receiver_, mmap, offset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void mmapUnmap(Object receiver_, Object mmap, long length) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.mmapUnmap(receiver_, mmap, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long mmapGetPointer(Object receiver_, Object mmap) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.mmapGetPointer(receiver_, mmap);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long semOpen(Object receiver_, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.semOpen(receiver_, name, openFlags, mode, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void semClose(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.semClose(receiver_, handle);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void semUnlink(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.semUnlink(receiver_, name);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int semGetValue(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.semGetValue(receiver_, handle);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void semPost(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.semPost(receiver_, handle);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void semWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.semWait(receiver_, handle);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean semTryWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.semTryWait(receiver_, handle);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean semTimedWait(Object receiver_, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.semTimedWait(receiver_, handle, deadlineNs);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.PwdResult getpwuid(Object receiver_, long uid) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpwuid(receiver_, uid);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.PwdResult getpwnam(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpwnam(receiver_, name);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean hasGetpwentries(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.hasGetpwentries(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpwentries(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object createPathFromString(Object receiver_, TruffleString path) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createPathFromString(receiver_, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object createPathFromBytes(Object receiver_, byte[] path) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createPathFromBytes(receiver_, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public TruffleString getPathAsString(Object receiver_, Object path) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getPathAsString(receiver_, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver_, Object path) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getPathAsBytes(receiver_, path);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int socket(Object receiver_, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.socket(receiver_, domain, type, protocol);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.AcceptResult accept(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.accept(receiver_, sockfd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void bind(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.bind(receiver_, sockfd, addr);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void connect(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.connect(receiver_, sockfd, addr);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void listen(Object receiver_, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.listen(receiver_, sockfd, backlog);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getpeername(receiver_, sockfd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getsockname(receiver_, sockfd);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int send(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.send(receiver_, sockfd, buf, offset, len, flags);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int sendto(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.sendto(receiver_, sockfd, buf, offset, len, flags, destAddr);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int recv(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.recv(receiver_, sockfd, buf, offset, len, flags);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.recvfrom(receiver_, sockfd, buf, offset, len, flags);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void shutdown(Object receiver_, int sockfd, int how) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.shutdown(receiver_, sockfd, how);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int getsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getsockopt(receiver_, sockfd, level, optname, optval, optlen);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void setsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.setsockopt(receiver_, sockfd, level, optname, optval, optlen);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int inet_addr(Object receiver_, Object src) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.inet_addr(receiver_, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int inet_aton(Object receiver_, Object src) throws PosixSupportLibrary.InvalidAddressException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.inet_aton(receiver_, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object inet_ntoa(Object receiver_, int address) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.inet_ntoa(receiver_, address);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public byte[] inet_pton(Object receiver_, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.inet_pton(receiver_, family, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object inet_ntop(Object receiver_, int family, byte[] src) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.inet_ntop(receiver_, family, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object gethostname(Object receiver_) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.gethostname(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object[] getnameinfo(Object receiver_, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getnameinfo(receiver_, addr, flags);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver_, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getaddrinfo(receiver_, node, service, family, sockType, protocol, flags);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public TruffleString crypt(Object receiver_, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.crypt(receiver_, word, salt);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int ioctlBytes(Object receiver_, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.ioctlBytes(receiver_, fd, request, arg);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int ioctlInt(Object receiver_, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.ioctlInt(receiver_, fd, request, arg);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver_, PosixSupportLibrary.Inet4SockAddr src) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createUniversalSockAddrInet4(receiver_, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver_, PosixSupportLibrary.Inet6SockAddr src) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createUniversalSockAddrInet6(receiver_, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver_, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PosixSupportLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createUniversalSockAddrUnix(receiver_, src);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PosixSupportLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (PosixSupportLibrary)this.insert((Node)((PosixSupportLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        PosixSupportLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (PosixSupportLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((PosixSupportLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends PosixSupportLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString getBackend(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getBackend(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString strerror(Object receiver_, int errorCode) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).strerror(receiver_, errorCode);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getpid(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int umask(Object receiver_, int mask) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).umask(receiver_, mask);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int openat(Object receiver_, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).openat(receiver_, dirFd, pathname, flags, mode);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int close(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).close(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.Buffer read(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).read(receiver_, fd, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long write(Object receiver_, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).write(receiver_, fd, data);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int dup(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dup(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int dup2(Object receiver_, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dup2(receiver_, fd, fd2, inheritable);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean getInheritable(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getInheritable(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void setInheritable(Object receiver_, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setInheritable(receiver_, fd, inheritable);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int[] pipe(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).pipe(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.SelectResult select(Object receiver_, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).select(receiver_, readfds, writefds, errorfds, timeout);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean poll(Object receiver_, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).poll(receiver_, fd, forWriting, timeout);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long lseek(Object receiver_, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).lseek(receiver_, fd, offset, how);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void ftruncate(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ftruncate(receiver_, fd, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void truncate(Object receiver_, Object path, long length) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).truncate(receiver_, path, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fsync(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fsync(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void flock(Object receiver_, int fd, int operation) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).flock(receiver_, fd, operation);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fcntlLock(Object receiver_, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fcntlLock(receiver_, fd, blocking, lockType, whence, start, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean getBlocking(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getBlocking(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void setBlocking(Object receiver_, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setBlocking(receiver_, fd, blocking);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int[] getTerminalSize(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getTerminalSize(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long sysconf(Object receiver_, int name) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).sysconf(receiver_, name);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] fstatat(Object receiver_, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fstatat(receiver_, dirFd, pathname, followSymlinks);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] fstat(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fstat(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] statvfs(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).statvfs(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] fstatvfs(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fstatvfs(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] uname(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).uname(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void unlinkat(Object receiver_, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).unlinkat(receiver_, dirFd, pathname, rmdir);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void linkat(Object receiver_, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).linkat(receiver_, oldFdDir, oldPath, newFdDir, newPath, flags);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void symlinkat(Object receiver_, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).symlinkat(receiver_, target, linkpathDirFd, linkpath);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void mkdirat(Object receiver_, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mkdirat(receiver_, dirFd, pathname, mode);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getcwd(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getcwd(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void chdir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).chdir(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchdir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchdir(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isatty(Object receiver_, int fd) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).isatty(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object opendir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).opendir(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object fdopendir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fdopendir(receiver_, fd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void closedir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).closedir(receiver_, dirStream);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readdir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).readdir(receiver_, dirStream);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void rewinddir(Object receiver_, Object dirStream) {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).rewinddir(receiver_, dirStream);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object dirEntryGetName(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetName(receiver_, dirEntry);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object dirEntryGetPath(Object receiver_, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetPath(receiver_, dirEntry, scandirPath);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long dirEntryGetInode(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetInode(receiver_, dirEntry);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int dirEntryGetType(Object receiver_, Object dirEntry) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetType(receiver_, dirEntry);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void utimensat(Object receiver_, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).utimensat(receiver_, dirFd, pathname, timespec, followSymlinks);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void futimens(Object receiver_, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).futimens(receiver_, fd, timespec);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void futimes(Object receiver_, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).futimes(receiver_, fd, timeval);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void lutimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).lutimes(receiver_, filename, timeval);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void utimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).utimes(receiver_, filename, timeval);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void renameat(Object receiver_, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).renameat(receiver_, oldDirFd, oldPath, newDirFd, newPath);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean faccessat(Object receiver_, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).faccessat(receiver_, dirFd, path, mode, effectiveIds, followSymlinks);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchmodat(Object receiver_, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchmodat(receiver_, dirFd, path, mode, followSymlinks);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchmod(Object receiver_, int fd, int mode) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchmod(receiver_, fd, mode);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchownat(Object receiver_, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchownat(receiver_, dirFd, pathname, owner, group, followSymlinks);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchown(Object receiver_, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchown(receiver_, fd, owner, group);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readlinkat(Object receiver_, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).readlinkat(receiver_, dirFd, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void kill(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).kill(receiver_, pid, signal);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void killpg(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).killpg(receiver_, pid, signal);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] waitpid(Object receiver_, long pid, int options) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).waitpid(receiver_, pid, options);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void abort(Object receiver_) {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).abort(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wcoredump(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wcoredump(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifcontinued(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifcontinued(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifstopped(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifstopped(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifsignaled(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifsignaled(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifexited(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifexited(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int wexitstatus(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wexitstatus(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int wtermsig(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wtermsig(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int wstopsig(Object receiver_, int status) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wstopsig(receiver_, status);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getuid(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getuid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long geteuid(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).geteuid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getgid(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getgid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getegid(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getegid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getppid(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getppid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getpgid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpgid(receiver_, pid);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void setpgid(Object receiver_, long pid, long pgid) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setpgid(receiver_, pid, pgid);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getpgrp(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpgrp(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getsid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getsid(receiver_, pid);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long setsid(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setsid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] getgroups(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getgroups(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.RusageResult getrusage(Object receiver_, int who) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getrusage(receiver_, who);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.OpenPtyResult openpty(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).openpty(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString ctermid(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ctermid(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void setenv(Object receiver_, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setenv(receiver_, name, value, overwrite);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void unsetenv(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).unsetenv(receiver_, name);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int forkExec(Object receiver_, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).forkExec(receiver_, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void execv(Object receiver_, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).execv(receiver_, pathname, args);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int system(Object receiver_, Object command) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).system(receiver_, command);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object mmap(Object receiver_, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmap(receiver_, length, prot, flags, fd, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public byte mmapReadByte(Object receiver_, Object mmap, long index) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapReadByte(receiver_, mmap, index);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapWriteByte(Object receiver_, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapWriteByte(receiver_, mmap, index, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int mmapReadBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapReadBytes(receiver_, mmap, index, bytes, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapWriteBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapWriteBytes(receiver_, mmap, index, bytes, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapFlush(Object receiver_, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapFlush(receiver_, mmap, offset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapUnmap(Object receiver_, Object mmap, long length) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapUnmap(receiver_, mmap, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long mmapGetPointer(Object receiver_, Object mmap) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapGetPointer(receiver_, mmap);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long semOpen(Object receiver_, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semOpen(receiver_, name, openFlags, mode, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void semClose(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semClose(receiver_, handle);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void semUnlink(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semUnlink(receiver_, name);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int semGetValue(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semGetValue(receiver_, handle);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void semPost(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semPost(receiver_, handle);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void semWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semWait(receiver_, handle);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean semTryWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semTryWait(receiver_, handle);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean semTimedWait(Object receiver_, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semTimedWait(receiver_, handle, deadlineNs);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.PwdResult getpwuid(Object receiver_, long uid) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpwuid(receiver_, uid);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.PwdResult getpwnam(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpwnam(receiver_, name);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasGetpwentries(Object receiver_) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).hasGetpwentries(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpwentries(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createPathFromString(Object receiver_, TruffleString path) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createPathFromString(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createPathFromBytes(Object receiver_, byte[] path) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createPathFromBytes(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString getPathAsString(Object receiver_, Object path) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getPathAsString(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver_, Object path) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getPathAsBytes(receiver_, path);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int socket(Object receiver_, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).socket(receiver_, domain, type, protocol);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.AcceptResult accept(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).accept(receiver_, sockfd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void bind(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).bind(receiver_, sockfd, addr);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void connect(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).connect(receiver_, sockfd, addr);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void listen(Object receiver_, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).listen(receiver_, sockfd, backlog);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpeername(receiver_, sockfd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getsockname(receiver_, sockfd);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int send(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).send(receiver_, sockfd, buf, offset, len, flags);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int sendto(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).sendto(receiver_, sockfd, buf, offset, len, flags, destAddr);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int recv(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).recv(receiver_, sockfd, buf, offset, len, flags);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).recvfrom(receiver_, sockfd, buf, offset, len, flags);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void shutdown(Object receiver_, int sockfd, int how) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).shutdown(receiver_, sockfd, how);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getsockopt(receiver_, sockfd, level, optname, optval, optlen);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void setsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setsockopt(receiver_, sockfd, level, optname, optval, optlen);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int inet_addr(Object receiver_, Object src) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_addr(receiver_, src);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int inet_aton(Object receiver_, Object src) throws PosixSupportLibrary.InvalidAddressException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_aton(receiver_, src);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object inet_ntoa(Object receiver_, int address) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_ntoa(receiver_, address);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public byte[] inet_pton(Object receiver_, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_pton(receiver_, family, src);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object inet_ntop(Object receiver_, int family, byte[] src) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_ntop(receiver_, family, src);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object gethostname(Object receiver_) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).gethostname(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] getnameinfo(Object receiver_, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getnameinfo(receiver_, addr, flags);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver_, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getaddrinfo(receiver_, node, service, family, sockType, protocol, flags);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString crypt(Object receiver_, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).crypt(receiver_, word, salt);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int ioctlBytes(Object receiver_, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ioctlBytes(receiver_, fd, request, arg);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int ioctlInt(Object receiver_, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ioctlInt(receiver_, fd, request, arg);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver_, PosixSupportLibrary.Inet4SockAddr src) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createUniversalSockAddrInet4(receiver_, src);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver_, PosixSupportLibrary.Inet6SockAddr src) {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createUniversalSockAddrInet6(receiver_, src);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver_, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
            return ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createUniversalSockAddrUnix(receiver_, src);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static final class Default
    extends LibraryExport<PosixSupportLibrary> {
        private Default() {
            super(PosixSupportLibrary.class, Object.class, false, false, 0);
        }

        protected PosixSupportLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected PosixSupportLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=PosixSupportLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends PosixSupportLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getBackend(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString strerror(Object receiver, int errorCode) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int umask(Object receiver, int mask) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int openat(Object receiver, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int close(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.Buffer read(Object receiver, int fd, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long write(Object receiver, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dup(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dup2(Object receiver, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean getInheritable(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setInheritable(Object receiver, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int[] pipe(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.SelectResult select(Object receiver, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean poll(Object receiver, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long lseek(Object receiver, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void ftruncate(Object receiver, int fd, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void truncate(Object receiver, Object path, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fsync(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void flock(Object receiver, int fd, int operation) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fcntlLock(Object receiver, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean getBlocking(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setBlocking(Object receiver, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int[] getTerminalSize(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long sysconf(Object receiver, int name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstatat(Object receiver, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstat(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] statvfs(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstatvfs(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] uname(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unlinkat(Object receiver, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void linkat(Object receiver, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void symlinkat(Object receiver, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mkdirat(Object receiver, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getcwd(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void chdir(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchdir(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isatty(Object receiver, int fd) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object opendir(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object fdopendir(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void closedir(Object receiver, Object dirStream) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readdir(Object receiver, Object dirStream) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void rewinddir(Object receiver, Object dirStream) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object dirEntryGetName(Object receiver, Object dirEntry) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object dirEntryGetPath(Object receiver, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long dirEntryGetInode(Object receiver, Object dirEntry) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dirEntryGetType(Object receiver, Object dirEntry) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void utimensat(Object receiver, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void futimens(Object receiver, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void futimes(Object receiver, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void lutimes(Object receiver, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void utimes(Object receiver, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void renameat(Object receiver, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean faccessat(Object receiver, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchmodat(Object receiver, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchmod(Object receiver, int fd, int mode) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchownat(Object receiver, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchown(Object receiver, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readlinkat(Object receiver, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void kill(Object receiver, long pid, int signal) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void killpg(Object receiver, long pid, int signal) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] waitpid(Object receiver, long pid, int options) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void abort(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wcoredump(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifcontinued(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifstopped(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifsignaled(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifexited(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wexitstatus(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wtermsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wstopsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long geteuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getgid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getegid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getppid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpgid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setpgid(Object receiver, long pid, long pgid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpgrp(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getsid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long setsid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] getgroups(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RusageResult getrusage(Object receiver, int who) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.OpenPtyResult openpty(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString ctermid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setenv(Object receiver, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unsetenv(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int forkExec(Object receiver, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execv(Object receiver, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int system(Object receiver, Object command) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object mmap(Object receiver, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte mmapReadByte(Object receiver, Object mmap, long index) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapWriteByte(Object receiver, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int mmapReadBytes(Object receiver, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapWriteBytes(Object receiver, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapFlush(Object receiver, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapUnmap(Object receiver, Object mmap, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long mmapGetPointer(Object receiver, Object mmap) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long semOpen(Object receiver, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semClose(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semUnlink(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int semGetValue(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semPost(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean semTryWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean semTimedWait(Object receiver, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwuid(Object receiver, long uid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwnam(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasGetpwentries(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createPathFromString(Object receiver, TruffleString path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createPathFromBytes(Object receiver, byte[] path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getPathAsString(Object receiver, Object path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver, Object path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int socket(Object receiver, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AcceptResult accept(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void bind(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void connect(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void listen(Object receiver, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int send(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int sendto(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int recv(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void shutdown(Object receiver, int sockfd, int how) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_addr(Object receiver, Object src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_aton(Object receiver, Object src) throws PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntoa(Object receiver, int address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte[] inet_pton(Object receiver, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntop(Object receiver, int family, byte[] src) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object gethostname(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] getnameinfo(Object receiver, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString crypt(Object receiver, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int ioctlBytes(Object receiver, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int ioctlInt(Object receiver, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver, PosixSupportLibrary.Inet4SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver, PosixSupportLibrary.Inet6SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=PosixSupportLibrary.class)
        private static final class Cached
        extends PosixSupportLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getBackend(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString strerror(Object receiver, int errorCode) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int umask(Object receiver, int mask) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int openat(Object receiver, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int close(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.Buffer read(Object receiver, int fd, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long write(Object receiver, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dup(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dup2(Object receiver, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean getInheritable(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setInheritable(Object receiver, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int[] pipe(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.SelectResult select(Object receiver, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean poll(Object receiver, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long lseek(Object receiver, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void ftruncate(Object receiver, int fd, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void truncate(Object receiver, Object path, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fsync(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void flock(Object receiver, int fd, int operation) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fcntlLock(Object receiver, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean getBlocking(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setBlocking(Object receiver, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int[] getTerminalSize(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long sysconf(Object receiver, int name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstatat(Object receiver, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstat(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] statvfs(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstatvfs(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] uname(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unlinkat(Object receiver, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void linkat(Object receiver, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void symlinkat(Object receiver, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mkdirat(Object receiver, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getcwd(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void chdir(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchdir(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isatty(Object receiver, int fd) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object opendir(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object fdopendir(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void closedir(Object receiver, Object dirStream) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readdir(Object receiver, Object dirStream) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void rewinddir(Object receiver, Object dirStream) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object dirEntryGetName(Object receiver, Object dirEntry) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object dirEntryGetPath(Object receiver, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long dirEntryGetInode(Object receiver, Object dirEntry) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dirEntryGetType(Object receiver, Object dirEntry) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void utimensat(Object receiver, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void futimens(Object receiver, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void futimes(Object receiver, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void lutimes(Object receiver, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void utimes(Object receiver, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void renameat(Object receiver, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean faccessat(Object receiver, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchmodat(Object receiver, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchmod(Object receiver, int fd, int mode) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchownat(Object receiver, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchown(Object receiver, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readlinkat(Object receiver, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void kill(Object receiver, long pid, int signal) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void killpg(Object receiver, long pid, int signal) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] waitpid(Object receiver, long pid, int options) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void abort(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wcoredump(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifcontinued(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifstopped(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifsignaled(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifexited(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wexitstatus(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wtermsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wstopsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long geteuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getgid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getegid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getppid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpgid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setpgid(Object receiver, long pid, long pgid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpgrp(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getsid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long setsid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] getgroups(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RusageResult getrusage(Object receiver, int who) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.OpenPtyResult openpty(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString ctermid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setenv(Object receiver, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unsetenv(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int forkExec(Object receiver, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execv(Object receiver, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int system(Object receiver, Object command) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object mmap(Object receiver, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte mmapReadByte(Object receiver, Object mmap, long index) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapWriteByte(Object receiver, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int mmapReadBytes(Object receiver, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapWriteBytes(Object receiver, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapFlush(Object receiver, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapUnmap(Object receiver, Object mmap, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long mmapGetPointer(Object receiver, Object mmap) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long semOpen(Object receiver, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semClose(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semUnlink(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int semGetValue(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semPost(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean semTryWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean semTimedWait(Object receiver, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwuid(Object receiver, long uid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwnam(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasGetpwentries(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createPathFromString(Object receiver, TruffleString path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createPathFromBytes(Object receiver, byte[] path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getPathAsString(Object receiver, Object path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver, Object path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int socket(Object receiver, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AcceptResult accept(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void bind(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void connect(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void listen(Object receiver, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int send(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int sendto(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int recv(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void shutdown(Object receiver, int sockfd, int how) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_addr(Object receiver, Object src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_aton(Object receiver, Object src) throws PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntoa(Object receiver, int address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte[] inet_pton(Object receiver, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntop(Object receiver, int family, byte[] src) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object gethostname(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] getnameinfo(Object receiver, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString crypt(Object receiver, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int ioctlBytes(Object receiver, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int ioctlInt(Object receiver, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver, PosixSupportLibrary.Inet4SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver, PosixSupportLibrary.Inet6SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(PosixSupportLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=PosixSupportLibrary.class)
    private static final class CachedToUncachedDispatch
    extends PosixSupportLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString getBackend(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getBackend(receiver_);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString strerror(Object receiver_, int errorCode) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).strerror(receiver_, errorCode);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getpid(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int umask(Object receiver_, int mask) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).umask(receiver_, mask);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int openat(Object receiver_, int dirFd, Object pathname, int flags, int mode) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).openat(receiver_, dirFd, pathname, flags, mode);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int close(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).close(receiver_, fd);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.Buffer read(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.Buffer buffer = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).read(receiver_, fd, length);
                return buffer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long write(Object receiver_, int fd, PosixSupportLibrary.Buffer data) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).write(receiver_, fd, data);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int dup(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dup(receiver_, fd);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int dup2(Object receiver_, int fd, int fd2, boolean inheritable) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dup2(receiver_, fd, fd2, inheritable);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean getInheritable(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getInheritable(receiver_, fd);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void setInheritable(Object receiver_, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setInheritable(receiver_, fd, inheritable);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int[] pipe(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int[] nArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).pipe(receiver_);
                return nArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.SelectResult select(Object receiver_, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.SelectResult selectResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).select(receiver_, readfds, writefds, errorfds, timeout);
                return selectResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean poll(Object receiver_, int fd, boolean forWriting, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).poll(receiver_, fd, forWriting, timeout);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long lseek(Object receiver_, int fd, long offset, int how) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).lseek(receiver_, fd, offset, how);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void ftruncate(Object receiver_, int fd, long length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ftruncate(receiver_, fd, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void truncate(Object receiver_, Object path, long length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).truncate(receiver_, path, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fsync(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fsync(receiver_, fd);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void flock(Object receiver_, int fd, int operation) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).flock(receiver_, fd, operation);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fcntlLock(Object receiver_, int fd, boolean blocking, int lockType, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fcntlLock(receiver_, fd, blocking, lockType, whence, start, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean getBlocking(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getBlocking(receiver_, fd);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void setBlocking(Object receiver_, int fd, boolean blocking) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setBlocking(receiver_, fd, blocking);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int[] getTerminalSize(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int[] nArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getTerminalSize(receiver_, fd);
                return nArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long sysconf(Object receiver_, int name) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).sysconf(receiver_, name);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] fstatat(Object receiver_, int dirFd, Object pathname, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long[] lArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fstatat(receiver_, dirFd, pathname, followSymlinks);
                return lArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] fstat(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long[] lArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fstat(receiver_, fd);
                return lArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] statvfs(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long[] lArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).statvfs(receiver_, path);
                return lArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] fstatvfs(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long[] lArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fstatvfs(receiver_, fd);
                return lArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] uname(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object[] objectArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).uname(receiver_);
                return objectArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void unlinkat(Object receiver_, int dirFd, Object pathname, boolean rmdir) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).unlinkat(receiver_, dirFd, pathname, rmdir);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void linkat(Object receiver_, int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).linkat(receiver_, oldFdDir, oldPath, newFdDir, newPath, flags);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void symlinkat(Object receiver_, Object target, int linkpathDirFd, Object linkpath) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).symlinkat(receiver_, target, linkpathDirFd, linkpath);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void mkdirat(Object receiver_, int dirFd, Object pathname, int mode) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mkdirat(receiver_, dirFd, pathname, mode);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getcwd(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getcwd(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void chdir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).chdir(receiver_, path);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchdir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchdir(receiver_, fd);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isatty(Object receiver_, int fd) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).isatty(receiver_, fd);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object opendir(Object receiver_, Object path) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).opendir(receiver_, path);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object fdopendir(Object receiver_, int fd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fdopendir(receiver_, fd);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void closedir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).closedir(receiver_, dirStream);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readdir(Object receiver_, Object dirStream) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).readdir(receiver_, dirStream);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void rewinddir(Object receiver_, Object dirStream) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).rewinddir(receiver_, dirStream);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object dirEntryGetName(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetName(receiver_, dirEntry);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object dirEntryGetPath(Object receiver_, Object dirEntry, Object scandirPath) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetPath(receiver_, dirEntry, scandirPath);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long dirEntryGetInode(Object receiver_, Object dirEntry) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetInode(receiver_, dirEntry);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int dirEntryGetType(Object receiver_, Object dirEntry) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).dirEntryGetType(receiver_, dirEntry);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void utimensat(Object receiver_, int dirFd, Object pathname, long[] timespec, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).utimensat(receiver_, dirFd, pathname, timespec, followSymlinks);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void futimens(Object receiver_, int fd, long[] timespec) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).futimens(receiver_, fd, timespec);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void futimes(Object receiver_, int fd, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).futimes(receiver_, fd, timeval);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void lutimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).lutimes(receiver_, filename, timeval);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void utimes(Object receiver_, Object filename, PosixSupportLibrary.Timeval[] timeval) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).utimes(receiver_, filename, timeval);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void renameat(Object receiver_, int oldDirFd, Object oldPath, int newDirFd, Object newPath) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).renameat(receiver_, oldDirFd, oldPath, newDirFd, newPath);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean faccessat(Object receiver_, int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).faccessat(receiver_, dirFd, path, mode, effectiveIds, followSymlinks);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchmodat(Object receiver_, int dirFd, Object path, int mode, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchmodat(receiver_, dirFd, path, mode, followSymlinks);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchmod(Object receiver_, int fd, int mode) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchmod(receiver_, fd, mode);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchownat(Object receiver_, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchownat(receiver_, dirFd, pathname, owner, group, followSymlinks);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fchown(Object receiver_, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).fchown(receiver_, fd, owner, group);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readlinkat(Object receiver_, int dirFd, Object path) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).readlinkat(receiver_, dirFd, path);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void kill(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).kill(receiver_, pid, signal);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void killpg(Object receiver_, long pid, int signal) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).killpg(receiver_, pid, signal);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] waitpid(Object receiver_, long pid, int options) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long[] lArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).waitpid(receiver_, pid, options);
                return lArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void abort(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).abort(receiver_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wcoredump(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wcoredump(receiver_, status);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifcontinued(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifcontinued(receiver_, status);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifstopped(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifstopped(receiver_, status);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifsignaled(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifsignaled(receiver_, status);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean wifexited(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wifexited(receiver_, status);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int wexitstatus(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wexitstatus(receiver_, status);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int wtermsig(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wtermsig(receiver_, status);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int wstopsig(Object receiver_, int status) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).wstopsig(receiver_, status);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getuid(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getuid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long geteuid(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).geteuid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getgid(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getgid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getegid(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getegid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getppid(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getppid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getpgid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpgid(receiver_, pid);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void setpgid(Object receiver_, long pid, long pgid) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setpgid(receiver_, pid, pgid);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getpgrp(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpgrp(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long getsid(Object receiver_, long pid) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getsid(receiver_, pid);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long setsid(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setsid(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long[] getgroups(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long[] lArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getgroups(receiver_);
                return lArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.RusageResult getrusage(Object receiver_, int who) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.RusageResult rusageResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getrusage(receiver_, who);
                return rusageResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.OpenPtyResult openpty(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.OpenPtyResult openPtyResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).openpty(receiver_);
                return openPtyResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString ctermid(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ctermid(receiver_);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void setenv(Object receiver_, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setenv(receiver_, name, value, overwrite);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void unsetenv(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).unsetenv(receiver_, name);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int forkExec(Object receiver_, Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).forkExec(receiver_, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void execv(Object receiver_, Object pathname, Object[] args) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).execv(receiver_, pathname, args);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int system(Object receiver_, Object command) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).system(receiver_, command);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object mmap(Object receiver_, long length, int prot, int flags, int fd, long offset) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmap(receiver_, length, prot, flags, fd, offset);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public byte mmapReadByte(Object receiver_, Object mmap, long index) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                byte by = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapReadByte(receiver_, mmap, index);
                return by;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapWriteByte(Object receiver_, Object mmap, long index, byte value) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapWriteByte(receiver_, mmap, index, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int mmapReadBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapReadBytes(receiver_, mmap, index, bytes, length);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapWriteBytes(Object receiver_, Object mmap, long index, byte[] bytes, int length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapWriteBytes(receiver_, mmap, index, bytes, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapFlush(Object receiver_, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapFlush(receiver_, mmap, offset, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void mmapUnmap(Object receiver_, Object mmap, long length) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapUnmap(receiver_, mmap, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long mmapGetPointer(Object receiver_, Object mmap) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).mmapGetPointer(receiver_, mmap);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long semOpen(Object receiver_, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semOpen(receiver_, name, openFlags, mode, value);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void semClose(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semClose(receiver_, handle);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void semUnlink(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semUnlink(receiver_, name);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int semGetValue(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semGetValue(receiver_, handle);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void semPost(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semPost(receiver_, handle);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void semWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semWait(receiver_, handle);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean semTryWait(Object receiver_, long handle) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semTryWait(receiver_, handle);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean semTimedWait(Object receiver_, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).semTimedWait(receiver_, handle, deadlineNs);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.PwdResult getpwuid(Object receiver_, long uid) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.PwdResult pwdResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpwuid(receiver_, uid);
                return pwdResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.PwdResult getpwnam(Object receiver_, Object name) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.PwdResult pwdResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpwnam(receiver_, name);
                return pwdResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasGetpwentries(Object receiver_) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).hasGetpwentries(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.PwdResult[] pwdResultArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpwentries(receiver_);
                return pwdResultArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createPathFromString(Object receiver_, TruffleString path) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createPathFromString(receiver_, path);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createPathFromBytes(Object receiver_, byte[] path) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createPathFromBytes(receiver_, path);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString getPathAsString(Object receiver_, Object path) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getPathAsString(receiver_, path);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver_, Object path) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.Buffer buffer = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getPathAsBytes(receiver_, path);
                return buffer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int socket(Object receiver_, int domain, int type, int protocol) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).socket(receiver_, domain, type, protocol);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.AcceptResult accept(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.AcceptResult acceptResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).accept(receiver_, sockfd);
                return acceptResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void bind(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).bind(receiver_, sockfd, addr);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void connect(Object receiver_, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).connect(receiver_, sockfd, addr);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void listen(Object receiver_, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).listen(receiver_, sockfd, backlog);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.UniversalSockAddr universalSockAddr = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getpeername(receiver_, sockfd);
                return universalSockAddr;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver_, int sockfd) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.UniversalSockAddr universalSockAddr = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getsockname(receiver_, sockfd);
                return universalSockAddr;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int send(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).send(receiver_, sockfd, buf, offset, len, flags);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int sendto(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).sendto(receiver_, sockfd, buf, offset, len, flags, destAddr);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int recv(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).recv(receiver_, sockfd, buf, offset, len, flags);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver_, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.RecvfromResult recvfromResult = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).recvfrom(receiver_, sockfd, buf, offset, len, flags);
                return recvfromResult;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void shutdown(Object receiver_, int sockfd, int how) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).shutdown(receiver_, sockfd, how);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int getsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getsockopt(receiver_, sockfd, level, optname, optval, optlen);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void setsockopt(Object receiver_, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).setsockopt(receiver_, sockfd, level, optname, optval, optlen);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int inet_addr(Object receiver_, Object src) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_addr(receiver_, src);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int inet_aton(Object receiver_, Object src) throws PosixSupportLibrary.InvalidAddressException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_aton(receiver_, src);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object inet_ntoa(Object receiver_, int address) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_ntoa(receiver_, address);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public byte[] inet_pton(Object receiver_, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                byte[] byArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_pton(receiver_, family, src);
                return byArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object inet_ntop(Object receiver_, int family, byte[] src) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).inet_ntop(receiver_, family, src);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object gethostname(Object receiver_) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).gethostname(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] getnameinfo(Object receiver_, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object[] objectArray = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getnameinfo(receiver_, addr, flags);
                return objectArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver_, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.AddrInfoCursor addrInfoCursor = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).getaddrinfo(receiver_, node, service, family, sockType, protocol, flags);
                return addrInfoCursor;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString crypt(Object receiver_, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).crypt(receiver_, word, salt);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int ioctlBytes(Object receiver_, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ioctlBytes(receiver_, fd, request, arg);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int ioctlInt(Object receiver_, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).ioctlInt(receiver_, fd, request, arg);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver_, PosixSupportLibrary.Inet4SockAddr src) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.UniversalSockAddr universalSockAddr = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createUniversalSockAddrInet4(receiver_, src);
                return universalSockAddr;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver_, PosixSupportLibrary.Inet6SockAddr src) {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.UniversalSockAddr universalSockAddr = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createUniversalSockAddrInet6(receiver_, src);
                return universalSockAddr;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver_, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
            assert (PosixSupportLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PosixSupportLibrary.UniversalSockAddr universalSockAddr = ((PosixSupportLibrary)INSTANCE.getUncached(receiver_)).createUniversalSockAddrUnix(receiver_, src);
                return universalSockAddr;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

