/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.jdbc.MetadataAPIHelper;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.RedshiftLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MetadataAPIPostProcessor
extends MetadataAPIHelper {
    protected final RedshiftConnectionImpl connection;

    public MetadataAPIPostProcessor(RedshiftConnectionImpl connection) {
        super(connection);
        this.connection = connection;
    }

    protected ResultSet getCatalogsPostProcessing(List<String> serverResults) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getCatalogsPostProcessing", new Object[0]);
        }
        if (serverResults == null) {
            return this.createRs(this.GET_CATALOGS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> catalogTuples = new ArrayList<Tuple>();
        try {
            for (String database_name : serverResults) {
                byte[][] tuple = this.getEmptyTuple(this.GET_CATALOGS_COLS, this.GET_CATALOGS_COLS.length);
                tuple[MetadataAPIHelper.GetCatalogs_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(database_name);
                catalogTuples.add(new Tuple(tuple));
            }
            return this.createRs(this.GET_CATALOGS_COLS, catalogTuples);
        }
        catch (SQLException e) {
            if (RedshiftLogger.isEnable()) {
                RedshiftLogger.getDriverLogger().logError(e);
            }
            throw e;
        }
    }

    protected ResultSet getSchemasPostProcessing(List<MetadataAPIHelper.ShowSchemasInfo> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getSchemasPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_SCHEMAS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> schemaTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ShowSchemasInfo resultSet : serverResultSets) {
            byte[][] tuple = this.getEmptyTuple(this.GET_SCHEMAS_COLS, this.GET_SCHEMAS_COLS.length);
            tuple[MetadataAPIHelper.GetSchemas_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(resultSet.getSchemaName());
            tuple[MetadataAPIHelper.GetSchemas_Metadata.TABLE_CATALOG.getIndex()] = this.encodeStr(resultSet.getDatabaseName());
            schemaTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_SCHEMAS_COLS, schemaTuples);
    }

    protected ResultSet getTablesPostProcessing(List<MetadataAPIHelper.ShowTablesInfo> serverResultSets, String[] types) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getTablesPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_TABLES_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> final_data = new ArrayList<Tuple>();
        HashSet<String> typeSet = null;
        if (types != null) {
            typeSet = new HashSet<String>(Arrays.asList(types));
        }
        for (MetadataAPIHelper.ShowTablesInfo resultSet : serverResultSets) {
            if (types != null && !typeSet.contains(resultSet.getTableType())) continue;
            byte[][] tuple = this.getEmptyTuple(this.GET_TABLES_COLS, this.GET_TABLES_COLS.length);
            tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(resultSet.getDatabaseName());
            tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(resultSet.getSchemaName());
            tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_NAME.getIndex()] = this.encodeStr(resultSet.getTableName());
            tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_TYPE.getIndex()] = this.encodeStr(resultSet.getTableType());
            tuple[MetadataAPIHelper.GetTables_Metadata.REMARKS.getIndex()] = this.encodeStr(resultSet.getRemarks());
            tuple[MetadataAPIHelper.GetTables_Metadata.OWNER.getIndex()] = this.encodeStr(resultSet.getOwner());
            tuple[MetadataAPIHelper.GetTables_Metadata.LAST_ALTERED_TIME.getIndex()] = this.encodeStr(resultSet.getLastAlteredTime());
            tuple[MetadataAPIHelper.GetTables_Metadata.LAST_MODIFIED_TIME.getIndex()] = this.encodeStr(resultSet.getLastModifiedTime());
            tuple[MetadataAPIHelper.GetTables_Metadata.DIST_STYLE.getIndex()] = this.encodeStr(resultSet.getDistStyle());
            tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_SUBTYPE.getIndex()] = this.encodeStr(resultSet.getTableSubtype());
            final_data.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_TABLES_COLS, final_data);
    }

    protected ResultSet getColumnsPostProcessing(List<MetadataAPIHelper.ShowColumnsInfo> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getColumnsPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_COLUMNS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> columnTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ShowColumnsInfo resultSet : serverResultSets) {
            String rsType;
            String dataType = resultSet.getDataType();
            int precisions = 0;
            boolean dateTimeCustomizePrecision = false;
            if (dataType.matches("(time|timetz|timestamp|timestamptz)\\(\\d+\\).*") || dataType.matches("interval.*.\\(\\d+\\)")) {
                rsType = this.getRSType(dataType.replaceAll("\\(\\d+\\)", "").replaceFirst("\\s++$", ""));
                precisions = Integer.parseInt(dataType.replaceAll(".*\\(([0-9]+)\\).*", "$1"));
                dateTimeCustomizePrecision = true;
            } else {
                rsType = this.getRSType(dataType);
            }
            String sqlType = this.getSQLType(rsType);
            String autoIncrement = this.getAutoIncrement(resultSet.getColumnDefault());
            byte[][] tuple = this.getEmptyTuple(this.GET_COLUMNS_COLS, this.GET_COLUMNS_COLS.length);
            tuple[MetadataAPIHelper.GetColumns_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(resultSet.getDatabaseName());
            tuple[MetadataAPIHelper.GetColumns_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(resultSet.getSchemaName());
            tuple[MetadataAPIHelper.GetColumns_Metadata.TABLE_NAME.getIndex()] = this.encodeStr(resultSet.getTableName());
            tuple[MetadataAPIHelper.GetColumns_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr(resultSet.getColumnName());
            tuple[MetadataAPIHelper.GetColumns_Metadata.DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
            tuple[MetadataAPIHelper.GetColumns_Metadata.TYPE_NAME.getIndex()] = this.encodeStr(rsType);
            tuple[MetadataAPIHelper.GetColumns_Metadata.COLUMN_SIZE.getIndex()] = this.encodeStr(this.getColumnSize(rsType, resultSet.getCharacterMaximumLength(), resultSet.getNumericPrecision()));
            tuple[MetadataAPIHelper.GetColumns_Metadata.BUFFER_LENGTH.getIndex()] = null;
            tuple[MetadataAPIHelper.GetColumns_Metadata.DECIMAL_DIGITS.getIndex()] = this.encodeStr(this.getDecimalDigit(rsType, resultSet.getNumericScale(), precisions, dateTimeCustomizePrecision));
            tuple[MetadataAPIHelper.GetColumns_Metadata.NUM_PREC_RADIX.getIndex()] = this.encodeStr(this.getNumPrefixRadix(resultSet.getDataType()));
            tuple[MetadataAPIHelper.GetColumns_Metadata.NULLABLE.getIndex()] = this.encodeStr(this.getNullable(resultSet.getIsNullable()));
            tuple[MetadataAPIHelper.GetColumns_Metadata.REMARKS.getIndex()] = this.encodeStr(resultSet.getRemarks());
            tuple[MetadataAPIHelper.GetColumns_Metadata.COLUMN_DEF.getIndex()] = this.encodeStr(resultSet.getColumnDefault());
            tuple[MetadataAPIHelper.GetColumns_Metadata.SQL_DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
            tuple[MetadataAPIHelper.GetColumns_Metadata.SQL_DATETIME_SUB.getIndex()] = null;
            tuple[MetadataAPIHelper.GetColumns_Metadata.CHAR_OCTET_LENGTH.getIndex()] = this.encodeStr(this.getColumnSize(rsType, resultSet.getCharacterMaximumLength(), resultSet.getNumericPrecision()));
            tuple[MetadataAPIHelper.GetColumns_Metadata.ORDINAL_POSITION.getIndex()] = this.encodeStr(resultSet.getOrdinalPosition());
            tuple[MetadataAPIHelper.GetColumns_Metadata.IS_NULLABLE.getIndex()] = this.encodeStr(resultSet.getIsNullable());
            tuple[MetadataAPIHelper.GetColumns_Metadata.SCOPE_CATALOG.getIndex()] = null;
            tuple[MetadataAPIHelper.GetColumns_Metadata.SCOPE_SCHEMA.getIndex()] = null;
            tuple[MetadataAPIHelper.GetColumns_Metadata.SCOPE_TABLE.getIndex()] = null;
            tuple[MetadataAPIHelper.GetColumns_Metadata.SOURCE_DATA_TYPE.getIndex()] = null;
            tuple[MetadataAPIHelper.GetColumns_Metadata.IS_AUTOINCREMENT.getIndex()] = this.encodeStr(autoIncrement);
            tuple[MetadataAPIHelper.GetColumns_Metadata.IS_GENERATEDCOLUMN.getIndex()] = this.encodeStr(autoIncrement);
            tuple[MetadataAPIHelper.GetColumns_Metadata.SORT_KEY_TYPE.getIndex()] = this.encodeStr(resultSet.getSortKeyType());
            tuple[MetadataAPIHelper.GetColumns_Metadata.SORT_KEY.getIndex()] = this.encodeStr(resultSet.getSortKey());
            tuple[MetadataAPIHelper.GetColumns_Metadata.DIST_KEY.getIndex()] = this.encodeStr(resultSet.getDistKey());
            tuple[MetadataAPIHelper.GetColumns_Metadata.ENCODING.getIndex()] = this.encodeStr(resultSet.getEncoding());
            tuple[MetadataAPIHelper.GetColumns_Metadata.COLLATION.getIndex()] = this.encodeStr(resultSet.getCollation());
            columnTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_COLUMNS_COLS, columnTuples);
    }

    protected ResultSet getPrimaryKeysPostProcessing(List<MetadataAPIHelper.ShowPrimaryKeysInfo> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getPrimaryKeysPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_PRIMARY_KEYS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> primaryKeyTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ShowPrimaryKeysInfo resultSet : serverResultSets) {
            byte[][] tuple = this.getEmptyTuple(this.GET_PRIMARY_KEYS_COLS, this.GET_PRIMARY_KEYS_COLS.length);
            tuple[MetadataAPIHelper.GetPrimaryKeys_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(resultSet.getDatabaseName());
            tuple[MetadataAPIHelper.GetPrimaryKeys_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(resultSet.getSchemaName());
            tuple[MetadataAPIHelper.GetPrimaryKeys_Metadata.TABLE_NAME.getIndex()] = this.encodeStr(resultSet.getTableName());
            tuple[MetadataAPIHelper.GetPrimaryKeys_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr(resultSet.getColumnName());
            tuple[MetadataAPIHelper.GetPrimaryKeys_Metadata.KEY_SEQ.getIndex()] = this.encodeStr(resultSet.getKeySeq());
            tuple[MetadataAPIHelper.GetPrimaryKeys_Metadata.PK_NAME.getIndex()] = this.encodeStr(resultSet.getPkName());
            primaryKeyTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_PRIMARY_KEYS_COLS, primaryKeyTuples);
    }

    protected ResultSet getForeignKeysPostProcessing(List<MetadataAPIHelper.ShowForeignKeysInfo> serverResultSets, boolean isImported) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getForeignKeysPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_FOREIGN_KEYS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> foreignKeyTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ShowForeignKeysInfo resultSet : serverResultSets) {
            String updateRule = resultSet.getUpdateRule() == null ? Short.toString((short)3) : resultSet.getUpdateRule();
            String deleteRule = resultSet.getDeleteRule() == null ? Short.toString((short)3) : resultSet.getDeleteRule();
            String deferrability = resultSet.getDeferrability() == null ? Short.toString((short)7) : resultSet.getDeferrability();
            byte[][] tuple = this.getEmptyTuple(this.GET_FOREIGN_KEYS_COLS, this.GET_FOREIGN_KEYS_COLS.length);
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.PKTABLE_CAT.getIndex()] = this.encodeStr(resultSet.getPkDatabaseName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.PKTABLE_SCHEM.getIndex()] = this.encodeStr(resultSet.getPkSchemaName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.PKTABLE_NAME.getIndex()] = this.encodeStr(resultSet.getPkTableName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.PKCOLUMN_NAME.getIndex()] = this.encodeStr(resultSet.getPkColumnName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.FKTABLE_CAT.getIndex()] = this.encodeStr(resultSet.getFkDatabaseName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.FKTABLE_SCHEM.getIndex()] = this.encodeStr(resultSet.getFkSchemaName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.FKTABLE_NAME.getIndex()] = this.encodeStr(resultSet.getFkTableName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.FKCOLUMN_NAME.getIndex()] = this.encodeStr(resultSet.getFkColumnName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.KEY_SEQ.getIndex()] = this.encodeStr(resultSet.getKeySeq());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.UPDATE_RULE.getIndex()] = this.encodeStr(updateRule);
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.DELETE_RULE.getIndex()] = this.encodeStr(deleteRule);
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.FK_NAME.getIndex()] = this.encodeStr(resultSet.getFkName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.PK_NAME.getIndex()] = this.encodeStr(resultSet.getPkName());
            tuple[MetadataAPIHelper.GetForeignKeys_Metadata.DEFERRABILITY.getIndex()] = this.encodeStr(deferrability);
            foreignKeyTuples.add(new Tuple(tuple));
        }
        MetadataAPIPostProcessor.sortForeignKeyTuples(foreignKeyTuples, isImported);
        return this.createRs(this.GET_FOREIGN_KEYS_COLS, foreignKeyTuples);
    }

    protected ResultSet getBestRowIdentifierPostProcessing(List<MetadataAPIHelper.BestRowIdenData> serverResultSets, int scope) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getBestRowIdentifierPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_BEST_ROW_IDENTIFIER_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> bestRowIdentifierTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.BestRowIdenData bestRowIdenRs : serverResultSets) {
            if (bestRowIdenRs == null) {
                if (!RedshiftLogger.isEnable()) continue;
                this.connection.getLogger().logDebug("Receive null intermediate data hence skipping post-processing", new Object[0]);
                continue;
            }
            List<MetadataAPIHelper.ShowColumnsInfo> curRs = bestRowIdenRs.getResultSet();
            for (MetadataAPIHelper.ShowColumnsInfo columnRs : curRs) {
                String rsType;
                String columnName = columnRs.getColumnName();
                if (!bestRowIdenRs.getPkColumnSet().contains(columnName)) continue;
                String dataType = columnRs.getDataType();
                int precisions = 0;
                boolean dateTimeCustomizePrecision = false;
                if (dataType.matches("(time|timetz|timestamp|timestamptz)\\(\\d+\\).*") || dataType.matches("interval.*.\\(\\d+\\)")) {
                    rsType = this.getRSType(dataType.replaceAll("\\(\\d+\\)", "").replaceFirst("\\s++$", ""));
                    precisions = Integer.parseInt(dataType.replaceAll(".*\\(([0-9]+)\\).*", "$1"));
                    dateTimeCustomizePrecision = true;
                } else {
                    rsType = this.getRSType(dataType);
                }
                String sqlType = this.getSQLType(rsType);
                byte[][] tuple = this.getEmptyTuple(this.GET_BEST_ROW_IDENTIFIER_COLS, this.GET_BEST_ROW_IDENTIFIER_COLS.length);
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.SCOPE.getIndex()] = this.encodeStr(Integer.toString(scope));
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr(columnRs.getColumnName());
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.TYPE_NAME.getIndex()] = this.encodeStr(rsType);
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.COLUMN_SIZE.getIndex()] = this.encodeStr(this.getColumnSize(rsType, columnRs.getCharacterMaximumLength(), columnRs.getNumericPrecision()));
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.BUFFER_LENGTH.getIndex()] = null;
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.DECIMAL_DIGITS.getIndex()] = this.encodeStr(this.getDecimalDigit(rsType, columnRs.getNumericScale(), precisions, dateTimeCustomizePrecision));
                tuple[MetadataAPIHelper.GetBestRowIdentifier_Metadata.PSEUDO_COLUMN.getIndex()] = this.encodeStr("1");
                bestRowIdentifierTuples.add(new Tuple(tuple));
            }
        }
        return this.createRs(this.GET_BEST_ROW_IDENTIFIER_COLS, bestRowIdentifierTuples);
    }

    protected ResultSet getTableTypesPostProcessing(ResultSet serverResultSet) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getTableTypesPostProcessing", new Object[0]);
        }
        if (serverResultSet == null) {
            return this.createRs(this.GET_TABLE_TYPE_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> finalData = new ArrayList<Tuple>();
        try (Statement stmt = serverResultSet.getStatement();){
            while (serverResultSet.next()) {
                byte[][] tuple = this.getEmptyTuple(this.GET_TABLE_TYPE_COLS, this.GET_TABLE_TYPE_COLS.length);
                tuple[0] = this.encodeStr(serverResultSet.getString(1));
                finalData.add(new Tuple(tuple));
            }
        }
        catch (SQLException e) {
            if (RedshiftLogger.isEnable()) {
                RedshiftLogger.getDriverLogger().logError(e);
            }
            throw e;
        }
        return this.createRs(this.GET_TABLE_TYPE_COLS, finalData);
    }

    protected ResultSet getColumnPrivilegesPostProcessing(List<MetadataAPIHelper.ShowGrantsInfo> serverResultSets, String columnPattern) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getColumnPrivilegesPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_COLUMN_PRIVILEGES_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> columnPrivilegesTuples = new ArrayList<Tuple>();
        ArrayList rows = new ArrayList();
        for (MetadataAPIHelper.ShowGrantsInfo showGrantsInfo : serverResultSets) {
            if (!MetadataAPIPostProcessor.patternMatch(showGrantsInfo.getColumnName(), columnPattern)) continue;
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("database_name", showGrantsInfo.getDatabaseName());
            row.put("schema_name", showGrantsInfo.getSchemaName());
            row.put("table_name", showGrantsInfo.getTableName());
            row.put("column_name", showGrantsInfo.getColumnName());
            row.put("grantor_name", showGrantsInfo.getGrantor());
            row.put("identity_name", showGrantsInfo.getIdentityName());
            row.put("privilege_type", showGrantsInfo.getPrivilegeType());
            row.put("admin_option", showGrantsInfo.getAdminOption());
            rows.add(row);
        }
        Collections.sort(rows, (r1, r2) -> {
            String column2;
            String column1 = (String)r1.get("column_name");
            int columnCompare = MetadataAPIPostProcessor.compareNullableStrings(column1, column2 = (String)r2.get("column_name"));
            if (columnCompare != 0) {
                return columnCompare;
            }
            String priv1 = (String)r1.get("privilege_type");
            String priv2 = (String)r2.get("privilege_type");
            return MetadataAPIPostProcessor.compareNullableStrings(priv1, priv2);
        });
        for (Map map : rows) {
            byte[][] tuple = this.getEmptyTuple(this.GET_COLUMN_PRIVILEGES_COLS, this.GET_COLUMN_PRIVILEGES_COLS.length);
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.TABLE_CAT.getIndex()] = this.encodeStr((String)map.get("database_name"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr((String)map.get("schema_name"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.TABLE_NAME.getIndex()] = this.encodeStr((String)map.get("table_name"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr((String)map.get("column_name"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.GRANTOR.getIndex()] = this.encodeStr((String)map.get("grantor_name"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.GRANTEE.getIndex()] = this.encodeStr((String)map.get("identity_name"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.PRIVILEGE.getIndex()] = this.encodeStr((String)map.get("privilege_type"));
            tuple[MetadataAPIHelper.GetColumnPrivileges_Metadata.IS_GRANTABLE.getIndex()] = this.encodeStr(MetadataAPIPostProcessor.getIsGrantable((Boolean)map.get("admin_option")));
            columnPrivilegesTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_COLUMN_PRIVILEGES_COLS, columnPrivilegesTuples);
    }

    protected ResultSet getTablePrivilegesPostProcessing(List<MetadataAPIHelper.ShowGrantsInfo> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getTablePrivilegesPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_TABLE_PRIVILEGES_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> tablePrivilegesTuples = new ArrayList<Tuple>();
        ArrayList rows = new ArrayList();
        for (MetadataAPIHelper.ShowGrantsInfo showGrantsInfo : serverResultSets) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("database_name", showGrantsInfo.getDatabaseName());
            row.put("schema_name", showGrantsInfo.getSchemaName());
            row.put("object_name", showGrantsInfo.getObjectName());
            row.put("grantor_name", showGrantsInfo.getGrantor());
            row.put("identity_name", showGrantsInfo.getIdentityName());
            row.put("privilege_type", showGrantsInfo.getPrivilegeType());
            row.put("admin_option", showGrantsInfo.getAdminOption());
            rows.add(row);
        }
        Collections.sort(rows, (r1, r2) -> {
            String table2;
            String schema2;
            String db2;
            String db1 = (String)r1.get("database_name");
            int dbCompare = MetadataAPIPostProcessor.compareNullableStrings(db1, db2 = (String)r2.get("database_name"));
            if (dbCompare != 0) {
                return dbCompare;
            }
            String schema1 = (String)r1.get("schema_name");
            int schemaCompare = MetadataAPIPostProcessor.compareNullableStrings(schema1, schema2 = (String)r2.get("schema_name"));
            if (schemaCompare != 0) {
                return schemaCompare;
            }
            String table1 = (String)r1.get("object_name");
            int tableCompare = MetadataAPIPostProcessor.compareNullableStrings(table1, table2 = (String)r2.get("object_name"));
            if (tableCompare != 0) {
                return tableCompare;
            }
            String priv1 = (String)r1.get("privilege_type");
            String priv2 = (String)r2.get("privilege_type");
            return MetadataAPIPostProcessor.compareNullableStrings(priv1, priv2);
        });
        for (Map map : rows) {
            byte[][] tuple = this.getEmptyTuple(this.GET_TABLE_PRIVILEGES_COLS, this.GET_TABLE_PRIVILEGES_COLS.length);
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.TABLE_CAT.getIndex()] = this.encodeStr((String)map.get("database_name"));
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr((String)map.get("schema_name"));
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.TABLE_NAME.getIndex()] = this.encodeStr((String)map.get("object_name"));
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.GRANTOR.getIndex()] = this.encodeStr((String)map.get("grantor_name"));
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.GRANTEE.getIndex()] = this.encodeStr((String)map.get("identity_name"));
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.PRIVILEGE.getIndex()] = this.encodeStr((String)map.get("privilege_type"));
            tuple[MetadataAPIHelper.GetTablePrivileges_Metadata.IS_GRANTABLE.getIndex()] = this.encodeStr(MetadataAPIPostProcessor.getIsGrantable((Boolean)map.get("admin_option")));
            tablePrivilegesTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_TABLE_PRIVILEGES_COLS, tablePrivilegesTuples);
    }

    private static int compareNullableStrings(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    protected ResultSet getProceduresPostProcessing(List<MetadataAPIHelper.ShowProceduresInfo> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getProceduresPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_PROCEDURES_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> proceduresTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ShowProceduresInfo resultSet : serverResultSets) {
            byte[][] tuple = this.getEmptyTuple(this.GET_PROCEDURES_COLS, this.GET_PROCEDURES_COLS.length);
            tuple[MetadataAPIHelper.GetProcedures_Metadata.PROCEDURE_CAT.getIndex()] = this.encodeStr(resultSet.getDatabaseName());
            tuple[MetadataAPIHelper.GetProcedures_Metadata.PROCEDURE_SCHEM.getIndex()] = this.encodeStr(resultSet.getSchemaName());
            tuple[MetadataAPIHelper.GetProcedures_Metadata.PROCEDURE_NAME.getIndex()] = this.encodeStr(resultSet.getProcedureName());
            tuple[MetadataAPIHelper.GetProcedures_Metadata.RESERVE1.getIndex()] = null;
            tuple[MetadataAPIHelper.GetProcedures_Metadata.RESERVE2.getIndex()] = null;
            tuple[MetadataAPIHelper.GetProcedures_Metadata.RESERVE3.getIndex()] = null;
            tuple[MetadataAPIHelper.GetProcedures_Metadata.REMARKS.getIndex()] = this.encodeStr("");
            tuple[MetadataAPIHelper.GetProcedures_Metadata.PROCEDURE_TYPE.getIndex()] = this.encodeStr(String.valueOf(MetadataAPIPostProcessor.getProcedureType(resultSet.getReturnType())));
            tuple[MetadataAPIHelper.GetProcedures_Metadata.SPECIFIC_NAME.getIndex()] = this.encodeStr(this.getSpecificName(resultSet.getProcedureName(), resultSet.getArgumentList()));
            proceduresTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_PROCEDURES_COLS, proceduresTuples);
    }

    protected ResultSet getProcedureColumnsPostProcessing(List<MetadataAPIHelper.ProcedureFunctionColumnData> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getProcedureColumnsPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_PROCEDURES_COLUMNS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> procedureColumnsTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ProcedureFunctionColumnData procRs : serverResultSets) {
            if (procRs == null) {
                if (!RedshiftLogger.isEnable()) continue;
                this.connection.getLogger().logDebug("Receive null intermediate data hence skipping post-processing", new Object[0]);
                continue;
            }
            List<MetadataAPIHelper.ShowParametersInfo> rs = procRs.getResultSet();
            for (MetadataAPIHelper.ShowParametersInfo paramInfo : rs) {
                String rsType;
                String dataType = paramInfo.getDataType();
                int precisions = 0;
                boolean dateTimeCustomizePrecision = false;
                if (dataType.matches("(time|timetz|timestamp|timestamptz)\\(\\d+\\).*") || dataType.matches("interval.*.\\(\\d+\\)")) {
                    rsType = this.getRSType(dataType.replaceAll("\\(\\d+\\)", "").replaceFirst("\\s++$", ""));
                    precisions = Integer.parseInt(dataType.replaceAll(".*\\(([0-9]+)\\).*", "$1"));
                    dateTimeCustomizePrecision = true;
                } else {
                    rsType = this.getRSType(dataType);
                }
                String sqlType = this.getSQLType(rsType);
                byte[][] tuple = this.getEmptyTuple(this.GET_PROCEDURES_COLUMNS_COLS, this.GET_PROCEDURES_COLUMNS_COLS.length);
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.PROCEDURE_CAT.getIndex()] = this.encodeStr(paramInfo.getDatabaseName());
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.PROCEDURE_SCHEM.getIndex()] = this.encodeStr(paramInfo.getSchemaName());
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.PROCEDURE_NAME.getIndex()] = this.encodeStr(paramInfo.getProcedureName());
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr(paramInfo.getParameterName());
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.COLUMN_TYPE.getIndex()] = this.encodeStr(String.valueOf(MetadataAPIPostProcessor.getProcedureColumnType(paramInfo.getParameterType())));
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.TYPE_NAME.getIndex()] = this.encodeStr(rsType);
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.PRECISION.getIndex()] = this.encodeStr(this.getColumnSize(rsType, paramInfo.getCharacterMaximumLength(), paramInfo.getNumericPrecision()));
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.LENGTH.getIndex()] = this.encodeStr(this.getColumnLength(rsType));
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.SCALE.getIndex()] = this.encodeStr(this.getDecimalDigit(rsType, paramInfo.getNumericScale(), precisions, dateTimeCustomizePrecision));
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.RADIX.getIndex()] = this.encodeStr("10");
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.NULLABLE.getIndex()] = this.encodeStr("2");
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.REMARKS.getIndex()] = this.encodeStr("");
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.COLUMN_DEF.getIndex()] = null;
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.SQL_DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.SQL_DATETIME_SUB.getIndex()] = null;
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.CHAR_OCTET_LENGTH.getIndex()] = null;
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.ORDINAL_POSITION.getIndex()] = this.encodeStr(paramInfo.getOrdinalPosition());
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.IS_NULLABLE.getIndex()] = this.encodeStr("");
                tuple[MetadataAPIHelper.GetProceduresColumns_Metadata.SPECIFIC_NAME.getIndex()] = this.encodeStr(procRs.getSpecificName());
                procedureColumnsTuples.add(new Tuple(tuple));
            }
        }
        return this.createRs(this.GET_PROCEDURES_COLUMNS_COLS, procedureColumnsTuples);
    }

    protected ResultSet getFunctionsPostProcessing(List<MetadataAPIHelper.ShowFunctionsInfo> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getFunctionsPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_FUNCTIONS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> functionsTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ShowFunctionsInfo resultSet : serverResultSets) {
            byte[][] tuple = this.getEmptyTuple(this.GET_FUNCTIONS_COLS, this.GET_FUNCTIONS_COLS.length);
            tuple[MetadataAPIHelper.GetFunctions_Metadata.FUNCTION_CAT.getIndex()] = this.encodeStr(resultSet.getDatabaseName());
            tuple[MetadataAPIHelper.GetFunctions_Metadata.FUNCTION_SCHEM.getIndex()] = this.encodeStr(resultSet.getSchemaName());
            tuple[MetadataAPIHelper.GetFunctions_Metadata.FUNCTION_NAME.getIndex()] = this.encodeStr(resultSet.getFunctionName());
            tuple[MetadataAPIHelper.GetFunctions_Metadata.REMARKS.getIndex()] = this.encodeStr("");
            tuple[MetadataAPIHelper.GetFunctions_Metadata.FUNCTION_TYPE.getIndex()] = this.encodeStr(String.valueOf(MetadataAPIPostProcessor.getFunctionType(resultSet.getReturnType())));
            tuple[MetadataAPIHelper.GetFunctions_Metadata.SPECIFIC_NAME.getIndex()] = this.encodeStr(this.getSpecificName(resultSet.getFunctionName(), resultSet.getArgumentList()));
            functionsTuples.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_FUNCTIONS_COLS, functionsTuples);
    }

    protected ResultSet getFunctionColumnsPostProcessing(List<MetadataAPIHelper.ProcedureFunctionColumnData> serverResultSets) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getFunctionColumnsPostProcessing", new Object[0]);
        }
        if (serverResultSets == null || serverResultSets.isEmpty()) {
            return this.createRs(this.GET_FUNCTIONS_COLUMNS_COLS, new ArrayList<Tuple>());
        }
        ArrayList<Tuple> functionColumnsTuples = new ArrayList<Tuple>();
        for (MetadataAPIHelper.ProcedureFunctionColumnData funcRs : serverResultSets) {
            if (funcRs == null) {
                if (!RedshiftLogger.isEnable()) continue;
                this.connection.getLogger().logDebug("Receive null intermediate data hence skipping post-processing", new Object[0]);
                continue;
            }
            List<MetadataAPIHelper.ShowParametersInfo> rs = funcRs.getResultSet();
            for (MetadataAPIHelper.ShowParametersInfo paramInfo : rs) {
                String rsType;
                String dataType = paramInfo.getDataType();
                int precisions = 0;
                boolean dateTimeCustomizePrecision = false;
                if (dataType.matches("(time|timetz|timestamp|timestamptz)\\(\\d+\\).*") || dataType.matches("interval.*.\\(\\d+\\)")) {
                    rsType = this.getRSType(dataType.replaceAll("\\(\\d+\\)", "").replaceFirst("\\s++$", ""));
                    precisions = Integer.parseInt(dataType.replaceAll(".*\\(([0-9]+)\\).*", "$1"));
                    dateTimeCustomizePrecision = true;
                } else {
                    rsType = this.getRSType(dataType);
                }
                String sqlType = this.getSQLType(rsType);
                byte[][] tuple = this.getEmptyTuple(this.GET_FUNCTIONS_COLUMNS_COLS, this.GET_FUNCTIONS_COLUMNS_COLS.length);
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.FUNCTION_CAT.getIndex()] = this.encodeStr(paramInfo.getDatabaseName());
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.FUNCTION_SCHEM.getIndex()] = this.encodeStr(paramInfo.getSchemaName());
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.FUNCTION_NAME.getIndex()] = this.encodeStr(paramInfo.getFunctionName());
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr(paramInfo.getParameterName());
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.COLUMN_TYPE.getIndex()] = this.encodeStr(String.valueOf(MetadataAPIPostProcessor.getFunctionColumnType(paramInfo.getParameterType())));
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.TYPE_NAME.getIndex()] = this.encodeStr(rsType);
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.PRECISION.getIndex()] = this.encodeStr(this.getColumnSize(rsType, paramInfo.getCharacterMaximumLength(), paramInfo.getNumericPrecision()));
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.LENGTH.getIndex()] = this.encodeStr(this.getColumnLength(rsType));
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.SCALE.getIndex()] = this.encodeStr(this.getDecimalDigit(rsType, paramInfo.getNumericScale(), precisions, dateTimeCustomizePrecision));
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.RADIX.getIndex()] = this.encodeStr("10");
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.NULLABLE.getIndex()] = this.encodeStr("2");
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.REMARKS.getIndex()] = this.encodeStr("");
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.CHAR_OCTET_LENGTH.getIndex()] = null;
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.ORDINAL_POSITION.getIndex()] = this.encodeStr(paramInfo.getOrdinalPosition());
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.IS_NULLABLE.getIndex()] = this.encodeStr("");
                tuple[MetadataAPIHelper.GetFunctionsColumns_Metadata.SPECIFIC_NAME.getIndex()] = this.encodeStr(funcRs.getSpecificName());
                functionColumnsTuples.add(new Tuple(tuple));
            }
        }
        return this.createRs(this.GET_FUNCTIONS_COLUMNS_COLS, functionColumnsTuples);
    }
}

