# How to set up the Active Directory server for Ubuntu clients

Active Directory requires policy files (`.admx` and `.adml`), which define the settings for configuring clients and the actions for managing users.

As a rule of thumb, we distinguish between the configuration of Ubuntu and Windows clients to avoid incompatibilities, such as:

* Namespace conflicts
* Slashes used for paths
* Platform-specific support for different configurations

(template-generations)=
## Generation of Ubuntu administrative templates

ADSys ships with pre-built Active Directory administrative templates that you can copy to your Active Directory server. 

To generate the templates that list Long Term Support ({term}`LTS`) Ubuntu releases, run:

```shell
adsysctl policy admx lts-only
```

These will list only the LTS releases of Ubuntu.

To generate templates for all supported releases:

```shell
adsysctl policy admx all
```

The commands generate two files --- `Ubuntu.adml` and `Ubuntu.admx` --- in the current directory. 

These files are the files that must be copied to your Active Directory server.

```{note}
You can find the latest version of these policy files in the [ADSys
repository](https://github.com/ubuntu/adsys/tree/main/policies). 

Not all of the keys in the latest version may be supported by a local `ADSys`
installation. Only templates generated by `adsysctl` match the version of your
client.

The policy files are also shipped as part of the `adsys-windows` package,
together with the [Active Directory Watch Daemon](../reference/adwatchd.md).
```

## Deployment of policy files on the Active Directory server

The administrative templates for Ubuntu must be deployed on your Active Directory server in the policy definition directory corresponding to your forest root. 

For example:

* For the `.admx` file: `\\example.com\sysvol\example.com\Policies\PolicyDefinitions` 
* For the `.adml` file: `\\example.com\sysvol\example.com\Policies\PolicyDefinitions\en-US`

Create these directories manually if they do not exist.

> Read the Microsoft documentation on ["creating and managing the Central Store"](https://docs.microsoft.com/en-us/troubleshoot/windows-client/group-policy/create-and-manage-central-store).

After deployment in Active Directory, Ubuntu specific settings for machines and users become available in the **Group Policy Management Editor**:

* Machines: `[Policy Name] > Computer Configuration > Policies > Administrative Templates > Ubuntu`
* Users: `[Policy Name] > User Configuration > Policies > Administrative Templates > Ubuntu`

![Ubuntu GPOs in Active Directory](../images/how-to/set-up-ad/gpo_editor-tree.png)

You can then select individual settings for configuration:

![Ubuntu Settings details page](../images/how-to/set-up-ad/gpo_editor-details.png)

## Recommended readings

* Show relevant documentation in the terminal with: `adsysctl help policy admx` or `man adsyctl-policy-admx`.
* Microsoft documentation on [creating and managing the Central Store](https://docs.microsoft.com/en-us/troubleshoot/windows-client/group-policy/create-and-manage-central-store).
