// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -fopenmp -fnoopenmp-use-tls -DBODY -triple x86_64-unknown-unknown -x c++ -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --check-prefixes=CHECK1
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -fnoopenmp-use-tls -DBODY -triple x86_64-unknown-unknown -x c++ -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --check-prefixes=CHECK2

// RUN: %clang_cc1 -verify -fopenmp-simd -fnoopenmp-use-tls -DBODY -triple x86_64-unknown-unknown -x c++ -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck --check-prefix SIMD1 %s
// RUN: %clang_cc1 -fopenmp-simd -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fnoopenmp-use-tls -DBODY -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -debug-info-kind=limited -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefix SIMD2 %s
// RUN: %clang_cc1 -verify -fopenmp -DBODY -triple x86_64-unknown-unknown -x c++ -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --check-prefixes=CHECK-TLS1
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -DBODY -triple x86_64-unknown-unknown -x c++ -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --check-prefixes=CHECK-TLS2
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -DBODY -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -debug-info-kind=limited -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefixes=CHECK-TLS3 %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -DBODY -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -debug-info-kind=limited -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefixes=CHECK-TLS4 %s

// RUN: %clang_cc1 -verify -fopenmp-simd -DBODY -triple x86_64-unknown-unknown -x c++ -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck --check-prefix SIMD3 %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -DBODY -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -debug-info-kind=limited -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefix SIMD4 %s

// RUN: %clang_cc1 -fopenmp -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fnoopenmp-use-tls -DBODY -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -debug-info-kind=limited -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefixes=DEBUG1 %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -fnoopenmp-use-tls -DBODY -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -debug-info-kind=limited -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck --check-prefixes=DEBUG2 %s

// expected-no-diagnostics
#ifndef HEADER
#define HEADER
struct S1 {
  int a;
  S1()
      : a(0) {
  }
  S1(int a)
      : a(a) {
  }
  S1(const S1 &s) {
    a = 12 + s.a;
  }
  ~S1() {
    a = 0;
  }
};

struct S2 {
  int a;
  double b;
  S2()
      : a(0) {
  }
  S2(int a)
      : a(a) {
  }
  S2(const S2 &s) {
    a = 12 + s.a;
  }
  ~S2() {
    a = 0;
  }
};

struct S3 {
  int a;
  float b;
  S3()
      : a(0) {
  }
  S3(int a)
      : a(a) {
  }
  S3(const S3 &s) {
    a = 12 + s.a;
  }
  ~S3() {
    a = 0;
  }
};

struct S4 {
  int a, b;
  S4()
      : a(0) {
  }
  S4(int a)
      : a(a) {
  }
  S4(const S4 &s) {
    a = 12 + s.a;
  }
  ~S4() {
    a = 0;
  }
};

struct S5 {
  int a, b, c;
  S5()
      : a(0) {
  }
  S5(int a)
      : a(a) {
  }
  S5(const S5 &s) {
    a = 12 + s.a;
  }
  ~S5() {
    a = 0;
  }
};

// CHECK-DAG:  [[GS1:@.+]] = internal global [[S1]] zeroinitializer
// CHECK-DAG:  [[GS1]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[DEFAULT_LOC:@.+]] = private unnamed_addr constant [[IDENT]] { i32 0, i32 2, i32 0, i32 0, ptr {{@.+}} }
// CHECK-DAG:  [[GS2:@.+]] = internal global [[S2]] zeroinitializer
// CHECK-DAG:  [[ARR_X:@.+]] ={{.*}} global [2 x [3 x [[S1]]]] zeroinitializer
// CHECK-DAG:  [[ARR_X]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[SM:@.+]] = internal global [[SMAIN]] zeroinitializer
// CHECK-DAG:  [[SM]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[STATIC_S:@.+]] = external global [[S3]]
// CHECK-DAG:  [[STATIC_S]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[GS3:@.+]] = external global [[S5]]
// CHECK-DAG:  [[GS3]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[ST_INT_ST:@.+]] = linkonce_odr global i32 23
// CHECK-DAG:  [[ST_INT_ST]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[ST_FLOAT_ST:@.+]] = linkonce_odr global float 2.300000e+01
// CHECK-DAG:  [[ST_FLOAT_ST]].cache. = common{{.*}} global ptr null
// CHECK-DAG:  [[ST_S4_ST:@.+]] = linkonce_odr global %struct.S4 zeroinitializer
// CHECK-DAG:  [[ST_S4_ST]].cache. = common{{.*}} global ptr null
// CHECK-NOT:  .cache. = common{{.*}} global ptr null
// There is no cache for gs2 - it is not threadprivate. Check that there is only
// 8 caches created (for Static::s, gs1, gs3, arr_x, main::sm, ST<int>::st,
// ST<float>::st, ST<S4>::st)
// CHECK-DEBUG-DAG: [[GS1:@.+]] = internal global [[S1]] zeroinitializer
// CHECK-DEBUG-DAG: [[GS2:@.+]] = internal global [[S2]] zeroinitializer
// CHECK-DEBUG-DAG: [[ARR_X:@.+]] ={{.*}} global [2 x [3 x [[S1]]]] zeroinitializer
// CHECK-DEBUG-DAG: [[SM:@.+]] = internal global [[SMAIN]] zeroinitializer
// CHECK-DEBUG-DAG: [[STATIC_S:@.+]] = external global [[S3]]
// CHECK-DEBUG-DAG: [[GS3:@.+]] = external global [[S5]]
// CHECK-DEBUG-DAG: [[ST_INT_ST:@.+]] = linkonce_odr global i32 23
// CHECK-DEBUG-DAG: [[ST_FLOAT_ST:@.+]] = linkonce_odr global float 2.300000e+01
// CHECK-DEBUG-DAG: [[ST_S4_ST:@.+]] = linkonce_odr global %struct.S4 zeroinitializer

// CHECK-DEBUG-DAG: [[LOC1:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;;249;1;;\00"
// CHECK-DEBUG-DAG: [[ID1:@.*]] = private unnamed_addr constant %struct.ident_t { {{.*}} [[LOC1]]
// CHECK-DEBUG-DAG: [[LOC2:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;;304;1;;\00"
// CHECK-DEBUG-DAG: [[ID2:@.*]] = private unnamed_addr constant %struct.ident_t { {{.*}} [[LOC2]]
// CHECK-DEBUG-DAG: [[LOC3:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;;422;19;;\00"
// CHECK-DEBUG-DAG: [[LOC4:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;459;1;;\00"
// CHECK-DEBUG-DAG: [[LOC5:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;476;9;;\00"
// CHECK-DEBUG-DAG: [[LOC6:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;498;10;;\00"
// CHECK-DEBUG-DAG: [[LOC7:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;521;10;;\00"
// CHECK-DEBUG-DAG: [[LOC8:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;557;10;;\00"
// CHECK-DEBUG-DAG: [[LOC9:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;586;10;;\00"
// CHECK-DEBUG-DAG: [[LOC10:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;606;10;;\00"
// CHECK-DEBUG-DAG: [[LOC11:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;629;27;;\00"
// CHECK-DEBUG-DAG: [[LOC12:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;main;652;10;;\00"
// CHECK-DEBUG-DAG: [[LOC13:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;774;9;;\00"
// CHECK-DEBUG-DAG: [[LOC14:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;797;10;;\00"
// CHECK-DEBUG-DAG: [[LOC15:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;833;10;;\00"
// CHECK-DEBUG-DAG: [[LOC16:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;862;10;;\00"
// CHECK-DEBUG-DAG: [[LOC17:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;882;10;;\00"
// CHECK-DEBUG-DAG: [[LOC18:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;905;27;;\00"
// CHECK-DEBUG-DAG: [[LOC19:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;foobar;928;10;;\00"
// CHECK-DEBUG-DAG: [[LOC20:@.*]] = private unnamed_addr constant [{{[0-9]+}} x i8] c";{{.*}}threadprivate_codegen.cpp;;363;1;;\00"

// CHECK-TLS-DAG:  [[GS1:@.+]] = internal thread_local global [[S1]] zeroinitializer
// CHECK-TLS-DAG:  [[GS2:@.+]] = internal global [[S2]] zeroinitializer
// CHECK-TLS-DAG:  [[ARR_X:@.+]] ={{.*}} thread_local global [2 x [3 x [[S1]]]] zeroinitializer
// CHECK-TLS-DAG:  [[SM:@.+]] = internal thread_local global [[SMAIN]] zeroinitializer
// CHECK-TLS-DAG:  [[SM_GUARD:@_ZGVZ4mainE2sm]] = internal thread_local global i8 0
// CHECK-TLS-DAG:  [[STATIC_S:@.+]] = external thread_local global [[S3]]
// CHECK-TLS-DAG:  [[GS3:@.+]] = external thread_local global [[S5]]
// CHECK-TLS-DAG:  [[ST_INT_ST:@.+]] = linkonce_odr thread_local global i32 23
// CHECK-TLS-DAG:  [[ST_FLOAT_ST:@.+]] = linkonce_odr thread_local global float 2.300000e+01
// CHECK-TLS-DAG:  [[ST_S4_ST:@.+]] = linkonce_odr thread_local global %struct.S4 zeroinitializer
// CHECK-TLS-DAG:  [[ST_S4_ST_GUARD:@_ZGVN2STI2S4E2stE]] = linkonce_odr thread_local global i64 0
// CHECK-TLS-DAG:  @__tls_guard = internal thread_local global i8 0
// CHECK-TLS-DAG:  @__dso_handle = external hidden global i8
// CHECK-TLS-DAG:  [[GS1_TLS_INIT:@_ZTHL3gs1]] = internal alias void (), ptr @__tls_init
// CHECK-TLS-DAG:  [[ARR_X_TLS_INIT:@_ZTH5arr_x]] ={{.*}} alias void (), ptr @__tls_init
// CHECK-TLS-DAG:  [[ST_S4_ST_TLS_INIT:@_ZTHN2STI2S4E2stE]] = linkonce_odr alias void (), ptr [[ST_S4_ST_CXX_INIT:@[^, ]*]]

// OMP50-TLS: define internal void [[GS1_CXX_INIT:@.*]]()
// OMP50-TLS: call void [[GS1_CTOR1:@.*]](ptr {{[^,]*}} [[GS1]], i32 5)
// OMP50-TLS: call i32 @__cxa_thread_atexit(ptr [[GS1_DTOR1:.*]], ptr [[GS1]]
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[GS1_CTOR1]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: call void [[GS1_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[GS1_DTOR1]](ptr {{.*}})
// OMP50-TLS: call void [[GS1_DTOR2:@.*]](ptr {{.*}})
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[GS1_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: define {{.*}}void [[GS1_DTOR2]](ptr {{.*}})

// OMP50-TLS: define internal void [[GS2_CXX_INIT:@.*]]()
// OMP50-TLS: call void [[GS2_CTOR1:@.*]](ptr {{[^,]*}} [[GS2]], i32 27)
// OMP50-TLS: call i32 @__cxa_atexit(ptr [[GS2_DTOR1:.*]], ptr [[GS2]]
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[GS2_CTOR1]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: call void [[GS2_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[GS2_DTOR1]](ptr {{.*}})
// OMP50-TLS: call void [[GS2_DTOR2:@.*]](ptr {{.*}})
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[GS2_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: define {{.*}}void [[GS2_DTOR2]](ptr {{.*}})

// OMP50-TLS: define internal void [[ARR_X_CXX_INIT:@.*]]()
// OMP50-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 0, i{{.*}} 0), i{{.*}} 1)
// OMP50-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 0, i{{.*}} 1), i{{.*}} 2)
// OMP50-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 0, i{{.*}} 2), i{{.*}} 3)
// OMP50-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 1, i{{.*}} 0), i{{.*}} 4)
// OMP50-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 1, i{{.*}} 1), i{{.*}} 5)
// OMP50-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 1, i{{.*}} 2), i{{.*}} 6)
// OMP50-TLS: call i32 @__cxa_thread_atexit(ptr [[ARR_X_CXX_DTOR:@[^,]+]]
// OMP50-TLS: define internal void [[ARR_X_CXX_DTOR]](ptr %0)
// OMP50-TLS: void [[GS1_DTOR1]](ptr {{.*}})

struct Static {
  static S3 s;
#pragma omp threadprivate(s)
};

static S1 gs1(5);
#pragma omp threadprivate(gs1)
#pragma omp threadprivate(gs1)
// CHECK:      define {{.*}} [[S1_CTOR:@.*]](ptr {{.*}},
// CHECK:      define {{.*}} [[S1_DTOR:@.*]](ptr {{.*}})
// CHECK:      define internal {{.*}}ptr [[GS1_CTOR:@\.__kmpc_global_ctor_\..*]](ptr %0)
// CHECK:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-NEXT: call {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARG]], {{.*}} 5)
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK:      ret ptr [[ARG]]
// CHECK-NEXT: }
// CHECK:      define internal {{.*}}void [[GS1_DTOR:@\.__kmpc_global_dtor_\..*]](ptr %0)
// CHECK:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-NEXT: call {{.*}} [[S1_DTOR]](ptr {{[^,]*}} [[ARG]])
// CHECK-NEXT: ret void
// CHECK-NEXT: }
// CHECK:      define internal {{.*}}void [[GS1_INIT:@\.__omp_threadprivate_init_\..*]]()
// CHECK:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[DEFAULT_LOC]], ptr [[GS1]], ptr [[GS1_CTOR]], ptr null, ptr [[GS1_DTOR]])
// CHECK-NEXT: ret void
// CHECK-NEXT: }



// CHECK-DEBUG:      @__kmpc_global_thread_num
// CHECK-DEBUG:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[ID1]], ptr [[GS1]], ptr [[GS1_CTOR:@\.__kmpc_global_ctor_\..*]], ptr null, ptr [[GS1_DTOR:@\.__kmpc_global_dtor_\..*]])
// CHECK-DEBUG:      define internal {{.*}}ptr [[GS1_CTOR]](ptr %0)
// CHECK-DEBUG:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK-DEBUG:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-DEBUG-NEXT: call {{.*}} [[S1_CTOR:@.+]](ptr {{[^,]*}} [[ARG]], {{.*}} 5){{.*}}, !dbg
// CHECK-DEBUG:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-DEBUG:      ret ptr [[ARG]]
// CHECK-DEBUG-NEXT: }
// CHECK-DEBUG:      define {{.*}} [[S1_CTOR]](ptr {{.*}},
// CHECK-DEBUG:      define internal {{.*}}void [[GS1_DTOR]](ptr %0)
// CHECK-DEBUG:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK-DEBUG:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-DEBUG-NEXT: call {{.*}} [[S1_DTOR:@.+]](ptr {{[^,]*}} [[ARG]]){{.*}}, !dbg
// CHECK-DEBUG-NEXT: ret void
// CHECK-DEBUG-NEXT: }
// CHECK-DEBUG:      define {{.*}} [[S1_DTOR]](ptr {{.*}})
static S2 gs2(27);
// CHECK:      define {{.*}} [[S2_CTOR:@.*]](ptr {{.*}},
// CHECK:      define {{.*}} [[S2_DTOR:@.*]](ptr {{.*}})
// No another call for S2 constructor because it is not threadprivate
// CHECK-NOT:  call {{.*}} [[S2_CTOR]](ptr
// CHECK-DEBUG:      define {{.*}} [[S2_CTOR:@.*]](ptr {{.*}},
// CHECK-DEBUG:      define {{.*}} [[S2_DTOR:@.*]](ptr {{.*}})
// No another call for S2 constructor because it is not threadprivate
// CHECK-DEBUG-NOT:  call {{.*}} [[S2_CTOR]](ptr
S1 arr_x[2][3] = { { 1, 2, 3 }, { 4, 5, 6 } };
#pragma omp threadprivate(arr_x)
// CHECK:      define internal {{.*}}ptr [[ARR_X_CTOR:@\.__kmpc_global_ctor_\..*]](ptr %0)
// CHECK:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK:      [[ARR1:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARG]], i{{.*}} 0, i{{.*}} 0
// CHECK:      [[ARR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR1]], i{{.*}} 0, i{{.*}} 0
// CHECK:      invoke {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARR]], [[INT]] {{.*}}1)
// CHECK:      [[ARR_ELEMENT:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR]], i{{.*}} 1
// CHECK:      invoke {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARR_ELEMENT]], [[INT]] {{.*}}2)
// CHECK:      [[ARR_ELEMENT2:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_ELEMENT]], i{{.*}} 1
// CHECK:      invoke {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARR_ELEMENT2]], [[INT]] {{.*}}3)
// CHECK:      [[ARR_ELEMENT3:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR1]], i{{.*}} 1
// CHECK:      [[ARR_:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_ELEMENT3]], i{{.*}} 0, i{{.*}} 0
// CHECK:      invoke {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARR_]], [[INT]] {{.*}}4)
// CHECK:      [[ARR_ELEMENT:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_]], i{{.*}} 1
// CHECK:      invoke {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARR_ELEMENT]], [[INT]] {{.*}}5)
// CHECK:      [[ARR_ELEMENT2:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_ELEMENT]], i{{.*}} 1
// CHECK:      invoke {{.*}} [[S1_CTOR]](ptr {{[^,]*}} [[ARR_ELEMENT2]], [[INT]] {{.*}}6)
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK:      ret ptr [[ARG]]
// CHECK:      }
// CHECK:      define internal {{.*}}void [[ARR_X_DTOR:@\.__kmpc_global_dtor_\..*]](ptr %0)
// CHECK:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-NEXT: [[ARR_CUR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARG]], i{{.*}} 6
// CHECK-NEXT: br label %[[ARR_LOOP:.*]]
// CHECK:      {{.*}}[[ARR_LOOP]]{{.*}}
// CHECK-NEXT: [[ARR_ELEMENTPAST:%.*]] = phi ptr [ [[ARR_CUR]], {{.*}} ], [ [[ARR_ELEMENT:%.*]], {{.*}} ]
// CHECK-NEXT: [[ARR_ELEMENT:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_ELEMENTPAST]], i{{.*}} -1
// CHECK-NEXT: {{call|invoke}} {{.*}} [[S1_DTOR]](ptr {{[^,]*}} [[ARR_ELEMENT]])
// CHECK:      [[ARR_DONE:%.*]] = icmp eq ptr [[ARR_ELEMENT]], [[ARG]]
// CHECK-NEXT: br i1 [[ARR_DONE]], label %[[ARR_EXIT:.*]], label %[[ARR_LOOP]]
// CHECK:      {{.*}}[[ARR_EXIT]]{{.*}}
// CHECK-NEXT: ret void
// CHECK:      }
// CHECK:      define internal {{.*}}void [[ARR_X_INIT:@\.__omp_threadprivate_init_\..*]]()
// CHECK:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[DEFAULT_LOC]], ptr [[ARR_X]], ptr [[ARR_X_CTOR]], ptr null, ptr [[ARR_X_DTOR]])
// CHECK-NEXT: ret void
// CHECK-NEXT: }



// CHECK-DEBUG:      @__kmpc_global_thread_num
// CHECK-DEBUG:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[ID2]], ptr [[ARR_X]], ptr [[ARR_X_CTOR:@\.__kmpc_global_ctor_\..*]], ptr null, ptr [[ARR_X_DTOR:@\.__kmpc_global_dtor_\..*]])
// CHECK-DEBUG:      define internal {{.*}}ptr [[ARR_X_CTOR]](ptr %0)
// CHECK-DEBUG:      }
// CHECK-DEBUG:      define internal {{.*}}void [[ARR_X_DTOR]](ptr %0)
// CHECK-DEBUG:      }
extern S5 gs3;
#pragma omp threadprivate(gs3)
// No call for S5 constructor because gs3 has just declaration, not a definition.
// CHECK-NOT:  call {{.*}}(ptr
// CHECK-DEBUG-NOT:  call {{.*}}(ptr

template <class T>
struct ST {
  static T st;
#pragma omp threadprivate(st)
};





// OMP50-DEBUG:      @__kmpc_global_thread_num
// OMP50-DEBUG:      call {{.*}}void @__kmpc_threadprivate_register(ptr {{.*}}, ptr [[ST_S4_ST]], ptr [[ST_S4_ST_CTOR:@\.__kmpc_global_ctor_\..+]], ptr null, ptr [[ST_S4_ST_DTOR:@\.__kmpc_global_dtor_\..+]])
// OMP50-DEBUG:      define internal {{.*}}ptr [[ST_S4_ST_CTOR]](ptr %0)
// OMP50-DEBUG:      }
// OMP50-DEBUG:      define {{.*}} [[S4_CTOR:@.*]](ptr {{.*}},
// OMP50-DEBUG:      define internal {{.*}}void [[ST_S4_ST_DTOR]](ptr %0)
// OMP50-DEBUG:      }
// OMP50-DEBUG:      define {{.*}} [[S4_DTOR:@.*]](ptr {{.*}})

// OMP50:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[DEFAULT_LOC]], ptr [[ST_S4_ST]], ptr [[ST_S4_ST_CTOR:@\.__kmpc_global_ctor_\..+]], ptr null, ptr [[ST_S4_ST_DTOR:@\.__kmpc_global_dtor_\..+]])
// OMP50:      define internal {{.*}}ptr [[ST_S4_ST_CTOR]](ptr %0)
// OMP50:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// OMP50:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// OMP50-NEXT: call {{.*}} [[S4_CTOR:@.+]](ptr {{[^,]*}} [[ARG]], {{.*}} 23)
// OMP50:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// OMP50-NEXT: ret ptr [[ARG]]
// OMP50-NEXT: }
// OMP50:      define {{.*}} [[S4_CTOR]](ptr {{.*}},
// OMP50:      define internal {{.*}}void [[ST_S4_ST_DTOR]](ptr %0)
// OMP50:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// OMP50:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// OMP50-NEXT: call {{.*}} [[S4_DTOR:@.+]](ptr {{[^,]*}} [[ARG]])
// OMP50-NEXT: ret void
// OMP50-NEXT: }
// OMP50:      define {{.*}} [[S4_DTOR]](ptr {{[^,]*}} {{.*}})
template <class T>
T ST<T>::st(23);

// CHECK-LABEL:  @main()
// CHECK-DEBUG-LABEL: @main()
int main() {

  int Res;
  struct Smain {
    int a;
    double b, c;
    Smain()
        : a(0) {
    }
    Smain(int a)
        : a(a) {
    }
    Smain(const Smain &s) {
      a = 12 + s.a;
    }
    ~Smain() {
      a = 0;
    }
  };

  static Smain sm(gs1.a);
// CHECK:      [[THREAD_NUM:%.+]] = call {{.*}}i32 @__kmpc_global_thread_num(ptr [[DEFAULT_LOC]])
// CHECK:      call {{.*}}i{{.*}} @__cxa_guard_acquire
// CHECK:      call {{.*}}i32 @__kmpc_global_thread_num(ptr [[DEFAULT_LOC]])
// CHECK:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[DEFAULT_LOC]], ptr [[SM]], ptr [[SM_CTOR:@\.__kmpc_global_ctor_\..+]], ptr null, ptr [[SM_DTOR:@\.__kmpc_global_dtor_\..+]])
// CHECK:      [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr [[GS1]].cache.)
// CHECK-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
// CHECK-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
// CHECK-NEXT: invoke {{.*}} [[SMAIN_CTOR:.*]](ptr {{[^,]*}} [[SM]], [[INT]] {{.*}}[[GS1_A]])
// CHECK:      call {{.*}}void @__cxa_guard_release



// CHECK-DEBUG:      call {{.*}}i{{.*}} @__cxa_guard_acquire
// CHECK-DEBUG:      call {{.*}}i32 @__kmpc_global_thread_num(ptr [[KMPC_LOC:@.+]])
// CHECK-DEBUG:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[KMPC_LOC]], ptr [[SM]], ptr [[SM_CTOR:@\.__kmpc_global_ctor_\..+]], ptr null, ptr [[SM_DTOR:@\.__kmpc_global_dtor_\..+]])
// CHECK-DEBUG:      [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr


// CHECK-DEBUG-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
// CHECK-DEBUG-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
// CHECK-DEBUG-NEXT: invoke {{.*}} [[SMAIN_CTOR:.*]](ptr {{[^,]*}} [[SM]], [[INT]] {{.*}}[[GS1_A]])
// CHECK-DEBUG:      call {{.*}}void @__cxa_guard_release
// CHECK-TLS:      [[IS_INIT_INT:%.*]] = load i8, ptr [[SM_GUARD]]
// CHECK-TLS-NEXT: [[IS_INIT_BOOL:%.*]] = icmp eq i8 [[IS_INIT_INT]], 0
// CHECK-TLS-NEXT: br i1 [[IS_INIT_BOOL]], label %[[INIT_LABEL:.*]], label %[[INIT_DONE:[^,]+]]{{.*}}
// CHECK-TLS:      [[INIT_LABEL]]
// CHECK-TLS-NEXT: [[GS1_ADDR:%.*]] = call ptr [[GS1_TLS_INITD:@[^,]+]]
// CHECK-TLS-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_ADDR]], i32 0, i32 0
// CHECK-TLS-NEXT: [[GS1_A_VAL:%.*]] = load i32, ptr [[GS1_A_ADDR]]
// CHECK-TLS-NEXT: call void [[SM_CTOR1:@.*]](ptr {{[^,]*}} [[SM]], i32 [[GS1_A_VAL]])
// CHECK-TLS-NEXT: call i32 @__cxa_thread_atexit(ptr [[SM_DTOR1:@.*]], ptr [[SM]], ptr @__dso_handle)
// CHECK-TLS-NEXT: store i8 1, ptr [[SM_GUARD]]
// CHECK-TLS-NEXT: br label %[[INIT_DONE]]
// CHECK-TLS:      [[INIT_DONE]]
#pragma omp threadprivate(sm)
  // CHECK:      [[STATIC_S_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[STATIC_S]], i{{.*}} {{[0-9]+}}, ptr [[STATIC_S]].cache.)
  // CHECK-NEXT: [[STATIC_S_A_ADDR:%.*]] = getelementptr inbounds [[S3]], ptr [[STATIC_S_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[STATIC_S_A:%.*]] = load [[INT]], ptr [[STATIC_S_A_ADDR]]
  // CHECK-NEXT: store [[INT]] [[STATIC_S_A]], ptr [[RES_ADDR:[^,]+]]
  // CHECK-DEBUG:[[STATIC_S_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[STATIC_S]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[STATIC_S_A_ADDR:%.*]] = getelementptr inbounds [[S3]], ptr [[STATIC_S_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[STATIC_S_A:%.*]] = load [[INT]], ptr [[STATIC_S_A_ADDR]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[STATIC_S_A]], ptr [[RES_ADDR:[^,]+]]
  // CHECK-TLS:      [[STATIC_S_ADDR:%.*]] = call ptr [[STATIC_S_TLS_INITD:@[^,]+]]
  // CHECK-TLS-NEXT: [[STATIC_S_A_ADDR:%.*]] = getelementptr inbounds [[S3]], ptr [[STATIC_S_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[STATIC_S_A:%.*]] = load i32, ptr [[STATIC_S_A_ADDR]]
  // CHECK-TLS-NEXT: store i32 [[STATIC_S_A]], ptr [[RES_ADDR:[^,]+]]
  Res = Static::s.a;
  // CHECK:      [[SM_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[SM]], i{{.*}} {{[0-9]+}}, ptr [[SM]].cache.)
  // CHECK-NEXT: [[SM_A_ADDR:%.*]] = getelementptr inbounds [[SMAIN]], ptr [[SM_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[SM_A:%.*]] = load [[INT]], ptr [[SM_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[SM_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[SM_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[SM]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[SM_A_ADDR:%.*]] = getelementptr inbounds [[SMAIN]], ptr [[SM_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[SM_A:%.*]] = load [[INT]], ptr [[SM_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[SM_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // [[SM]] was initialized already, so it can be used directly
  // CHECK-TLS:      [[SM_A:%.*]] = load i32, ptr getelementptr inbounds ([[SMAIN]], ptr [[SM]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-TLS-NEXT: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[SM_A]]
  // CHECK-TLS-NEXT: store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += sm.a;
  // CHECK:      [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr [[GS1]].cache.)
  // CHECK-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS1_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS1_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[GS1_ADDR:%.*]] = call ptr [[GS1_TLS_INITD]]
  // CHECK-TLS-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[GS1_A:%.*]] = load i32, ptr [[GS1_A_ADDR]]
  // CHECK-TLS-NEXT: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[GS1_A]]
  // CHECK-TLS-NEXT: store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += gs1.a;
  // CHECK:      [[GS2_A:%.*]] = load [[INT]], ptr getelementptr inbounds ([[S2]], ptr [[GS2]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS2_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG:      [[GS2_A:%.*]] = load [[INT]], ptr getelementptr inbounds ([[S2]], ptr [[GS2]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS2_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[GS2_A:%.*]] = load [[INT]], ptr getelementptr inbounds ([[S2]], ptr [[GS2]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-TLS-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS2_A]]
  // CHECK-TLS-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  Res += gs2.a;
  // CHECK:      [[GS3_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[GS3]], i{{.*}} {{[0-9]+}}, ptr [[GS3]].cache.)
  // CHECK-NEXT: [[GS3_A_ADDR:%.*]] = getelementptr inbounds [[S5]], ptr [[GS3_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[GS3_A:%.*]] = load [[INT]], ptr [[GS3_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS3_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[GS3_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[GS3]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[GS3_A_ADDR:%.*]] = getelementptr inbounds [[S5]], ptr [[GS3_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[GS3_A:%.*]] = load [[INT]], ptr [[GS3_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS3_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[GS3_ADDR:%.*]] = call ptr [[GS3_TLS_INITD:[^,]+]]
  // CHECK-TLS-NEXT: [[GS3_A_ADDR:%.*]] = getelementptr inbounds [[S5]], ptr [[GS3_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[GS3_A:%.*]] = load i32, ptr [[GS3_A_ADDR]]
  // CHECK-TLS-NEXT: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add nsw i32 [[RES]], [[GS3_A]]
  // CHECK-TLS-NEXT: store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += gs3.a;
  // CHECK:      [[ARR_X_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ARR_X]], i{{.*}} {{[0-9]+}}, ptr [[ARR_X]].cache.)
  // CHECK-NEXT: [[ARR_X_1_ADDR:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARR_X_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-NEXT: [[ARR_X_1_1_ADDR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_X_1_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-NEXT: [[ARR_X_1_1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_X_1_1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[ARR_X_1_1_A:%.*]] = load [[INT]], ptr [[ARR_X_1_1_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ARR_X_1_1_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT:      [[ARR_X_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ARR_X]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ARR_X_1_ADDR:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARR_X_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-DEBUG-NEXT: [[ARR_X_1_1_ADDR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_X_1_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-DEBUG-NEXT: [[ARR_X_1_1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_X_1_1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[ARR_X_1_1_A:%.*]] = load [[INT]], ptr [[ARR_X_1_1_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ARR_X_1_1_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:       [[ARR_X_ADDR:%.*]] = call ptr [[ARR_X_TLS_INITD:[^,]+]]
  // CHECK-TLS-NEXT:  [[ARR_X_1_ADDR:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARR_X_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-TLS-NEXT:  [[ARR_X_1_1_ADDR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_X_1_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-TLS-NEXT:  [[ARR_X_1_1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_X_1_1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT:  [[ARR_X_1_1_A:%.*]] = load i32, ptr [[ARR_X_1_1_A_ADDR]]
  // CHECK-TLS-NEXT:  [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT:  [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[ARR_X_1_1_A]]
  // CHECK-TLS-NEXT:  store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += arr_x[1][1].a;
  // CHECK:      [[ST_INT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ST_INT_ST]], i{{.*}} {{[0-9]+}}, ptr [[ST_INT_ST]].cache.)
  // CHECK-NEXT: [[ST_INT_ST_VAL:%.*]] = load [[INT]], ptr [[ST_INT_ST_TEMP_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_INT_ST_VAL]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[ST_INT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ST_INT_ST]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ST_INT_ST_VAL:%.*]] = load [[INT]], ptr [[ST_INT_ST_TEMP_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_INT_ST_VAL]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:       [[ST_INT_ST_VAL:%.*]] = load i32, ptr [[ST_INT_ST_ADDR:[^,]+]]
  // CHECK-TLS-NEXT:  [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT:  [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[ST_INT_ST_VAL]]
  // CHECK-TLS-NEXT:  store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += ST<int>::st;
  // CHECK:      [[ST_FLOAT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ST_FLOAT_ST]], i{{.*}} {{[0-9]+}}, ptr [[ST_FLOAT_ST]].cache.)
  // CHECK-NEXT: [[ST_FLOAT_ST_VAL:%.*]] = load float, ptr [[ST_FLOAT_ST_TEMP_ADDR]]
  // CHECK-NEXT: [[FLOAT_TO_INT_CONV:%.*]] = fptosi float [[ST_FLOAT_ST_VAL]] to [[INT]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[FLOAT_TO_INT_CONV]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[ST_FLOAT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ST_FLOAT_ST]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ST_FLOAT_ST_VAL:%.*]] = load float, ptr [[ST_FLOAT_ST_TEMP_ADDR]]
  // CHECK-DEBUG-NEXT: [[FLOAT_TO_INT_CONV:%.*]] = fptosi float [[ST_FLOAT_ST_VAL]] to [[INT]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[FLOAT_TO_INT_CONV]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[ST_FLOAT_ST_VAL:%.*]]  = load float, ptr [[ST_FLOAT_ST_ADDR:[^,]+]]
  // CHECK-TLS-NEXT: [[FLOAT_TO_INT_CONV:%.*]] = fptosi float [[ST_FLOAT_ST_VAL]]  to i32
  // CHECK-TLS-NEXT: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[FLOAT_TO_INT_CONV]]
  // CHECK-TLS-NEXT: store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += static_cast<int>(ST<float>::st);
  // CHECK:      [[ST_S4_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ST_S4_ST]], i{{.*}} {{[0-9]+}}, ptr [[ST_S4_ST]].cache.)
  // CHECK-NEXT: [[ST_S4_ST_A_ADDR:%.*]] = getelementptr inbounds [[S4]], ptr [[ST_S4_ST_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[ST_S4_ST_A:%.*]] = load [[INT]], ptr [[ST_S4_ST_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_S4_ST_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[ST_S4_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ST_S4_ST]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ST_S4_ST_A_ADDR:%.*]] = getelementptr inbounds [[S4]], ptr [[ST_S4_ST_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[ST_S4_ST_A:%.*]] = load [[INT]], ptr [[ST_S4_ST_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_S4_ST_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:       [[ST_S4_ST_ADDR:%.*]] = call ptr [[ST_S4_ST_TLS_INITD:[^,]+]]
  // CHECK-TLS-NEXT:  [[ST_S4_ST_A_ADDR:%.*]] = getelementptr inbounds [[S4]], ptr [[ST_S4_ST_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT:  [[ST_S4_ST_A:%.*]] = load i32, ptr [[ST_S4_ST_A_ADDR]]
  // CHECK-TLS-NEXT:  [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT:  [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[ST_S4_ST_A]]
  // CHECK-TLS-NEXT:  store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += ST<S4>::st.a;
  // CHECK:      [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: ret [[INT]] [[RES]]
  // CHECK-DEBUG:      [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: ret [[INT]] [[RES]]
  // CHECK-TLS:      [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: ret i32 [[RES]]
  return Res;
}
// CHECK: }

// CHECK:      define internal {{.*}}ptr [[SM_CTOR]](ptr %0)
// CHECK:      [[THREAD_NUM:%.+]] = call {{.*}}i32 @__kmpc_global_thread_num(ptr [[DEFAULT_LOC]])
// CHECK:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK:      [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr [[GS1]].cache.)
// CHECK-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
// CHECK-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
// CHECK-NEXT: call {{.*}} [[SMAIN_CTOR:@.+]](ptr {{[^,]*}} [[ARG]], [[INT]] {{.*}}[[GS1_A]])
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-NEXT: ret ptr [[ARG]]
// CHECK-NEXT: }
// CHECK:      define {{.*}} [[SMAIN_CTOR]](ptr {{.*}},
// CHECK:      define internal {{.*}}void [[SM_DTOR]](ptr %0)
// CHECK:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-NEXT: call {{.*}} [[SMAIN_DTOR:@.+]](ptr {{[^,]*}} [[ARG]])
// CHECK-NEXT: ret void
// CHECK-NEXT: }
// CHECK:      define {{.*}} [[SMAIN_DTOR]](ptr {{.*}})
// CHECK-DEBUG:      define internal {{.*}}ptr [[SM_CTOR]](ptr %0)
// CHECK-DEBUG:      [[THREAD_NUM:%.+]] = call {{.*}}i32 @__kmpc_global_thread_num(ptr {{.*}})



// CHECK-DEBUG:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// CHECK-DEBUG:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-DEBUG:      [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr


// CHECK-DEBUG-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
// CHECK-DEBUG-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
// CHECK-DEBUG-NEXT: call {{.*}} [[SMAIN_CTOR:@.+]](ptr {{[^,]*}} [[ARG]], [[INT]] {{.*}}[[GS1_A]])
// CHECK-DEBUG:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// CHECK-DEBUG-NEXT: ret ptr [[ARG]]
// CHECK-DEBUG-NEXT: }
// CHECK-DEBUG:      define {{.*}} [[SMAIN_CTOR]](ptr {{.*}},
// CHECK-DEBUG:      define internal {{.*}} [[SM_DTOR:@.+]](ptr %0)
// CHECK-DEBUG:      call {{.*}} [[SMAIN_DTOR:@.+]](ptr
// CHECK-DEBUG:      }
// CHECK-DEBUG:      define {{.*}} [[SMAIN_DTOR]](ptr {{.*}})
// CHECK-TLS:      define internal ptr [[GS1_TLS_INITD]] {{#[0-9]+}} {
// CHECK-TLS-NEXT: call void [[GS1_TLS_INIT]]
// CHECK-TLS-NEXT: ret ptr [[GS1]]
// CHECK-TLS-NEXT: }
// CHECK-TLS: define internal void [[SM_CTOR1]](ptr {{[^,]*}} %this, i32 {{.*}}) {{.*}} {
// CHECK-TLS: void [[SM_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// CHECK-TLS: }
// CHECK-TLS: define internal void [[SM_DTOR1]](ptr {{[^,]*}} %this) {{.*}} {
// CHECK-TLS: void [[SM_DTOR2:@.*]](ptr {{.*}})
// CHECK-TLS: }
// CHECK-TLS: define {{.*}} ptr [[STATIC_S_TLS_INITD]]
// CHECK-TLS: call void [[STATIC_S_TLS_INIT:[^,]+]]
// CHECK-TLS: ret ptr [[STATIC_S]]
// CHECK-TLS: }
// CHECK-TLS: define {{.*}} ptr [[GS3_TLS_INITD]]
// CHECK-TLS:   call void [[GS3_TLS_INIT:@[^,]+]]
// CHECK-TLS:   ret ptr [[GS3]]
// CHECK-TLS: }
// CHECK-TLS: define {{.*}} ptr [[ARR_X_TLS_INITD]]
// CHECK-TLS:   call void [[ARR_X_TLS_INIT]]
// CHECK-TLS:   ret ptr [[ARR_X]]
// CHECK-TLS: }
// CHECK-TLS: define {{.*}} ptr [[ST_S4_ST_TLS_INITD]] {{#[0-9]+}} comdat {
// CHECK-TLS:   call void [[ST_S4_ST_TLS_INIT]]
// CHECK-TLS:   ret ptr [[ST_S4_ST]]
// CHECK-TLS: }

#endif
// OMP50-TLS: define {{.*}}void [[SM_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: define {{.*}}void [[SM_DTOR2]](ptr {{.*}})

#ifdef BODY
// CHECK-LABEL:  @{{.*}}foobar{{.*}}()
// CHECK-DEBUG-LABEL: @{{.*}}foobar{{.*}}()
// CHECK-TLS-LABEL: @{{.*}}foobar{{.*}}()
int foobar() {

  int Res;
  // CHECK:      [[THREAD_NUM:%.+]] = call {{.*}}i32 @__kmpc_global_thread_num(ptr [[DEFAULT_LOC]])
  // CHECK:      [[STATIC_S_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[STATIC_S]], i{{.*}} {{[0-9]+}}, ptr [[STATIC_S]].cache.)
  // CHECK-NEXT: [[STATIC_S_A_ADDR:%.*]] = getelementptr inbounds [[S3]], ptr [[STATIC_S_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[STATIC_S_A:%.*]] = load [[INT]], ptr [[STATIC_S_A_ADDR]]
  // CHECK-NEXT: store [[INT]] [[STATIC_S_A]], ptr [[RES_ADDR:[^,]+]]
  // CHECK-DEBUG:      [[THREAD_NUM:%.+]] = call {{.*}}i32 @__kmpc_global_thread_num(ptr {{.*}})
  // CHECK-DEBUG:      [[STATIC_S_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[STATIC_S]], i{{.*}} {{[0-9]+}}, ptr




  // CHECK-DEBUG-NEXT: [[STATIC_S_A_ADDR:%.*]] = getelementptr inbounds [[S3]], ptr [[STATIC_S_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[STATIC_S_A:%.*]] = load [[INT]], ptr [[STATIC_S_A_ADDR]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[STATIC_S_A]], ptr [[RES_ADDR:[^,]+]]
  // CHECK-TLS:      [[STATIC_S_ADDR:%.*]]  = call ptr [[STATIC_S_TLS_INITD]]
  // CHECK-TLS-NEXT: [[STATIC_S_A_ADDR:%.*]] = getelementptr inbounds [[S3]], ptr [[STATIC_S_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[STATIC_S_A:%.*]] = load i32, ptr [[STATIC_S_A_ADDR]]
  // CHECK-TLS-NEXT: store i32 [[STATIC_S_A]], ptr [[RES_ADDR:[^,]+]]
  Res = Static::s.a;
  // CHECK:      [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr [[GS1]].cache.)
  // CHECK-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS1_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[GS1_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[GS1]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[GS1_A:%.*]] = load [[INT]], ptr [[GS1_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS1_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[GS1_ADDR:%.*]] = call ptr [[GS1_TLS_INITD]]
  // CHECK-TLS-NEXT: [[GS1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[GS1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[GS1_A:%.*]] = load i32, ptr [[GS1_A_ADDR]]
  // CHECK-TLS-NEXT: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[GS1_A]]
  // CHECK-TLS-NEXT: store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += gs1.a;
  // CHECK:      [[GS2_A:%.*]] = load [[INT]], ptr getelementptr inbounds ([[S2]], ptr [[GS2]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS2_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG:      [[GS2_A:%.*]] = load [[INT]], ptr getelementptr inbounds ([[S2]], ptr [[GS2]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS2_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[GS2_A:%.*]] = load i32, ptr getelementptr inbounds ([[S2]], ptr [[GS2]], i{{.*}} 0, i{{.*}} 0)
  // CHECK-TLS-NEXT: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} i32 [[RES]], [[GS2_A]]
  // CHECK-TLS-NEXT: store i32 [[ADD]], ptr [[RES:.+]]
  Res += gs2.a;
  // CHECK:      [[GS3_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[GS3]], i{{.*}} {{[0-9]+}}, ptr [[GS3]].cache.)
  // CHECK-NEXT: [[GS3_A_ADDR:%.*]] = getelementptr inbounds [[S5]], ptr [[GS3_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[GS3_A:%.*]] = load [[INT]], ptr [[GS3_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS3_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[GS3_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[GS3]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[GS3_A_ADDR:%.*]] = getelementptr inbounds [[S5]], ptr [[GS3_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[GS3_A:%.*]] = load [[INT]], ptr [[GS3_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[GS3_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:       [[GS3_ADDR:%.*]] = call ptr [[GS3_TLS_INITD]]
  // CHECK-TLS-DEBUG: [[GS3_A_ADDR:%.*]] = getelementptr inbounds [[S5]], ptr [[GS3_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-DEBUG: [[GS3_A:%.*]] = load i32, ptr [[GS3_A_ADDR]]
  // CHECK-TLS-DEBUG: [[RES:%.*]] = load i32, ptr [[RES_ADDR]]
  // CHECK-TLS-DEBUG: [[ADD:%.*]]= add nsw i32 [[RES]], [[GS3_A]]
  // CHECK-TLS-DEBUG: store i32 [[ADD]], ptr [[RES_ADDR]]
  Res += gs3.a;
  // CHECK:      [[ARR_X_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ARR_X]], i{{.*}} {{[0-9]+}}, ptr [[ARR_X]].cache.)
  // CHECK-NEXT: [[ARR_X_1_ADDR:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARR_X_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-NEXT: [[ARR_X_1_1_ADDR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_X_1_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-NEXT: [[ARR_X_1_1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_X_1_1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[ARR_X_1_1_A:%.*]] = load [[INT]], ptr [[ARR_X_1_1_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ARR_X_1_1_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT:      [[ARR_X_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ARR_X]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ARR_X_1_ADDR:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARR_X_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-DEBUG-NEXT: [[ARR_X_1_1_ADDR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_X_1_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-DEBUG-NEXT: [[ARR_X_1_1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_X_1_1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[ARR_X_1_1_A:%.*]] = load [[INT]], ptr [[ARR_X_1_1_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ARR_X_1_1_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[ARR_X_ADDR:%.*]] = call ptr [[ARR_X_TLS_INITD]]
  // CHECK-TLS-NEXT: [[ARR_X_1_ADDR:%.*]] = getelementptr inbounds [2 x [3 x [[S1]]]], ptr [[ARR_X_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-TLS-NEXT: [[ARR_X_1_1_ADDR:%.*]] = getelementptr inbounds [3 x [[S1]]], ptr [[ARR_X_1_ADDR]], i{{.*}} 0, i{{.*}} 1
  // CHECK-TLS-NEXT: [[ARR_X_1_1_A_ADDR:%.*]] = getelementptr inbounds [[S1]], ptr [[ARR_X_1_1_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[ARR_X_1_1_A:%.*]] = load [[INT]], ptr [[ARR_X_1_1_A_ADDR]]
  // CHECK-TLS-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ARR_X_1_1_A]]
  // CHECK-TLS-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  Res += arr_x[1][1].a;
  // CHECK:      [[ST_INT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ST_INT_ST]], i{{.*}} {{[0-9]+}}, ptr [[ST_INT_ST]].cache.)
  // CHECK-NEXT: [[ST_INT_ST_VAL:%.*]] = load [[INT]], ptr [[ST_INT_ST_TEMP_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_INT_ST_VAL]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[ST_INT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ST_INT_ST]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ST_INT_ST_VAL:%.*]] = load [[INT]], ptr [[ST_INT_ST_TEMP_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_INT_ST_VAL]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // OMP45-TLS:      [[ST_INT_ST_VAL:%.*]] = load [[INT]], ptr [[ST_INT_ST_ADDR:[^,]+]]
  // OMP45-TLS-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // OMP45-TLS-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_INT_ST_VAL]]
  // OMP45-TLS-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  Res += ST<int>::st;
  // CHECK:      [[ST_FLOAT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ST_FLOAT_ST]], i{{.*}} {{[0-9]+}}, ptr [[ST_FLOAT_ST]].cache.)
  // CHECK-NEXT: [[ST_FLOAT_ST_VAL:%.*]] = load float, ptr [[ST_FLOAT_ST_TEMP_ADDR]]
  // CHECK-NEXT: [[FLOAT_TO_INT_CONV:%.*]] = fptosi float [[ST_FLOAT_ST_VAL]] to [[INT]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[FLOAT_TO_INT_CONV]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[ST_FLOAT_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ST_FLOAT_ST]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ST_FLOAT_ST_VAL:%.*]] = load float, ptr [[ST_FLOAT_ST_TEMP_ADDR]]
  // CHECK-DEBUG-NEXT: [[FLOAT_TO_INT_CONV:%.*]] = fptosi float [[ST_FLOAT_ST_VAL]] to [[INT]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[FLOAT_TO_INT_CONV]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // OMP45-TLS:      [[ST_FLOAT_ST_VAL:%.*]] = load float, ptr [[ST_FLOAT_ST_ADDR:[^,]+]]
  // OMP45-TLS-NEXT: [[FLOAT_TO_INT_CONV:%.*]] = fptosi float [[ST_FLOAT_ST_VAL]] to [[INT]]
  // OMP45-TLS-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // OMP45-TLS-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[FLOAT_TO_INT_CONV]]
  // OMP45-TLS-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  Res += static_cast<int>(ST<float>::st);
  // CHECK:      [[ST_S4_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr [[DEFAULT_LOC]], i32 {{.*}}, ptr [[ST_S4_ST]], i{{.*}} {{[0-9]+}}, ptr [[ST_S4_ST]].cache.)
  // CHECK-NEXT: [[ST_S4_ST_A_ADDR:%.*]] = getelementptr inbounds [[S4]], ptr [[ST_S4_ST_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-NEXT: [[ST_S4_ST_A:%.*]] = load [[INT]], ptr [[ST_S4_ST_A_ADDR]]
  // CHECK-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_S4_ST_A]]
  // CHECK-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-DEBUG-NEXT: [[ST_S4_ST_TEMP_ADDR:%.*]] = call {{.*}}ptr @__kmpc_threadprivate_cached(ptr {{.*}}, i32 {{.*}}, ptr [[ST_S4_ST]], i{{.*}} {{[0-9]+}}, ptr


  // CHECK-DEBUG-NEXT: [[ST_S4_ST_A_ADDR:%.*]] = getelementptr inbounds [[S4]], ptr [[ST_S4_ST_TEMP_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-DEBUG-NEXT: [[ST_S4_ST_A:%.*]] = load [[INT]], ptr [[ST_S4_ST_A_ADDR]]
  // CHECK-DEBUG-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_S4_ST_A]]
  // CHECK-DEBUG-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  // CHECK-TLS:      [[ST_S4_ST_ADDR:%.*]] = call ptr [[ST_S4_ST_TLS_INITD]]
  // CHECK-TLS-NEXT: [[ST_S4_ST_A_ADDR:%.*]] = getelementptr inbounds [[S4]], ptr [[ST_S4_ST_ADDR]], i{{.*}} 0, i{{.*}} 0
  // CHECK-TLS-NEXT: [[ST_S4_ST_A:%.*]] = load [[INT]], ptr [[ST_S4_ST_A_ADDR]]
  // CHECK-TLS-NEXT: [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: [[ADD:%.*]] = add {{.*}} [[INT]] [[RES]], [[ST_S4_ST_A]]
  // CHECK-TLS-NEXT: store [[INT]] [[ADD]], ptr [[RES:.+]]
  Res += ST<S4>::st.a;
  // CHECK:      [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-NEXT: ret [[INT]] [[RES]]
  // CHECK-DEBUG:      [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-DEBUG-NEXT: ret [[INT]] [[RES]]
  // CHECK-TLS:      [[RES:%.*]] = load [[INT]], ptr [[RES_ADDR]]
  // CHECK-TLS-NEXT: ret [[INT]] [[RES]]
  return Res;
}
#endif

// OMP45:      call {{.*}}void @__kmpc_threadprivate_register(ptr [[DEFAULT_LOC]], ptr [[ST_S4_ST]], ptr [[ST_S4_ST_CTOR:@\.__kmpc_global_ctor_\..+]], ptr null, ptr [[ST_S4_ST_DTOR:@\.__kmpc_global_dtor_\..+]])
// OMP45:      define internal {{.*}}ptr [[ST_S4_ST_CTOR]](ptr %0)
// OMP45:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// OMP45:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// OMP45-NEXT: call {{.*}} [[S4_CTOR:@.+]](ptr {{[^,]*}} [[ARG]], {{.*}} 23)
// OMP45:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// OMP45-NEXT: ret ptr [[ARG]]
// OMP45-NEXT: }
// OMP45:      define {{.*}} [[S4_CTOR]](ptr {{.*}},
// OMP45:      define internal {{.*}}void [[ST_S4_ST_DTOR]](ptr %0)
// OMP45:      store ptr %0, ptr [[ARG_ADDR:%.*]],
// OMP45:      [[ARG:%.+]] = load ptr, ptr [[ARG_ADDR]]
// OMP45-NEXT: call {{.*}} [[S4_DTOR:@.+]](ptr {{[^,]*}} [[ARG]])
// OMP45-NEXT: ret void
// OMP45-NEXT: }
// OMP45:      define {{.*}} [[S4_DTOR]](ptr {{.*}})




// OMP45-DEBUG:      @__kmpc_global_thread_num
// OMP45-DEBUG:      call {{.*}}void @__kmpc_threadprivate_register(ptr {{.*}}, ptr [[ST_S4_ST]], ptr [[ST_S4_ST_CTOR:@\.__kmpc_global_ctor_\..+]], ptr null, ptr [[ST_S4_ST_DTOR:@\.__kmpc_global_dtor_\..+]])
// OMP45-DEBUG:      define internal {{.*}}ptr [[ST_S4_ST_CTOR]](ptr %0)
// OMP45-DEBUG:      }
// OMP45-DEBUG:      define {{.*}} [[S4_CTOR:@.*]](ptr {{.*}},
// OMP45-DEBUG:      define internal {{.*}}void [[ST_S4_ST_DTOR]](ptr %0)
// OMP45-DEBUG:      }
// OMP45-DEBUG:      define {{.*}} [[S4_DTOR:@.*]](ptr {{.*}})

// CHECK:      define internal {{.*}}void {{@.*}}()
// CHECK-DAG:  call {{.*}}void [[GS1_INIT]]()
// CHECK-DAG:  call {{.*}}void [[ARR_X_INIT]]()
// CHECK:      ret void
// CHECK-DEBUG:      define internal {{.*}}void {{@.*}}()
// CHECK-DEBUG:      ret void

// OMP45-TLS: define internal void [[GS1_CXX_INIT:@.*]]()
// OMP45-TLS: call void [[GS1_CTOR1:@.*]](ptr {{[^,]*}} [[GS1]], i32 5)
// OMP45-TLS: call i32 @__cxa_thread_atexit(ptr [[GS1_DTOR1:.*]], ptr [[GS1]]
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[GS1_CTOR1]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: call void [[GS1_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[GS1_DTOR1]](ptr {{.*}})
// OMP45-TLS: call void [[GS1_DTOR2:@.*]](ptr {{.*}})
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[GS1_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: define {{.*}}void [[GS1_DTOR2]](ptr {{.*}})

// OMP45-TLS: define internal void [[GS2_CXX_INIT:@.*]]()
// OMP45-TLS: call void [[GS2_CTOR1:@.*]](ptr {{[^,]*}} [[GS2]], i32 27)
// OMP45-TLS: call i32 @__cxa_atexit(ptr [[GS2_DTOR1:.*]], ptr [[GS2]]
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[GS2_CTOR1]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: call void [[GS2_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[GS2_DTOR1]](ptr {{.*}})
// OMP45-TLS: call void [[GS2_DTOR2:@.*]](ptr {{.*}})
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[GS2_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: define {{.*}}void [[GS2_DTOR2]](ptr {{.*}})

// OMP45-TLS: define internal void [[ARR_X_CXX_INIT:@.*]]()
// OMP45-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 0, i{{.*}} 0), i{{.*}} 1)
// OMP45-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 0, i{{.*}} 1), i{{.*}} 2)
// OMP45-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 0, i{{.*}} 2), i{{.*}} 3)
// OMP45-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 1, i{{.*}} 0), i{{.*}} 4)
// OMP45-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 1, i{{.*}} 1), i{{.*}} 5)
// OMP45-TLS: invoke void [[GS1_CTOR1]](ptr {{[^,]*}} getelementptr inbounds ([2 x [3 x [[S1]]]], ptr [[ARR_X]], i{{.*}} 0, i{{.*}} 1, i{{.*}} 2), i{{.*}} 6)
// OMP45-TLS: call i32 @__cxa_thread_atexit(ptr [[ARR_X_CXX_DTOR:@[^,]+]]
// OMP45-TLS: define internal void [[ARR_X_CXX_DTOR]](ptr %0)
// OMP45-TLS: void [[GS1_DTOR1]](ptr {{.*}})

// OMP45-TLS: define {{.*}}void [[SM_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: define {{.*}}void [[SM_DTOR2]](ptr {{.*}})

// OMP45-TLS: define internal void [[ST_S4_ST_CXX_INIT]]()
// OMP45-TLS: call void [[ST_S4_ST_CTOR1:@.*]](ptr {{[^,]*}} [[ST_S4_ST]], i32 23)
// OMP45-TLS: call i32 @__cxa_thread_atexit(ptr [[ST_S4_ST_DTOR1:.*]], ptr [[ST_S4_ST]]
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[ST_S4_ST_CTOR1]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: call void [[ST_S4_ST_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[ST_S4_ST_DTOR1]](ptr {{.*}})
// OMP45-TLS: call void [[ST_S4_ST_DTOR2:@.*]](ptr {{.*}})
// OMP45-TLS: }
// OMP45-TLS: define {{.*}}void [[ST_S4_ST_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP45-TLS: define {{.*}}void [[ST_S4_ST_DTOR2]](ptr {{.*}})

// OMP50-TLS: define internal void [[ST_S4_ST_CXX_INIT]]()
// OMP50-TLS: call void [[ST_S4_ST_CTOR1:@.*]](ptr {{[^,]*}} [[ST_S4_ST]], i32 23)

// OMP50-TLS: call i32 @__cxa_thread_atexit(ptr [[ST_S4_ST_DTOR1:.*]], ptr [[ST_S4_ST]]
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[ST_S4_ST_CTOR1]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: call void [[ST_S4_ST_CTOR2:@.*]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[ST_S4_ST_DTOR1]](ptr {{.*}})
// OMP50-TLS: call void [[ST_S4_ST_DTOR2:@.*]](ptr {{.*}})
// OMP50-TLS: }
// OMP50-TLS: define {{.*}}void [[ST_S4_ST_CTOR2]](ptr {{.*}}, i32 {{.*}})
// OMP50-TLS: define {{.*}}void [[ST_S4_ST_DTOR2]](ptr {{.*}})

// CHECK-TLS:      define internal void @__tls_init()
// CHECK-TLS:      [[GRD:%.*]] = load i8, ptr @__tls_guard
// CHECK-TLS-NEXT: [[IS_INIT:%.*]] = icmp eq i8 [[GRD]], 0
// CHECK-TLS-NEXT: br i1 [[IS_INIT]], label %[[INIT_LABEL:[^,]+]], label %[[DONE_LABEL:[^,]+]]{{.*}}
// CHECK-TLS:      [[INIT_LABEL]]
// CHECK-TLS-NEXT: store i8 1, ptr @__tls_guard
// CHECK-TLS:      call void [[GS1_CXX_INIT]]
// CHECK-TLS-NOT:  call void [[GS2_CXX_INIT]]
// CHECK-TLS:      call void [[ARR_X_CXX_INIT]]
// CHECK-TLS-NOT:  call void [[ST_S4_ST_CXX_INIT]]
// CHECK-TLS:      [[DONE_LABEL]]

// CHECK-TLS-DAG:      declare {{.*}} void [[GS3_TLS_INIT]]
// CHECK-TLS-DAG:      declare {{.*}} void [[STATIC_S_TLS_INIT]]
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 5)
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3:[0-9]+]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_.
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZL3gs1, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..1
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[ARRAYINIT_ENDOFINIT7:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 1)
// CHECK1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 1
// CHECK1-NEXT:    store ptr [[ARRAYINIT_ELEMENT]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK1-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// CHECK1:       invoke.cont2:
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT3:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[TMP1]], i64 2
// CHECK1-NEXT:    store ptr [[ARRAYINIT_ELEMENT3]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT3]], i32 noundef 3)
// CHECK1-NEXT:            to label [[INVOKE_CONT4:%.*]] unwind label [[LPAD]]
// CHECK1:       invoke.cont4:
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT6:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 1
// CHECK1-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK1-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT6]], i32 noundef 4)
// CHECK1-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD8:%.*]]
// CHECK1:       invoke.cont9:
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT10:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 1
// CHECK1-NEXT:    store ptr [[ARRAYINIT_ELEMENT10]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT10]], i32 noundef 5)
// CHECK1-NEXT:            to label [[INVOKE_CONT11:%.*]] unwind label [[LPAD8]]
// CHECK1:       invoke.cont11:
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT12:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 2
// CHECK1-NEXT:    store ptr [[ARRAYINIT_ELEMENT12]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT12]], i32 noundef 6)
// CHECK1-NEXT:            to label [[INVOKE_CONT13:%.*]] unwind label [[LPAD8]]
// CHECK1:       invoke.cont13:
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    ret ptr [[TMP2]]
// CHECK1:       lpad:
// CHECK1-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:            cleanup
// CHECK1-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0
// CHECK1-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1
// CHECK1-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[TMP1]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE5:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE5]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done5:
// CHECK1-NEXT:    br label [[EHCLEANUP:%.*]]
// CHECK1:       lpad8:
// CHECK1-NEXT:    [[TMP7:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:            cleanup
// CHECK1-NEXT:    [[TMP8:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 0
// CHECK1-NEXT:    store ptr [[TMP8]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 1
// CHECK1-NEXT:    store i32 [[TMP9]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY14:%.*]] = icmp eq ptr [[ARRAYINIT_ELEMENT6]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY14]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15:%.*]]
// CHECK1:       arraydestroy.body15:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi ptr [ [[TMP10]], [[LPAD8]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST16]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT17]], [[ARRAYINIT_ELEMENT6]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19]], label [[ARRAYDESTROY_BODY15]]
// CHECK1:       arraydestroy.done19:
// CHECK1-NEXT:    br label [[EHCLEANUP]]
// CHECK1:       ehcleanup:
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK1-NEXT:    [[PAD_ARRAYBEGIN:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 0, i64 0
// CHECK1-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP11]], i64 0, i64 0
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY20:%.*]] = icmp eq ptr [[PAD_ARRAYBEGIN]], [[PAD_ARRAYEND]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY20]], label [[ARRAYDESTROY_DONE25:%.*]], label [[ARRAYDESTROY_BODY21:%.*]]
// CHECK1:       arraydestroy.body21:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST22:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT23:%.*]], [[ARRAYDESTROY_BODY21]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT23]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST22]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT23]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE24:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT23]], [[PAD_ARRAYBEGIN]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE24]], label [[ARRAYDESTROY_DONE25]], label [[ARRAYDESTROY_BODY21]]
// CHECK1:       arraydestroy.done25:
// CHECK1-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK1:       eh.resume:
// CHECK1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK1-NEXT:    [[LPAD_VAL26:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK1-NEXT:    resume { ptr, i32 } [[LPAD_VAL26]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..2
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 6
// CHECK1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_..3
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @arr_x, ptr @.__kmpc_global_ctor_..1, ptr null, ptr @.__kmpc_global_dtor_..2)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5)
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init.4
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27)
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init.5
// CHECK1-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// CHECK1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// CHECK1-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// CHECK1:       invoke.cont2:
// CHECK1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// CHECK1-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
// CHECK1:       invoke.cont3:
// CHECK1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// CHECK1-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]]
// CHECK1:       invoke.cont7:
// CHECK1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// CHECK1-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]]
// CHECK1:       invoke.cont8:
// CHECK1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// CHECK1-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]]
// CHECK1:       invoke.cont9:
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    ret void
// CHECK1:       lpad:
// CHECK1-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:            cleanup
// CHECK1-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// CHECK1-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done4:
// CHECK1-NEXT:    br label [[EHCLEANUP:%.*]]
// CHECK1:       lpad6:
// CHECK1-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:            cleanup
// CHECK1-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0
// CHECK1-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1
// CHECK1-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]]
// CHECK1:       arraydestroy.body11:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1)
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]]
// CHECK1:       arraydestroy.done15:
// CHECK1-NEXT:    br label [[EHCLEANUP]]
// CHECK1:       ehcleanup:
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK1-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]]
// CHECK1:       arraydestroy.body17:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]]
// CHECK1:       arraydestroy.done21:
// CHECK1-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK1:       eh.resume:
// CHECK1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK1-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK1-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8
// CHECK1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP1]], 0
// CHECK1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !prof [[PROF3:![0-9]+]]
// CHECK1:       init.check:
// CHECK1-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]]
// CHECK1:       init:
// CHECK1-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZZ4mainE2sm, ptr @.__kmpc_global_ctor_..6, ptr null, ptr @.__kmpc_global_dtor_..7)
// CHECK1-NEXT:    [[TMP4:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A]], align 4
// CHECK1-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP5]])
// CHECK1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    [[TMP6:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// CHECK1-NEXT:    br label [[INIT_END]]
// CHECK1:       init.end:
// CHECK1-NEXT:    [[TMP7:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.)
// CHECK1-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP7]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A1]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZZ4mainE2sm, i64 24, ptr @_ZZ4mainE2sm.cache.)
// CHECK1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A2]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP11]], [[TMP10]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK1-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP12]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[A3]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]]
// CHECK1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// CHECK1-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.)
// CHECK1-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP17]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A6]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], [[TMP18]]
// CHECK1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.)
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP20]], i64 0, i64 1
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK1-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A9]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP22]], [[TMP21]]
// CHECK1-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.)
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[TMP23]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP25]], [[TMP24]]
// CHECK1-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.)
// CHECK1-NEXT:    [[TMP27:%.*]] = load float, ptr [[TMP26]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP27]] to i32
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], [[CONV]]
// CHECK1-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP29:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.)
// CHECK1-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP29]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[A13]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP31]], [[TMP30]]
// CHECK1-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    ret i32 [[TMP32]]
// CHECK1:       lpad:
// CHECK1-NEXT:    [[TMP33:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:            cleanup
// CHECK1-NEXT:    [[TMP34:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 0
// CHECK1-NEXT:    store ptr [[TMP34]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 1
// CHECK1-NEXT:    store i32 [[TMP35]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// CHECK1-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK1:       eh.resume:
// CHECK1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK1-NEXT:    [[LPAD_VAL15:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK1-NEXT:    resume { ptr, i32 } [[LPAD_VAL15]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..6
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP1]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A]], align 4
// CHECK1-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) [[TMP2]], i32 noundef [[TMP4]])
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    ret ptr [[TMP5]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..7
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZZ4mainEN5SmainD1Ev(ptr noundef nonnull align 8 dereferenceable(24) [[TMP1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z6foobarv
// CHECK1-SAME: () #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    [[TMP1:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.)
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK1-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP5]], [[TMP4]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP7]], [[TMP6]]
// CHECK1-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.)
// CHECK1-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP8]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[A3]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]]
// CHECK1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.)
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP11]], i64 0, i64 1
// CHECK1-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK1-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[A6]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], [[TMP12]]
// CHECK1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.)
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// CHECK1-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.)
// CHECK1-NEXT:    [[TMP18:%.*]] = load float, ptr [[TMP17]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP18]] to i32
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], [[CONV]]
// CHECK1-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.)
// CHECK1-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP20]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A10]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]]
// CHECK1-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[RES]], align 4
// CHECK1-NEXT:    ret i32 [[TMP23]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init.8
// CHECK1-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]]
// CHECK1:       init.check:
// CHECK1-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZN2STI2S4E2stE, ptr @.__kmpc_global_ctor_..9, ptr null, ptr @.__kmpc_global_dtor_..10)
// CHECK1-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23)
// CHECK1-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    br label [[INIT_END]]
// CHECK1:       init.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..9
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]], i32 noundef 23)
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..10
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S4D1Ev(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__cxx_global_var_init()
// CHECK1-NEXT:    call void @.__omp_threadprivate_init_.()
// CHECK1-NEXT:    call void @__cxx_global_var_init.4()
// CHECK1-NEXT:    call void @__cxx_global_var_init.5()
// CHECK1-NEXT:    call void @.__omp_threadprivate_init_..3()
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK2-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5)
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 5)
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_.
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZL3gs1, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27)
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// CHECK2-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// CHECK2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// CHECK2-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// CHECK2:       invoke.cont2:
// CHECK2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// CHECK2-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
// CHECK2:       invoke.cont3:
// CHECK2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// CHECK2-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]]
// CHECK2:       invoke.cont7:
// CHECK2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// CHECK2-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]]
// CHECK2:       invoke.cont8:
// CHECK2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// CHECK2-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]]
// CHECK2:       invoke.cont9:
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// CHECK2-NEXT:    ret void
// CHECK2:       lpad:
// CHECK2-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:            cleanup
// CHECK2-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// CHECK2-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done4:
// CHECK2-NEXT:    br label [[EHCLEANUP:%.*]]
// CHECK2:       lpad6:
// CHECK2-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:            cleanup
// CHECK2-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0
// CHECK2-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1
// CHECK2-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]]
// CHECK2:       arraydestroy.body11:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1)
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]]
// CHECK2:       arraydestroy.done15:
// CHECK2-NEXT:    br label [[EHCLEANUP]]
// CHECK2:       ehcleanup:
// CHECK2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK2-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]]
// CHECK2:       arraydestroy.body17:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]]
// CHECK2:       arraydestroy.done21:
// CHECK2-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK2:       eh.resume:
// CHECK2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK2-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK2-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done1:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..3
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[ARRAYINIT_ENDOFINIT7:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 1)
// CHECK2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 1
// CHECK2-NEXT:    store ptr [[ARRAYINIT_ELEMENT]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK2-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// CHECK2:       invoke.cont2:
// CHECK2-NEXT:    [[ARRAYINIT_ELEMENT3:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[TMP1]], i64 2
// CHECK2-NEXT:    store ptr [[ARRAYINIT_ELEMENT3]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT3]], i32 noundef 3)
// CHECK2-NEXT:            to label [[INVOKE_CONT4:%.*]] unwind label [[LPAD]]
// CHECK2:       invoke.cont4:
// CHECK2-NEXT:    [[ARRAYINIT_ELEMENT6:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 1
// CHECK2-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK2-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT6]], i32 noundef 4)
// CHECK2-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD8:%.*]]
// CHECK2:       invoke.cont9:
// CHECK2-NEXT:    [[ARRAYINIT_ELEMENT10:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 1
// CHECK2-NEXT:    store ptr [[ARRAYINIT_ELEMENT10]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT10]], i32 noundef 5)
// CHECK2-NEXT:            to label [[INVOKE_CONT11:%.*]] unwind label [[LPAD8]]
// CHECK2:       invoke.cont11:
// CHECK2-NEXT:    [[ARRAYINIT_ELEMENT12:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 2
// CHECK2-NEXT:    store ptr [[ARRAYINIT_ELEMENT12]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT12]], i32 noundef 6)
// CHECK2-NEXT:            to label [[INVOKE_CONT13:%.*]] unwind label [[LPAD8]]
// CHECK2:       invoke.cont13:
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    ret ptr [[TMP2]]
// CHECK2:       lpad:
// CHECK2-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:            cleanup
// CHECK2-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0
// CHECK2-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1
// CHECK2-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[TMP1]], [[TMP6]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE5:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE5]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done5:
// CHECK2-NEXT:    br label [[EHCLEANUP:%.*]]
// CHECK2:       lpad8:
// CHECK2-NEXT:    [[TMP7:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:            cleanup
// CHECK2-NEXT:    [[TMP8:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 0
// CHECK2-NEXT:    store ptr [[TMP8]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 1
// CHECK2-NEXT:    store i32 [[TMP9]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT7]], align 8
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY14:%.*]] = icmp eq ptr [[ARRAYINIT_ELEMENT6]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY14]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15:%.*]]
// CHECK2:       arraydestroy.body15:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi ptr [ [[TMP10]], [[LPAD8]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST16]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT17]], [[ARRAYINIT_ELEMENT6]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19]], label [[ARRAYDESTROY_BODY15]]
// CHECK2:       arraydestroy.done19:
// CHECK2-NEXT:    br label [[EHCLEANUP]]
// CHECK2:       ehcleanup:
// CHECK2-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK2-NEXT:    [[PAD_ARRAYBEGIN:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 0, i64 0
// CHECK2-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP11]], i64 0, i64 0
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY20:%.*]] = icmp eq ptr [[PAD_ARRAYBEGIN]], [[PAD_ARRAYEND]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY20]], label [[ARRAYDESTROY_DONE25:%.*]], label [[ARRAYDESTROY_BODY21:%.*]]
// CHECK2:       arraydestroy.body21:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST22:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT23:%.*]], [[ARRAYDESTROY_BODY21]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT23]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST22]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT23]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE24:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT23]], [[PAD_ARRAYBEGIN]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE24]], label [[ARRAYDESTROY_DONE25]], label [[ARRAYDESTROY_BODY21]]
// CHECK2:       arraydestroy.done25:
// CHECK2-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK2:       eh.resume:
// CHECK2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK2-NEXT:    [[LPAD_VAL26:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK2-NEXT:    resume { ptr, i32 } [[LPAD_VAL26]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..4
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 6
// CHECK2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done1:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_..5
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @arr_x, ptr @.__kmpc_global_ctor_..3, ptr null, ptr @.__kmpc_global_dtor_..4)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@main
// CHECK2-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8
// CHECK2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP1]], 0
// CHECK2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !prof [[PROF3:![0-9]+]]
// CHECK2:       init.check:
// CHECK2-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// CHECK2-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK2-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]]
// CHECK2:       init:
// CHECK2-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZZ4mainE2sm, ptr @.__kmpc_global_ctor_..6, ptr null, ptr @.__kmpc_global_dtor_..7)
// CHECK2-NEXT:    [[TMP4:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP4]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A]], align 4
// CHECK2-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP5]])
// CHECK2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    [[TMP6:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]]
// CHECK2-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// CHECK2-NEXT:    br label [[INIT_END]]
// CHECK2:       init.end:
// CHECK2-NEXT:    [[TMP7:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.)
// CHECK2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP7]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A1]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZZ4mainE2sm, i64 24, ptr @_ZZ4mainE2sm.cache.)
// CHECK2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP9]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A2]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP11]], [[TMP10]]
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP12]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[A3]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]]
// CHECK2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// CHECK2-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.)
// CHECK2-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP17]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A6]], align 4
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], [[TMP18]]
// CHECK2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.)
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP20]], i64 0, i64 1
// CHECK2-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK2-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A9]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP22]], [[TMP21]]
// CHECK2-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.)
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, ptr [[TMP23]], align 4
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP25]], [[TMP24]]
// CHECK2-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.)
// CHECK2-NEXT:    [[TMP27:%.*]] = load float, ptr [[TMP26]], align 4
// CHECK2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP27]] to i32
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], [[CONV]]
// CHECK2-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP29:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.)
// CHECK2-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP29]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, ptr [[A13]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP31]], [[TMP30]]
// CHECK2-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP32:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    ret i32 [[TMP32]]
// CHECK2:       lpad:
// CHECK2-NEXT:    [[TMP33:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:            cleanup
// CHECK2-NEXT:    [[TMP34:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 0
// CHECK2-NEXT:    store ptr [[TMP34]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP35:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 1
// CHECK2-NEXT:    store i32 [[TMP35]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// CHECK2-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK2:       eh.resume:
// CHECK2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK2-NEXT:    [[LPAD_VAL15:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK2-NEXT:    resume { ptr, i32 } [[LPAD_VAL15]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..6
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP1]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A]], align 4
// CHECK2-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) [[TMP2]], i32 noundef [[TMP4]])
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    ret ptr [[TMP5]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..7
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZZ4mainEN5SmainD1Ev(ptr noundef nonnull align 8 dereferenceable(24) [[TMP1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z6foobarv
// CHECK2-SAME: () #[[ATTR2]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    [[TMP1:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.)
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.)
// CHECK2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A1]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP5]], [[TMP4]]
// CHECK2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP7]], [[TMP6]]
// CHECK2-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.)
// CHECK2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP8]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[A3]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]]
// CHECK2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.)
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP11]], i64 0, i64 1
// CHECK2-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK2-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[A6]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], [[TMP12]]
// CHECK2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.)
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// CHECK2-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.)
// CHECK2-NEXT:    [[TMP18:%.*]] = load float, ptr [[TMP17]], align 4
// CHECK2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP18]] to i32
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], [[CONV]]
// CHECK2-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.)
// CHECK2-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP20]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A10]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]]
// CHECK2-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[RES]], align 4
// CHECK2-NEXT:    ret i32 [[TMP23]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init.8
// CHECK2-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]]
// CHECK2:       init.check:
// CHECK2-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZN2STI2S4E2stE, ptr @.__kmpc_global_ctor_..9, ptr null, ptr @.__kmpc_global_dtor_..10)
// CHECK2-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23)
// CHECK2-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]]
// CHECK2-NEXT:    br label [[INIT_END]]
// CHECK2:       init.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..9
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]], i32 noundef 23)
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..10
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S4D1Ev(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__cxx_global_var_init()
// CHECK2-NEXT:    call void @.__omp_threadprivate_init_.()
// CHECK2-NEXT:    call void @__cxx_global_var_init.1()
// CHECK2-NEXT:    call void @__cxx_global_var_init.2()
// CHECK2-NEXT:    call void @.__omp_threadprivate_init_..5()
// CHECK2-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// SIMD1-SAME: () #[[ATTR0:[0-9]+]] {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5)
// SIMD1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]]
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// SIMD1-SAME: () #[[ATTR0]] {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27)
// SIMD1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]]
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]])
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]]
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// SIMD1-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// SIMD1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// SIMD1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// SIMD1:       invoke.cont:
// SIMD1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// SIMD1-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// SIMD1:       invoke.cont2:
// SIMD1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// SIMD1-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
// SIMD1:       invoke.cont3:
// SIMD1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8
// SIMD1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// SIMD1-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]]
// SIMD1:       invoke.cont7:
// SIMD1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// SIMD1-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]]
// SIMD1:       invoke.cont8:
// SIMD1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// SIMD1-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]]
// SIMD1:       invoke.cont9:
// SIMD1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// SIMD1-NEXT:    ret void
// SIMD1:       lpad:
// SIMD1-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// SIMD1-NEXT:            cleanup
// SIMD1-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// SIMD1-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// SIMD1-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// SIMD1-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// SIMD1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]]
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// SIMD1:       arraydestroy.body:
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// SIMD1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]]
// SIMD1:       arraydestroy.done4:
// SIMD1-NEXT:    br label [[EHCLEANUP:%.*]]
// SIMD1:       lpad6:
// SIMD1-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// SIMD1-NEXT:            cleanup
// SIMD1-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0
// SIMD1-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8
// SIMD1-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1
// SIMD1-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4
// SIMD1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD1-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]]
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]]
// SIMD1:       arraydestroy.body11:
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ]
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1
// SIMD1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]]
// SIMD1-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1)
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]]
// SIMD1:       arraydestroy.done15:
// SIMD1-NEXT:    br label [[EHCLEANUP]]
// SIMD1:       ehcleanup:
// SIMD1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// SIMD1-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0
// SIMD1-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]]
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]]
// SIMD1:       arraydestroy.body17:
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ]
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1
// SIMD1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]]
// SIMD1-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]]
// SIMD1:       arraydestroy.done21:
// SIMD1-NEXT:    br label [[EH_RESUME:%.*]]
// SIMD1:       eh.resume:
// SIMD1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// SIMD1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// SIMD1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// SIMD1-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// SIMD1-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]]
//
//
// SIMD1-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// SIMD1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SIMD1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// SIMD1:       arraydestroy.body:
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// SIMD1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// SIMD1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// SIMD1:       arraydestroy.done1:
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@main
// SIMD1-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD1-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8
// SIMD1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// SIMD1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !prof [[PROF2:![0-9]+]]
// SIMD1:       init.check:
// SIMD1-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// SIMD1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP1]], 0
// SIMD1-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]]
// SIMD1:       init:
// SIMD1-NEXT:    [[TMP2:%.*]] = load i32, ptr @_ZL3gs1, align 4
// SIMD1-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]])
// SIMD1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// SIMD1:       invoke.cont:
// SIMD1-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]]
// SIMD1-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// SIMD1-NEXT:    br label [[INIT_END]]
// SIMD1:       init.end:
// SIMD1-NEXT:    [[TMP4:%.*]] = load i32, ptr @_ZN6Static1sE, align 4
// SIMD1-NEXT:    store i32 [[TMP4]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZZ4mainE2sm, align 8
// SIMD1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP6]], [[TMP5]]
// SIMD1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP7:%.*]] = load i32, ptr @_ZL3gs1, align 4
// SIMD1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP8]], [[TMP7]]
// SIMD1-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZL3gs2, align 8
// SIMD1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], [[TMP9]]
// SIMD1-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP11:%.*]] = load i32, ptr @gs3, align 4
// SIMD1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], [[TMP11]]
// SIMD1-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP13:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4
// SIMD1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]]
// SIMD1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4
// SIMD1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// SIMD1-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP17:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4
// SIMD1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32
// SIMD1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], [[CONV]]
// SIMD1-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP19:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4
// SIMD1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP20]], [[TMP19]]
// SIMD1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    ret i32 [[TMP21]]
// SIMD1:       lpad:
// SIMD1-NEXT:    [[TMP22:%.*]] = landingpad { ptr, i32 }
// SIMD1-NEXT:            cleanup
// SIMD1-NEXT:    [[TMP23:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 0
// SIMD1-NEXT:    store ptr [[TMP23]], ptr [[EXN_SLOT]], align 8
// SIMD1-NEXT:    [[TMP24:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 1
// SIMD1-NEXT:    store i32 [[TMP24]], ptr [[EHSELECTOR_SLOT]], align 4
// SIMD1-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// SIMD1-NEXT:    br label [[EH_RESUME:%.*]]
// SIMD1:       eh.resume:
// SIMD1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// SIMD1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// SIMD1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// SIMD1-NEXT:    [[LPAD_VAL8:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// SIMD1-NEXT:    resume { ptr, i32 } [[LPAD_VAL8]]
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]])
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]]
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_Z6foobarv
// SIMD1-SAME: () #[[ATTR2]] {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr @_ZN6Static1sE, align 4
// SIMD1-NEXT:    store i32 [[TMP0]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP1:%.*]] = load i32, ptr @_ZL3gs1, align 4
// SIMD1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP2]], [[TMP1]]
// SIMD1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP3:%.*]] = load i32, ptr @_ZL3gs2, align 8
// SIMD1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], [[TMP3]]
// SIMD1-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP5:%.*]] = load i32, ptr @gs3, align 4
// SIMD1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]]
// SIMD1-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP7:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4
// SIMD1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], [[TMP7]]
// SIMD1-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4
// SIMD1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]]
// SIMD1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP11:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4
// SIMD1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP11]] to i32
// SIMD1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], [[CONV]]
// SIMD1-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP13:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4
// SIMD1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP14]], [[TMP13]]
// SIMD1-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4
// SIMD1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4
// SIMD1-NEXT:    ret i32 [[TMP15]]
//
//
// SIMD1-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// SIMD1-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8
// SIMD1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// SIMD1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]]
// SIMD1:       init.check:
// SIMD1-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8
// SIMD1-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23)
// SIMD1-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]]
// SIMD1-NEXT:    br label [[INIT_END]]
// SIMD1:       init.end:
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]])
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]]
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    store i32 0, ptr [[A]], align 4
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    store i32 0, ptr [[A]], align 8
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// SIMD1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    store i32 0, ptr [[A]], align 8
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// SIMD1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD1-NEXT:    store i32 0, ptr [[A]], align 4
// SIMD1-NEXT:    ret void
//
//
// SIMD1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// SIMD1-SAME: () #[[ATTR0]] {
// SIMD1-NEXT:  entry:
// SIMD1-NEXT:    call void @__cxx_global_var_init()
// SIMD1-NEXT:    call void @__cxx_global_var_init.1()
// SIMD1-NEXT:    call void @__cxx_global_var_init.2()
// SIMD1-NEXT:    ret void
//
//
// SIMD2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// SIMD2-SAME: () #[[ATTR0:[0-9]+]] !dbg [[DBG115:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5), !dbg [[DBG118:![0-9]+]]
// SIMD2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]], !dbg [[DBG120:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG121:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 !dbg [[DBG122:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META123:![0-9]+]], !DIExpression(), [[META125:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META126:![0-9]+]], !DIExpression(), [[META127:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG128:![0-9]+]]
// SIMD2-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG128]]
// SIMD2-NEXT:    ret void, !dbg [[DBG129:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 !dbg [[DBG130:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META131:![0-9]+]], !DIExpression(), [[META132:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]], !dbg [[DBG133:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG134:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// SIMD2-SAME: () #[[ATTR0]] !dbg [[DBG135:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27), !dbg [[DBG136:![0-9]+]]
// SIMD2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG138:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG139:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG140:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META141:![0-9]+]], !DIExpression(), [[META143:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META144:![0-9]+]], !DIExpression(), [[META145:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG146:![0-9]+]]
// SIMD2-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG146]]
// SIMD2-NEXT:    ret void, !dbg [[DBG147:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG148:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META149:![0-9]+]], !DIExpression(), [[META150:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]], !dbg [[DBG151:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG152:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// SIMD2-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG153:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG154:![0-9]+]]
// SIMD2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156:![0-9]+]]
// SIMD2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// SIMD2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG157:![0-9]+]]
// SIMD2:       invoke.cont:
// SIMD2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156]]
// SIMD2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// SIMD2-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG158:![0-9]+]]
// SIMD2:       invoke.cont2:
// SIMD2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156]]
// SIMD2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// SIMD2-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]], !dbg [[DBG159:![0-9]+]]
// SIMD2:       invoke.cont3:
// SIMD2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG154]]
// SIMD2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160:![0-9]+]]
// SIMD2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// SIMD2-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]], !dbg [[DBG161:![0-9]+]]
// SIMD2:       invoke.cont7:
// SIMD2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160]]
// SIMD2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// SIMD2-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]], !dbg [[DBG162:![0-9]+]]
// SIMD2:       invoke.cont8:
// SIMD2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160]]
// SIMD2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// SIMD2-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]], !dbg [[DBG163:![0-9]+]]
// SIMD2:       invoke.cont9:
// SIMD2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG164:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG164]]
// SIMD2:       lpad:
// SIMD2-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// SIMD2-NEXT:            cleanup, !dbg [[DBG165:![0-9]+]]
// SIMD2-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0, !dbg [[DBG165]]
// SIMD2-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG165]]
// SIMD2-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1, !dbg [[DBG165]]
// SIMD2-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG165]]
// SIMD2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]], !dbg [[DBG156]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG156]]
// SIMD2:       arraydestroy.body:
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG156]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG156]]
// SIMD2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG156]]
// SIMD2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[DBG156]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG156]]
// SIMD2:       arraydestroy.done4:
// SIMD2-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG156]]
// SIMD2:       lpad6:
// SIMD2-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// SIMD2-NEXT:            cleanup, !dbg [[DBG165]]
// SIMD2-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0, !dbg [[DBG165]]
// SIMD2-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG165]]
// SIMD2-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1, !dbg [[DBG165]]
// SIMD2-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG165]]
// SIMD2-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]], !dbg [[DBG160]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]], !dbg [[DBG160]]
// SIMD2:       arraydestroy.body11:
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ], !dbg [[DBG160]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1, !dbg [[DBG160]]
// SIMD2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]], !dbg [[DBG160]]
// SIMD2-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), !dbg [[DBG160]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]], !dbg [[DBG160]]
// SIMD2:       arraydestroy.done15:
// SIMD2-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG160]]
// SIMD2:       ehcleanup:
// SIMD2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG154]]
// SIMD2-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0, !dbg [[DBG154]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]], !dbg [[DBG154]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]], !dbg [[DBG154]]
// SIMD2:       arraydestroy.body17:
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ], !dbg [[DBG154]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1, !dbg [[DBG154]]
// SIMD2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]], !dbg [[DBG154]]
// SIMD2-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x, !dbg [[DBG154]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]], !dbg [[DBG154]]
// SIMD2:       arraydestroy.done21:
// SIMD2-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG154]]
// SIMD2:       eh.resume:
// SIMD2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG154]]
// SIMD2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG154]]
// SIMD2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG154]]
// SIMD2-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG154]]
// SIMD2-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]], !dbg [[DBG154]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// SIMD2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG166:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META170:![0-9]+]], !DIExpression(), [[META171:![0-9]+]])
// SIMD2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META171]]
// SIMD2:       arraydestroy.body:
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META171]]
// SIMD2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META171]]
// SIMD2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META171]]
// SIMD2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[META171]]
// SIMD2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META171]]
// SIMD2:       arraydestroy.done1:
// SIMD2-NEXT:    ret void, !dbg [[META171]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@main
// SIMD2-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 !dbg [[DBG52:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[RES]], [[META172:![0-9]+]], !DIExpression(), [[META173:![0-9]+]])
// SIMD2-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8, !dbg [[DBG174:![0-9]+]]
// SIMD2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG174]]
// SIMD2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG174]], !prof [[PROF175:![0-9]+]]
// SIMD2:       init.check:
// SIMD2-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG174]]
// SIMD2-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP1]], 0, !dbg [[DBG174]]
// SIMD2-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]], !dbg [[DBG174]]
// SIMD2:       init:
// SIMD2-NEXT:    [[TMP2:%.*]] = load i32, ptr @_ZL3gs1, align 4, !dbg [[DBG176:![0-9]+]]
// SIMD2-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]])
// SIMD2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG177:![0-9]+]]
// SIMD2:       invoke.cont:
// SIMD2-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG174]]
// SIMD2-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG174]]
// SIMD2-NEXT:    br label [[INIT_END]], !dbg [[DBG174]]
// SIMD2:       init.end:
// SIMD2-NEXT:    [[TMP4:%.*]] = load i32, ptr @_ZN6Static1sE, align 4, !dbg [[DBG178:![0-9]+]]
// SIMD2-NEXT:    store i32 [[TMP4]], ptr [[RES]], align 4, !dbg [[DBG179:![0-9]+]]
// SIMD2-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZZ4mainE2sm, align 8, !dbg [[DBG180:![0-9]+]]
// SIMD2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG181:![0-9]+]]
// SIMD2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP6]], [[TMP5]], !dbg [[DBG181]]
// SIMD2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG181]]
// SIMD2-NEXT:    [[TMP7:%.*]] = load i32, ptr @_ZL3gs1, align 4, !dbg [[DBG182:![0-9]+]]
// SIMD2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG183:![0-9]+]]
// SIMD2-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP8]], [[TMP7]], !dbg [[DBG183]]
// SIMD2-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4, !dbg [[DBG183]]
// SIMD2-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG184:![0-9]+]]
// SIMD2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG185:![0-9]+]]
// SIMD2-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], [[TMP9]], !dbg [[DBG185]]
// SIMD2-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG185]]
// SIMD2-NEXT:    [[TMP11:%.*]] = load i32, ptr @gs3, align 4, !dbg [[DBG186:![0-9]+]]
// SIMD2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG187:![0-9]+]]
// SIMD2-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], [[TMP11]], !dbg [[DBG187]]
// SIMD2-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4, !dbg [[DBG187]]
// SIMD2-NEXT:    [[TMP13:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4, !dbg [[DBG188:![0-9]+]]
// SIMD2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG189:![0-9]+]]
// SIMD2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]], !dbg [[DBG189]]
// SIMD2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG189]]
// SIMD2-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4, !dbg [[DBG190:![0-9]+]]
// SIMD2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG191:![0-9]+]]
// SIMD2-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG191]]
// SIMD2-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG191]]
// SIMD2-NEXT:    [[TMP17:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4, !dbg [[DBG192:![0-9]+]]
// SIMD2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32, !dbg [[DBG192]]
// SIMD2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG193:![0-9]+]]
// SIMD2-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], [[CONV]], !dbg [[DBG193]]
// SIMD2-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4, !dbg [[DBG193]]
// SIMD2-NEXT:    [[TMP19:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4, !dbg [[DBG194:![0-9]+]]
// SIMD2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG195:![0-9]+]]
// SIMD2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP20]], [[TMP19]], !dbg [[DBG195]]
// SIMD2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG195]]
// SIMD2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG196:![0-9]+]]
// SIMD2-NEXT:    ret i32 [[TMP21]], !dbg [[DBG197:![0-9]+]]
// SIMD2:       lpad:
// SIMD2-NEXT:    [[TMP22:%.*]] = landingpad { ptr, i32 }
// SIMD2-NEXT:            cleanup, !dbg [[DBG198:![0-9]+]]
// SIMD2-NEXT:    [[TMP23:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 0, !dbg [[DBG198]]
// SIMD2-NEXT:    store ptr [[TMP23]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG198]]
// SIMD2-NEXT:    [[TMP24:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 1, !dbg [[DBG198]]
// SIMD2-NEXT:    store i32 [[TMP24]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG198]]
// SIMD2-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG174]]
// SIMD2-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG174]]
// SIMD2:       eh.resume:
// SIMD2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG174]]
// SIMD2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG174]]
// SIMD2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG174]]
// SIMD2-NEXT:    [[LPAD_VAL8:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG174]]
// SIMD2-NEXT:    resume { ptr, i32 } [[LPAD_VAL8]], !dbg [[DBG174]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG199:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META200:![0-9]+]], !DIExpression(), [[META202:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META203:![0-9]+]], !DIExpression(), [[META204:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG205:![0-9]+]]
// SIMD2-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG205]]
// SIMD2-NEXT:    ret void, !dbg [[DBG206:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG207:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META208:![0-9]+]], !DIExpression(), [[META209:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]], !dbg [[DBG210:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG211:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_Z6foobarv
// SIMD2-SAME: () #[[ATTR2]] !dbg [[DBG212:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[RES]], [[META213:![0-9]+]], !DIExpression(), [[META214:![0-9]+]])
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr @_ZN6Static1sE, align 4, !dbg [[DBG215:![0-9]+]]
// SIMD2-NEXT:    store i32 [[TMP0]], ptr [[RES]], align 4, !dbg [[DBG216:![0-9]+]]
// SIMD2-NEXT:    [[TMP1:%.*]] = load i32, ptr @_ZL3gs1, align 4, !dbg [[DBG217:![0-9]+]]
// SIMD2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG218:![0-9]+]]
// SIMD2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP2]], [[TMP1]], !dbg [[DBG218]]
// SIMD2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG218]]
// SIMD2-NEXT:    [[TMP3:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG219:![0-9]+]]
// SIMD2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG220:![0-9]+]]
// SIMD2-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], [[TMP3]], !dbg [[DBG220]]
// SIMD2-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4, !dbg [[DBG220]]
// SIMD2-NEXT:    [[TMP5:%.*]] = load i32, ptr @gs3, align 4, !dbg [[DBG221:![0-9]+]]
// SIMD2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG222:![0-9]+]]
// SIMD2-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]], !dbg [[DBG222]]
// SIMD2-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG222]]
// SIMD2-NEXT:    [[TMP7:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4, !dbg [[DBG223:![0-9]+]]
// SIMD2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG224:![0-9]+]]
// SIMD2-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], [[TMP7]], !dbg [[DBG224]]
// SIMD2-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4, !dbg [[DBG224]]
// SIMD2-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4, !dbg [[DBG225:![0-9]+]]
// SIMD2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG226:![0-9]+]]
// SIMD2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]], !dbg [[DBG226]]
// SIMD2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG226]]
// SIMD2-NEXT:    [[TMP11:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4, !dbg [[DBG227:![0-9]+]]
// SIMD2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP11]] to i32, !dbg [[DBG227]]
// SIMD2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG228:![0-9]+]]
// SIMD2-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], [[CONV]], !dbg [[DBG228]]
// SIMD2-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG228]]
// SIMD2-NEXT:    [[TMP13:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4, !dbg [[DBG229:![0-9]+]]
// SIMD2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG230:![0-9]+]]
// SIMD2-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP14]], [[TMP13]], !dbg [[DBG230]]
// SIMD2-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4, !dbg [[DBG230]]
// SIMD2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG231:![0-9]+]]
// SIMD2-NEXT:    ret i32 [[TMP15]], !dbg [[DBG232:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// SIMD2-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) !dbg [[DBG233:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG234:![0-9]+]]
// SIMD2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG234]]
// SIMD2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG234]]
// SIMD2:       init.check:
// SIMD2-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG234]]
// SIMD2-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23), !dbg [[DBG235:![0-9]+]]
// SIMD2-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG234]]
// SIMD2-NEXT:    br label [[INIT_END]], !dbg [[DBG234]]
// SIMD2:       init.end:
// SIMD2-NEXT:    ret void, !dbg [[DBG237:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG238:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META239:![0-9]+]], !DIExpression(), [[META241:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META242:![0-9]+]], !DIExpression(), [[META243:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG244:![0-9]+]]
// SIMD2-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG244]]
// SIMD2-NEXT:    ret void, !dbg [[DBG245:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG246:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META247:![0-9]+]], !DIExpression(), [[META248:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]], !dbg [[DBG249:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG250:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG251:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META252:![0-9]+]], !DIExpression(), [[META253:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META254:![0-9]+]], !DIExpression(), [[META255:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG256:![0-9]+]]
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG257:![0-9]+]]
// SIMD2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG256]]
// SIMD2-NEXT:    ret void, !dbg [[DBG258:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG259:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META260:![0-9]+]], !DIExpression(), [[META261:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG262:![0-9]+]]
// SIMD2-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG264:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG265:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG266:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META267:![0-9]+]], !DIExpression(), [[META268:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META269:![0-9]+]], !DIExpression(), [[META270:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG271:![0-9]+]]
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG272:![0-9]+]]
// SIMD2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG271]]
// SIMD2-NEXT:    ret void, !dbg [[DBG273:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG274:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META275:![0-9]+]], !DIExpression(), [[META276:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG277:![0-9]+]]
// SIMD2-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG279:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG280:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG281:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META282:![0-9]+]], !DIExpression(), [[META283:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META284:![0-9]+]], !DIExpression(), [[META285:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG286:![0-9]+]]
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG287:![0-9]+]]
// SIMD2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG286]]
// SIMD2-NEXT:    ret void, !dbg [[DBG288:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// SIMD2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG289:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META290:![0-9]+]], !DIExpression(), [[META291:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG292:![0-9]+]]
// SIMD2-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG294:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG295:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG296:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META297:![0-9]+]], !DIExpression(), [[META298:![0-9]+]])
// SIMD2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META299:![0-9]+]], !DIExpression(), [[META300:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG301:![0-9]+]]
// SIMD2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG302:![0-9]+]]
// SIMD2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG301]]
// SIMD2-NEXT:    ret void, !dbg [[DBG303:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// SIMD2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG304:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META305:![0-9]+]], !DIExpression(), [[META306:![0-9]+]])
// SIMD2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG307:![0-9]+]]
// SIMD2-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG309:![0-9]+]]
// SIMD2-NEXT:    ret void, !dbg [[DBG310:![0-9]+]]
//
//
// SIMD2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// SIMD2-SAME: () #[[ATTR0]] !dbg [[DBG311:![0-9]+]] {
// SIMD2-NEXT:  entry:
// SIMD2-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG313:![0-9]+]]
// SIMD2-NEXT:    call void @__cxx_global_var_init.1(), !dbg [[DBG313]]
// SIMD2-NEXT:    call void @__cxx_global_var_init.2(), !dbg [[DBG313]]
// SIMD2-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK-TLS1-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5)
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]]
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK-TLS1-SAME: () #[[ATTR0]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27)
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]]
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// CHECK-TLS1-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK-TLS1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// CHECK-TLS1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK-TLS1:       invoke.cont:
// CHECK-TLS1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// CHECK-TLS1-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// CHECK-TLS1:       invoke.cont2:
// CHECK-TLS1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// CHECK-TLS1-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
// CHECK-TLS1:       invoke.cont3:
// CHECK-TLS1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK-TLS1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// CHECK-TLS1-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]]
// CHECK-TLS1:       invoke.cont7:
// CHECK-TLS1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// CHECK-TLS1-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]]
// CHECK-TLS1:       invoke.cont8:
// CHECK-TLS1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// CHECK-TLS1-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]]
// CHECK-TLS1:       invoke.cont9:
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// CHECK-TLS1-NEXT:    ret void
// CHECK-TLS1:       lpad:
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS1-NEXT:            cleanup
// CHECK-TLS1-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// CHECK-TLS1-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// CHECK-TLS1-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// CHECK-TLS1-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK-TLS1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]]
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK-TLS1:       arraydestroy.body:
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-TLS1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]]
// CHECK-TLS1:       arraydestroy.done4:
// CHECK-TLS1-NEXT:    br label [[EHCLEANUP:%.*]]
// CHECK-TLS1:       lpad6:
// CHECK-TLS1-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS1-NEXT:            cleanup
// CHECK-TLS1-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0
// CHECK-TLS1-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8
// CHECK-TLS1-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1
// CHECK-TLS1-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK-TLS1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]]
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]]
// CHECK-TLS1:       arraydestroy.body11:
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1
// CHECK-TLS1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1)
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]]
// CHECK-TLS1:       arraydestroy.done15:
// CHECK-TLS1-NEXT:    br label [[EHCLEANUP]]
// CHECK-TLS1:       ehcleanup:
// CHECK-TLS1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK-TLS1-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]]
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]]
// CHECK-TLS1:       arraydestroy.body17:
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1
// CHECK-TLS1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]]
// CHECK-TLS1:       arraydestroy.done21:
// CHECK-TLS1-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK-TLS1:       eh.resume:
// CHECK-TLS1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK-TLS1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK-TLS1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK-TLS1-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK-TLS1-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK-TLS1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-TLS1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK-TLS1:       arraydestroy.body:
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-TLS1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK-TLS1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK-TLS1:       arraydestroy.done1:
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@main
// CHECK-TLS1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVZ4mainE2sm, align 1
// CHECK-TLS1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK-TLS1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !prof [[PROF3:![0-9]+]]
// CHECK-TLS1:       init.check:
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = call ptr @_ZTWL3gs1()
// CHECK-TLS1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK-TLS1-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]])
// CHECK-TLS1-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]]
// CHECK-TLS1-NEXT:    store i8 1, ptr @_ZGVZ4mainE2sm, align 1
// CHECK-TLS1-NEXT:    br label [[INIT_END]]
// CHECK-TLS1:       init.end:
// CHECK-TLS1-NEXT:    [[TMP4:%.*]] = call ptr @_ZTWN6Static1sE()
// CHECK-TLS1-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP4]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A1]], align 4
// CHECK-TLS1-NEXT:    store i32 [[TMP5]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP6:%.*]] = call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @_ZZ4mainE2sm)
// CHECK-TLS1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP6]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[A2]], align 8
// CHECK-TLS1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP8]], [[TMP7]]
// CHECK-TLS1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP9:%.*]] = call ptr @_ZTWL3gs1()
// CHECK-TLS1-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP9]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A3]], align 4
// CHECK-TLS1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP11]], [[TMP10]]
// CHECK-TLS1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP12:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK-TLS1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP13]], [[TMP12]]
// CHECK-TLS1-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP14:%.*]] = call ptr @_ZTW3gs3()
// CHECK-TLS1-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP14]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[A6]], align 4
// CHECK-TLS1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// CHECK-TLS1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP17:%.*]] = call ptr @_ZTW5arr_x()
// CHECK-TLS1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP17]], i64 0, i64 1
// CHECK-TLS1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK-TLS1-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A9]], align 4
// CHECK-TLS1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP19]], [[TMP18]]
// CHECK-TLS1-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP20:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIiE2stE)
// CHECK-TLS1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK-TLS1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]]
// CHECK-TLS1-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP23:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIfE2stE)
// CHECK-TLS1-NEXT:    [[TMP24:%.*]] = load float, ptr [[TMP23]], align 4
// CHECK-TLS1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP24]] to i32
// CHECK-TLS1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP25]], [[CONV]]
// CHECK-TLS1-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP26:%.*]] = call ptr @_ZTWN2STI2S4E2stE()
// CHECK-TLS1-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP26]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP27:%.*]] = load i32, ptr [[A13]], align 4
// CHECK-TLS1-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP28]], [[TMP27]]
// CHECK-TLS1-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP29:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    ret i32 [[TMP29]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZTWL3gs1
// CHECK-TLS1-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK-TLS1-NEXT:    call void @_ZTHL3gs1()
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZL3gs1)
// CHECK-TLS1-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZTWN6Static1sE
// CHECK-TLS1-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTHN6Static1sE, null
// CHECK-TLS1-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS1:       2:
// CHECK-TLS1-NEXT:    call void @_ZTHN6Static1sE()
// CHECK-TLS1-NEXT:    br label [[TMP3]]
// CHECK-TLS1:       3:
// CHECK-TLS1-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN6Static1sE)
// CHECK-TLS1-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZTW3gs3
// CHECK-TLS1-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTH3gs3, null
// CHECK-TLS1-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS1:       2:
// CHECK-TLS1-NEXT:    call void @_ZTH3gs3()
// CHECK-TLS1-NEXT:    br label [[TMP3]]
// CHECK-TLS1:       3:
// CHECK-TLS1-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @gs3)
// CHECK-TLS1-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZTW5arr_x
// CHECK-TLS1-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS1-NEXT:    call void @_ZTH5arr_x()
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = call align 16 ptr @llvm.threadlocal.address.p0(ptr align 16 @arr_x)
// CHECK-TLS1-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZTWN2STI2S4E2stE
// CHECK-TLS1-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS1-NEXT:    call void @_ZTHN2STI2S4E2stE()
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STI2S4E2stE)
// CHECK-TLS1-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_Z6foobarv
// CHECK-TLS1-SAME: () #[[ATTR1]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = call ptr @_ZTWN6Static1sE()
// CHECK-TLS1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP0]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4
// CHECK-TLS1-NEXT:    store i32 [[TMP1]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP2:%.*]] = call ptr @_ZTWL3gs1()
// CHECK-TLS1-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP2]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A1]], align 4
// CHECK-TLS1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP4]], [[TMP3]]
// CHECK-TLS1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK-TLS1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]]
// CHECK-TLS1-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP7:%.*]] = call ptr @_ZTW3gs3()
// CHECK-TLS1-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP7]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A3]], align 4
// CHECK-TLS1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], [[TMP8]]
// CHECK-TLS1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP10:%.*]] = call ptr @_ZTW5arr_x()
// CHECK-TLS1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP10]], i64 0, i64 1
// CHECK-TLS1-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK-TLS1-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[A6]], align 4
// CHECK-TLS1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], [[TMP11]]
// CHECK-TLS1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP13:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIiE2stE)
// CHECK-TLS1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK-TLS1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP15]], [[TMP14]]
// CHECK-TLS1-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP16:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIfE2stE)
// CHECK-TLS1-NEXT:    [[TMP17:%.*]] = load float, ptr [[TMP16]], align 4
// CHECK-TLS1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32
// CHECK-TLS1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP18]], [[CONV]]
// CHECK-TLS1-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP19:%.*]] = call ptr @_ZTWN2STI2S4E2stE()
// CHECK-TLS1-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP19]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[A10]], align 4
// CHECK-TLS1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], [[TMP20]]
// CHECK-TLS1-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS1-NEXT:    ret i32 [[TMP22]]
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// CHECK-TLS1-SAME: () #[[ATTR0]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK-TLS1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK-TLS1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]]
// CHECK-TLS1:       init.check:
// CHECK-TLS1-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK-TLS1-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23)
// CHECK-TLS1-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]]
// CHECK-TLS1-NEXT:    br label [[INIT_END]]
// CHECK-TLS1:       init.end:
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]]
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// CHECK-TLS1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS1-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// CHECK-TLS1-SAME: () #[[ATTR0]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    call void @__cxx_global_var_init.1()
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS1-LABEL: define {{[^@]+}}@__tls_init
// CHECK-TLS1-SAME: () #[[ATTR0]] {
// CHECK-TLS1-NEXT:  entry:
// CHECK-TLS1-NEXT:    [[TMP0:%.*]] = load i8, ptr @__tls_guard, align 1
// CHECK-TLS1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK-TLS1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT:%.*]], label [[EXIT:%.*]], !prof [[PROF3]]
// CHECK-TLS1:       init:
// CHECK-TLS1-NEXT:    store i8 1, ptr @__tls_guard, align 1
// CHECK-TLS1-NEXT:    call void @__cxx_global_var_init()
// CHECK-TLS1-NEXT:    call void @__cxx_global_var_init.2()
// CHECK-TLS1-NEXT:    br label [[EXIT]]
// CHECK-TLS1:       exit:
// CHECK-TLS1-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@main
// CHECK-TLS2-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVZ4mainE2sm, align 1
// CHECK-TLS2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK-TLS2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !prof [[PROF3:![0-9]+]]
// CHECK-TLS2:       init.check:
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call ptr @_ZTWL3gs1()
// CHECK-TLS2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK-TLS2-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]])
// CHECK-TLS2-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR4:[0-9]+]]
// CHECK-TLS2-NEXT:    store i8 1, ptr @_ZGVZ4mainE2sm, align 1
// CHECK-TLS2-NEXT:    br label [[INIT_END]]
// CHECK-TLS2:       init.end:
// CHECK-TLS2-NEXT:    [[TMP4:%.*]] = call ptr @_ZTWN6Static1sE()
// CHECK-TLS2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP4]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A1]], align 4
// CHECK-TLS2-NEXT:    store i32 [[TMP5]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP6:%.*]] = call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @_ZZ4mainE2sm)
// CHECK-TLS2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP6]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[A2]], align 8
// CHECK-TLS2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP8]], [[TMP7]]
// CHECK-TLS2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP9:%.*]] = call ptr @_ZTWL3gs1()
// CHECK-TLS2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP9]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A3]], align 4
// CHECK-TLS2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP11]], [[TMP10]]
// CHECK-TLS2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP12:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK-TLS2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP13]], [[TMP12]]
// CHECK-TLS2-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP14:%.*]] = call ptr @_ZTW3gs3()
// CHECK-TLS2-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP14]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[A6]], align 4
// CHECK-TLS2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// CHECK-TLS2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP17:%.*]] = call ptr @_ZTW5arr_x()
// CHECK-TLS2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP17]], i64 0, i64 1
// CHECK-TLS2-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK-TLS2-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A9]], align 4
// CHECK-TLS2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP19]], [[TMP18]]
// CHECK-TLS2-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP20:%.*]] = call ptr @_ZTWN2STIiE2stE()
// CHECK-TLS2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK-TLS2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]]
// CHECK-TLS2-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP23:%.*]] = call ptr @_ZTWN2STIfE2stE()
// CHECK-TLS2-NEXT:    [[TMP24:%.*]] = load float, ptr [[TMP23]], align 4
// CHECK-TLS2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP24]] to i32
// CHECK-TLS2-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP25]], [[CONV]]
// CHECK-TLS2-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP26:%.*]] = call ptr @_ZTWN2STI2S4E2stE()
// CHECK-TLS2-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP26]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP27:%.*]] = load i32, ptr [[A13]], align 4
// CHECK-TLS2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP28]], [[TMP27]]
// CHECK-TLS2-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP29:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    ret i32 [[TMP29]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTWL3gs1
// CHECK-TLS2-SAME: () #[[ATTR1:[0-9]+]] {
// CHECK-TLS2-NEXT:    call void @_ZTHL3gs1()
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZL3gs1)
// CHECK-TLS2-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR3:[0-9]+]] align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTWN6Static1sE
// CHECK-TLS2-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTHN6Static1sE, null
// CHECK-TLS2-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS2:       2:
// CHECK-TLS2-NEXT:    call void @_ZTHN6Static1sE()
// CHECK-TLS2-NEXT:    br label [[TMP3]]
// CHECK-TLS2:       3:
// CHECK-TLS2-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN6Static1sE)
// CHECK-TLS2-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTW3gs3
// CHECK-TLS2-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTH3gs3, null
// CHECK-TLS2-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS2:       2:
// CHECK-TLS2-NEXT:    call void @_ZTH3gs3()
// CHECK-TLS2-NEXT:    br label [[TMP3]]
// CHECK-TLS2:       3:
// CHECK-TLS2-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @gs3)
// CHECK-TLS2-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTW5arr_x
// CHECK-TLS2-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS2-NEXT:    call void @_ZTH5arr_x()
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call align 16 ptr @llvm.threadlocal.address.p0(ptr align 16 @arr_x)
// CHECK-TLS2-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTWN2STIiE2stE
// CHECK-TLS2-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIiE2stE)
// CHECK-TLS2-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTWN2STIfE2stE
// CHECK-TLS2-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIfE2stE)
// CHECK-TLS2-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZTWN2STI2S4E2stE
// CHECK-TLS2-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS2-NEXT:    call void @_ZTHN2STI2S4E2stE()
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STI2S4E2stE)
// CHECK-TLS2-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_Z6foobarv
// CHECK-TLS2-SAME: () #[[ATTR2]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = call ptr @_ZTWN6Static1sE()
// CHECK-TLS2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP0]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4
// CHECK-TLS2-NEXT:    store i32 [[TMP1]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP2:%.*]] = call ptr @_ZTWL3gs1()
// CHECK-TLS2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP2]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A1]], align 4
// CHECK-TLS2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP4]], [[TMP3]]
// CHECK-TLS2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZL3gs2, align 8
// CHECK-TLS2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]]
// CHECK-TLS2-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP7:%.*]] = call ptr @_ZTW3gs3()
// CHECK-TLS2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP7]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A3]], align 4
// CHECK-TLS2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], [[TMP8]]
// CHECK-TLS2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP10:%.*]] = call ptr @_ZTW5arr_x()
// CHECK-TLS2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP10]], i64 0, i64 1
// CHECK-TLS2-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1
// CHECK-TLS2-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[A6]], align 4
// CHECK-TLS2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], [[TMP11]]
// CHECK-TLS2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP13:%.*]] = call ptr @_ZTWN2STIiE2stE()
// CHECK-TLS2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK-TLS2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP15]], [[TMP14]]
// CHECK-TLS2-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP16:%.*]] = call ptr @_ZTWN2STIfE2stE()
// CHECK-TLS2-NEXT:    [[TMP17:%.*]] = load float, ptr [[TMP16]], align 4
// CHECK-TLS2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32
// CHECK-TLS2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP18]], [[CONV]]
// CHECK-TLS2-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP19:%.*]] = call ptr @_ZTWN2STI2S4E2stE()
// CHECK-TLS2-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP19]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[A10]], align 4
// CHECK-TLS2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], [[TMP20]]
// CHECK-TLS2-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4
// CHECK-TLS2-NEXT:    ret i32 [[TMP22]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK-TLS2-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5)
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK-TLS2-SAME: () #[[ATTR6]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27)
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// CHECK-TLS2-SAME: () #[[ATTR6]] personality ptr @__gxx_personality_v0 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK-TLS2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// CHECK-TLS2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// CHECK-TLS2:       invoke.cont:
// CHECK-TLS2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// CHECK-TLS2-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// CHECK-TLS2:       invoke.cont2:
// CHECK-TLS2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// CHECK-TLS2-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
// CHECK-TLS2:       invoke.cont3:
// CHECK-TLS2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK-TLS2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// CHECK-TLS2-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]]
// CHECK-TLS2:       invoke.cont7:
// CHECK-TLS2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// CHECK-TLS2-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]]
// CHECK-TLS2:       invoke.cont8:
// CHECK-TLS2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// CHECK-TLS2-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]]
// CHECK-TLS2:       invoke.cont9:
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
// CHECK-TLS2:       lpad:
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS2-NEXT:            cleanup
// CHECK-TLS2-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// CHECK-TLS2-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// CHECK-TLS2-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// CHECK-TLS2-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK-TLS2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]]
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK-TLS2:       arraydestroy.body:
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-TLS2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]]
// CHECK-TLS2:       arraydestroy.done4:
// CHECK-TLS2-NEXT:    br label [[EHCLEANUP:%.*]]
// CHECK-TLS2:       lpad6:
// CHECK-TLS2-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS2-NEXT:            cleanup
// CHECK-TLS2-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0
// CHECK-TLS2-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8
// CHECK-TLS2-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1
// CHECK-TLS2-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK-TLS2-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]]
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]]
// CHECK-TLS2:       arraydestroy.body11:
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1
// CHECK-TLS2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1)
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]]
// CHECK-TLS2:       arraydestroy.done15:
// CHECK-TLS2-NEXT:    br label [[EHCLEANUP]]
// CHECK-TLS2:       ehcleanup:
// CHECK-TLS2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// CHECK-TLS2-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]]
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]]
// CHECK-TLS2:       arraydestroy.body17:
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1
// CHECK-TLS2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]]
// CHECK-TLS2:       arraydestroy.done21:
// CHECK-TLS2-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK-TLS2:       eh.resume:
// CHECK-TLS2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK-TLS2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK-TLS2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK-TLS2-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK-TLS2-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]]
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK-TLS2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR6]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-TLS2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK-TLS2:       arraydestroy.body:
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK-TLS2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// CHECK-TLS2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK-TLS2:       arraydestroy.done1:
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// CHECK-TLS2-SAME: () #[[ATTR6]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK-TLS2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK-TLS2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]]
// CHECK-TLS2:       init.check:
// CHECK-TLS2-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8
// CHECK-TLS2-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23)
// CHECK-TLS2-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR4]]
// CHECK-TLS2-NEXT:    br label [[INIT_END]]
// CHECK-TLS2:       init.end:
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]])
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR4]]
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK-TLS2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// CHECK-TLS2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK-TLS2-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// CHECK-TLS2-SAME: () #[[ATTR6]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    call void @__cxx_global_var_init.1()
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS2-LABEL: define {{[^@]+}}@__tls_init
// CHECK-TLS2-SAME: () #[[ATTR6]] {
// CHECK-TLS2-NEXT:  entry:
// CHECK-TLS2-NEXT:    [[TMP0:%.*]] = load i8, ptr @__tls_guard, align 1
// CHECK-TLS2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// CHECK-TLS2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT:%.*]], label [[EXIT:%.*]], !prof [[PROF3]]
// CHECK-TLS2:       init:
// CHECK-TLS2-NEXT:    store i8 1, ptr @__tls_guard, align 1
// CHECK-TLS2-NEXT:    call void @__cxx_global_var_init()
// CHECK-TLS2-NEXT:    call void @__cxx_global_var_init.2()
// CHECK-TLS2-NEXT:    br label [[EXIT]]
// CHECK-TLS2:       exit:
// CHECK-TLS2-NEXT:    ret void
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK-TLS3-SAME: () #[[ATTR0:[0-9]+]] !dbg [[DBG116:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5), !dbg [[DBG119:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]], !dbg [[DBG121:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG122:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 !dbg [[DBG123:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META124:![0-9]+]], !DIExpression(), [[META126:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META127:![0-9]+]], !DIExpression(), [[META128:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG129:![0-9]+]]
// CHECK-TLS3-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG129]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG130:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 !dbg [[DBG131:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META132:![0-9]+]], !DIExpression(), [[META133:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]], !dbg [[DBG134:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG135:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG136:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META137:![0-9]+]], !DIExpression(), [[META138:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META139:![0-9]+]], !DIExpression(), [[META140:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG141:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG142:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG141]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG143:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG144:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META145:![0-9]+]], !DIExpression(), [[META146:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG147:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG149:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG150:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK-TLS3-SAME: () #[[ATTR0]] !dbg [[DBG151:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27), !dbg [[DBG152:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG154:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG155:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG156:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META157:![0-9]+]], !DIExpression(), [[META159:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META160:![0-9]+]], !DIExpression(), [[META161:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG162:![0-9]+]]
// CHECK-TLS3-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG162]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG163:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG164:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META165:![0-9]+]], !DIExpression(), [[META166:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]], !dbg [[DBG167:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG168:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG169:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META170:![0-9]+]], !DIExpression(), [[META171:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META172:![0-9]+]], !DIExpression(), [[META173:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG174:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG175:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG174]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG176:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG177:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META178:![0-9]+]], !DIExpression(), [[META179:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG180:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG182:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG183:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// CHECK-TLS3-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG184:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG185:![0-9]+]]
// CHECK-TLS3-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG187:![0-9]+]]
// CHECK-TLS3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// CHECK-TLS3-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG188:![0-9]+]]
// CHECK-TLS3:       invoke.cont:
// CHECK-TLS3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// CHECK-TLS3-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG189:![0-9]+]]
// CHECK-TLS3:       invoke.cont2:
// CHECK-TLS3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// CHECK-TLS3-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]], !dbg [[DBG190:![0-9]+]]
// CHECK-TLS3:       invoke.cont3:
// CHECK-TLS3-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG191:![0-9]+]]
// CHECK-TLS3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// CHECK-TLS3-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]], !dbg [[DBG192:![0-9]+]]
// CHECK-TLS3:       invoke.cont7:
// CHECK-TLS3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// CHECK-TLS3-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]], !dbg [[DBG193:![0-9]+]]
// CHECK-TLS3:       invoke.cont8:
// CHECK-TLS3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// CHECK-TLS3-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]], !dbg [[DBG194:![0-9]+]]
// CHECK-TLS3:       invoke.cont9:
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG195:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG195]]
// CHECK-TLS3:       lpad:
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS3-NEXT:            cleanup, !dbg [[DBG196:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]], !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG187]]
// CHECK-TLS3:       arraydestroy.body:
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[DBG187]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG187]]
// CHECK-TLS3:       arraydestroy.done4:
// CHECK-TLS3-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG187]]
// CHECK-TLS3:       lpad6:
// CHECK-TLS3-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS3-NEXT:            cleanup, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG196]]
// CHECK-TLS3-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]], !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]], !dbg [[DBG191]]
// CHECK-TLS3:       arraydestroy.body11:
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ], !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1, !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]], !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), !dbg [[DBG191]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]], !dbg [[DBG191]]
// CHECK-TLS3:       arraydestroy.done15:
// CHECK-TLS3-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG191]]
// CHECK-TLS3:       ehcleanup:
// CHECK-TLS3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]], !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]], !dbg [[DBG185]]
// CHECK-TLS3:       arraydestroy.body17:
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ], !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]], !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]], !dbg [[DBG185]]
// CHECK-TLS3:       arraydestroy.done21:
// CHECK-TLS3-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG185]]
// CHECK-TLS3:       eh.resume:
// CHECK-TLS3-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG185]]
// CHECK-TLS3-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]], !dbg [[DBG185]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK-TLS3-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG197:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META201:![0-9]+]], !DIExpression(), [[META202:![0-9]+]])
// CHECK-TLS3-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META202]]
// CHECK-TLS3:       arraydestroy.body:
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META202]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META202]]
// CHECK-TLS3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META202]]
// CHECK-TLS3-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[META202]]
// CHECK-TLS3-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META202]]
// CHECK-TLS3:       arraydestroy.done1:
// CHECK-TLS3-NEXT:    ret void, !dbg [[META202]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@main
// CHECK-TLS3-SAME: () #[[ATTR4:[0-9]+]] !dbg [[DBG52:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[RES]], [[META203:![0-9]+]], !DIExpression(), [[META204:![0-9]+]])
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVZ4mainE2sm, align 1, !dbg [[DBG205:![0-9]+]]
// CHECK-TLS3-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG205]]
// CHECK-TLS3-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG205]], !prof [[PROF206:![0-9]+]]
// CHECK-TLS3:       init.check:
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = call ptr @_ZTWL3gs1(), !dbg [[DBG207:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP1]], i32 0, i32 0, !dbg [[DBG208:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG208]]
// CHECK-TLS3-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]]), !dbg [[DBG209:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG205]]
// CHECK-TLS3-NEXT:    store i8 1, ptr @_ZGVZ4mainE2sm, align 1, !dbg [[DBG205]]
// CHECK-TLS3-NEXT:    br label [[INIT_END]], !dbg [[DBG205]]
// CHECK-TLS3:       init.end:
// CHECK-TLS3-NEXT:    [[TMP4:%.*]] = call ptr @_ZTWN6Static1sE(), !dbg [[DBG210:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP4]], i32 0, i32 0, !dbg [[DBG211:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG211]]
// CHECK-TLS3-NEXT:    store i32 [[TMP5]], ptr [[RES]], align 4, !dbg [[DBG212:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP6:%.*]] = call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @_ZZ4mainE2sm), !dbg [[DBG213:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP6]], i32 0, i32 0, !dbg [[DBG214:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[A2]], align 8, !dbg [[DBG214]]
// CHECK-TLS3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG215:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP8]], [[TMP7]], !dbg [[DBG215]]
// CHECK-TLS3-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG215]]
// CHECK-TLS3-NEXT:    [[TMP9:%.*]] = call ptr @_ZTWL3gs1(), !dbg [[DBG216:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP9]], i32 0, i32 0, !dbg [[DBG217:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG217]]
// CHECK-TLS3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG218:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP11]], [[TMP10]], !dbg [[DBG218]]
// CHECK-TLS3-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG218]]
// CHECK-TLS3-NEXT:    [[TMP12:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG219:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG220:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP13]], [[TMP12]], !dbg [[DBG220]]
// CHECK-TLS3-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG220]]
// CHECK-TLS3-NEXT:    [[TMP14:%.*]] = call ptr @_ZTW3gs3(), !dbg [[DBG221:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP14]], i32 0, i32 0, !dbg [[DBG222:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG222]]
// CHECK-TLS3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG223:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG223]]
// CHECK-TLS3-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG223]]
// CHECK-TLS3-NEXT:    [[TMP17:%.*]] = call ptr @_ZTW5arr_x(), !dbg [[DBG224:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP17]], i64 0, i64 1, !dbg [[DBG224]]
// CHECK-TLS3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG224]]
// CHECK-TLS3-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0, !dbg [[DBG225:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A9]], align 4, !dbg [[DBG225]]
// CHECK-TLS3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG226:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP19]], [[TMP18]], !dbg [[DBG226]]
// CHECK-TLS3-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4, !dbg [[DBG226]]
// CHECK-TLS3-NEXT:    [[TMP20:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIiE2stE), !dbg [[DBG227:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4, !dbg [[DBG227]]
// CHECK-TLS3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG228:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]], !dbg [[DBG228]]
// CHECK-TLS3-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG228]]
// CHECK-TLS3-NEXT:    [[TMP23:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIfE2stE), !dbg [[DBG229:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP24:%.*]] = load float, ptr [[TMP23]], align 4, !dbg [[DBG229]]
// CHECK-TLS3-NEXT:    [[CONV:%.*]] = fptosi float [[TMP24]] to i32, !dbg [[DBG229]]
// CHECK-TLS3-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG230:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP25]], [[CONV]], !dbg [[DBG230]]
// CHECK-TLS3-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4, !dbg [[DBG230]]
// CHECK-TLS3-NEXT:    [[TMP26:%.*]] = call ptr @_ZTWN2STI2S4E2stE(), !dbg [[DBG231:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP26]], i32 0, i32 0, !dbg [[DBG232:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP27:%.*]] = load i32, ptr [[A13]], align 4, !dbg [[DBG232]]
// CHECK-TLS3-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG233:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP28]], [[TMP27]], !dbg [[DBG233]]
// CHECK-TLS3-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4, !dbg [[DBG233]]
// CHECK-TLS3-NEXT:    [[TMP29:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG234:![0-9]+]]
// CHECK-TLS3-NEXT:    ret i32 [[TMP29]], !dbg [[DBG235:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZTWL3gs1
// CHECK-TLS3-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK-TLS3-NEXT:    call void @_ZTHL3gs1()
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZL3gs1)
// CHECK-TLS3-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG236:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META237:![0-9]+]], !DIExpression(), [[META239:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META240:![0-9]+]], !DIExpression(), [[META241:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG242:![0-9]+]]
// CHECK-TLS3-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG242]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG243:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG244:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META245:![0-9]+]], !DIExpression(), [[META246:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]], !dbg [[DBG247:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG248:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZTWN6Static1sE
// CHECK-TLS3-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTHN6Static1sE, null
// CHECK-TLS3-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS3:       2:
// CHECK-TLS3-NEXT:    call void @_ZTHN6Static1sE()
// CHECK-TLS3-NEXT:    br label [[TMP3]]
// CHECK-TLS3:       3:
// CHECK-TLS3-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN6Static1sE)
// CHECK-TLS3-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZTW3gs3
// CHECK-TLS3-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTH3gs3, null
// CHECK-TLS3-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS3:       2:
// CHECK-TLS3-NEXT:    call void @_ZTH3gs3()
// CHECK-TLS3-NEXT:    br label [[TMP3]]
// CHECK-TLS3:       3:
// CHECK-TLS3-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @gs3)
// CHECK-TLS3-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZTW5arr_x
// CHECK-TLS3-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS3-NEXT:    call void @_ZTH5arr_x()
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = call align 16 ptr @llvm.threadlocal.address.p0(ptr align 16 @arr_x)
// CHECK-TLS3-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZTWN2STI2S4E2stE
// CHECK-TLS3-SAME: () #[[ATTR5]] comdat {
// CHECK-TLS3-NEXT:    call void @_ZTHN2STI2S4E2stE()
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STI2S4E2stE)
// CHECK-TLS3-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG249:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META250:![0-9]+]], !DIExpression(), [[META251:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META252:![0-9]+]], !DIExpression(), [[META253:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG254:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG255:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG254]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG256:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG257:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META258:![0-9]+]], !DIExpression(), [[META259:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG260:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG262:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG263:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_Z6foobarv
// CHECK-TLS3-SAME: () #[[ATTR1]] !dbg [[DBG264:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[RES]], [[META265:![0-9]+]], !DIExpression(), [[META266:![0-9]+]])
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = call ptr @_ZTWN6Static1sE(), !dbg [[DBG267:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP0]], i32 0, i32 0, !dbg [[DBG268:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG268]]
// CHECK-TLS3-NEXT:    store i32 [[TMP1]], ptr [[RES]], align 4, !dbg [[DBG269:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP2:%.*]] = call ptr @_ZTWL3gs1(), !dbg [[DBG270:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP2]], i32 0, i32 0, !dbg [[DBG271:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG271]]
// CHECK-TLS3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG272:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP4]], [[TMP3]], !dbg [[DBG272]]
// CHECK-TLS3-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG272]]
// CHECK-TLS3-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG273:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG274:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]], !dbg [[DBG274]]
// CHECK-TLS3-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG274]]
// CHECK-TLS3-NEXT:    [[TMP7:%.*]] = call ptr @_ZTW3gs3(), !dbg [[DBG275:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP7]], i32 0, i32 0, !dbg [[DBG276:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG276]]
// CHECK-TLS3-NEXT:    [[TMP9:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG277:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], [[TMP8]], !dbg [[DBG277]]
// CHECK-TLS3-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG277]]
// CHECK-TLS3-NEXT:    [[TMP10:%.*]] = call ptr @_ZTW5arr_x(), !dbg [[DBG278:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP10]], i64 0, i64 1, !dbg [[DBG278]]
// CHECK-TLS3-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG278]]
// CHECK-TLS3-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0, !dbg [[DBG279:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG279]]
// CHECK-TLS3-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG280:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], [[TMP11]], !dbg [[DBG280]]
// CHECK-TLS3-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG280]]
// CHECK-TLS3-NEXT:    [[TMP13:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIiE2stE), !dbg [[DBG281:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4, !dbg [[DBG281]]
// CHECK-TLS3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG282:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP15]], [[TMP14]], !dbg [[DBG282]]
// CHECK-TLS3-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4, !dbg [[DBG282]]
// CHECK-TLS3-NEXT:    [[TMP16:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIfE2stE), !dbg [[DBG283:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP17:%.*]] = load float, ptr [[TMP16]], align 4, !dbg [[DBG283]]
// CHECK-TLS3-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32, !dbg [[DBG283]]
// CHECK-TLS3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG284:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP18]], [[CONV]], !dbg [[DBG284]]
// CHECK-TLS3-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4, !dbg [[DBG284]]
// CHECK-TLS3-NEXT:    [[TMP19:%.*]] = call ptr @_ZTWN2STI2S4E2stE(), !dbg [[DBG285:![0-9]+]]
// CHECK-TLS3-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP19]], i32 0, i32 0, !dbg [[DBG286:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[A10]], align 4, !dbg [[DBG286]]
// CHECK-TLS3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG287:![0-9]+]]
// CHECK-TLS3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], [[TMP20]], !dbg [[DBG287]]
// CHECK-TLS3-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG287]]
// CHECK-TLS3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG288:![0-9]+]]
// CHECK-TLS3-NEXT:    ret i32 [[TMP22]], !dbg [[DBG289:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// CHECK-TLS3-SAME: () #[[ATTR0]] !dbg [[DBG290:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG291:![0-9]+]]
// CHECK-TLS3-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG291]]
// CHECK-TLS3-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG291]]
// CHECK-TLS3:       init.check:
// CHECK-TLS3-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG291]]
// CHECK-TLS3-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23), !dbg [[DBG292:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG291]]
// CHECK-TLS3-NEXT:    br label [[INIT_END]], !dbg [[DBG291]]
// CHECK-TLS3:       init.end:
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG294:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG295:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META296:![0-9]+]], !DIExpression(), [[META298:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META299:![0-9]+]], !DIExpression(), [[META300:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG301:![0-9]+]]
// CHECK-TLS3-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG301]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG302:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG303:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META304:![0-9]+]], !DIExpression(), [[META305:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]], !dbg [[DBG306:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG307:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG308:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META309:![0-9]+]], !DIExpression(), [[META310:![0-9]+]])
// CHECK-TLS3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META311:![0-9]+]], !DIExpression(), [[META312:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG313:![0-9]+]]
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG314:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG313]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG315:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// CHECK-TLS3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG316:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META317:![0-9]+]], !DIExpression(), [[META318:![0-9]+]])
// CHECK-TLS3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG319:![0-9]+]]
// CHECK-TLS3-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG321:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void, !dbg [[DBG322:![0-9]+]]
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// CHECK-TLS3-SAME: () #[[ATTR0]] !dbg [[DBG323:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    call void @__cxx_global_var_init.1(), !dbg [[DBG325:![0-9]+]]
// CHECK-TLS3-NEXT:    ret void
//
//
// CHECK-TLS3-LABEL: define {{[^@]+}}@__tls_init
// CHECK-TLS3-SAME: () #[[ATTR0]] !dbg [[DBG326:![0-9]+]] {
// CHECK-TLS3-NEXT:  entry:
// CHECK-TLS3-NEXT:    [[TMP0:%.*]] = load i8, ptr @__tls_guard, align 1, !dbg [[DBG327:![0-9]+]]
// CHECK-TLS3-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG327]]
// CHECK-TLS3-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT:%.*]], label [[EXIT:%.*]], !dbg [[DBG327]], !prof [[PROF206]]
// CHECK-TLS3:       init:
// CHECK-TLS3-NEXT:    store i8 1, ptr @__tls_guard, align 1, !dbg [[DBG327]]
// CHECK-TLS3-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG327]]
// CHECK-TLS3-NEXT:    call void @__cxx_global_var_init.2(), !dbg [[DBG327]]
// CHECK-TLS3-NEXT:    br label [[EXIT]], !dbg [[DBG327]]
// CHECK-TLS3:       exit:
// CHECK-TLS3-NEXT:    ret void
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@main
// CHECK-TLS4-SAME: () #[[ATTR0:[0-9]+]] !dbg [[DBG9:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[RES]], [[META116:![0-9]+]], !DIExpression(), [[META117:![0-9]+]])
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVZ4mainE2sm, align 1, !dbg [[DBG118:![0-9]+]]
// CHECK-TLS4-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG118]]
// CHECK-TLS4-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG118]], !prof [[PROF119:![0-9]+]]
// CHECK-TLS4:       init.check:
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call ptr @_ZTWL3gs1(), !dbg [[DBG120:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP1]], i32 0, i32 0, !dbg [[DBG121:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG121]]
// CHECK-TLS4-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]]), !dbg [[DBG122:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR4:[0-9]+]], !dbg [[DBG118]]
// CHECK-TLS4-NEXT:    store i8 1, ptr @_ZGVZ4mainE2sm, align 1, !dbg [[DBG118]]
// CHECK-TLS4-NEXT:    br label [[INIT_END]], !dbg [[DBG118]]
// CHECK-TLS4:       init.end:
// CHECK-TLS4-NEXT:    [[TMP4:%.*]] = call ptr @_ZTWN6Static1sE(), !dbg [[DBG123:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP4]], i32 0, i32 0, !dbg [[DBG124:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG124]]
// CHECK-TLS4-NEXT:    store i32 [[TMP5]], ptr [[RES]], align 4, !dbg [[DBG125:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP6:%.*]] = call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @_ZZ4mainE2sm), !dbg [[DBG126:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP6]], i32 0, i32 0, !dbg [[DBG127:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP7:%.*]] = load i32, ptr [[A2]], align 8, !dbg [[DBG127]]
// CHECK-TLS4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG128:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP8]], [[TMP7]], !dbg [[DBG128]]
// CHECK-TLS4-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG128]]
// CHECK-TLS4-NEXT:    [[TMP9:%.*]] = call ptr @_ZTWL3gs1(), !dbg [[DBG129:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP9]], i32 0, i32 0, !dbg [[DBG130:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG130]]
// CHECK-TLS4-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG131:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP11]], [[TMP10]], !dbg [[DBG131]]
// CHECK-TLS4-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG131]]
// CHECK-TLS4-NEXT:    [[TMP12:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG132:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG133:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP13]], [[TMP12]], !dbg [[DBG133]]
// CHECK-TLS4-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG133]]
// CHECK-TLS4-NEXT:    [[TMP14:%.*]] = call ptr @_ZTW3gs3(), !dbg [[DBG134:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP14]], i32 0, i32 0, !dbg [[DBG135:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP15:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG135]]
// CHECK-TLS4-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG136:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG136]]
// CHECK-TLS4-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG136]]
// CHECK-TLS4-NEXT:    [[TMP17:%.*]] = call ptr @_ZTW5arr_x(), !dbg [[DBG137:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP17]], i64 0, i64 1, !dbg [[DBG137]]
// CHECK-TLS4-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG137]]
// CHECK-TLS4-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0, !dbg [[DBG138:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A9]], align 4, !dbg [[DBG138]]
// CHECK-TLS4-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG139:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP19]], [[TMP18]], !dbg [[DBG139]]
// CHECK-TLS4-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4, !dbg [[DBG139]]
// CHECK-TLS4-NEXT:    [[TMP20:%.*]] = call ptr @_ZTWN2STIiE2stE(), !dbg [[DBG140:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4, !dbg [[DBG140]]
// CHECK-TLS4-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG141:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]], !dbg [[DBG141]]
// CHECK-TLS4-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG141]]
// CHECK-TLS4-NEXT:    [[TMP23:%.*]] = call ptr @_ZTWN2STIfE2stE(), !dbg [[DBG142:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP24:%.*]] = load float, ptr [[TMP23]], align 4, !dbg [[DBG142]]
// CHECK-TLS4-NEXT:    [[CONV:%.*]] = fptosi float [[TMP24]] to i32, !dbg [[DBG142]]
// CHECK-TLS4-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG143:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP25]], [[CONV]], !dbg [[DBG143]]
// CHECK-TLS4-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4, !dbg [[DBG143]]
// CHECK-TLS4-NEXT:    [[TMP26:%.*]] = call ptr @_ZTWN2STI2S4E2stE(), !dbg [[DBG144:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP26]], i32 0, i32 0, !dbg [[DBG145:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP27:%.*]] = load i32, ptr [[A13]], align 4, !dbg [[DBG145]]
// CHECK-TLS4-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG146:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP28]], [[TMP27]], !dbg [[DBG146]]
// CHECK-TLS4-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4, !dbg [[DBG146]]
// CHECK-TLS4-NEXT:    [[TMP29:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG147:![0-9]+]]
// CHECK-TLS4-NEXT:    ret i32 [[TMP29]], !dbg [[DBG148:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTWL3gs1
// CHECK-TLS4-SAME: () #[[ATTR1:[0-9]+]] {
// CHECK-TLS4-NEXT:    call void @_ZTHL3gs1()
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZL3gs1)
// CHECK-TLS4-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] align 2 !dbg [[DBG149:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META150:![0-9]+]], !DIExpression(), [[META152:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META153:![0-9]+]], !DIExpression(), [[META154:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG155:![0-9]+]]
// CHECK-TLS4-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG155]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG156:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR3:[0-9]+]] align 2 !dbg [[DBG157:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META158:![0-9]+]], !DIExpression(), [[META159:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR4]], !dbg [[DBG160:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG161:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTWN6Static1sE
// CHECK-TLS4-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTHN6Static1sE, null
// CHECK-TLS4-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS4:       2:
// CHECK-TLS4-NEXT:    call void @_ZTHN6Static1sE()
// CHECK-TLS4-NEXT:    br label [[TMP3]]
// CHECK-TLS4:       3:
// CHECK-TLS4-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN6Static1sE)
// CHECK-TLS4-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTW3gs3
// CHECK-TLS4-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = icmp ne ptr @_ZTH3gs3, null
// CHECK-TLS4-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
// CHECK-TLS4:       2:
// CHECK-TLS4-NEXT:    call void @_ZTH3gs3()
// CHECK-TLS4-NEXT:    br label [[TMP3]]
// CHECK-TLS4:       3:
// CHECK-TLS4-NEXT:    [[TMP4:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @gs3)
// CHECK-TLS4-NEXT:    ret ptr [[TMP4]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTW5arr_x
// CHECK-TLS4-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS4-NEXT:    call void @_ZTH5arr_x()
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call align 16 ptr @llvm.threadlocal.address.p0(ptr align 16 @arr_x)
// CHECK-TLS4-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTWN2STIiE2stE
// CHECK-TLS4-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIiE2stE)
// CHECK-TLS4-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTWN2STIfE2stE
// CHECK-TLS4-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STIfE2stE)
// CHECK-TLS4-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZTWN2STI2S4E2stE
// CHECK-TLS4-SAME: () #[[ATTR1]] comdat {
// CHECK-TLS4-NEXT:    call void @_ZTHN2STI2S4E2stE()
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @_ZN2STI2S4E2stE)
// CHECK-TLS4-NEXT:    ret ptr [[TMP1]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_Z6foobarv
// CHECK-TLS4-SAME: () #[[ATTR2]] !dbg [[DBG162:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[RES:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[RES]], [[META163:![0-9]+]], !DIExpression(), [[META164:![0-9]+]])
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = call ptr @_ZTWN6Static1sE(), !dbg [[DBG165:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP0]], i32 0, i32 0, !dbg [[DBG166:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG166]]
// CHECK-TLS4-NEXT:    store i32 [[TMP1]], ptr [[RES]], align 4, !dbg [[DBG167:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP2:%.*]] = call ptr @_ZTWL3gs1(), !dbg [[DBG168:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP2]], i32 0, i32 0, !dbg [[DBG169:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG169]]
// CHECK-TLS4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG170:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP4]], [[TMP3]], !dbg [[DBG170]]
// CHECK-TLS4-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG170]]
// CHECK-TLS4-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG171:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG172:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]], !dbg [[DBG172]]
// CHECK-TLS4-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG172]]
// CHECK-TLS4-NEXT:    [[TMP7:%.*]] = call ptr @_ZTW3gs3(), !dbg [[DBG173:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP7]], i32 0, i32 0, !dbg [[DBG174:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG174]]
// CHECK-TLS4-NEXT:    [[TMP9:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG175:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], [[TMP8]], !dbg [[DBG175]]
// CHECK-TLS4-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG175]]
// CHECK-TLS4-NEXT:    [[TMP10:%.*]] = call ptr @_ZTW5arr_x(), !dbg [[DBG176:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP10]], i64 0, i64 1, !dbg [[DBG176]]
// CHECK-TLS4-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG176]]
// CHECK-TLS4-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0, !dbg [[DBG177:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP11:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG177]]
// CHECK-TLS4-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG178:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], [[TMP11]], !dbg [[DBG178]]
// CHECK-TLS4-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG178]]
// CHECK-TLS4-NEXT:    [[TMP13:%.*]] = call ptr @_ZTWN2STIiE2stE(), !dbg [[DBG179:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4, !dbg [[DBG179]]
// CHECK-TLS4-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG180:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP15]], [[TMP14]], !dbg [[DBG180]]
// CHECK-TLS4-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4, !dbg [[DBG180]]
// CHECK-TLS4-NEXT:    [[TMP16:%.*]] = call ptr @_ZTWN2STIfE2stE(), !dbg [[DBG181:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP17:%.*]] = load float, ptr [[TMP16]], align 4, !dbg [[DBG181]]
// CHECK-TLS4-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32, !dbg [[DBG181]]
// CHECK-TLS4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG182:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP18]], [[CONV]], !dbg [[DBG182]]
// CHECK-TLS4-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4, !dbg [[DBG182]]
// CHECK-TLS4-NEXT:    [[TMP19:%.*]] = call ptr @_ZTWN2STI2S4E2stE(), !dbg [[DBG183:![0-9]+]]
// CHECK-TLS4-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP19]], i32 0, i32 0, !dbg [[DBG184:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[A10]], align 4, !dbg [[DBG184]]
// CHECK-TLS4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG185:![0-9]+]]
// CHECK-TLS4-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], [[TMP20]], !dbg [[DBG185]]
// CHECK-TLS4-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG185]]
// CHECK-TLS4-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG186:![0-9]+]]
// CHECK-TLS4-NEXT:    ret i32 [[TMP22]], !dbg [[DBG187:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK-TLS4-SAME: () #[[ATTR6:[0-9]+]] !dbg [[DBG188:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5), !dbg [[DBG191:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR4]], !dbg [[DBG193:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG194:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG195:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META196:![0-9]+]], !DIExpression(), [[META198:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META199:![0-9]+]], !DIExpression(), [[META200:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG201:![0-9]+]]
// CHECK-TLS4-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG201]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG202:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG203:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META204:![0-9]+]], !DIExpression(), [[META205:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]], !dbg [[DBG206:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG207:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG208:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META209:![0-9]+]], !DIExpression(), [[META210:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META211:![0-9]+]], !DIExpression(), [[META212:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG213:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG214:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG213]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG215:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG216:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META217:![0-9]+]], !DIExpression(), [[META218:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG219:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG221:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG222:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK-TLS4-SAME: () #[[ATTR6]] !dbg [[DBG223:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27), !dbg [[DBG224:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR4]], !dbg [[DBG226:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG227:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG228:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META229:![0-9]+]], !DIExpression(), [[META231:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META232:![0-9]+]], !DIExpression(), [[META233:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG234:![0-9]+]]
// CHECK-TLS4-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG234]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG235:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG236:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META237:![0-9]+]], !DIExpression(), [[META238:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR4]], !dbg [[DBG239:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG240:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG241:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META242:![0-9]+]], !DIExpression(), [[META243:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META244:![0-9]+]], !DIExpression(), [[META245:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG246:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG247:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG246]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG248:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG249:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META250:![0-9]+]], !DIExpression(), [[META251:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG252:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG254:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG255:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// CHECK-TLS4-SAME: () #[[ATTR6]] personality ptr @__gxx_personality_v0 !dbg [[DBG256:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG257:![0-9]+]]
// CHECK-TLS4-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG259:![0-9]+]]
// CHECK-TLS4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// CHECK-TLS4-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG260:![0-9]+]]
// CHECK-TLS4:       invoke.cont:
// CHECK-TLS4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// CHECK-TLS4-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG261:![0-9]+]]
// CHECK-TLS4:       invoke.cont2:
// CHECK-TLS4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// CHECK-TLS4-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]], !dbg [[DBG262:![0-9]+]]
// CHECK-TLS4:       invoke.cont3:
// CHECK-TLS4-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG263:![0-9]+]]
// CHECK-TLS4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// CHECK-TLS4-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]], !dbg [[DBG264:![0-9]+]]
// CHECK-TLS4:       invoke.cont7:
// CHECK-TLS4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// CHECK-TLS4-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]], !dbg [[DBG265:![0-9]+]]
// CHECK-TLS4:       invoke.cont8:
// CHECK-TLS4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// CHECK-TLS4-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]], !dbg [[DBG266:![0-9]+]]
// CHECK-TLS4:       invoke.cont9:
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_thread_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR4]], !dbg [[DBG267:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG267]]
// CHECK-TLS4:       lpad:
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS4-NEXT:            cleanup, !dbg [[DBG268:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]], !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG259]]
// CHECK-TLS4:       arraydestroy.body:
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]], !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[DBG259]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG259]]
// CHECK-TLS4:       arraydestroy.done4:
// CHECK-TLS4-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG259]]
// CHECK-TLS4:       lpad6:
// CHECK-TLS4-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// CHECK-TLS4-NEXT:            cleanup, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG268]]
// CHECK-TLS4-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]], !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]], !dbg [[DBG263]]
// CHECK-TLS4:       arraydestroy.body11:
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ], !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1, !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR4]], !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), !dbg [[DBG263]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]], !dbg [[DBG263]]
// CHECK-TLS4:       arraydestroy.done15:
// CHECK-TLS4-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG263]]
// CHECK-TLS4:       ehcleanup:
// CHECK-TLS4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]], !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]], !dbg [[DBG257]]
// CHECK-TLS4:       arraydestroy.body17:
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ], !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR4]], !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]], !dbg [[DBG257]]
// CHECK-TLS4:       arraydestroy.done21:
// CHECK-TLS4-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG257]]
// CHECK-TLS4:       eh.resume:
// CHECK-TLS4-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG257]]
// CHECK-TLS4-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]], !dbg [[DBG257]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK-TLS4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR6]] !dbg [[DBG269:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META273:![0-9]+]], !DIExpression(), [[META274:![0-9]+]])
// CHECK-TLS4-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META274]]
// CHECK-TLS4:       arraydestroy.body:
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META274]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META274]]
// CHECK-TLS4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]], !dbg [[META274]]
// CHECK-TLS4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[META274]]
// CHECK-TLS4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META274]]
// CHECK-TLS4:       arraydestroy.done1:
// CHECK-TLS4-NEXT:    ret void, !dbg [[META274]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] align 2 !dbg [[DBG275:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META276:![0-9]+]], !DIExpression(), [[META277:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META278:![0-9]+]], !DIExpression(), [[META279:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG280:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG281:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG280]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG282:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] align 2 !dbg [[DBG283:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META284:![0-9]+]], !DIExpression(), [[META285:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG286:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG288:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG289:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// CHECK-TLS4-SAME: () #[[ATTR6]] !dbg [[DBG290:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG291:![0-9]+]]
// CHECK-TLS4-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG291]]
// CHECK-TLS4-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG291]]
// CHECK-TLS4:       init.check:
// CHECK-TLS4-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG291]]
// CHECK-TLS4-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23), !dbg [[DBG292:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_thread_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR4]], !dbg [[DBG291]]
// CHECK-TLS4-NEXT:    br label [[INIT_END]], !dbg [[DBG291]]
// CHECK-TLS4:       init.end:
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG294:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG295:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META296:![0-9]+]], !DIExpression(), [[META298:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META299:![0-9]+]], !DIExpression(), [[META300:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG301:![0-9]+]]
// CHECK-TLS4-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG301]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG302:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG303:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META304:![0-9]+]], !DIExpression(), [[META305:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR4]], !dbg [[DBG306:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG307:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG308:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META309:![0-9]+]], !DIExpression(), [[META310:![0-9]+]])
// CHECK-TLS4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META311:![0-9]+]], !DIExpression(), [[META312:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG313:![0-9]+]]
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG314:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG313]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG315:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// CHECK-TLS4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR3]] comdat align 2 !dbg [[DBG316:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK-TLS4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META317:![0-9]+]], !DIExpression(), [[META318:![0-9]+]])
// CHECK-TLS4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK-TLS4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG319:![0-9]+]]
// CHECK-TLS4-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG321:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void, !dbg [[DBG322:![0-9]+]]
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// CHECK-TLS4-SAME: () #[[ATTR6]] !dbg [[DBG323:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    call void @__cxx_global_var_init.1(), !dbg [[DBG325:![0-9]+]]
// CHECK-TLS4-NEXT:    ret void
//
//
// CHECK-TLS4-LABEL: define {{[^@]+}}@__tls_init
// CHECK-TLS4-SAME: () #[[ATTR6]] !dbg [[DBG326:![0-9]+]] {
// CHECK-TLS4-NEXT:  entry:
// CHECK-TLS4-NEXT:    [[TMP0:%.*]] = load i8, ptr @__tls_guard, align 1, !dbg [[DBG327:![0-9]+]]
// CHECK-TLS4-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG327]]
// CHECK-TLS4-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT:%.*]], label [[EXIT:%.*]], !dbg [[DBG327]], !prof [[PROF119]]
// CHECK-TLS4:       init:
// CHECK-TLS4-NEXT:    store i8 1, ptr @__tls_guard, align 1, !dbg [[DBG327]]
// CHECK-TLS4-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG327]]
// CHECK-TLS4-NEXT:    call void @__cxx_global_var_init.2(), !dbg [[DBG327]]
// CHECK-TLS4-NEXT:    br label [[EXIT]], !dbg [[DBG327]]
// CHECK-TLS4:       exit:
// CHECK-TLS4-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@__cxx_global_var_init
// SIMD3-SAME: () #[[ATTR0:[0-9]+]] {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5)
// SIMD3-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]]
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// SIMD3-SAME: () #[[ATTR0]] {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27)
// SIMD3-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]]
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]])
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]]
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// SIMD3-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// SIMD3-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// SIMD3-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// SIMD3:       invoke.cont:
// SIMD3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// SIMD3-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
// SIMD3:       invoke.cont2:
// SIMD3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// SIMD3-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
// SIMD3:       invoke.cont3:
// SIMD3-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8
// SIMD3-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// SIMD3-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]]
// SIMD3:       invoke.cont7:
// SIMD3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// SIMD3-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]]
// SIMD3:       invoke.cont8:
// SIMD3-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD3-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// SIMD3-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]]
// SIMD3:       invoke.cont9:
// SIMD3-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// SIMD3-NEXT:    ret void
// SIMD3:       lpad:
// SIMD3-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// SIMD3-NEXT:            cleanup
// SIMD3-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// SIMD3-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// SIMD3-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// SIMD3-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// SIMD3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8
// SIMD3-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]]
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// SIMD3:       arraydestroy.body:
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// SIMD3-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]]
// SIMD3:       arraydestroy.done4:
// SIMD3-NEXT:    br label [[EHCLEANUP:%.*]]
// SIMD3:       lpad6:
// SIMD3-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// SIMD3-NEXT:            cleanup
// SIMD3-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0
// SIMD3-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8
// SIMD3-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1
// SIMD3-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4
// SIMD3-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8
// SIMD3-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]]
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]]
// SIMD3:       arraydestroy.body11:
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ]
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1
// SIMD3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]]
// SIMD3-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1)
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]]
// SIMD3:       arraydestroy.done15:
// SIMD3-NEXT:    br label [[EHCLEANUP]]
// SIMD3:       ehcleanup:
// SIMD3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8
// SIMD3-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0
// SIMD3-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]]
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]]
// SIMD3:       arraydestroy.body17:
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ]
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1
// SIMD3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]]
// SIMD3-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]]
// SIMD3:       arraydestroy.done21:
// SIMD3-NEXT:    br label [[EH_RESUME:%.*]]
// SIMD3:       eh.resume:
// SIMD3-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// SIMD3-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// SIMD3-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// SIMD3-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// SIMD3-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]]
//
//
// SIMD3-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// SIMD3-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SIMD3-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// SIMD3:       arraydestroy.body:
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// SIMD3-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// SIMD3-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// SIMD3-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x
// SIMD3-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// SIMD3:       arraydestroy.done1:
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@main
// SIMD3-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD3-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8
// SIMD3-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// SIMD3-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !prof [[PROF2:![0-9]+]]
// SIMD3:       init.check:
// SIMD3-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// SIMD3-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP1]], 0
// SIMD3-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]]
// SIMD3:       init:
// SIMD3-NEXT:    [[TMP2:%.*]] = load i32, ptr @_ZL3gs1, align 4
// SIMD3-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]])
// SIMD3-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
// SIMD3:       invoke.cont:
// SIMD3-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]]
// SIMD3-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// SIMD3-NEXT:    br label [[INIT_END]]
// SIMD3:       init.end:
// SIMD3-NEXT:    [[TMP4:%.*]] = load i32, ptr @_ZN6Static1sE, align 4
// SIMD3-NEXT:    store i32 [[TMP4]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZZ4mainE2sm, align 8
// SIMD3-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP6]], [[TMP5]]
// SIMD3-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP7:%.*]] = load i32, ptr @_ZL3gs1, align 4
// SIMD3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP8]], [[TMP7]]
// SIMD3-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZL3gs2, align 8
// SIMD3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], [[TMP9]]
// SIMD3-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP11:%.*]] = load i32, ptr @gs3, align 4
// SIMD3-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], [[TMP11]]
// SIMD3-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP13:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4
// SIMD3-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]]
// SIMD3-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4
// SIMD3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]]
// SIMD3-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP17:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4
// SIMD3-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32
// SIMD3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], [[CONV]]
// SIMD3-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP19:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4
// SIMD3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP20]], [[TMP19]]
// SIMD3-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    ret i32 [[TMP21]]
// SIMD3:       lpad:
// SIMD3-NEXT:    [[TMP22:%.*]] = landingpad { ptr, i32 }
// SIMD3-NEXT:            cleanup
// SIMD3-NEXT:    [[TMP23:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 0
// SIMD3-NEXT:    store ptr [[TMP23]], ptr [[EXN_SLOT]], align 8
// SIMD3-NEXT:    [[TMP24:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 1
// SIMD3-NEXT:    store i32 [[TMP24]], ptr [[EHSELECTOR_SLOT]], align 4
// SIMD3-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]]
// SIMD3-NEXT:    br label [[EH_RESUME:%.*]]
// SIMD3:       eh.resume:
// SIMD3-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// SIMD3-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// SIMD3-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// SIMD3-NEXT:    [[LPAD_VAL8:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// SIMD3-NEXT:    resume { ptr, i32 } [[LPAD_VAL8]]
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]])
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]]
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_Z6foobarv
// SIMD3-SAME: () #[[ATTR2]] {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr @_ZN6Static1sE, align 4
// SIMD3-NEXT:    store i32 [[TMP0]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP1:%.*]] = load i32, ptr @_ZL3gs1, align 4
// SIMD3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP2]], [[TMP1]]
// SIMD3-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP3:%.*]] = load i32, ptr @_ZL3gs2, align 8
// SIMD3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], [[TMP3]]
// SIMD3-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP5:%.*]] = load i32, ptr @gs3, align 4
// SIMD3-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]]
// SIMD3-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP7:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4
// SIMD3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], [[TMP7]]
// SIMD3-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4
// SIMD3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]]
// SIMD3-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP11:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4
// SIMD3-NEXT:    [[CONV:%.*]] = fptosi float [[TMP11]] to i32
// SIMD3-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], [[CONV]]
// SIMD3-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP13:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4
// SIMD3-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP14]], [[TMP13]]
// SIMD3-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4
// SIMD3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4
// SIMD3-NEXT:    ret i32 [[TMP15]]
//
//
// SIMD3-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// SIMD3-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8
// SIMD3-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0
// SIMD3-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]]
// SIMD3:       init.check:
// SIMD3-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8
// SIMD3-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23)
// SIMD3-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]]
// SIMD3-NEXT:    br label [[INIT_END]]
// SIMD3:       init.end:
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]])
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]]
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    store i32 0, ptr [[A]], align 4
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    store i32 0, ptr [[A]], align 8
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// SIMD3-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    store i32 0, ptr [[A]], align 8
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// SIMD3-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// SIMD3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD3-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0
// SIMD3-NEXT:    store i32 0, ptr [[A]], align 4
// SIMD3-NEXT:    ret void
//
//
// SIMD3-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// SIMD3-SAME: () #[[ATTR0]] {
// SIMD3-NEXT:  entry:
// SIMD3-NEXT:    call void @__cxx_global_var_init()
// SIMD3-NEXT:    call void @__cxx_global_var_init.1()
// SIMD3-NEXT:    call void @__cxx_global_var_init.2()
// SIMD3-NEXT:    ret void
//
//
// SIMD4-LABEL: define {{[^@]+}}@__cxx_global_var_init
// SIMD4-SAME: () #[[ATTR0:[0-9]+]] !dbg [[DBG115:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5), !dbg [[DBG118:![0-9]+]]
// SIMD4-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]], !dbg [[DBG120:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG121:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 !dbg [[DBG122:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META123:![0-9]+]], !DIExpression(), [[META125:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META126:![0-9]+]], !DIExpression(), [[META127:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG128:![0-9]+]]
// SIMD4-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG128]]
// SIMD4-NEXT:    ret void, !dbg [[DBG129:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 !dbg [[DBG130:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META131:![0-9]+]], !DIExpression(), [[META132:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]], !dbg [[DBG133:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG134:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// SIMD4-SAME: () #[[ATTR0]] !dbg [[DBG135:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27), !dbg [[DBG136:![0-9]+]]
// SIMD4-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG138:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG139:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG140:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META141:![0-9]+]], !DIExpression(), [[META143:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META144:![0-9]+]], !DIExpression(), [[META145:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG146:![0-9]+]]
// SIMD4-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG146]]
// SIMD4-NEXT:    ret void, !dbg [[DBG147:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG148:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META149:![0-9]+]], !DIExpression(), [[META150:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]], !dbg [[DBG151:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG152:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// SIMD4-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG153:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG154:![0-9]+]]
// SIMD4-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156:![0-9]+]]
// SIMD4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// SIMD4-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG157:![0-9]+]]
// SIMD4:       invoke.cont:
// SIMD4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156]]
// SIMD4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// SIMD4-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG158:![0-9]+]]
// SIMD4:       invoke.cont2:
// SIMD4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156]]
// SIMD4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// SIMD4-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]], !dbg [[DBG159:![0-9]+]]
// SIMD4:       invoke.cont3:
// SIMD4-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG154]]
// SIMD4-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160:![0-9]+]]
// SIMD4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// SIMD4-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]], !dbg [[DBG161:![0-9]+]]
// SIMD4:       invoke.cont7:
// SIMD4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160]]
// SIMD4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// SIMD4-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]], !dbg [[DBG162:![0-9]+]]
// SIMD4:       invoke.cont8:
// SIMD4-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160]]
// SIMD4-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// SIMD4-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]], !dbg [[DBG163:![0-9]+]]
// SIMD4:       invoke.cont9:
// SIMD4-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG164:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG164]]
// SIMD4:       lpad:
// SIMD4-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// SIMD4-NEXT:            cleanup, !dbg [[DBG165:![0-9]+]]
// SIMD4-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0, !dbg [[DBG165]]
// SIMD4-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG165]]
// SIMD4-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1, !dbg [[DBG165]]
// SIMD4-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG165]]
// SIMD4-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG156]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]], !dbg [[DBG156]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG156]]
// SIMD4:       arraydestroy.body:
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG156]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG156]]
// SIMD4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG156]]
// SIMD4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[DBG156]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG156]]
// SIMD4:       arraydestroy.done4:
// SIMD4-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG156]]
// SIMD4:       lpad6:
// SIMD4-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// SIMD4-NEXT:            cleanup, !dbg [[DBG165]]
// SIMD4-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0, !dbg [[DBG165]]
// SIMD4-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG165]]
// SIMD4-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1, !dbg [[DBG165]]
// SIMD4-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG165]]
// SIMD4-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG160]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]], !dbg [[DBG160]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]], !dbg [[DBG160]]
// SIMD4:       arraydestroy.body11:
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ], !dbg [[DBG160]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1, !dbg [[DBG160]]
// SIMD4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]], !dbg [[DBG160]]
// SIMD4-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), !dbg [[DBG160]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]], !dbg [[DBG160]]
// SIMD4:       arraydestroy.done15:
// SIMD4-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG160]]
// SIMD4:       ehcleanup:
// SIMD4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG154]]
// SIMD4-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0, !dbg [[DBG154]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]], !dbg [[DBG154]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]], !dbg [[DBG154]]
// SIMD4:       arraydestroy.body17:
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ], !dbg [[DBG154]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1, !dbg [[DBG154]]
// SIMD4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]], !dbg [[DBG154]]
// SIMD4-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x, !dbg [[DBG154]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]], !dbg [[DBG154]]
// SIMD4:       arraydestroy.done21:
// SIMD4-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG154]]
// SIMD4:       eh.resume:
// SIMD4-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG154]]
// SIMD4-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG154]]
// SIMD4-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG154]]
// SIMD4-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG154]]
// SIMD4-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]], !dbg [[DBG154]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// SIMD4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG166:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META170:![0-9]+]], !DIExpression(), [[META171:![0-9]+]])
// SIMD4-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META171]]
// SIMD4:       arraydestroy.body:
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META171]]
// SIMD4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META171]]
// SIMD4-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META171]]
// SIMD4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[META171]]
// SIMD4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META171]]
// SIMD4:       arraydestroy.done1:
// SIMD4-NEXT:    ret void, !dbg [[META171]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@main
// SIMD4-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 !dbg [[DBG52:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[RES]], [[META172:![0-9]+]], !DIExpression(), [[META173:![0-9]+]])
// SIMD4-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8, !dbg [[DBG174:![0-9]+]]
// SIMD4-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG174]]
// SIMD4-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG174]], !prof [[PROF175:![0-9]+]]
// SIMD4:       init.check:
// SIMD4-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG174]]
// SIMD4-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP1]], 0, !dbg [[DBG174]]
// SIMD4-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]], !dbg [[DBG174]]
// SIMD4:       init:
// SIMD4-NEXT:    [[TMP2:%.*]] = load i32, ptr @_ZL3gs1, align 4, !dbg [[DBG176:![0-9]+]]
// SIMD4-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP2]])
// SIMD4-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG177:![0-9]+]]
// SIMD4:       invoke.cont:
// SIMD4-NEXT:    [[TMP3:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG174]]
// SIMD4-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG174]]
// SIMD4-NEXT:    br label [[INIT_END]], !dbg [[DBG174]]
// SIMD4:       init.end:
// SIMD4-NEXT:    [[TMP4:%.*]] = load i32, ptr @_ZN6Static1sE, align 4, !dbg [[DBG178:![0-9]+]]
// SIMD4-NEXT:    store i32 [[TMP4]], ptr [[RES]], align 4, !dbg [[DBG179:![0-9]+]]
// SIMD4-NEXT:    [[TMP5:%.*]] = load i32, ptr @_ZZ4mainE2sm, align 8, !dbg [[DBG180:![0-9]+]]
// SIMD4-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG181:![0-9]+]]
// SIMD4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP6]], [[TMP5]], !dbg [[DBG181]]
// SIMD4-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG181]]
// SIMD4-NEXT:    [[TMP7:%.*]] = load i32, ptr @_ZL3gs1, align 4, !dbg [[DBG182:![0-9]+]]
// SIMD4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG183:![0-9]+]]
// SIMD4-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP8]], [[TMP7]], !dbg [[DBG183]]
// SIMD4-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4, !dbg [[DBG183]]
// SIMD4-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG184:![0-9]+]]
// SIMD4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG185:![0-9]+]]
// SIMD4-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], [[TMP9]], !dbg [[DBG185]]
// SIMD4-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG185]]
// SIMD4-NEXT:    [[TMP11:%.*]] = load i32, ptr @gs3, align 4, !dbg [[DBG186:![0-9]+]]
// SIMD4-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG187:![0-9]+]]
// SIMD4-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], [[TMP11]], !dbg [[DBG187]]
// SIMD4-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4, !dbg [[DBG187]]
// SIMD4-NEXT:    [[TMP13:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4, !dbg [[DBG188:![0-9]+]]
// SIMD4-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG189:![0-9]+]]
// SIMD4-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]], !dbg [[DBG189]]
// SIMD4-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG189]]
// SIMD4-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4, !dbg [[DBG190:![0-9]+]]
// SIMD4-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG191:![0-9]+]]
// SIMD4-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG191]]
// SIMD4-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG191]]
// SIMD4-NEXT:    [[TMP17:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4, !dbg [[DBG192:![0-9]+]]
// SIMD4-NEXT:    [[CONV:%.*]] = fptosi float [[TMP17]] to i32, !dbg [[DBG192]]
// SIMD4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG193:![0-9]+]]
// SIMD4-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], [[CONV]], !dbg [[DBG193]]
// SIMD4-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4, !dbg [[DBG193]]
// SIMD4-NEXT:    [[TMP19:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4, !dbg [[DBG194:![0-9]+]]
// SIMD4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG195:![0-9]+]]
// SIMD4-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP20]], [[TMP19]], !dbg [[DBG195]]
// SIMD4-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG195]]
// SIMD4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG196:![0-9]+]]
// SIMD4-NEXT:    ret i32 [[TMP21]], !dbg [[DBG197:![0-9]+]]
// SIMD4:       lpad:
// SIMD4-NEXT:    [[TMP22:%.*]] = landingpad { ptr, i32 }
// SIMD4-NEXT:            cleanup, !dbg [[DBG198:![0-9]+]]
// SIMD4-NEXT:    [[TMP23:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 0, !dbg [[DBG198]]
// SIMD4-NEXT:    store ptr [[TMP23]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG198]]
// SIMD4-NEXT:    [[TMP24:%.*]] = extractvalue { ptr, i32 } [[TMP22]], 1, !dbg [[DBG198]]
// SIMD4-NEXT:    store i32 [[TMP24]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG198]]
// SIMD4-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG174]]
// SIMD4-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG174]]
// SIMD4:       eh.resume:
// SIMD4-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG174]]
// SIMD4-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG174]]
// SIMD4-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG174]]
// SIMD4-NEXT:    [[LPAD_VAL8:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG174]]
// SIMD4-NEXT:    resume { ptr, i32 } [[LPAD_VAL8]], !dbg [[DBG174]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG199:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META200:![0-9]+]], !DIExpression(), [[META202:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META203:![0-9]+]], !DIExpression(), [[META204:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG205:![0-9]+]]
// SIMD4-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG205]]
// SIMD4-NEXT:    ret void, !dbg [[DBG206:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG207:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META208:![0-9]+]], !DIExpression(), [[META209:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]], !dbg [[DBG210:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG211:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_Z6foobarv
// SIMD4-SAME: () #[[ATTR2]] !dbg [[DBG212:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[RES:%.*]] = alloca i32, align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[RES]], [[META213:![0-9]+]], !DIExpression(), [[META214:![0-9]+]])
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr @_ZN6Static1sE, align 4, !dbg [[DBG215:![0-9]+]]
// SIMD4-NEXT:    store i32 [[TMP0]], ptr [[RES]], align 4, !dbg [[DBG216:![0-9]+]]
// SIMD4-NEXT:    [[TMP1:%.*]] = load i32, ptr @_ZL3gs1, align 4, !dbg [[DBG217:![0-9]+]]
// SIMD4-NEXT:    [[TMP2:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG218:![0-9]+]]
// SIMD4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP2]], [[TMP1]], !dbg [[DBG218]]
// SIMD4-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG218]]
// SIMD4-NEXT:    [[TMP3:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG219:![0-9]+]]
// SIMD4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG220:![0-9]+]]
// SIMD4-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], [[TMP3]], !dbg [[DBG220]]
// SIMD4-NEXT:    store i32 [[ADD1]], ptr [[RES]], align 4, !dbg [[DBG220]]
// SIMD4-NEXT:    [[TMP5:%.*]] = load i32, ptr @gs3, align 4, !dbg [[DBG221:![0-9]+]]
// SIMD4-NEXT:    [[TMP6:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG222:![0-9]+]]
// SIMD4-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], [[TMP5]], !dbg [[DBG222]]
// SIMD4-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG222]]
// SIMD4-NEXT:    [[TMP7:%.*]] = load i32, ptr getelementptr inbounds ([3 x %struct.S1], ptr getelementptr inbounds ([2 x [3 x %struct.S1]], ptr @arr_x, i64 0, i64 1), i64 0, i64 1), align 4, !dbg [[DBG223:![0-9]+]]
// SIMD4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG224:![0-9]+]]
// SIMD4-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], [[TMP7]], !dbg [[DBG224]]
// SIMD4-NEXT:    store i32 [[ADD3]], ptr [[RES]], align 4, !dbg [[DBG224]]
// SIMD4-NEXT:    [[TMP9:%.*]] = load i32, ptr @_ZN2STIiE2stE, align 4, !dbg [[DBG225:![0-9]+]]
// SIMD4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG226:![0-9]+]]
// SIMD4-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]], !dbg [[DBG226]]
// SIMD4-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG226]]
// SIMD4-NEXT:    [[TMP11:%.*]] = load float, ptr @_ZN2STIfE2stE, align 4, !dbg [[DBG227:![0-9]+]]
// SIMD4-NEXT:    [[CONV:%.*]] = fptosi float [[TMP11]] to i32, !dbg [[DBG227]]
// SIMD4-NEXT:    [[TMP12:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG228:![0-9]+]]
// SIMD4-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], [[CONV]], !dbg [[DBG228]]
// SIMD4-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG228]]
// SIMD4-NEXT:    [[TMP13:%.*]] = load i32, ptr @_ZN2STI2S4E2stE, align 4, !dbg [[DBG229:![0-9]+]]
// SIMD4-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG230:![0-9]+]]
// SIMD4-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP14]], [[TMP13]], !dbg [[DBG230]]
// SIMD4-NEXT:    store i32 [[ADD6]], ptr [[RES]], align 4, !dbg [[DBG230]]
// SIMD4-NEXT:    [[TMP15:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG231:![0-9]+]]
// SIMD4-NEXT:    ret i32 [[TMP15]], !dbg [[DBG232:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@__cxx_global_var_init.3
// SIMD4-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) !dbg [[DBG233:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG234:![0-9]+]]
// SIMD4-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG234]]
// SIMD4-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG234]]
// SIMD4:       init.check:
// SIMD4-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG234]]
// SIMD4-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23), !dbg [[DBG235:![0-9]+]]
// SIMD4-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG234]]
// SIMD4-NEXT:    br label [[INIT_END]], !dbg [[DBG234]]
// SIMD4:       init.end:
// SIMD4-NEXT:    ret void, !dbg [[DBG237:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG238:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META239:![0-9]+]], !DIExpression(), [[META241:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META242:![0-9]+]], !DIExpression(), [[META243:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG244:![0-9]+]]
// SIMD4-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG244]]
// SIMD4-NEXT:    ret void, !dbg [[DBG245:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG246:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META247:![0-9]+]], !DIExpression(), [[META248:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]], !dbg [[DBG249:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG250:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG251:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META252:![0-9]+]], !DIExpression(), [[META253:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META254:![0-9]+]], !DIExpression(), [[META255:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG256:![0-9]+]]
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG257:![0-9]+]]
// SIMD4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG256]]
// SIMD4-NEXT:    ret void, !dbg [[DBG258:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG259:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META260:![0-9]+]], !DIExpression(), [[META261:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG262:![0-9]+]]
// SIMD4-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG264:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG265:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG266:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META267:![0-9]+]], !DIExpression(), [[META268:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META269:![0-9]+]], !DIExpression(), [[META270:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG271:![0-9]+]]
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG272:![0-9]+]]
// SIMD4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG271]]
// SIMD4-NEXT:    ret void, !dbg [[DBG273:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG274:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META275:![0-9]+]], !DIExpression(), [[META276:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG277:![0-9]+]]
// SIMD4-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG279:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG280:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG281:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META282:![0-9]+]], !DIExpression(), [[META283:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META284:![0-9]+]], !DIExpression(), [[META285:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG286:![0-9]+]]
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG287:![0-9]+]]
// SIMD4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG286]]
// SIMD4-NEXT:    ret void, !dbg [[DBG288:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// SIMD4-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG289:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META290:![0-9]+]], !DIExpression(), [[META291:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG292:![0-9]+]]
// SIMD4-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG294:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG295:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG296:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META297:![0-9]+]], !DIExpression(), [[META298:![0-9]+]])
// SIMD4-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// SIMD4-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META299:![0-9]+]], !DIExpression(), [[META300:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG301:![0-9]+]]
// SIMD4-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG302:![0-9]+]]
// SIMD4-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG301]]
// SIMD4-NEXT:    ret void, !dbg [[DBG303:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// SIMD4-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG304:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// SIMD4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META305:![0-9]+]], !DIExpression(), [[META306:![0-9]+]])
// SIMD4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// SIMD4-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG307:![0-9]+]]
// SIMD4-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG309:![0-9]+]]
// SIMD4-NEXT:    ret void, !dbg [[DBG310:![0-9]+]]
//
//
// SIMD4-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// SIMD4-SAME: () #[[ATTR0]] !dbg [[DBG311:![0-9]+]] {
// SIMD4-NEXT:  entry:
// SIMD4-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG313:![0-9]+]]
// SIMD4-NEXT:    call void @__cxx_global_var_init.1(), !dbg [[DBG313]]
// SIMD4-NEXT:    call void @__cxx_global_var_init.2(), !dbg [[DBG313]]
// SIMD4-NEXT:    ret void
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0:[0-9]+]] !dbg [[DBG116:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META118:![0-9]+]], !DIExpression(), [[META120:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG121:![0-9]+]]
// DEBUG1-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 5), !dbg [[DBG122:![0-9]+]]
// DEBUG1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG121]]
// DEBUG1-NEXT:    ret ptr [[TMP2]], !dbg [[DBG121]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 !dbg [[DBG123:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META124:![0-9]+]], !DIExpression(), [[META126:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META127:![0-9]+]], !DIExpression(), [[META128:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG129:![0-9]+]]
// DEBUG1-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG129]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG130:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG131:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META132:![0-9]+]], !DIExpression(), [[META133:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META133]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3:[0-9]+]], !dbg [[META133]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG134:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 !dbg [[DBG135:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META136:![0-9]+]], !DIExpression(), [[META137:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]], !dbg [[DBG138:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG139:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_.
// DEBUG1-SAME: () #[[ATTR0]] !dbg [[DBG140:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]]), !dbg [[DBG141:![0-9]+]]
// DEBUG1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZL3gs1, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.), !dbg [[DBG141]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG141]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..1
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG142:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    [[ARRAYINIT_ENDOFINIT7:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META143:![0-9]+]], !DIExpression(), [[META144:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG145:![0-9]+]]
// DEBUG1-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG146:![0-9]+]]
// DEBUG1-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG147:![0-9]+]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 1)
// DEBUG1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG148:![0-9]+]]
// DEBUG1:       invoke.cont:
// DEBUG1-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 1, !dbg [[DBG147]]
// DEBUG1-NEXT:    store ptr [[ARRAYINIT_ELEMENT]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG147]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// DEBUG1-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG149:![0-9]+]]
// DEBUG1:       invoke.cont2:
// DEBUG1-NEXT:    [[ARRAYINIT_ELEMENT3:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[TMP1]], i64 2, !dbg [[DBG147]]
// DEBUG1-NEXT:    store ptr [[ARRAYINIT_ELEMENT3]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG147]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT3]], i32 noundef 3)
// DEBUG1-NEXT:            to label [[INVOKE_CONT4:%.*]] unwind label [[LPAD]], !dbg [[DBG150:![0-9]+]]
// DEBUG1:       invoke.cont4:
// DEBUG1-NEXT:    [[ARRAYINIT_ELEMENT6:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 1, !dbg [[DBG146]]
// DEBUG1-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG146]]
// DEBUG1-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG151:![0-9]+]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT6]], i32 noundef 4)
// DEBUG1-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD8:%.*]], !dbg [[DBG152:![0-9]+]]
// DEBUG1:       invoke.cont9:
// DEBUG1-NEXT:    [[ARRAYINIT_ELEMENT10:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 1, !dbg [[DBG151]]
// DEBUG1-NEXT:    store ptr [[ARRAYINIT_ELEMENT10]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG151]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT10]], i32 noundef 5)
// DEBUG1-NEXT:            to label [[INVOKE_CONT11:%.*]] unwind label [[LPAD8]], !dbg [[DBG153:![0-9]+]]
// DEBUG1:       invoke.cont11:
// DEBUG1-NEXT:    [[ARRAYINIT_ELEMENT12:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 2, !dbg [[DBG151]]
// DEBUG1-NEXT:    store ptr [[ARRAYINIT_ELEMENT12]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG151]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT12]], i32 noundef 6)
// DEBUG1-NEXT:            to label [[INVOKE_CONT13:%.*]] unwind label [[LPAD8]], !dbg [[DBG154:![0-9]+]]
// DEBUG1:       invoke.cont13:
// DEBUG1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG145]]
// DEBUG1-NEXT:    ret ptr [[TMP2]], !dbg [[DBG145]]
// DEBUG1:       lpad:
// DEBUG1-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// DEBUG1-NEXT:            cleanup, !dbg [[META144]]
// DEBUG1-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0, !dbg [[META144]]
// DEBUG1-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8, !dbg [[META144]]
// DEBUG1-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1, !dbg [[META144]]
// DEBUG1-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[META144]]
// DEBUG1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG147]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[TMP1]], [[TMP6]], !dbg [[DBG147]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE5:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG147]]
// DEBUG1:       arraydestroy.body:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG147]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG147]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG147]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]], !dbg [[DBG147]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE5]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG147]]
// DEBUG1:       arraydestroy.done5:
// DEBUG1-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG147]]
// DEBUG1:       lpad8:
// DEBUG1-NEXT:    [[TMP7:%.*]] = landingpad { ptr, i32 }
// DEBUG1-NEXT:            cleanup, !dbg [[META144]]
// DEBUG1-NEXT:    [[TMP8:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 0, !dbg [[META144]]
// DEBUG1-NEXT:    store ptr [[TMP8]], ptr [[EXN_SLOT]], align 8, !dbg [[META144]]
// DEBUG1-NEXT:    [[TMP9:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 1, !dbg [[META144]]
// DEBUG1-NEXT:    store i32 [[TMP9]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[META144]]
// DEBUG1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG151]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ISEMPTY14:%.*]] = icmp eq ptr [[ARRAYINIT_ELEMENT6]], [[TMP10]], !dbg [[DBG151]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY14]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15:%.*]], !dbg [[DBG151]]
// DEBUG1:       arraydestroy.body15:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi ptr [ [[TMP10]], [[LPAD8]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ], !dbg [[DBG151]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST16]], i64 -1, !dbg [[DBG151]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR3]], !dbg [[DBG151]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT17]], [[ARRAYINIT_ELEMENT6]], !dbg [[DBG151]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19]], label [[ARRAYDESTROY_BODY15]], !dbg [[DBG151]]
// DEBUG1:       arraydestroy.done19:
// DEBUG1-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG151]]
// DEBUG1:       ehcleanup:
// DEBUG1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG146]]
// DEBUG1-NEXT:    [[PAD_ARRAYBEGIN:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 0, i64 0, !dbg [[DBG146]]
// DEBUG1-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP11]], i64 0, i64 0, !dbg [[DBG146]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ISEMPTY20:%.*]] = icmp eq ptr [[PAD_ARRAYBEGIN]], [[PAD_ARRAYEND]], !dbg [[DBG146]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY20]], label [[ARRAYDESTROY_DONE25:%.*]], label [[ARRAYDESTROY_BODY21:%.*]], !dbg [[DBG146]]
// DEBUG1:       arraydestroy.body21:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST22:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT23:%.*]], [[ARRAYDESTROY_BODY21]] ], !dbg [[DBG146]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT23]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST22]], i64 -1, !dbg [[DBG146]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT23]]) #[[ATTR3]], !dbg [[DBG146]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE24:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT23]], [[PAD_ARRAYBEGIN]], !dbg [[DBG146]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE24]], label [[ARRAYDESTROY_DONE25]], label [[ARRAYDESTROY_BODY21]], !dbg [[DBG146]]
// DEBUG1:       arraydestroy.done25:
// DEBUG1-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG146]]
// DEBUG1:       eh.resume:
// DEBUG1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG146]]
// DEBUG1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG146]]
// DEBUG1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG146]]
// DEBUG1-NEXT:    [[LPAD_VAL26:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG146]]
// DEBUG1-NEXT:    resume { ptr, i32 } [[LPAD_VAL26]], !dbg [[DBG146]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..2
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG155:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META156:![0-9]+]], !DIExpression(), [[META157:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META157]]
// DEBUG1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 6, !dbg [[META157]]
// DEBUG1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META157]]
// DEBUG1:       arraydestroy.body:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META157]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META157]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META157]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]], !dbg [[META157]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META157]]
// DEBUG1:       arraydestroy.done1:
// DEBUG1-NEXT:    ret void, !dbg [[DBG158:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_..3
// DEBUG1-SAME: () #[[ATTR0]] !dbg [[DBG159:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB3:[0-9]+]]), !dbg [[DBG160:![0-9]+]]
// DEBUG1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB3]], ptr @arr_x, ptr @.__kmpc_global_ctor_..1, ptr null, ptr @.__kmpc_global_dtor_..2), !dbg [[DBG160]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG160]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// DEBUG1-SAME: () #[[ATTR0]] !dbg [[DBG161:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5), !dbg [[DBG164:![0-9]+]]
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG166:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG167:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG168:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META169:![0-9]+]], !DIExpression(), [[META170:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META171:![0-9]+]], !DIExpression(), [[META172:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG173:![0-9]+]]
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG174:![0-9]+]]
// DEBUG1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG173]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG175:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG176:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META177:![0-9]+]], !DIExpression(), [[META178:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG179:![0-9]+]]
// DEBUG1-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG181:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG182:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@__cxx_global_var_init.4
// DEBUG1-SAME: () #[[ATTR0]] !dbg [[DBG183:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27), !dbg [[DBG184:![0-9]+]]
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG186:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG187:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG188:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META189:![0-9]+]], !DIExpression(), [[META191:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META192:![0-9]+]], !DIExpression(), [[META193:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG194:![0-9]+]]
// DEBUG1-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG194]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG195:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG196:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META197:![0-9]+]], !DIExpression(), [[META198:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]], !dbg [[DBG199:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG200:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG201:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META202:![0-9]+]], !DIExpression(), [[META203:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META204:![0-9]+]], !DIExpression(), [[META205:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG206:![0-9]+]]
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG207:![0-9]+]]
// DEBUG1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG206]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG208:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG209:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META210:![0-9]+]], !DIExpression(), [[META211:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG212:![0-9]+]]
// DEBUG1-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG214:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG215:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@__cxx_global_var_init.5
// DEBUG1-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG216:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG217:![0-9]+]]
// DEBUG1-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG219:![0-9]+]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// DEBUG1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG220:![0-9]+]]
// DEBUG1:       invoke.cont:
// DEBUG1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG219]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// DEBUG1-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG221:![0-9]+]]
// DEBUG1:       invoke.cont2:
// DEBUG1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG219]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// DEBUG1-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]], !dbg [[DBG222:![0-9]+]]
// DEBUG1:       invoke.cont3:
// DEBUG1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG217]]
// DEBUG1-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG223:![0-9]+]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// DEBUG1-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]], !dbg [[DBG224:![0-9]+]]
// DEBUG1:       invoke.cont7:
// DEBUG1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG223]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// DEBUG1-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]], !dbg [[DBG225:![0-9]+]]
// DEBUG1:       invoke.cont8:
// DEBUG1-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG223]]
// DEBUG1-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// DEBUG1-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]], !dbg [[DBG226:![0-9]+]]
// DEBUG1:       invoke.cont9:
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG227:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG227]]
// DEBUG1:       lpad:
// DEBUG1-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// DEBUG1-NEXT:            cleanup, !dbg [[DBG228:![0-9]+]]
// DEBUG1-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0, !dbg [[DBG228]]
// DEBUG1-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG228]]
// DEBUG1-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1, !dbg [[DBG228]]
// DEBUG1-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG228]]
// DEBUG1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG219]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP4]], !dbg [[DBG219]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG219]]
// DEBUG1:       arraydestroy.body:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP4]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG219]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG219]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG219]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[DBG219]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG219]]
// DEBUG1:       arraydestroy.done4:
// DEBUG1-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG219]]
// DEBUG1:       lpad6:
// DEBUG1-NEXT:    [[TMP5:%.*]] = landingpad { ptr, i32 }
// DEBUG1-NEXT:            cleanup, !dbg [[DBG228]]
// DEBUG1-NEXT:    [[TMP6:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 0, !dbg [[DBG228]]
// DEBUG1-NEXT:    store ptr [[TMP6]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG228]]
// DEBUG1-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP5]], 1, !dbg [[DBG228]]
// DEBUG1-NEXT:    store i32 [[TMP7]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG228]]
// DEBUG1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG223]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP8]], !dbg [[DBG223]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]], !dbg [[DBG223]]
// DEBUG1:       arraydestroy.body11:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP8]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ], !dbg [[DBG223]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1, !dbg [[DBG223]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]], !dbg [[DBG223]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), !dbg [[DBG223]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]], !dbg [[DBG223]]
// DEBUG1:       arraydestroy.done15:
// DEBUG1-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG223]]
// DEBUG1:       ehcleanup:
// DEBUG1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG217]]
// DEBUG1-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP9]], i64 0, i64 0, !dbg [[DBG217]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]], !dbg [[DBG217]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]], !dbg [[DBG217]]
// DEBUG1:       arraydestroy.body17:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ], !dbg [[DBG217]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1, !dbg [[DBG217]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]], !dbg [[DBG217]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x, !dbg [[DBG217]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]], !dbg [[DBG217]]
// DEBUG1:       arraydestroy.done21:
// DEBUG1-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG217]]
// DEBUG1:       eh.resume:
// DEBUG1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG217]]
// DEBUG1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG217]]
// DEBUG1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG217]]
// DEBUG1-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG217]]
// DEBUG1-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]], !dbg [[DBG217]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG229:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META232:![0-9]+]], !DIExpression(), [[META233:![0-9]+]])
// DEBUG1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META233]]
// DEBUG1:       arraydestroy.body:
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META233]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META233]]
// DEBUG1-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META233]]
// DEBUG1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[META233]]
// DEBUG1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META233]]
// DEBUG1:       arraydestroy.done1:
// DEBUG1-NEXT:    ret void, !dbg [[META233]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@main
// DEBUG1-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 !dbg [[DBG52:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB9:[0-9]+]]), !dbg [[DBG234:![0-9]+]]
// DEBUG1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[RES]], [[META235:![0-9]+]], !DIExpression(), [[META236:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8, !dbg [[DBG237:![0-9]+]]
// DEBUG1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP1]], 0, !dbg [[DBG237]]
// DEBUG1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG237]], !prof [[PROF238:![0-9]+]]
// DEBUG1:       init.check:
// DEBUG1-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG237]]
// DEBUG1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0, !dbg [[DBG237]]
// DEBUG1-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]], !dbg [[DBG237]]
// DEBUG1:       init:
// DEBUG1-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB7:[0-9]+]]), !dbg [[DBG237]]
// DEBUG1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB7]], ptr @_ZZ4mainE2sm, ptr @.__kmpc_global_ctor_..6, ptr null, ptr @.__kmpc_global_dtor_..7), !dbg [[DBG237]]
// DEBUG1-NEXT:    [[TMP4:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB9]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG234]]
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP4]], i32 0, i32 0, !dbg [[DBG239:![0-9]+]]
// DEBUG1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG239]]
// DEBUG1-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP5]])
// DEBUG1-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG240:![0-9]+]]
// DEBUG1:       invoke.cont:
// DEBUG1-NEXT:    [[TMP6:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG237]]
// DEBUG1-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG237]]
// DEBUG1-NEXT:    br label [[INIT_END]], !dbg [[DBG237]]
// DEBUG1:       init.end:
// DEBUG1-NEXT:    [[TMP7:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB11:[0-9]+]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.), !dbg [[DBG241:![0-9]+]]
// DEBUG1-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP7]], i32 0, i32 0, !dbg [[DBG242:![0-9]+]]
// DEBUG1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG242]]
// DEBUG1-NEXT:    store i32 [[TMP8]], ptr [[RES]], align 4, !dbg [[DBG243:![0-9]+]]
// DEBUG1-NEXT:    [[TMP9:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB13:[0-9]+]], i32 [[TMP0]], ptr @_ZZ4mainE2sm, i64 24, ptr @_ZZ4mainE2sm.cache.), !dbg [[DBG244:![0-9]+]]
// DEBUG1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP9]], i32 0, i32 0, !dbg [[DBG245:![0-9]+]]
// DEBUG1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A2]], align 8, !dbg [[DBG245]]
// DEBUG1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG246:![0-9]+]]
// DEBUG1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP11]], [[TMP10]], !dbg [[DBG246]]
// DEBUG1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG246]]
// DEBUG1-NEXT:    [[TMP12:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB15:[0-9]+]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG247:![0-9]+]]
// DEBUG1-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP12]], i32 0, i32 0, !dbg [[DBG248:![0-9]+]]
// DEBUG1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG248]]
// DEBUG1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG249:![0-9]+]]
// DEBUG1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]], !dbg [[DBG249]]
// DEBUG1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG249]]
// DEBUG1-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG250:![0-9]+]]
// DEBUG1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG251:![0-9]+]]
// DEBUG1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG251]]
// DEBUG1-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG251]]
// DEBUG1-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB17:[0-9]+]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.), !dbg [[DBG252:![0-9]+]]
// DEBUG1-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP17]], i32 0, i32 0, !dbg [[DBG253:![0-9]+]]
// DEBUG1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG253]]
// DEBUG1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG254:![0-9]+]]
// DEBUG1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], [[TMP18]], !dbg [[DBG254]]
// DEBUG1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG254]]
// DEBUG1-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB19:[0-9]+]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.), !dbg [[DBG255:![0-9]+]]
// DEBUG1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP20]], i64 0, i64 1, !dbg [[DBG255]]
// DEBUG1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG255]]
// DEBUG1-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0, !dbg [[DBG256:![0-9]+]]
// DEBUG1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A9]], align 4, !dbg [[DBG256]]
// DEBUG1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG257:![0-9]+]]
// DEBUG1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP22]], [[TMP21]], !dbg [[DBG257]]
// DEBUG1-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4, !dbg [[DBG257]]
// DEBUG1-NEXT:    [[TMP23:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB21:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.), !dbg [[DBG258:![0-9]+]]
// DEBUG1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[TMP23]], align 4, !dbg [[DBG258]]
// DEBUG1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG259:![0-9]+]]
// DEBUG1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP25]], [[TMP24]], !dbg [[DBG259]]
// DEBUG1-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG259]]
// DEBUG1-NEXT:    [[TMP26:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB23:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.), !dbg [[DBG260:![0-9]+]]
// DEBUG1-NEXT:    [[TMP27:%.*]] = load float, ptr [[TMP26]], align 4, !dbg [[DBG260]]
// DEBUG1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP27]] to i32, !dbg [[DBG260]]
// DEBUG1-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG261:![0-9]+]]
// DEBUG1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], [[CONV]], !dbg [[DBG261]]
// DEBUG1-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4, !dbg [[DBG261]]
// DEBUG1-NEXT:    [[TMP29:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB25:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.), !dbg [[DBG262:![0-9]+]]
// DEBUG1-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP29]], i32 0, i32 0, !dbg [[DBG263:![0-9]+]]
// DEBUG1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[A13]], align 4, !dbg [[DBG263]]
// DEBUG1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG264:![0-9]+]]
// DEBUG1-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP31]], [[TMP30]], !dbg [[DBG264]]
// DEBUG1-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4, !dbg [[DBG264]]
// DEBUG1-NEXT:    [[TMP32:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG265:![0-9]+]]
// DEBUG1-NEXT:    ret i32 [[TMP32]], !dbg [[DBG266:![0-9]+]]
// DEBUG1:       lpad:
// DEBUG1-NEXT:    [[TMP33:%.*]] = landingpad { ptr, i32 }
// DEBUG1-NEXT:            cleanup, !dbg [[DBG267:![0-9]+]]
// DEBUG1-NEXT:    [[TMP34:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 0, !dbg [[DBG267]]
// DEBUG1-NEXT:    store ptr [[TMP34]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG267]]
// DEBUG1-NEXT:    [[TMP35:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 1, !dbg [[DBG267]]
// DEBUG1-NEXT:    store i32 [[TMP35]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG267]]
// DEBUG1-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG237]]
// DEBUG1-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG237]]
// DEBUG1:       eh.resume:
// DEBUG1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG237]]
// DEBUG1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG237]]
// DEBUG1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG237]]
// DEBUG1-NEXT:    [[LPAD_VAL15:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG237]]
// DEBUG1-NEXT:    resume { ptr, i32 } [[LPAD_VAL15]], !dbg [[DBG237]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..6
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG268:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB5:[0-9]+]]), !dbg [[DBG269:![0-9]+]]
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META270:![0-9]+]], !DIExpression(), [[META271:![0-9]+]])
// DEBUG1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG272:![0-9]+]]
// DEBUG1-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB5]], i32 [[TMP1]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG269]]
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0, !dbg [[DBG273:![0-9]+]]
// DEBUG1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG273]]
// DEBUG1-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) [[TMP2]], i32 noundef [[TMP4]]), !dbg [[DBG274:![0-9]+]]
// DEBUG1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG272]]
// DEBUG1-NEXT:    ret ptr [[TMP5]], !dbg [[DBG272]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG275:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META276:![0-9]+]], !DIExpression(), [[META278:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META279:![0-9]+]], !DIExpression(), [[META280:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG281:![0-9]+]]
// DEBUG1-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG281]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG282:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..7
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG283:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META284:![0-9]+]], !DIExpression(), [[META285:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META285]]
// DEBUG1-NEXT:    call void @_ZZ4mainEN5SmainD1Ev(ptr noundef nonnull align 8 dereferenceable(24) [[TMP1]]) #[[ATTR3]], !dbg [[META285]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG286:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG287:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META288:![0-9]+]], !DIExpression(), [[META289:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]], !dbg [[DBG290:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG291:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG292:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META293:![0-9]+]], !DIExpression(), [[META294:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META295:![0-9]+]], !DIExpression(), [[META296:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG297:![0-9]+]]
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG298:![0-9]+]]
// DEBUG1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG297]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG299:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// DEBUG1-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG300:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META301:![0-9]+]], !DIExpression(), [[META302:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG303:![0-9]+]]
// DEBUG1-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG305:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG306:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_Z6foobarv
// DEBUG1-SAME: () #[[ATTR2]] !dbg [[DBG307:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[RES:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB27:[0-9]+]]), !dbg [[DBG308:![0-9]+]]
// DEBUG1-NEXT:      #dbg_declare(ptr [[RES]], [[META309:![0-9]+]], !DIExpression(), [[META310:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB27]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.), !dbg [[DBG308]]
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP1]], i32 0, i32 0, !dbg [[DBG311:![0-9]+]]
// DEBUG1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG311]]
// DEBUG1-NEXT:    store i32 [[TMP2]], ptr [[RES]], align 4, !dbg [[DBG312:![0-9]+]]
// DEBUG1-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB29:[0-9]+]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG313:![0-9]+]]
// DEBUG1-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0, !dbg [[DBG314:![0-9]+]]
// DEBUG1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG314]]
// DEBUG1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG315:![0-9]+]]
// DEBUG1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP5]], [[TMP4]], !dbg [[DBG315]]
// DEBUG1-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG315]]
// DEBUG1-NEXT:    [[TMP6:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG316:![0-9]+]]
// DEBUG1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG317:![0-9]+]]
// DEBUG1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP7]], [[TMP6]], !dbg [[DBG317]]
// DEBUG1-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG317]]
// DEBUG1-NEXT:    [[TMP8:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB31:[0-9]+]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.), !dbg [[DBG318:![0-9]+]]
// DEBUG1-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP8]], i32 0, i32 0, !dbg [[DBG319:![0-9]+]]
// DEBUG1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG319]]
// DEBUG1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG320:![0-9]+]]
// DEBUG1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]], !dbg [[DBG320]]
// DEBUG1-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG320]]
// DEBUG1-NEXT:    [[TMP11:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB33:[0-9]+]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.), !dbg [[DBG321:![0-9]+]]
// DEBUG1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP11]], i64 0, i64 1, !dbg [[DBG321]]
// DEBUG1-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG321]]
// DEBUG1-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0, !dbg [[DBG322:![0-9]+]]
// DEBUG1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG322]]
// DEBUG1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG323:![0-9]+]]
// DEBUG1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], [[TMP12]], !dbg [[DBG323]]
// DEBUG1-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG323]]
// DEBUG1-NEXT:    [[TMP14:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB35:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.), !dbg [[DBG324:![0-9]+]]
// DEBUG1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4, !dbg [[DBG324]]
// DEBUG1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG325:![0-9]+]]
// DEBUG1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG325]]
// DEBUG1-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4, !dbg [[DBG325]]
// DEBUG1-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB37:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.), !dbg [[DBG326:![0-9]+]]
// DEBUG1-NEXT:    [[TMP18:%.*]] = load float, ptr [[TMP17]], align 4, !dbg [[DBG326]]
// DEBUG1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP18]] to i32, !dbg [[DBG326]]
// DEBUG1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG327:![0-9]+]]
// DEBUG1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], [[CONV]], !dbg [[DBG327]]
// DEBUG1-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4, !dbg [[DBG327]]
// DEBUG1-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB39:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.), !dbg [[DBG328:![0-9]+]]
// DEBUG1-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP20]], i32 0, i32 0, !dbg [[DBG329:![0-9]+]]
// DEBUG1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A10]], align 4, !dbg [[DBG329]]
// DEBUG1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG330:![0-9]+]]
// DEBUG1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]], !dbg [[DBG330]]
// DEBUG1-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG330]]
// DEBUG1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG331:![0-9]+]]
// DEBUG1-NEXT:    ret i32 [[TMP23]], !dbg [[DBG332:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@__cxx_global_var_init.8
// DEBUG1-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) !dbg [[DBG333:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG334:![0-9]+]]
// DEBUG1-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG334]]
// DEBUG1-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG334]]
// DEBUG1:       init.check:
// DEBUG1-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG334]]
// DEBUG1-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB41:[0-9]+]]), !dbg [[DBG334]]
// DEBUG1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB41]], ptr @_ZN2STI2S4E2stE, ptr @.__kmpc_global_ctor_..9, ptr null, ptr @.__kmpc_global_dtor_..10), !dbg [[DBG334]]
// DEBUG1-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23), !dbg [[DBG335:![0-9]+]]
// DEBUG1-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG334]]
// DEBUG1-NEXT:    br label [[INIT_END]], !dbg [[DBG334]]
// DEBUG1:       init.end:
// DEBUG1-NEXT:    ret void, !dbg [[DBG337:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..9
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG338:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META339:![0-9]+]], !DIExpression(), [[META340:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG341:![0-9]+]]
// DEBUG1-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]], i32 noundef 23), !dbg [[DBG342:![0-9]+]]
// DEBUG1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG341]]
// DEBUG1-NEXT:    ret ptr [[TMP2]], !dbg [[DBG341]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG343:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META344:![0-9]+]], !DIExpression(), [[META346:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META347:![0-9]+]], !DIExpression(), [[META348:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG349:![0-9]+]]
// DEBUG1-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG349]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG350:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..10
// DEBUG1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG351:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META352:![0-9]+]], !DIExpression(), [[META353:![0-9]+]])
// DEBUG1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META353]]
// DEBUG1-NEXT:    call void @_ZN2S4D1Ev(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]]) #[[ATTR3]], !dbg [[META353]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG354:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG355:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META356:![0-9]+]], !DIExpression(), [[META357:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]], !dbg [[DBG358:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG359:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG360:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META361:![0-9]+]], !DIExpression(), [[META362:![0-9]+]])
// DEBUG1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG1-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META363:![0-9]+]], !DIExpression(), [[META364:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG365:![0-9]+]]
// DEBUG1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG366:![0-9]+]]
// DEBUG1-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG365]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG367:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// DEBUG1-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG368:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META369:![0-9]+]], !DIExpression(), [[META370:![0-9]+]])
// DEBUG1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG1-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG371:![0-9]+]]
// DEBUG1-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG373:![0-9]+]]
// DEBUG1-NEXT:    ret void, !dbg [[DBG374:![0-9]+]]
//
//
// DEBUG1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// DEBUG1-SAME: () #[[ATTR0]] !dbg [[DBG375:![0-9]+]] {
// DEBUG1-NEXT:  entry:
// DEBUG1-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG376:![0-9]+]]
// DEBUG1-NEXT:    call void @.__omp_threadprivate_init_.(), !dbg [[DBG376]]
// DEBUG1-NEXT:    call void @__cxx_global_var_init.4(), !dbg [[DBG376]]
// DEBUG1-NEXT:    call void @__cxx_global_var_init.5(), !dbg [[DBG376]]
// DEBUG1-NEXT:    call void @.__omp_threadprivate_init_..3(), !dbg [[DBG376]]
// DEBUG1-NEXT:    ret void
//
//
// DEBUG2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// DEBUG2-SAME: () #[[ATTR0:[0-9]+]] !dbg [[DBG116:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]]), !dbg [[DBG119:![0-9]+]]
// DEBUG2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @_ZL3gs1, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.), !dbg [[DBG119]]
// DEBUG2-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @_ZL3gs1, i32 noundef 5), !dbg [[DBG120:![0-9]+]]
// DEBUG2-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S1D1Ev, ptr @_ZL3gs1, ptr @__dso_handle) #[[ATTR3:[0-9]+]], !dbg [[DBG119]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG122:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG123:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META125:![0-9]+]], !DIExpression(), [[META127:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG128:![0-9]+]]
// DEBUG2-NEXT:    call void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 5), !dbg [[DBG129:![0-9]+]]
// DEBUG2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG128]]
// DEBUG2-NEXT:    ret ptr [[TMP2]], !dbg [[DBG128]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S1C1Ei
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 !dbg [[DBG130:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META131:![0-9]+]], !DIExpression(), [[META133:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META134:![0-9]+]], !DIExpression(), [[META135:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG136:![0-9]+]]
// DEBUG2-NEXT:    call void @_ZN2S1C2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG136]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG137:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG138:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META139:![0-9]+]], !DIExpression(), [[META140:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META140]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3]], !dbg [[META140]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG141:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S1D1Ev
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 !dbg [[DBG142:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META143:![0-9]+]], !DIExpression(), [[META144:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    call void @_ZN2S1D2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]], !dbg [[DBG145:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG146:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// DEBUG2-SAME: () #[[ATTR0]] !dbg [[DBG147:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    call void @_ZN2S2C1Ei(ptr noundef nonnull align 8 dereferenceable(16) @_ZL3gs2, i32 noundef 27), !dbg [[DBG148:![0-9]+]]
// DEBUG2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S2D1Ev, ptr @_ZL3gs2, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG150:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG151:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S2C1Ei
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG152:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META153:![0-9]+]], !DIExpression(), [[META155:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META156:![0-9]+]], !DIExpression(), [[META157:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG158:![0-9]+]]
// DEBUG2-NEXT:    call void @_ZN2S2C2Ei(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG158]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG159:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S2D1Ev
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG160:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META161:![0-9]+]], !DIExpression(), [[META162:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    call void @_ZN2S2D2Ev(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]]) #[[ATTR3]], !dbg [[DBG163:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG164:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@__cxx_global_var_init.2
// DEBUG2-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG165:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    [[ARRAYINIT_ENDOFINIT5:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB3:[0-9]+]]), !dbg [[DBG166:![0-9]+]]
// DEBUG2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB3]], ptr @arr_x, ptr @.__kmpc_global_ctor_..3, ptr null, ptr @.__kmpc_global_dtor_..4), !dbg [[DBG166]]
// DEBUG2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG167:![0-9]+]]
// DEBUG2-NEXT:    store ptr @arr_x, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG169:![0-9]+]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) @arr_x, i32 noundef 1)
// DEBUG2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG170:![0-9]+]]
// DEBUG2:       invoke.cont:
// DEBUG2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG169]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 1), i32 noundef 2)
// DEBUG2-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG171:![0-9]+]]
// DEBUG2:       invoke.cont2:
// DEBUG2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG169]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr @arr_x, i64 2), i32 noundef 3)
// DEBUG2-NEXT:            to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]], !dbg [[DBG172:![0-9]+]]
// DEBUG2:       invoke.cont3:
// DEBUG2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG167]]
// DEBUG2-NEXT:    store ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG173:![0-9]+]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i32 noundef 4)
// DEBUG2-NEXT:            to label [[INVOKE_CONT7:%.*]] unwind label [[LPAD6:%.*]], !dbg [[DBG174:![0-9]+]]
// DEBUG2:       invoke.cont7:
// DEBUG2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG173]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 1), i32 noundef 5)
// DEBUG2-NEXT:            to label [[INVOKE_CONT8:%.*]] unwind label [[LPAD6]], !dbg [[DBG175:![0-9]+]]
// DEBUG2:       invoke.cont8:
// DEBUG2-NEXT:    store ptr getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG173]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) getelementptr inbounds ([[STRUCT_S1]], ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), i64 2), i32 noundef 6)
// DEBUG2-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD6]], !dbg [[DBG176:![0-9]+]]
// DEBUG2:       invoke.cont9:
// DEBUG2-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG166]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG166]]
// DEBUG2:       lpad:
// DEBUG2-NEXT:    [[TMP2:%.*]] = landingpad { ptr, i32 }
// DEBUG2-NEXT:            cleanup, !dbg [[DBG177:![0-9]+]]
// DEBUG2-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP2]], 0, !dbg [[DBG177]]
// DEBUG2-NEXT:    store ptr [[TMP3]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG177]]
// DEBUG2-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP2]], 1, !dbg [[DBG177]]
// DEBUG2-NEXT:    store i32 [[TMP4]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG177]]
// DEBUG2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG169]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @arr_x, [[TMP5]], !dbg [[DBG169]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE4:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG169]]
// DEBUG2:       arraydestroy.body:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP5]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG169]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG169]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG169]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[DBG169]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE4]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG169]]
// DEBUG2:       arraydestroy.done4:
// DEBUG2-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG169]]
// DEBUG2:       lpad6:
// DEBUG2-NEXT:    [[TMP6:%.*]] = landingpad { ptr, i32 }
// DEBUG2-NEXT:            cleanup, !dbg [[DBG177]]
// DEBUG2-NEXT:    [[TMP7:%.*]] = extractvalue { ptr, i32 } [[TMP6]], 0, !dbg [[DBG177]]
// DEBUG2-NEXT:    store ptr [[TMP7]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG177]]
// DEBUG2-NEXT:    [[TMP8:%.*]] = extractvalue { ptr, i32 } [[TMP6]], 1, !dbg [[DBG177]]
// DEBUG2-NEXT:    store i32 [[TMP8]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG177]]
// DEBUG2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT5]], align 8, !dbg [[DBG173]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ISEMPTY10:%.*]] = icmp eq ptr getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), [[TMP9]], !dbg [[DBG173]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY10]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY11:%.*]], !dbg [[DBG173]]
// DEBUG2:       arraydestroy.body11:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST12:%.*]] = phi ptr [ [[TMP9]], [[LPAD6]] ], [ [[ARRAYDESTROY_ELEMENT13:%.*]], [[ARRAYDESTROY_BODY11]] ], !dbg [[DBG173]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT13]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST12]], i64 -1, !dbg [[DBG173]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT13]]) #[[ATTR3]], !dbg [[DBG173]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE14:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT13]], getelementptr inbounds ([3 x %struct.S1], ptr @arr_x, i64 1), !dbg [[DBG173]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE14]], label [[ARRAYDESTROY_DONE15]], label [[ARRAYDESTROY_BODY11]], !dbg [[DBG173]]
// DEBUG2:       arraydestroy.done15:
// DEBUG2-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG173]]
// DEBUG2:       ehcleanup:
// DEBUG2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG167]]
// DEBUG2-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP10]], i64 0, i64 0, !dbg [[DBG167]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ISEMPTY16:%.*]] = icmp eq ptr @arr_x, [[PAD_ARRAYEND]], !dbg [[DBG167]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY16]], label [[ARRAYDESTROY_DONE21:%.*]], label [[ARRAYDESTROY_BODY17:%.*]], !dbg [[DBG167]]
// DEBUG2:       arraydestroy.body17:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST18:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT19:%.*]], [[ARRAYDESTROY_BODY17]] ], !dbg [[DBG167]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT19]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST18]], i64 -1, !dbg [[DBG167]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT19]]) #[[ATTR3]], !dbg [[DBG167]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE20:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT19]], @arr_x, !dbg [[DBG167]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE20]], label [[ARRAYDESTROY_DONE21]], label [[ARRAYDESTROY_BODY17]], !dbg [[DBG167]]
// DEBUG2:       arraydestroy.done21:
// DEBUG2-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG167]]
// DEBUG2:       eh.resume:
// DEBUG2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG167]]
// DEBUG2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG167]]
// DEBUG2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG167]]
// DEBUG2-NEXT:    [[LPAD_VAL22:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG167]]
// DEBUG2-NEXT:    resume { ptr, i32 } [[LPAD_VAL22]], !dbg [[DBG167]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..3
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 !dbg [[DBG178:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[ARRAYINIT_ENDOFINIT:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[ARRAYINIT_ENDOFINIT1:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    [[ARRAYINIT_ENDOFINIT7:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META179:![0-9]+]], !DIExpression(), [[META180:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG181:![0-9]+]]
// DEBUG2-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG182:![0-9]+]]
// DEBUG2-NEXT:    store ptr [[TMP1]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG183:![0-9]+]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]], i32 noundef 1)
// DEBUG2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG184:![0-9]+]]
// DEBUG2:       invoke.cont:
// DEBUG2-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 1, !dbg [[DBG183]]
// DEBUG2-NEXT:    store ptr [[ARRAYINIT_ELEMENT]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG183]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// DEBUG2-NEXT:            to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]], !dbg [[DBG185:![0-9]+]]
// DEBUG2:       invoke.cont2:
// DEBUG2-NEXT:    [[ARRAYINIT_ELEMENT3:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[TMP1]], i64 2, !dbg [[DBG183]]
// DEBUG2-NEXT:    store ptr [[ARRAYINIT_ELEMENT3]], ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG183]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT3]], i32 noundef 3)
// DEBUG2-NEXT:            to label [[INVOKE_CONT4:%.*]] unwind label [[LPAD]], !dbg [[DBG186:![0-9]+]]
// DEBUG2:       invoke.cont4:
// DEBUG2-NEXT:    [[ARRAYINIT_ELEMENT6:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 1, !dbg [[DBG182]]
// DEBUG2-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG182]]
// DEBUG2-NEXT:    store ptr [[ARRAYINIT_ELEMENT6]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG187:![0-9]+]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT6]], i32 noundef 4)
// DEBUG2-NEXT:            to label [[INVOKE_CONT9:%.*]] unwind label [[LPAD8:%.*]], !dbg [[DBG188:![0-9]+]]
// DEBUG2:       invoke.cont9:
// DEBUG2-NEXT:    [[ARRAYINIT_ELEMENT10:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 1, !dbg [[DBG187]]
// DEBUG2-NEXT:    store ptr [[ARRAYINIT_ELEMENT10]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG187]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT10]], i32 noundef 5)
// DEBUG2-NEXT:            to label [[INVOKE_CONT11:%.*]] unwind label [[LPAD8]], !dbg [[DBG189:![0-9]+]]
// DEBUG2:       invoke.cont11:
// DEBUG2-NEXT:    [[ARRAYINIT_ELEMENT12:%.*]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYINIT_ELEMENT6]], i64 2, !dbg [[DBG187]]
// DEBUG2-NEXT:    store ptr [[ARRAYINIT_ELEMENT12]], ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG187]]
// DEBUG2-NEXT:    invoke void @_ZN2S1C1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT12]], i32 noundef 6)
// DEBUG2-NEXT:            to label [[INVOKE_CONT13:%.*]] unwind label [[LPAD8]], !dbg [[DBG190:![0-9]+]]
// DEBUG2:       invoke.cont13:
// DEBUG2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG181]]
// DEBUG2-NEXT:    ret ptr [[TMP2]], !dbg [[DBG181]]
// DEBUG2:       lpad:
// DEBUG2-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// DEBUG2-NEXT:            cleanup, !dbg [[META180]]
// DEBUG2-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0, !dbg [[META180]]
// DEBUG2-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8, !dbg [[META180]]
// DEBUG2-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1, !dbg [[META180]]
// DEBUG2-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[META180]]
// DEBUG2-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT1]], align 8, !dbg [[DBG183]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[TMP1]], [[TMP6]], !dbg [[DBG183]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE5:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG183]]
// DEBUG2:       arraydestroy.body:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP6]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG183]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG183]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG183]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]], !dbg [[DBG183]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE5]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG183]]
// DEBUG2:       arraydestroy.done5:
// DEBUG2-NEXT:    br label [[EHCLEANUP:%.*]], !dbg [[DBG183]]
// DEBUG2:       lpad8:
// DEBUG2-NEXT:    [[TMP7:%.*]] = landingpad { ptr, i32 }
// DEBUG2-NEXT:            cleanup, !dbg [[META180]]
// DEBUG2-NEXT:    [[TMP8:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 0, !dbg [[META180]]
// DEBUG2-NEXT:    store ptr [[TMP8]], ptr [[EXN_SLOT]], align 8, !dbg [[META180]]
// DEBUG2-NEXT:    [[TMP9:%.*]] = extractvalue { ptr, i32 } [[TMP7]], 1, !dbg [[META180]]
// DEBUG2-NEXT:    store i32 [[TMP9]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[META180]]
// DEBUG2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT7]], align 8, !dbg [[DBG187]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ISEMPTY14:%.*]] = icmp eq ptr [[ARRAYINIT_ELEMENT6]], [[TMP10]], !dbg [[DBG187]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY14]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15:%.*]], !dbg [[DBG187]]
// DEBUG2:       arraydestroy.body15:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi ptr [ [[TMP10]], [[LPAD8]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ], !dbg [[DBG187]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST16]], i64 -1, !dbg [[DBG187]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR3]], !dbg [[DBG187]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT17]], [[ARRAYINIT_ELEMENT6]], !dbg [[DBG187]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19]], label [[ARRAYDESTROY_BODY15]], !dbg [[DBG187]]
// DEBUG2:       arraydestroy.done19:
// DEBUG2-NEXT:    br label [[EHCLEANUP]], !dbg [[DBG187]]
// DEBUG2:       ehcleanup:
// DEBUG2-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[ARRAYINIT_ENDOFINIT]], align 8, !dbg [[DBG182]]
// DEBUG2-NEXT:    [[PAD_ARRAYBEGIN:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP1]], i64 0, i64 0, !dbg [[DBG182]]
// DEBUG2-NEXT:    [[PAD_ARRAYEND:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[TMP11]], i64 0, i64 0, !dbg [[DBG182]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ISEMPTY20:%.*]] = icmp eq ptr [[PAD_ARRAYBEGIN]], [[PAD_ARRAYEND]], !dbg [[DBG182]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY20]], label [[ARRAYDESTROY_DONE25:%.*]], label [[ARRAYDESTROY_BODY21:%.*]], !dbg [[DBG182]]
// DEBUG2:       arraydestroy.body21:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST22:%.*]] = phi ptr [ [[PAD_ARRAYEND]], [[EHCLEANUP]] ], [ [[ARRAYDESTROY_ELEMENT23:%.*]], [[ARRAYDESTROY_BODY21]] ], !dbg [[DBG182]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT23]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST22]], i64 -1, !dbg [[DBG182]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT23]]) #[[ATTR3]], !dbg [[DBG182]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE24:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT23]], [[PAD_ARRAYBEGIN]], !dbg [[DBG182]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE24]], label [[ARRAYDESTROY_DONE25]], label [[ARRAYDESTROY_BODY21]], !dbg [[DBG182]]
// DEBUG2:       arraydestroy.done25:
// DEBUG2-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG182]]
// DEBUG2:       eh.resume:
// DEBUG2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG182]]
// DEBUG2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG182]]
// DEBUG2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG182]]
// DEBUG2-NEXT:    [[LPAD_VAL26:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG182]]
// DEBUG2-NEXT:    resume { ptr, i32 } [[LPAD_VAL26]], !dbg [[DBG182]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..4
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG191:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META192:![0-9]+]], !DIExpression(), [[META193:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META193]]
// DEBUG2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], ptr [[TMP1]], i64 6, !dbg [[META193]]
// DEBUG2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META193]]
// DEBUG2:       arraydestroy.body:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META193]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META193]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META193]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]], !dbg [[META193]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META193]]
// DEBUG2:       arraydestroy.done1:
// DEBUG2-NEXT:    ret void, !dbg [[DBG194:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG195:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META198:![0-9]+]], !DIExpression(), [[META199:![0-9]+]])
// DEBUG2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[META199]]
// DEBUG2:       arraydestroy.body:
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[STRUCT_S1:%.*]], ptr @arr_x, i64 6), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[META199]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S1]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[META199]]
// DEBUG2-NEXT:    call void @_ZN2S1D1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[META199]]
// DEBUG2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @arr_x, !dbg [[META199]]
// DEBUG2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[META199]]
// DEBUG2:       arraydestroy.done1:
// DEBUG2-NEXT:    ret void, !dbg [[META199]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@main
// DEBUG2-SAME: () #[[ATTR4:[0-9]+]] personality ptr @__gxx_personality_v0 !dbg [[DBG52:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB9:[0-9]+]]), !dbg [[DBG200:![0-9]+]]
// DEBUG2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[RES]], [[META201:![0-9]+]], !DIExpression(), [[META202:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load atomic i8, ptr @_ZGVZ4mainE2sm acquire, align 8, !dbg [[DBG203:![0-9]+]]
// DEBUG2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP1]], 0, !dbg [[DBG203]]
// DEBUG2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG203]], !prof [[PROF204:![0-9]+]]
// DEBUG2:       init.check:
// DEBUG2-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_guard_acquire(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG203]]
// DEBUG2-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0, !dbg [[DBG203]]
// DEBUG2-NEXT:    br i1 [[TOBOOL]], label [[INIT:%.*]], label [[INIT_END]], !dbg [[DBG203]]
// DEBUG2:       init:
// DEBUG2-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB7:[0-9]+]]), !dbg [[DBG203]]
// DEBUG2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB7]], ptr @_ZZ4mainE2sm, ptr @.__kmpc_global_ctor_..5, ptr null, ptr @.__kmpc_global_dtor_..6), !dbg [[DBG203]]
// DEBUG2-NEXT:    [[TMP4:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB9]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG200]]
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP4]], i32 0, i32 0, !dbg [[DBG205:![0-9]+]]
// DEBUG2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG205]]
// DEBUG2-NEXT:    invoke void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) @_ZZ4mainE2sm, i32 noundef [[TMP5]])
// DEBUG2-NEXT:            to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]], !dbg [[DBG206:![0-9]+]]
// DEBUG2:       invoke.cont:
// DEBUG2-NEXT:    [[TMP6:%.*]] = call i32 @__cxa_atexit(ptr @_ZZ4mainEN5SmainD1Ev, ptr @_ZZ4mainE2sm, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG203]]
// DEBUG2-NEXT:    call void @__cxa_guard_release(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG203]]
// DEBUG2-NEXT:    br label [[INIT_END]], !dbg [[DBG203]]
// DEBUG2:       init.end:
// DEBUG2-NEXT:    [[TMP7:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB11:[0-9]+]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.), !dbg [[DBG207:![0-9]+]]
// DEBUG2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP7]], i32 0, i32 0, !dbg [[DBG208:![0-9]+]]
// DEBUG2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG208]]
// DEBUG2-NEXT:    store i32 [[TMP8]], ptr [[RES]], align 4, !dbg [[DBG209:![0-9]+]]
// DEBUG2-NEXT:    [[TMP9:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB13:[0-9]+]], i32 [[TMP0]], ptr @_ZZ4mainE2sm, i64 24, ptr @_ZZ4mainE2sm.cache.), !dbg [[DBG210:![0-9]+]]
// DEBUG2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[TMP9]], i32 0, i32 0, !dbg [[DBG211:![0-9]+]]
// DEBUG2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A2]], align 8, !dbg [[DBG211]]
// DEBUG2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG212:![0-9]+]]
// DEBUG2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP11]], [[TMP10]], !dbg [[DBG212]]
// DEBUG2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG212]]
// DEBUG2-NEXT:    [[TMP12:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB15:[0-9]+]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG213:![0-9]+]]
// DEBUG2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[TMP12]], i32 0, i32 0, !dbg [[DBG214:![0-9]+]]
// DEBUG2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG214]]
// DEBUG2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG215:![0-9]+]]
// DEBUG2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP14]], [[TMP13]], !dbg [[DBG215]]
// DEBUG2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG215]]
// DEBUG2-NEXT:    [[TMP15:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG216:![0-9]+]]
// DEBUG2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG217:![0-9]+]]
// DEBUG2-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG217]]
// DEBUG2-NEXT:    store i32 [[ADD5]], ptr [[RES]], align 4, !dbg [[DBG217]]
// DEBUG2-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB17:[0-9]+]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.), !dbg [[DBG218:![0-9]+]]
// DEBUG2-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP17]], i32 0, i32 0, !dbg [[DBG219:![0-9]+]]
// DEBUG2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG219]]
// DEBUG2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG220:![0-9]+]]
// DEBUG2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], [[TMP18]], !dbg [[DBG220]]
// DEBUG2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG220]]
// DEBUG2-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB19:[0-9]+]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.), !dbg [[DBG221:![0-9]+]]
// DEBUG2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP20]], i64 0, i64 1, !dbg [[DBG221]]
// DEBUG2-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG221]]
// DEBUG2-NEXT:    [[A9:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX8]], i32 0, i32 0, !dbg [[DBG222:![0-9]+]]
// DEBUG2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A9]], align 4, !dbg [[DBG222]]
// DEBUG2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG223:![0-9]+]]
// DEBUG2-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP22]], [[TMP21]], !dbg [[DBG223]]
// DEBUG2-NEXT:    store i32 [[ADD10]], ptr [[RES]], align 4, !dbg [[DBG223]]
// DEBUG2-NEXT:    [[TMP23:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB21:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.), !dbg [[DBG224:![0-9]+]]
// DEBUG2-NEXT:    [[TMP24:%.*]] = load i32, ptr [[TMP23]], align 4, !dbg [[DBG224]]
// DEBUG2-NEXT:    [[TMP25:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG225:![0-9]+]]
// DEBUG2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP25]], [[TMP24]], !dbg [[DBG225]]
// DEBUG2-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG225]]
// DEBUG2-NEXT:    [[TMP26:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB23:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.), !dbg [[DBG226:![0-9]+]]
// DEBUG2-NEXT:    [[TMP27:%.*]] = load float, ptr [[TMP26]], align 4, !dbg [[DBG226]]
// DEBUG2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP27]] to i32, !dbg [[DBG226]]
// DEBUG2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG227:![0-9]+]]
// DEBUG2-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], [[CONV]], !dbg [[DBG227]]
// DEBUG2-NEXT:    store i32 [[ADD12]], ptr [[RES]], align 4, !dbg [[DBG227]]
// DEBUG2-NEXT:    [[TMP29:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB25:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.), !dbg [[DBG228:![0-9]+]]
// DEBUG2-NEXT:    [[A13:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP29]], i32 0, i32 0, !dbg [[DBG229:![0-9]+]]
// DEBUG2-NEXT:    [[TMP30:%.*]] = load i32, ptr [[A13]], align 4, !dbg [[DBG229]]
// DEBUG2-NEXT:    [[TMP31:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG230:![0-9]+]]
// DEBUG2-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP31]], [[TMP30]], !dbg [[DBG230]]
// DEBUG2-NEXT:    store i32 [[ADD14]], ptr [[RES]], align 4, !dbg [[DBG230]]
// DEBUG2-NEXT:    [[TMP32:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG231:![0-9]+]]
// DEBUG2-NEXT:    ret i32 [[TMP32]], !dbg [[DBG232:![0-9]+]]
// DEBUG2:       lpad:
// DEBUG2-NEXT:    [[TMP33:%.*]] = landingpad { ptr, i32 }
// DEBUG2-NEXT:            cleanup, !dbg [[DBG233:![0-9]+]]
// DEBUG2-NEXT:    [[TMP34:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 0, !dbg [[DBG233]]
// DEBUG2-NEXT:    store ptr [[TMP34]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG233]]
// DEBUG2-NEXT:    [[TMP35:%.*]] = extractvalue { ptr, i32 } [[TMP33]], 1, !dbg [[DBG233]]
// DEBUG2-NEXT:    store i32 [[TMP35]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG233]]
// DEBUG2-NEXT:    call void @__cxa_guard_abort(ptr @_ZGVZ4mainE2sm) #[[ATTR3]], !dbg [[DBG203]]
// DEBUG2-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG203]]
// DEBUG2:       eh.resume:
// DEBUG2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG203]]
// DEBUG2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG203]]
// DEBUG2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG203]]
// DEBUG2-NEXT:    [[LPAD_VAL15:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG203]]
// DEBUG2-NEXT:    resume { ptr, i32 } [[LPAD_VAL15]], !dbg [[DBG203]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..5
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG234:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB5:[0-9]+]]), !dbg [[DBG235:![0-9]+]]
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META236:![0-9]+]], !DIExpression(), [[META237:![0-9]+]])
// DEBUG2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG238:![0-9]+]]
// DEBUG2-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB5]], i32 [[TMP1]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG235]]
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0, !dbg [[DBG239:![0-9]+]]
// DEBUG2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG239]]
// DEBUG2-NEXT:    call void @_ZZ4mainEN5SmainC1Ei(ptr noundef nonnull align 8 dereferenceable(24) [[TMP2]], i32 noundef [[TMP4]]), !dbg [[DBG240:![0-9]+]]
// DEBUG2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG238]]
// DEBUG2-NEXT:    ret ptr [[TMP5]], !dbg [[DBG238]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC1Ei
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG241:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META242:![0-9]+]], !DIExpression(), [[META244:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META245:![0-9]+]], !DIExpression(), [[META246:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG247:![0-9]+]]
// DEBUG2-NEXT:    call void @_ZZ4mainEN5SmainC2Ei(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG247]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG248:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..6
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG249:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META250:![0-9]+]], !DIExpression(), [[META251:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META251]]
// DEBUG2-NEXT:    call void @_ZZ4mainEN5SmainD1Ev(ptr noundef nonnull align 8 dereferenceable(24) [[TMP1]]) #[[ATTR3]], !dbg [[META251]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG252:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD1Ev
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG253:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META254:![0-9]+]], !DIExpression(), [[META255:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    call void @_ZZ4mainEN5SmainD2Ev(ptr noundef nonnull align 8 dereferenceable(24) [[THIS1]]) #[[ATTR3]], !dbg [[DBG256:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG257:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_Z6foobarv
// DEBUG2-SAME: () #[[ATTR2]] !dbg [[DBG258:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[RES:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB27:[0-9]+]]), !dbg [[DBG259:![0-9]+]]
// DEBUG2-NEXT:      #dbg_declare(ptr [[RES]], [[META260:![0-9]+]], !DIExpression(), [[META261:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB27]], i32 [[TMP0]], ptr @_ZN6Static1sE, i64 8, ptr @_ZN6Static1sE.cache.), !dbg [[DBG259]]
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S3:%.*]], ptr [[TMP1]], i32 0, i32 0, !dbg [[DBG262:![0-9]+]]
// DEBUG2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4, !dbg [[DBG262]]
// DEBUG2-NEXT:    store i32 [[TMP2]], ptr [[RES]], align 4, !dbg [[DBG263:![0-9]+]]
// DEBUG2-NEXT:    [[TMP3:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB29:[0-9]+]], i32 [[TMP0]], ptr @_ZL3gs1, i64 4, ptr @_ZL3gs1.cache.), !dbg [[DBG264:![0-9]+]]
// DEBUG2-NEXT:    [[A1:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[TMP3]], i32 0, i32 0, !dbg [[DBG265:![0-9]+]]
// DEBUG2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A1]], align 4, !dbg [[DBG265]]
// DEBUG2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG266:![0-9]+]]
// DEBUG2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP5]], [[TMP4]], !dbg [[DBG266]]
// DEBUG2-NEXT:    store i32 [[ADD]], ptr [[RES]], align 4, !dbg [[DBG266]]
// DEBUG2-NEXT:    [[TMP6:%.*]] = load i32, ptr @_ZL3gs2, align 8, !dbg [[DBG267:![0-9]+]]
// DEBUG2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG268:![0-9]+]]
// DEBUG2-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP7]], [[TMP6]], !dbg [[DBG268]]
// DEBUG2-NEXT:    store i32 [[ADD2]], ptr [[RES]], align 4, !dbg [[DBG268]]
// DEBUG2-NEXT:    [[TMP8:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB31:[0-9]+]], i32 [[TMP0]], ptr @gs3, i64 12, ptr @gs3.cache.), !dbg [[DBG269:![0-9]+]]
// DEBUG2-NEXT:    [[A3:%.*]] = getelementptr inbounds nuw [[STRUCT_S5:%.*]], ptr [[TMP8]], i32 0, i32 0, !dbg [[DBG270:![0-9]+]]
// DEBUG2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[A3]], align 4, !dbg [[DBG270]]
// DEBUG2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG271:![0-9]+]]
// DEBUG2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], [[TMP9]], !dbg [[DBG271]]
// DEBUG2-NEXT:    store i32 [[ADD4]], ptr [[RES]], align 4, !dbg [[DBG271]]
// DEBUG2-NEXT:    [[TMP11:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB33:[0-9]+]], i32 [[TMP0]], ptr @arr_x, i64 24, ptr @arr_x.cache.), !dbg [[DBG272:![0-9]+]]
// DEBUG2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x [3 x %struct.S1]], ptr [[TMP11]], i64 0, i64 1, !dbg [[DBG272]]
// DEBUG2-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [3 x %struct.S1], ptr [[ARRAYIDX]], i64 0, i64 1, !dbg [[DBG272]]
// DEBUG2-NEXT:    [[A6:%.*]] = getelementptr inbounds nuw [[STRUCT_S1]], ptr [[ARRAYIDX5]], i32 0, i32 0, !dbg [[DBG273:![0-9]+]]
// DEBUG2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[A6]], align 4, !dbg [[DBG273]]
// DEBUG2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG274:![0-9]+]]
// DEBUG2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], [[TMP12]], !dbg [[DBG274]]
// DEBUG2-NEXT:    store i32 [[ADD7]], ptr [[RES]], align 4, !dbg [[DBG274]]
// DEBUG2-NEXT:    [[TMP14:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB35:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIiE2stE, i64 4, ptr @_ZN2STIiE2stE.cache.), !dbg [[DBG275:![0-9]+]]
// DEBUG2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4, !dbg [[DBG275]]
// DEBUG2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG276:![0-9]+]]
// DEBUG2-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], [[TMP15]], !dbg [[DBG276]]
// DEBUG2-NEXT:    store i32 [[ADD8]], ptr [[RES]], align 4, !dbg [[DBG276]]
// DEBUG2-NEXT:    [[TMP17:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB37:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STIfE2stE, i64 4, ptr @_ZN2STIfE2stE.cache.), !dbg [[DBG277:![0-9]+]]
// DEBUG2-NEXT:    [[TMP18:%.*]] = load float, ptr [[TMP17]], align 4, !dbg [[DBG277]]
// DEBUG2-NEXT:    [[CONV:%.*]] = fptosi float [[TMP18]] to i32, !dbg [[DBG277]]
// DEBUG2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG278:![0-9]+]]
// DEBUG2-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], [[CONV]], !dbg [[DBG278]]
// DEBUG2-NEXT:    store i32 [[ADD9]], ptr [[RES]], align 4, !dbg [[DBG278]]
// DEBUG2-NEXT:    [[TMP20:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB39:[0-9]+]], i32 [[TMP0]], ptr @_ZN2STI2S4E2stE, i64 8, ptr @_ZN2STI2S4E2stE.cache.), !dbg [[DBG279:![0-9]+]]
// DEBUG2-NEXT:    [[A10:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[TMP20]], i32 0, i32 0, !dbg [[DBG280:![0-9]+]]
// DEBUG2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[A10]], align 4, !dbg [[DBG280]]
// DEBUG2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG281:![0-9]+]]
// DEBUG2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP22]], [[TMP21]], !dbg [[DBG281]]
// DEBUG2-NEXT:    store i32 [[ADD11]], ptr [[RES]], align 4, !dbg [[DBG281]]
// DEBUG2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[RES]], align 4, !dbg [[DBG282:![0-9]+]]
// DEBUG2-NEXT:    ret i32 [[TMP23]], !dbg [[DBG283:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@__cxx_global_var_init.7
// DEBUG2-SAME: () #[[ATTR0]] comdat($_ZN2STI2S4E2stE) !dbg [[DBG284:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i8, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG285:![0-9]+]]
// DEBUG2-NEXT:    [[GUARD_UNINITIALIZED:%.*]] = icmp eq i8 [[TMP0]], 0, !dbg [[DBG285]]
// DEBUG2-NEXT:    br i1 [[GUARD_UNINITIALIZED]], label [[INIT_CHECK:%.*]], label [[INIT_END:%.*]], !dbg [[DBG285]]
// DEBUG2:       init.check:
// DEBUG2-NEXT:    store i8 1, ptr @_ZGVN2STI2S4E2stE, align 8, !dbg [[DBG285]]
// DEBUG2-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB41:[0-9]+]]), !dbg [[DBG285]]
// DEBUG2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB41]], ptr @_ZN2STI2S4E2stE, ptr @.__kmpc_global_ctor_..8, ptr null, ptr @.__kmpc_global_dtor_..9), !dbg [[DBG285]]
// DEBUG2-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) @_ZN2STI2S4E2stE, i32 noundef 23), !dbg [[DBG286:![0-9]+]]
// DEBUG2-NEXT:    [[TMP2:%.*]] = call i32 @__cxa_atexit(ptr @_ZN2S4D1Ev, ptr @_ZN2STI2S4E2stE, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG285]]
// DEBUG2-NEXT:    br label [[INIT_END]], !dbg [[DBG285]]
// DEBUG2:       init.end:
// DEBUG2-NEXT:    ret void, !dbg [[DBG288:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..8
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG289:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META290:![0-9]+]], !DIExpression(), [[META291:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG292:![0-9]+]]
// DEBUG2-NEXT:    call void @_ZN2S4C1Ei(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]], i32 noundef 23), !dbg [[DBG293:![0-9]+]]
// DEBUG2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG292]]
// DEBUG2-NEXT:    ret ptr [[TMP2]], !dbg [[DBG292]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S4C1Ei
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 !dbg [[DBG294:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META295:![0-9]+]], !DIExpression(), [[META297:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META298:![0-9]+]], !DIExpression(), [[META299:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG300:![0-9]+]]
// DEBUG2-NEXT:    call void @_ZN2S4C2Ei(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]], i32 noundef [[TMP0]]), !dbg [[DBG300]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG301:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..9
// DEBUG2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] !dbg [[DBG302:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[DOTADDR]], [[META303:![0-9]+]], !DIExpression(), [[META304:![0-9]+]])
// DEBUG2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[META304]]
// DEBUG2-NEXT:    call void @_ZN2S4D1Ev(ptr noundef nonnull align 4 dereferenceable(8) [[TMP1]]) #[[ATTR3]], !dbg [[META304]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG305:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S4D1Ev
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG306:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META307:![0-9]+]], !DIExpression(), [[META308:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    call void @_ZN2S4D2Ev(ptr noundef nonnull align 4 dereferenceable(8) [[THIS1]]) #[[ATTR3]], !dbg [[DBG309:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG310:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S1C2Ei
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG311:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META312:![0-9]+]], !DIExpression(), [[META313:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META314:![0-9]+]], !DIExpression(), [[META315:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG316:![0-9]+]]
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG317:![0-9]+]]
// DEBUG2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG316]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG318:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S1D2Ev
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG319:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META320:![0-9]+]], !DIExpression(), [[META321:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S1:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG322:![0-9]+]]
// DEBUG2-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG324:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG325:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S2C2Ei
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG326:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META327:![0-9]+]], !DIExpression(), [[META328:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META329:![0-9]+]], !DIExpression(), [[META330:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG331:![0-9]+]]
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG332:![0-9]+]]
// DEBUG2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG331]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG333:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S2D2Ev
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG334:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META335:![0-9]+]], !DIExpression(), [[META336:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S2:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG337:![0-9]+]]
// DEBUG2-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG339:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG340:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainC2Ei
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG341:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META342:![0-9]+]], !DIExpression(), [[META343:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META344:![0-9]+]], !DIExpression(), [[META345:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG346:![0-9]+]]
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG347:![0-9]+]]
// DEBUG2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 8, !dbg [[DBG346]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG348:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZZ4mainEN5SmainD2Ev
// DEBUG2-SAME: (ptr noundef nonnull align 8 dereferenceable(24) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG349:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META350:![0-9]+]], !DIExpression(), [[META351:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_SMAIN:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG352:![0-9]+]]
// DEBUG2-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG354:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG355:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S4C2Ei
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG356:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META357:![0-9]+]], !DIExpression(), [[META358:![0-9]+]])
// DEBUG2-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// DEBUG2-NEXT:      #dbg_declare(ptr [[A_ADDR]], [[META359:![0-9]+]], !DIExpression(), [[META360:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A2:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG361:![0-9]+]]
// DEBUG2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4, !dbg [[DBG362:![0-9]+]]
// DEBUG2-NEXT:    store i32 [[TMP0]], ptr [[A2]], align 4, !dbg [[DBG361]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG363:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_ZN2S4D2Ev
// DEBUG2-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 !dbg [[DBG364:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// DEBUG2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:      #dbg_declare(ptr [[THIS_ADDR]], [[META365:![0-9]+]], !DIExpression(), [[META366:![0-9]+]])
// DEBUG2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// DEBUG2-NEXT:    [[A:%.*]] = getelementptr inbounds nuw [[STRUCT_S4:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG367:![0-9]+]]
// DEBUG2-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG369:![0-9]+]]
// DEBUG2-NEXT:    ret void, !dbg [[DBG370:![0-9]+]]
//
//
// DEBUG2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_threadprivate_codegen.cpp
// DEBUG2-SAME: () #[[ATTR0]] !dbg [[DBG371:![0-9]+]] {
// DEBUG2-NEXT:  entry:
// DEBUG2-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG372:![0-9]+]]
// DEBUG2-NEXT:    call void @__cxx_global_var_init.1(), !dbg [[DBG372]]
// DEBUG2-NEXT:    call void @__cxx_global_var_init.2(), !dbg [[DBG372]]
// DEBUG2-NEXT:    ret void
//
