# SPDX-License-Identifier: Apache-2.0
# Copyright 2015-2016 The Meson development team

from __future__ import annotations

import sys, os, subprocess, re
import typing as T

def config_vcs_tag(infile: str, outfile: str, fallback: str, source_dir: str, replace_string: str, regex_selector: str, cmd: T.List[str]) -> None:
    try:
        output = subprocess.check_output(cmd, cwd=source_dir)
        new_string = re.search(regex_selector, output.decode()).group(1).strip()
    except Exception:
        new_string = fallback

    with open(infile, encoding='utf-8') as f:
        new_data = f.read().replace(replace_string, new_string)
    if os.path.exists(outfile):
        with open(outfile, encoding='utf-8') as f:
            needs_update = f.read() != new_data
    else:
        needs_update = True
    if needs_update:
        with open(outfile, 'w', encoding='utf-8') as f:
            f.write(new_data)


def run(args: T.List[str]) -> int:
    infile, outfile, fallback, source_dir, replace_string, regex_selector = args[0:6]
    command = args[6:]
    config_vcs_tag(infile, outfile, fallback, source_dir, replace_string, regex_selector, command)
    return 0

if __name__ == '__main__':
    sys.exit(run(sys.argv[1:]))
