% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{csv_read_options}
\alias{csv_read_options}
\title{CSV Reading Options}
\usage{
csv_read_options(
  use_threads = option_use_threads(),
  block_size = 1048576L,
  skip_rows = 0L,
  column_names = character(0),
  autogenerate_column_names = FALSE,
  encoding = "UTF-8",
  skip_rows_after_names = 0L
)
}
\arguments{
\item{use_threads}{Whether to use the global CPU thread pool}

\item{block_size}{Block size we request from the IO layer; also determines
the size of chunks when use_threads is \code{TRUE}.}

\item{skip_rows}{Number of lines to skip before reading data (default 0).}

\item{column_names}{Character vector to supply column names. If length-0
(the default), the first non-skipped row will be parsed to generate column
names, unless \code{autogenerate_column_names} is \code{TRUE}.}

\item{autogenerate_column_names}{Logical: generate column names instead of
using the first non-skipped row (the default)? If \code{TRUE}, column names will
be "f0", "f1", ..., "fN".}

\item{encoding}{The file encoding. (default \code{"UTF-8"})}

\item{skip_rows_after_names}{Number of lines to skip after the column names (default 0).
This number can be larger than the number of rows in one block, and empty rows are counted.
The order of application is as follows:
- \code{skip_rows} is applied (if non-zero);
- column names are read (unless \code{column_names} is set);
- \code{skip_rows_after_names} is applied (if non-zero).}
}
\description{
CSV Reading Options
}
\examples{
\dontshow{if (arrow_with_dataset()) withAutoprint(\{ # examplesIf}
tf <- tempfile()
on.exit(unlink(tf))
writeLines("my file has a non-data header\nx\n1\n2", tf)
read_csv_arrow(tf, read_options = csv_read_options(skip_rows = 1))
open_csv_dataset(tf, read_options = csv_read_options(skip_rows = 1))
\dontshow{\}) # examplesIf}
}
