// generated by ../../../../tools/tube_transfer.py
// tube: EF86
// plate current function: pentode
// mu: 34.9
// kx: 1.35
// kg1: 2648.1
// kg2: 4267
// kp: 222.06
// kvb: 4.7
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_EF86[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	181.53912491572595,181.4332084765696,181.32723172109516,181.22119470111903,181.11509746837,
	181.00894007448971,180.90272257103223,180.79644500946475,180.69010744116753,180.5837099174343,
	180.47725248947216,180.37073520840187,180.26415812525804,180.15752129098942,180.05082475645898,
	179.94406857244397,179.83725278963638,179.730377458643,179.62344262998542,179.51644835410056,
	179.40939468134061,179.30228166197327,179.19510934618214,179.0878777840664,178.98058702564163,
	178.87323712083958,178.7658281195085,178.65836007141334,178.55083302623584,178.44324703357483,
	178.3356021429465,178.22789840378422,178.12013586543935,178.01231457718077,177.90443458819564,
	177.79649594758905,177.6884987043848,177.5804429075252,177.47232860587127,177.36415584820315,
	177.25592468322017,177.14763515954107,177.0392873257042,176.93088123016773,176.82241692130967,
	176.71389444742852,176.6053138567429,176.49667519739225,176.38797851743684,176.2792238648577,
	176.1704112875573,176.06154083335952,175.9526125500097,175.84362648517518,175.7345826864453,
	175.62548120133155,175.51632207726792,175.40710536161114,175.2978311016407,175.1884993445591,
	175.0791101374922,174.96966352748936,174.8601595615236,174.7505982864918,174.64097974921506,
	174.5313039964387,174.42157107483263,174.31178103099143,174.20193391143468,174.09202976260718,
	173.9820686308791,173.872050562546,173.76197560382965,173.65184380087743,173.5416551997632,
	173.43140984648718,173.32110778697637,173.21074906708452,173.10033373259245,172.98986182920848,
	172.8793334025683,172.7687484982355,172.65810716170145,172.5474094383859,172.43665537363694,
	172.32584501273126,172.21497840087443,172.10405558320107,171.99307660477515,171.88204151059003,
	171.770950345569,171.6598031545651,171.5485999823619,171.43734087367287,171.32602587314247,
	171.21465502534596,171.10322837478964,170.9917459659112,170.88020784307975,170.76861405059617,
	170.65696463269336,170.54525963353657,170.43349909722326,170.3216830677838,170.2098115891812,
	170.09788470531177,169.98590246000526,169.87386489702484,169.76177206006756,169.64962399276462,
	169.53742073868133,169.4251623413177,169.31284884410837,169.2004802904231,169.08805672356667,
	168.9755781867795,168.8630447232377,168.75045637605314,168.637813188274,168.52511520288488,
	168.41236246280687,168.29955501089802,168.18669288995358,168.073776142706,167.96080481182543,
	167.84777893991983,167.73469856953514,167.62156374315578,167.5083745032045,167.39513089204308,
	167.2818329519721,167.16848072523172,167.0550742540014,166.94161358040034,166.8280987464879,
	166.71452979426363,166.6009067656675,166.48722970258035,166.373498646824,166.25971364016144,
	166.14587472429722,166.03198194087756,165.91803533149064,165.80403493766707,165.68998080087965,
	165.5758729625442,165.46171146401923,165.3474963466069,165.23322765155234,165.1189054200448,
	165.0045296932175,164.89010051214763,164.77561791785715,164.6610819513127,164.5464926534259,
	164.43185006505365,164.31715422699838,164.20240518000833,164.08760296477763,163.97274762194695,
	163.8578391921033,163.74287771578062,163.62786323345983,163.51279578556932,163.39767541248494,
	163.28250215453042,163.16727605197764,163.05199714504687,162.93666547390697,162.82128107867578,
	162.70584399942024,162.59035427615672,162.47481194885148,162.35921705742044,162.24356964172995,
	162.12786974159687,162.01211739678882,161.89631264702427,161.7804555319733,161.6645460912574,
	161.54858436444982,161.43257039107627,161.31650421061448,161.200385862495,161.08421538610133,
	160.96799282077023,160.8517182057918,160.73539158041004,160.61901298382293,160.5025824551828,
	160.3861000335965,160.26956575812588,160.15297966778772,160.03634180155453,159.91965219835427,
	159.80291089707097,159.68611793654495,159.5692733555732,159.4523771929092,159.33542948726392,
	159.21843027730552,159.10137960165994,158.98427749891107,158.86712400760095,158.7499191662304,
	158.63266301325885,158.51535558710492,158.39799692614667,158.2805870687219,158.16312605312825,
	158.0456139176238,157.92805070042712,157.81043643971762,157.692771173636,157.57505494028428,
	157.4572877777263,157.33946972398786,157.22160081705724,157.10368109488522,156.98571059538557,
	156.86768935643536,156.7496174158751,156.63149481150919,156.51332158110608,156.3950977623988,
	156.276823393085,156.15849851082746,156.04012315325423,155.92169735795903,155.80322116250161,
	155.68469460440798,155.5661177211706,155.44749055024894,155.3288131290696,155.2100854950267,
	155.09130768548224,154.97247973776618,154.85360168917708,154.73467357698217,154.6156954384178,
	154.49666731068962,154.37758923097306,154.2584612364135,154.13928336412675,154.02005565119913,
	153.90077813468804,153.78145085162217,153.66207383900172,153.542647133799,153.4231707729584,
	153.30364479339698,153.1840692320047,153.0644441256448,152.944769511154,152.82504542534292,
	152.7052719049965,152.58544898687413,152.4655767077101,152.3456551042139,152.2256842130706,
	152.10566407094115,151.98559471446265,151.86547618024883,151.74530850489026,151.62509172495473,
	151.50482587698764,151.38451099751225,151.26414712303003,151.1437342900211,151.02327253494448,
	150.90276189423847,150.78220240432094,150.6615941015898,150.54093702242324,150.4202312031801,
	150.29947668020017,150.17867348980465,150.0578216682965,149.93692125196065,149.81597227706442,
	149.6949747798581,149.57392879657485,149.4528343634314,149.3316915166284,149.21050029235064,
	149.08926072676738,148.96797285603293,148.8466367162868,148.72525234365418,148.60381977424626,
	148.4823390441606,148.36081018948147,148.2392332462803,148.11760825061594,147.9959352385352,
	147.8742142460729,147.75244530925278,147.63062846408718,147.50876374657796,147.38685119271676,
	147.26489083848523,147.1428827198555,147.0208268727905,146.8987233332446,146.77657213716347,
	146.6543733204851,146.53212691913964,146.40983296905014,146.28749150613277,146.1651025662972,
	146.04266618544716,145.9201823994806,145.79765124429025,145.6750727557639,145.55244696978494,
	145.42977392223264,145.3070536489825,145.18428618590684,145.0614715688751,144.93860983375404,
	144.81570101640858,144.6927451527018,144.56974227849557,144.44669242965088,144.32359564202818,
	144.2004519514881,144.07726139389138,143.95402400509965,143.83073982097577,143.70740887738413,
	143.58403121019117,143.46060685526587,143.33713584847987,143.21361822570827,143.09005402282992,
	142.96644327572756,142.84278602028874,142.71908229240586,142.59533212797686,142.4715355629054,
	142.34769263310145,142.22380337448183,142.0998678229703,141.97588601449834,141.85185798500552,
	141.72778377043966,141.6036634067577,141.47949692992586,141.35528437592012,141.23102578072675,
	141.10672118034267,140.982370610776,140.8579741080464,140.73353170818555,140.60904344723775,
	140.4845093612602,140.3599294863234,140.2353038585119,140.11063251392451,139.98591548867478,
	139.86115281889158,139.73634454071956,139.61149069031947,139.48659130386872,139.36164641756199,
	139.23665606761145,139.11162029024743,138.9865391217187,138.8614125982932,138.7362407562584,
	138.61102363192165,138.4857612616109,138.36045368167495,138.23510092848423,138.109703038431,
	137.98426004793004,137.8587719934189,137.73323891135877,137.6076608382346,137.48203781055585,
	137.3563698648569,137.23065703769754,137.10489936566344,136.97909688536674,136.85324963344667,
	136.72735764656963,136.60142096143016,136.4754396147513,136.34941364328506,136.22334308381286,
	136.09722797314626,135.9710683481274,135.84486424562942,135.71861570255706,135.59232275584722,
	135.46598544246947,135.33960379942656,135.21317786375496,135.08670767252548,134.96019326284355,
	134.8336346718501,134.70703193672193,134.58038509467218,134.453694182951,134.32695923884617,
	134.20018029968332,134.07335740282687,133.9464905856804,133.8195798856872,133.69262534033084,
	133.56562698713586,133.43858486366793,133.3114990075351,133.18436945638774,133.05719624791928,
	132.92997941986707,132.80271901001254,132.6754150561821,132.5480675962475,132.42067666812656,
	132.29324230978366,132.16576455923035,132.038243454526,131.91067903377828,131.7830713351439,
	131.65542039682896,131.52772625708994,131.39998895423386,131.27220852661915,131.14438501265636,
	131.01651845080826,130.88860887959115,130.7606563375749,130.63266086338385,130.50462249569733,
	130.37654127325038,130.24841723483425,130.1202504192971,129.99204086554457,129.8637886125404,
	129.73549369930723,129.6071561649271,129.47877604854202,129.3503533893547,129.22188822662915,
	129.09338059969159,128.96483054793057,128.83623811079818,128.70760332781018,128.57892623854707,
	128.45020688265467,128.32144529984456,128.19264152989498,128.06379561265138,127.93490758802716,
	127.80597749600429,127.67700537663396,127.54799127003739,127.41893521640633,127.28983725600385,
	127.1606974291651,127.0315157762978,126.90229233788317,126.77302715447635,126.64372026670733,
	126.5143717152816,126.38498154098082,126.25554978466349,126.1260764872657,125.9965616898019,
	125.86700543336556,125.7374077591299,125.6077687083485,125.47808832235629,125.34836664257007,
	125.21860371048923,125.08879956769664,124.95895425585923,124.82906781672891,124.69914029214306,
	124.56917172402551,124.43916215438726,124.30911162532709,124.17902017903243,124.04888785778016,
	123.91871470393723,123.78850075996161,123.6582460684029,123.52795067190327,123.397614613198,
	123.2672379351165,123.13682068058306,123.00636289261743,122.8758646143359,122.74532588895192,
	122.61474675977696,122.48412727022131,122.35346746379477,122.22276738410774,122.09202707487175,
	121.96124657990048,121.83042594311043,121.69956520852183,121.5686644202595,121.43772362255368,
	121.30674285974075,121.17572217626419,121.04466161667548,120.91356122563474,120.78242104791188,
	120.65124112838713,120.52002151205225,120.38876224401112,120.25746336948076,120.12612493379216,
	119.99474698239122,119.86332956083953,119.73187271481545,119.60037649011473,119.4688409326517,
	119.33726608846003,119.20565200369361,119.07399872462757,118.94230629765913,118.81057476930863,
	118.6788041862203,118.54699459516333,118.41514604303276,118.28325857685056,118.15133224376629,
	118.01936709105841,117.88736316613492,117.7553205165347,117.6232391899282,117.4911192341184,
	117.35896069704212,117.22676362677072,117.09452807151128,116.96225407960742,116.82994169954057,
	116.69759097993077,116.5652019695379,116.43277471726259,116.30030927214727,116.16780568337732,
	116.03526400028208,115.90268427233592,115.77006654915917,115.63741088051965,115.50471731633331,
	115.3719859066655,115.23921670173216,115.10640975190083,114.97356510769188,114.8406828197796,
	114.70776293899334,114.57480551631873,114.44181060289883,114.30877825003525,114.17570850918952,
	114.04260143198405,113.90945707020359,113.77627547579635,113.64305670087522,113.509800797719,
	113.37650781877386,113.24317781665438,113.10981084414506,112.97640695420145,112.84296619995155,
	112.70948863469722,112.57597431191539,112.44242328525958,112.3088356085612,112.17521133583095,
	112.04155052126029,111.90785321922287,111.77411948427591,111.64034937116188,111.5065429348097,
	111.37270023033652,111.23882131304913,111.10490623844555,110.97095506221667,110.83696784024768,
	110.70294462861987,110.56888548361229,110.43479046170336,110.30065961957246,110.16649301410193,
	110.03229070237866,109.89805274169593,109.76377918955517,109.6294701036679,109.49512554195756,
	109.36074556256142,109.22633022383262,109.09187958434202,108.95739370288035,108.82287263846021,
	108.68831645031817,108.55372519791693,108.41909894094752,108.28443773933155,108.14974165322343,
	108.0150107430127,107.88024506932645,107.74544469303176,107.61060967523808,107.4757400772998,
	107.34083596081892,107.20589738764767,107.07092441989109,106.93591711990994,106.80087555032352,
	106.66579977401256,106.53068985412207,106.39554585406471,106.2603678375235,106.12515586845542,
	105.98991001109445,105.85463032995493,105.71931688983516,105.58396975582092,105.44858899328902,
	105.31317466791113,105.17772684565756,105.0422455928013,104.90673097592203,104.77118306191024,
	104.63560191797167,104.49998761163154,104.36434021073933,104.22865978347316,104.0929463983449,
	103.95720012420499,103.82142103024749,103.68560918601548,103.54976466140641,103.41388752667764,
	103.27797785245232,103.1420357097253,103.00606116986908,102.87005430464053,102.73401518618694,
	102.59794388705312,102.46184048018819,102.32570503895273,102.1895376371263,102.05333834891506,
	101.91710724895961,101.78084441234319,101.6445499146002,101.50822383172486,101.37186624018025,
	101.23547721690763,101.09905683933604,100.96260518539248,100.82612233351189,100.68960836264824,
	100.55306335228522,100.41648738244787,100.27988053371439,100.14324288722835,100.00657452471144,
	99.8698755284766,99.73314598144152,99.59638596714287,99.45959556975077,99.32277487408412,
	99.18592396562593,99.04904293053984,98.9121318556868,98.77519082864258,98.63821993771579,
	98.50121927196656,98.36418892122606,98.2271289761165,98.09003952807215,97.95292066936088,
	97.81577249310655,97.67859509331241,97.54138856488518,97.40415300366003,97.26688850642668,
	97.12959517095611,96.99227309602885,96.85492238146364,96.71754312814768,96.58013543806788,
	96.44269941434314,96.30523516125808,96.16774278429783,96.03022239018429,95.89267408691373,
	95.75509798379576,95.6174941914938,95.47986282206718,95.34220398901464,95.2045178073198,
	95.06680439349803,94.9290638656453,94.79129634348888,94.65350194844001,94.51568080364834,
	94.37783303405894,94.23995876647093,94.10205812959882,93.96413125413595,93.82617827282037,
	93.68819932050349,93.55019453422103,93.41216405326702,93.27410801927033,93.1360265762744,
	92.99791987082001,92.85978805203112,92.72163127170404,92.58344968440015,92.44524344754213,
	92.30701272151387,92.16875766976423,92.0304784589149,91.89217525887227,91.75384824294383,
	91.6154975879588,91.47712347439361,91.33872608650213,91.20030561245102,91.0618622444601,
	90.92339617894842,90.78490761668564,90.64639676294955,90.50786382768945,90.36930902569587,
	90.2307325767769,90.0921347059412,89.95351564358822,89.81487562570538,89.67621489407331,
	89.53753369647862,89.39883228693489,89.26011092591231,89.12136988057588,88.98260942503296,
	88.84382984059012,88.70503141601985,88.56621444783755,88.42737924058902,88.28852610714891,
	88.14965536903041,88.01076735670705,87.87186240994639,87.73294087815651,87.59400312074567,
	87.45504950749546,87.31608041894815,87.17709624680862,87.03809739436134,86.89908427690317,
	86.76005732219232,86.62101697091411,86.48196367716413,86.34289790894955,86.20382014870886,
	86.06473089385106,85.92563065731497,85.78651996814874,85.64739937211124,85.50826943229521,
	85.36913072977349,85.22998386426849,85.09082945484654,84.951668140637,84.81250058157771,
	84.67332745918702,84.53414947736383,84.39496736321608,84.25578186791873,84.11659376760227,
	83.97740386427252,83.83821298676273,83.69902199171916,83.55983176462065,83.4206432208336,
	83.28145730670327,83.14227500068242,83.00309731449786,82.86392529435774,82.72476002219572,
	82.5856026169622,82.44645423595317,82.30731607618468,82.1681893758117,82.02907541559254,
	81.88997552039987,81.75089106077941,81.61182345455724,81.47277416849673,81.33374472000617,
	81.19473667889721,81.05575166919634,80.9167913710088,80.77785752243653,80.63895192155063,
	80.50007642841882,80.36123296718837,80.22242352822518,80.08365017030923,79.94491502288646,
	79.8062202883773,79.66756824454191,79.5289612469017,79.3904017312169,79.25189221601956,
	79.11343530520146,78.97503369065566,78.83669015497068,78.69840757417595,78.56018892053667,
	78.4220372653963,78.28395578206423,78.14594774874607,78.00801655151366,77.87016568731154,
	77.7323987669957,77.59471951840143,77.45713178943441,77.31963955118121,77.18224690103284,
	77.04495806581572,76.90777740492328,76.77070941344108,76.63375872525799,76.4969301161545,
	76.36022850685983,76.22365896606777,76.08722671340125,75.95093712231451,75.81479572292125,
	75.67880820473653,75.54298041931905,75.40731838280054,75.27182827828712,75.13651645811794,
	75.00138944596507,74.8664539387578,74.73171680841479,74.59718510336508,74.46286604984104,
	74.32876705292291,74.19489569731633,74.06125974784256,73.9278671496216,73.79472602792717,
	73.66184468769346,73.52923161265261,73.39689546408242,73.26484507914375,73.13308946878756,
	73.00163781521162,72.87049946884841,72.73968394486508,72.60920091915891,72.47906022383154,
	72.34927184212745,72.21984590282304,72.09079267405518,71.96212255657883,71.83384607644675,
	71.70597387710575,71.57851671090714,71.45148543003039,71.32489097682416,71.19874437356953,
	71.07305671167501,70.94783914031576,70.82310285453269,70.69885908281078,70.57511907416001,
	70.45189408472507,70.32919536395408,70.20703414036063,70.08542160691573,69.9643689061112,
	69.84388711473783,69.7239872284259,69.60468014599799,69.48597665368672,69.367887409272,
	69.25042292619558,69.13359355771084,69.01740948112811,68.9018806822163,68.78701693982198,
	68.67282781076729,68.55932261508735,68.44651042166733,68.3344000343374,68.22299997848253,
	68.11231848822135,68.00236349420614,67.89314261209226,67.78466313172261,67.6769320070681,
	67.56995584696175,67.46374090665924,67.35829308025401,67.25361789397067,67.14972050035517,
	67.04660567337548,66.94427780444111,66.84274089934533,66.74199857612852,66.64205406385653,
	66.54291020230305,66.4445694425208,66.3470338482817,66.25030509836223,66.15438448964706,
	66.05927294101951,65.96497099800564,65.87147883813465,65.7787962769772,65.68692277482039,
	65.59585744393672,65.50559905640307,65.41614605242502,65.32749654912071,65.23964834971878,
	65.1525989531243,65.06634556380781,64.98088510197208,64.89621421395337,64.81232928281362,
	64.72922643908267,64.64690157161007,64.56535033848816,64.4845681780099,64.40455031962614,
	64.32529179487054,64.24678744821989,64.16903194786252,64.09201979634717,64.01574534108822,
	63.94020278470458,63.865386195172505,63.79128951577292,63.71790657481794,63.64523109514147,
	63.57325670334194,63.501976938765736,63.43138526222276,63.361475064426564,63.29223967415308,
	63.223672366113604,63.15576636853873,63.088514870471855,63.021911028770916,62.955947974819374,
	62.89061882094756,62.82591666656662,62.76183460401835,62.69836572414467,62.63550312158113,
	62.573239899779786,62.51156917576676,62.450484084640664,62.38997778381826,62.330043457033966,
	62.27067431810046,62.21186361443712,62.15360463037423,62.09589069023986,62.03871516123735,
	61.982071456120885,61.925953035676635,61.87035341101718,61.81526614569671,61.7606848576545,
	61.70660322099382,61.65301496760375,61.59991388863098,61.54729383580836,61.49514872264725,
	61.443472525500304,61.39225928450086,61.34150310438563,61.291198155206516,61.2413386729375,
	61.19191895998239,61.142933385588954,61.09437638617464,61.04624246556902,60.99852619517807,
	60.951222214074726,60.90432522902061,60.857830014422795,60.81173141223037,60.766024331774176,
	60.720703749554076,60.675764708976914,60.63120232004904,60.587011759026325,60.543188268025105,
	60.49972715459688,60.456623791259275,60.413873615049525,60.371472126940326,60.32941489134292,
	60.28769753552843,60.24631574903995,60.20526528308559,60.16454194991407,60.124141622175024,
	60.08406023226543,60.04429377166413,60.004838290255535,59.96568989564434,59.92684475246243,
	59.888299081669174,59.85004915984634,59.81209131848893,59.77442194329253,59.73703747343874,
	59.699934400878945,59.663109269617806,59.626558674997,59.5902792629798,59.55426772943767,
	59.518520819438905,59.48303532654028,59.447808092082155,59.412836004487424,59.37811599856508,
	59.3436450548182,59.30942019875754,59.27543850022047,59.24169707269566,59.20819307265416,
	59.17492369888673,59.1418861918479,59.10907783300681,59.0764959442052,59.044137887022565,
	59.0120010621486,58.9800829087633,58.94838090392458,58.9168925619635,58.885615433887445,
	58.854547106791024,58.823685203274934,58.793027380872616,58.762571331485056,58.73231478082345,
	58.70225548785986,58.67239124428581,58.64271987397892,58.613239232477476,58.58394720646275,
	58.5548417132495,58.52592070028405,58.49718214465016,58.46862405258294,58.440244458990016,
	58.41204142698062,58.384013047402206,58.35615743838435,58.32847274489036,58.300957138275976,
	58.27360881585545,58.24642600047477,58.21940694009207,58.19254990736491,58.16585319924459,
	58.13931513657726,58.11293406371183,58.08670834811449,58.060636379989816,58.034716571908376,
	58.00894735844076,57.98332719579782,57.957854561477184,57.932527953915894,57.90734589214902,
	57.88230691547422,57.857409583122184,57.8326524739328,57.80803418603692,57.78355333654381,
	57.759208561234004,57.73499851425745,57.71092186783722,57.68697731197821,57.66316355418103,
	57.63947931916086,57.61592334857149,57.59249440073392,57.569191250369975,57.54601268834055,
	57.52295752137671,57.50002457187517,57.477212677576,57.4545206913698,57.43194748104516,
	57.40949192905328,57.3871529322771,57.364929401804055,57.34282026270329,57.320824453806445,
	57.29894092749261,57.27716864947669,57.25550659860192,57.23395376663572,57.21250915806924,
	57.19117178992047,57.169940691540745,57.14881490442463,57.12779348202326,57.10687548956077,
	57.08606000385404,57.06534611313557,57.04473291687949,57.02421952563052,57.00380506083593,
	56.98348865468045,56.963269449924084,56.943146599742605,56.92311926757103,56.903186626949484,
	56.88334786137207,56.86360216413812,56.84394873820609,56.82438679605,56.80491555951821,
	56.78553425969478,56.7662421367631,56.74703843987189,56.72792242700353,56.70889336484443,
	56.68995052865796,56.6710932021592,56.65232067739201,56.63363225460807,56.61502724214815,
	56.59650495632512,56.578064721309076,56.559705869014486,56.54142773898904,56.52322967830446,
	56.50511104144918,56.4870711902227,56.46910949363183,56.45122532778853,56.433418075809584,
	56.415687127717824,56.39803188034502,56.3804517372364,56.362946108556706,56.34551441099786,
	56.32815606768803,56.31087050810232,56.293657167974764,56.27651548921199,56.259444919807954,
	56.24244491376043,56.225514930988574,56.20865443725194,56.19186290407076,56.17513980864765,
	56.158484633790266,56.14189686783559,56.12537600457512,56.108921543181424,56.092532988135716,
	56.07620984915681,56.059951641131015,56.043757884043174,56.02762810290886,56.01156182770758,
	55.99555859331705,55.97961793944852,55.96373941058309,55.947922555909,55.932166929260035,
	55.916472089054636,55.90083759823624,55.8852630242143,55.86974793880641,55.85429191818129,
	55.83889454280244,55.82355539737295,55.808274070781046,55.79305015604639,55.77788325026729,
	55.76277295456869,55.747718874051,55.7327206177396,55.71777779853516,55.702890033164785,
	55.688056942133755,55.673278149678104,55.65855328371785,55.64388197581101,55.629263861108164,
	55.61469857830776,55.6001857696122,55.58572508068442,55.57131616060507,55.556958661830656,
	55.542652240151845,55.52839655465271,55.51419126767048,55.50003604475588,55.485930554633946,
	55.47187446916563,55.457867463309796,55.4439092150858,55.42999940552396,55.41613771868116,
	55.40232384152525,55.38855746395423,55.3748382787476,55.36116598153201,55.347540270747466,
	55.333960847614,55.320427416098866,55.30693968288418,55.29349735733494,55.28010015146768,
	55.26674777991932,55.25343995991671,55.24017641124638,55.2269568562249,55.21378101966949,
	55.200648628869196,55.18755941355633,55.17451310587838,55.16150944037034,55.14854815392731,
	55.135628985777615,55.12275167745615,55.10991597277826,55.09712161781377,55.08436836086159,
	55.07165595242447,55.05898414518427,55.04635269397743,55.033761355770835,55.02120988963802,
	55.0086980567357,54.996225620280505,54.98379234552623,54.971397999741136,54.95904235218586,
	54.946725174091334,54.934446238637165,54.92220532093024,54.91000219798366,54.89783664869588,
	54.8857084538302,54.87361739599452,54.8615632596213,54.8495458309478,54.83756489799667,
	54.825620250556646,54.81371168016366,54.801838980082,54.79000194528597,54.778200372441475,
	54.76643405988817,54.75470280762158,54.74300641727557,54.73134469210511,54.719717436969,
	54.708124458313165,54.69656556415386,54.68504056406134,54.67354926914345,54.66209149202977,
	54.65066704685563,54.639275749246615,54.62791741630293,54.616591866584336,54.60529892009507,
	54.594038398268886,54.58281012395447,54.57161392140088,54.560449616243275,54.54931703548878,
	54.53821600750247,54.52714636199368,54.51610793000226,54.505100543885206,54.494124037303365,
	54.48317824520832,54.47226300382939,54.46137815066081,54.45052352444921,54.43969896518096,
	54.42890431406988,54.41813941354515,54.40740410723911,54.39669823997543,54.386021657757375,
	54.375374207756174,54.36475573829951,54.35416609886021,54.34360514004508,54.33307271358371,
	54.32256867231765,54.312092870189616,54.30164516223271,54.291225404559945,54.28083345435376,
	54.27046916985572,54.260132410356405,54.249823036185255,54.23954090870065,54.229285890280046,
	54.2190578443104,54.2088566351783,54.198682128260735,54.18853418991555,54.17841268747226,
	54.16831748922278,54.15824846441249,54.14820548323113,54.13818841680413,54.12819713718364,
	54.118231517340035,54.10829143115331,54.0983767534046,54.088487359767846,54.078623126801475,
	54.06878393194033,54.05896965348747,54.04918017060624,54.039415363312386,54.029675112466165,
	54.01995929976472,54.010267807723196,54.00060051971313,53.99095731988405,53.98133809320495,
	53.97174272544419,53.96217110316242,53.9526231137054,53.943098645196955,53.93359758653192,
	53.924119827369296,53.9146652581254,53.90523376996706,53.895825254805,53.88643960528716,
	53.87707671479219,53.86773647742301,53.85841878800028,53.84912354205622,53.839850635828284,
	53.83059996625295,53.82137143095959,53.81216492826441,53.80298035716451,53.79381761733182,
	53.78467660910738,53.77555723349543,53.76645939215764,53.75738298740755,53.748327922204844,
	53.739294100149735,53.73028142547765,53.721289803053544,53.71231913836666,53.7033693375252,
	53.69444030725092,53.68553195487402,53.67664418832792,53.66777691614417,53.658930047447356,
	53.65010349195014,53.641297159948216,53.632510962315486,53.62374481049915,53.614998616514924,
	53.606272292942286,53.597565752919714,53.5888789101401,53.5802116788461,53.57156397382554,
	53.56293571040697,53.55432680445508,53.5457371723664,53.537166731064794,53.52861539799722,
	53.52008309112936,53.51156972894141,53.50307523042391,53.49459951507339,53.486142502888534,
	53.47770411436582,53.46928427049566,53.460882892758335,53.452499903119964,53.444135224028734,
	53.435788778410846,53.42746048966677,53.41915028166747,53.410858078750465,53.4025838057163,
	53.39432738782466,53.3860887507909,53.37786782078223,53.36966452441426,53.36147878874739,
	53.35331054128331,53.34515970996145,53.33702622315561,53.32891000967053,53.32081099873844,
	53.31272912001575,53.304664303579756,53.29661647992531,53.28858557994529,53.2805715349959,
	53.27257427678487,53.2645937374452,53.256629849511356,53.24868254591635,53.24075175998856,
	53.23283742544869,53.22493947640679,53.21705784735928,53.20919247318587,53.201343289146855,
	53.193510230879944,53.18569323439758,53.17789223608402,53.170107172692504,53.162337981342425,
	53.15458459951669,53.14684696505878,53.13912501617019,53.131418691407646,53.12372792968049,
	53.11605267024801,53.10839285271673,53.10074841703802,53.09311930350529,53.085505452751626,
	53.07790680574716,53.07032330379656,53.06275488853662,53.055201501933766,53.047663086276394,
	53.04013958419735,53.03263093862502,53.02513709282245,53.01765799050632,53.01019357515809,
	53.00274379139744,52.995308583605876,52.987887896602686,52.98048167552783,52.9730898658149,
	52.965712413202006,52.95834926372691,52.95100036372478,52.943665659826145,52.93634509895469,
	52.929038628325166,52.921746195441315,52.91446774809381,52.907203234358136,52.899952602592656,
	52.89271580143649,52.885492779807585,52.87828348690071,52.871087872185484,52.86390588540447,
	52.856737476571155,52.84958259596813,52.84244119414517,52.83531322191726,52.828198630362884,
	52.82109737082206,52.81400939489457,52.80693465443808,52.799873101566405,52.79282468864773,
	52.78578936830271,52.778767093402884,52.771757817068824,52.76476149266846,52.757778073815366,
	52.750807514387375,52.74384976844815,52.736904790354636,52.72997253468618,52.723052956259494,
	52.71614601012696,52.70925165157501,52.70236983612251,52.695500519519285,52.688643657744464,
	52.68179920700484,52.674967123733545,52.66814736458831,52.66133988645003,52.65454464642129,
	52.647761601824804,52.640990710201976,52.6342319293114,52.627485217127465,52.6207505318388,
	52.61402783184697,52.60731707576494,52.60061822241575,52.59393123083109,52.58725606024984,
	52.58059267011686,52.57394102008147,52.567301069996134,52.56067277991518,52.55405611009341,
	52.54745102098482,52.54085747324123,52.53427542771102,52.527704845437896,52.52114568765951,
	52.51459791580629,52.50806149150008,52.50153637655298,52.495022532966075,52.48851992292821,
	52.482028508814764,52.475548253186446,52.46907911878814,52.46262106854762,52.45617406557447,
	52.44973807315887,52.44331305477041,52.43689897405697,52.43049579484364,52.424103481131404,
	52.417721997096244,52.41135130708789,52.40499137562866,52.39864216741254,52.39230364730392,
	52.385975780336636,52.379658531712835,52.37335186680191,52.367055751139475,52.360770150426305,
	52.35449503052729,52.348230357470385,52.34197609744564,52.335732216804146,52.329498682057036,
	52.32327545987448,52.31706251708469,52.31085982067297,52.30466733778068,52.29848503570434,
	52.29231288189457,52.286150843955255,52.279998889642506,52.273856986863734,52.26772510367678,
	52.26160320828891,52.2554912690559,52.24938925448124,52.24329713321504,52.237214874053294,
	52.23114244593694,52.22507981795094,52.219026959323436,52.212983839424844,52.20695042776703,
	52.20092669400249,52.19491260792336,52.188908139460686,52.182913258683584,52.17692793579837,
	52.170952141147716,52.164985845209856,52.159029018597785,52.153081632058445,52.14714365647191,
	52.141215062850584,52.13529582233841,52.129385906210125,52.123485285870416,52.11759393284106,
	52.11171181880761,52.10583891554901,52.09997519498218,52.094120629150304,52.08827519022194,
	52.08243885049034,52.07661158237278,52.07079335840963,52.0649841512639,52.059183933720284,
	52.05339267868463,52.04761035918309,52.041836948361485,52.036072419484626,52.030316745935565,
	52.024569901214946,52.01883185894031,52.01310259284543,52.0073820767796,52.001670284707025,
	51.995967190706075,51.99027276896872,51.984586993799844,51.978909839616534,51.97324128094749,
	51.967581292432406,51.96192984882132,51.95628692497392,51.950652495858996,51.94502653655377,
	51.93940902224333,51.93379992821994,51.928199229882516,51.92260690273593,51.91702292239049,
	51.91144726456129,51.90587990506764,51.90032081983254,51.894769984881904,51.8892273763442,
	51.88369297044977,51.87816674353024,51.872648672017974,51.86713873244559,51.86163690144521,
	51.856143155748114,51.85065747218406,51.845179827680745,51.83971019926334,51.834248564053794,
	51.82879489927051,51.82334918222762,51.81791139033453,51.812481501095455,51.80705949210875,
	51.80164534106654,51.79623902575409,51.7908405240494,51.785449813922554,51.780066873435366,
	51.77469168074082,51.76932421408251,51.76396445179421,51.758612372299375,51.753267954110655,
	51.74793117582939,51.74260201614513,51.7372804538352,51.731966467764146,51.72666003688332,
	51.72136114023041,51.716069756928924,51.710785866187805,51.70550944730093,51.70024047964663,
	51.69497894268724,51.68972481596874,51.68447807912012,51.67923871185315,51.674006693961815,
	51.66878200532188,51.663564625890444,51.65835453570562,51.653151714885944,51.64795614363005,
	51.64276780221625,51.637586671002005,51.63241273042364,51.627245960995864,51.62208634331135,
	51.61693385804034,51.61178848593024,51.60665020780518,51.60151900456569,51.59639485718817,
	51.59127774672466,51.58616765430229,51.58106456112296,51.57596844846295,51.57087929767255,
	51.56579709017559,51.5607218074692,51.555653431123254,51.55059194278016,51.54553732415436,
	51.54048955703204,51.535448623270696,51.530414504798834,51.5253871836155,51.52036664179005,
	51.51535286146172,51.51034582483923,51.50534551420046,51.50035191189214,51.49536500032944,
	51.49038476199564,51.48541117944182,51.480444235286384,51.47548391221491,51.470530192979666,
	51.46558306039928,51.460642497358506,51.45570848680779,51.45078101176293,51.44586005530484,
	51.44094560057915,51.43603763079587,51.43113612922911,51.42624107921673,51.42135246416003,
	51.41647026752346,51.41159447283421,51.406725063682,51.40186202371872,51.39700533665812,
	51.39215498627552,51.387310956407454,51.38247323095146,51.37764179386569,51.372816629168604,
	51.36799772093875,51.36318505331442,51.358378610493304,51.3535783767323,51.34878433634718,
	51.34399647371224,51.33921477326008,51.33443921948131,51.329669796924264,51.324906490194664,
	51.32014928395543,51.315398162926314,51.310653111883674,51.30591411566021,51.301181159144605,
	51.29645422728136,51.29173330507044,51.28701837756705,51.28230942988137,51.277606447178236,
	51.272909414676946,51.26821831765093,51.26353314142756,51.25885387138778,51.254180492966015,
	51.24951299164972,51.24485135297931,51.24019556254773,51.23554560600036,51.23090146903463,
	51.226263137399904,51.22163059689709,51.21700383337854,51.212382832747636,51.20776758095874,
	51.203158064016826,51.19855426797718,51.19395617894534,51.18936378307675,51.184777066576515,
	51.180196015699195,51.17562061674857,51.17105085607738,51.16648672008716,51.16192819522793,
	51.15737526799802,51.15282792494382,51.148286152659544,51.14374993778705,51.139219267015584,
	51.13469412708155,51.130174504768306,51.12566038690595,51.12115176037106,51.11664861208659,
	51.11215092902148,51.10765869819058,51.10317190665442,51.09869054151893,51.09421458992032,
	51.08974403908391,51.08527887623652,51.08081908866377,51.07636466369567,51.07191558870646,
	51.06747185111433,51.063033438381275,51.0586003380129,51.05417253755818,51.049750024609295,
	51.0453327868014,51.040920811812484,51.03651408736308,51.03211260121618,51.02771634117695,
	51.02332529509261,51.01893945085219,51.01455879638638,51.010183319667306,51.00581300870836,
	51.001447851563995,50.997087836329605,50.992732951141235,50.98838318417548,50.98403852364928,
	50.979698957819735,50.975364474983884,50.97103506347861,50.96671071168041,50.96239140800519,
	50.95807714090815,50.95376789888357,50.94946367046465,50.94516444422334,50.94087020877013,
	50.936580952753935,50.93229666486188,50.92801733381915,50.92374294838884,50.919473497371705,
	50.91520896960611,50.91094935396781,50.90669463936968,50.90244481476181,50.89819986913103,
	50.89395979150099,50.88972457093192,50.885494196520376,50.88126865739923,50.87704794273742,
	50.87283204173982,50.86862094364704,50.864414637735386,50.860213113316554,50.85601635973755,
	50.85182436638055,50.84763712266276,50.84345461803618,50.83927684198752,50.83510378403805,
	50.83093543374343,50.82677178069353,50.822612814512354,50.81845852485788,50.81430890142184,
	50.810163933929616,50.806023612140145,50.8018879258457,50.79775686487179,50.793630419077054,
	50.78950857835295,50.78539133262383,50.78127867184669,50.77717058601103,50.77306706513872,
	50.768968099283875,50.76487367853275,50.76078379300349,50.75669843284615,50.75261758824243,
	50.748541249405605,50.74446940658035,50.74040205004271,50.73633917009979,50.7322807570898,
	50.72822680138177,50.724177293375604,50.720132223501736,50.71609158222116,50.71205536002527,
	50.708023547435644,50.703996135004054,50.69997311331221,50.69595447297175,50.691940204624004,
	50.68793029893996,50.68392474662012,50.6799235383943,50.675926665021635,50.67193411729035,
	50.66794588601768,50.66396196204978,50.659982336261535,50.656006999556496,50.65203594286677,
	50.648069157152825,50.64410663340346,50.640148362635635,50.6361943358944,50.63224454425272,
	50.62829897881138,50.62435763069892,50.62042049107146,50.61648755111258,50.612558802033305,
	50.608634235071854,50.60471384149366,50.60079761259112,50.596885539683626,50.59297761411738,
	50.58907382726525,50.58517417052675,50.58127863532786,50.577387213120964,50.57349989538472,
	50.56961667362397,50.565737539369565,50.56186248417839,50.55799149963311,50.554124577342215,
	50.55026170893977,50.54640288608545,50.542548100464316,50.538697343786765,50.53485060778846,
	50.53100788423017,50.527169164897735,50.52333444160187,50.51950370617816,50.51567695048692,
	50.51185416641307,50.50803534586611,50.5042204807799,50.500409563112754,50.4966025848471,
	50.49279953798961,50.489000414570945,50.48520520664575,50.48141390629255,50.47762650561354,
	50.47384299673469,50.470063371805495,50.46628762299893,50.46251574251139,50.45874772256252,
	50.45498355539521,50.45122323327545,50.44746674849227,50.44371409335758,50.439965260206186,
	50.43622024139562,50.43247902930608,50.42874161634035,50.4250079949237,50.42127815750378,
	50.41755209655056,50.41382980455622,50.41011127403511,50.406396497523595,50.40268546758001,
	50.39897817678461,50.39527461773938,50.39157478306807,50.38787866541601,50.38418625745009,
	50.380497551858674,50.37681254135148,50.37313121865952,50.36945357653504,50.36577960775137,
	50.36210930510292,50.35844266140508,50.35477966949404,50.351120322226926,50.34746461248152,
	50.34381253315618,50.340164077169966,50.336519237462326,50.33287800699318,50.32924037874271,
	50.32560634571143,50.32197590091997,50.3183490374091,50.314725748239596,50.31110602649214,
	50.30748986526737,50.30387725768568,50.300268196887124,50.2966626760315,50.29306068829814,
	50.28946222688584,50.285867285012856,50.282275855916815,50.278687932854545,50.27510350910214,
	50.27152257795483
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	181.53912491572595,181.4332084765696,181.32723172109516,181.22119470111903,181.11509746837007,
	181.00894007448971,180.90272257103223,180.79644500946475,180.69010744116758,180.5837099174343,
	180.47725248947216,180.37073520840187,180.2641581252581,180.15752129098945,180.05082475645898,
	179.94406857244397,179.83725278963638,179.730377458643,179.62344262998542,179.51644835410056,
	179.40939468134061,179.30228166197327,179.19510934618214,179.08787778406642,178.98058702564165,
	178.8732371208396,178.7658281195085,178.65836007141334,178.55083302623584,178.44324703357483,
	178.33560214294644,178.22789840378422,178.12013586543935,178.01231457718083,177.90443458819564,
	177.79649594758905,177.68849870438484,177.5804429075252,177.47232860587127,177.36415584820315,
	177.25592468322017,177.14763515954112,177.0392873257042,176.9308812301677,176.82241692130967,
	176.71389444742852,176.6053138567429,176.4966751973923,176.3879785174368,176.2792238648577,
	176.17041128755733,176.06154083335952,175.95261255000972,175.8436264851752,175.7345826864453,
	175.62548120133158,175.51632207726794,175.40710536161117,175.2978311016407,175.1884993445591,
	175.0791101374922,174.96966352748942,174.8601595615236,174.75059828649185,174.64097974921512,
	174.53130399643874,174.42157107483263,174.31178103099148,174.2019339114347,174.09202976260724,
	173.9820686308791,173.87205056254606,173.76197560382965,173.65184380087746,173.54165519976323,
	173.4314098464873,173.32110778697646,173.21074906708455,173.1003337325925,172.98986182920854,
	172.87933340256836,172.76874849823554,172.65810716170148,172.54740943838598,172.43665537363702,
	172.32584501273132,172.2149784008745,172.1040555832011,171.99307660477518,171.8820415105901,
	171.77095034556908,171.65980315456525,171.54859998236196,171.43734087367292,171.32602587314256,
	171.2146550253461,171.10322837478975,170.99174596591126,170.8802078430798,170.76861405059623,
	170.65696463269347,170.5452596335367,170.43349909722338,170.32168306778388,170.20981158918127,
	170.09788470531188,169.98590246000538,169.873864897025,169.7617720600677,169.64962399276473,
	169.53742073868145,169.42516234131784,169.31284884410852,169.20048029042326,169.08805672356687,
	168.9755781867797,168.8630447232379,168.75045637605336,168.63781318827424,168.5251152028851,
	168.4123624628071,168.29955501089825,168.1866928899538,168.07377614270627,167.9608048118257,
	167.8477789399201,167.73469856953537,167.62156374315603,167.50837450320478,167.39513089204334,
	167.28183295197246,167.16848072523206,167.05507425400174,166.94161358040068,166.82809874648828,
	166.714529794264,166.6009067656679,166.48722970258078,166.37349864682443,166.25971364016192,
	166.14587472429767,166.031981940878,165.91803533149113,165.80403493766758,165.68998080088022,
	165.57587296254474,165.46171146401983,165.3474963466075,165.233227651553,165.1189054200455,
	165.0045296932182,164.89010051214834,164.77561791785791,164.6610819513135,164.5464926534267,
	164.43185006505448,164.31715422699924,164.20240518000924,164.0876029647786,163.97274762194797,
	163.85783919210434,163.74287771578173,163.62786323346097,163.5127957855705,163.39767541248614,
	163.2825021545317,163.16727605197892,163.0519971450482,162.93666547390836,162.82128107867723,
	162.70584399942177,162.59035427615834,162.47481194885313,162.35921705742211,162.24356964173174,
	162.12786974159877,162.01211739679073,161.89631264702624,161.78045553197538,161.66454609125958,
	161.54858436445215,161.43257039107857,161.3165042106169,161.20038586249754,161.08421538610398,
	160.967992820773,160.85171820579464,160.735391580413,160.61901298382605,160.50258245518597,
	160.38610003359986,160.26956575812935,160.15297966779136,160.03634180155828,159.91965219835816,
	159.80291089707504,159.68611793654918,159.5692733555775,159.45237719291376,159.33542948726867,
	159.21843027731046,159.1013796016651,158.98427749891638,158.86712400760652,158.74991916623617,
	158.63266301326485,158.51535558711117,158.39799692615318,158.28058706872864,158.16312605313527,
	158.04561391763107,157.92805070043468,157.8104364397255,157.69277117364425,157.57505494029283,
	157.45728777773516,157.3394697239971,157.22160081706681,157.10368109489517,156.98571059539597,
	156.86768935644614,156.74961741588632,156.63149481152084,156.5133215811182,156.3950977624114,
	156.27682339309814,156.15849851084107,156.0401231532684,155.92169735797378,155.80322116251702,
	155.68469460442395,155.56611772118723,155.4474905502662,155.32881312908756,155.2100854950454,
	155.09130768550168,154.9724797377864,154.85360168919811,154.73467357700406,154.6156954384405,
	154.49666731071326,154.37758923099761,154.25846123643908,154.13928336415333,154.02005565122678,
	153.9007781347168,153.7814508516521,153.66207383903284,153.54264713383134,153.423170772992,
	153.30364479343197,153.18406923204108,153.06444412568263,152.9447695111933,152.82504542538385,
	152.70527190503907,152.5854489869184,152.4655767077561,152.3456551042617,152.22568421312033,
	152.10566407099287,151.98559471451642,151.86547618030477,151.74530850494847,151.62509172501527,
	151.50482587705056,151.38451099757768,151.26414712309807,151.14373429009188,151.0232725350181,
	150.902761894315,150.78220240440052,150.6615941016726,150.54093702250933,150.4202312032696,
	150.29947668029325,150.17867348990148,150.05782166839717,149.9369212520653,149.81597227717333,
	149.69497477997132,149.57392879669257,149.45283436355385,149.33169151675574,149.21050029248303,
	149.08926072690508,148.96797285617612,148.8466367164357,148.72525234380902,148.60381977440727,
	148.48233904432806,148.3608101896556,148.23923324646142,148.1176082508043,147.99593523873105,
	147.87421424627664,147.75244530946458,147.6306284643074,147.508763746807,147.38685119295496,
	147.26489083873295,147.14288272011308,147.02082687305838,146.89872333352312,146.77657213745314,
	146.65437332078633,146.5321269194529,146.40983296937594,146.28749150647155,146.16510256664952,
	146.04266618581354,145.9201823998616,145.79765124468645,145.67507275617592,145.55244697021342,
	145.42977392267815,145.30705364944586,145.1842861863887,145.06147156937612,144.9386098342751,
	144.8157010169504,144.6927451532653,144.5697422790815,144.4466924302602,144.32359564266187,
	144.200451952147,144.0772613945766,143.95402400581224,143.83073982171678,143.70740887815472,
	143.58403121099252,143.46060685609916,143.33713584934645,143.21361822660944,143.09005402376704,
	142.96644327670208,142.84278602130212,142.7190822934597,142.59533212907274,142.47153556404498,
	142.3476926342865,142.22380337571417,142.09986782425182,141.975886015831,141.85185798639134,
	141.72778377188072,141.60366340825632,141.47949693148425,141.35528437754064,141.23102578241193,
	141.10672118209513,140.98237061259834,140.8579741099414,140.73353171015623,140.60904344928707,
	140.48450936339123,140.35992948853945,140.23530386081637,140.11063251632086,139.98591549116674,
	139.86115282148296,139.73634454341428,139.61149069312168,139.48659130678274,139.36164642059222,
	139.23665607076256,139.11162029352423,138.98653912512623,138.86141260183663,138.73624075994317,
	138.61102363575338,138.48576126559541,138.36045368581844,138.235100932793,138.10970304291166,
	137.98426005258938,137.85877199826405,137.73323891639717,137.60766084347395,137.48203781600418,
	137.35636987052246,137.23065704358905,137.1048993717899,136.9790968917376,136.85324964007157,
	136.7273576534587,136.60142096859403,136.47543962220084,136.34941365103165,136.22334309186837,
	136.09722798152305,135.97106835683823,135.84486425468756,135.7186157119764,135.5923227656422,
	135.46598545265502,135.33960381001827,135.21317787476903,135.0867076839787,134.96019327475344,
	134.8336346842349,134.70703194960055,134.58038510806432,134.4536941968771,134.3269592533275,
	134.20018031474206,134.07335741848598,133.9464906019639,133.8195799026199,133.69262535793865,
	133.56562700544563,133.43858488270774,133.31149902733398,133.18436947697592,133.05719626932827,
	132.9299794421296,132.8027190331626,132.67541508025505,132.54806762128015,132.4206766941571,
	132.2932423368519,132.16576458737765,132.03824348379538,131.9106790642144,131.78307136679334,
	131.65542042974,131.52772629131292,131.39998898982097,131.27220856362487,131.1443850511371,
	131.0165184908229,130.88860892120076,130.76065638084305,130.63266090837664,130.5046225424835,
	130.37654132190136,130.24841728542435,130.12025047190357,129.99204092024777,129.86378866942388,
	129.73549375845792,129.60715622643525,129.47877611250158,129.35035345586334,129.22188829578852,
	129.0933806716072,128.9648306227123,128.83623818856012,128.70760340867116,128.57892632263056,
	128.450206970089,128.32144539076327,128.1926416244369,128.06379571096085,127.93490769025429,
	127.80597760230512,127.6770054871708,127.54799138497896,127.41893533592813,127.28983738028839,
	127.16069755840205,127.03151591068448,126.90229247762466,126.77302729978602,126.64372041780697,
	126.51437187240187,126.38498170436151,126.25554995455396,126.1260766639253,125.99656187350027,
	125.86700562438305,125.73740795775801,125.6077689148904,125.4780885371272,125.34836686589775,
	125.21860394271448,125.08879980917385,124.95895450695691,124.8290680778302,124.69914056364642,
	124.56917200634525,124.4391624479541,124.309111930589,124.1790204964552,124.04888818784806,
	123.91871504715391,123.7885011168507,123.65824643950893,123.52795105779235,123.39761501445886,
	123.26723835236133,123.13682111444834,123.00636334376506,122.8758650834541,122.7453263767563,
	122.6147472670116,122.4841277976599,122.35346801224189,122.22276795439991,122.09202766787885,
	121.96124719652695,121.83042658429677,121.69956587524594,121.56866511353826,121.43772434344439,
	121.30674360934282,121.17572295572077,121.04466242717525,120.91356206841371,120.78242192425517,
	120.65124203963111,120.52002245958644,120.38876322928033,120.25746439398732,120.12612599909822,
	119.99474809012105,119.86333071268209,119.73187391252686,119.60037773552109,119.46884222765169,
	119.33726743502795,119.20565340388232,119.07400018057164,118.94230781157806,118.81057634351022,
	118.67880582310426,118.54699629722481,118.41514781286622,118.28326041715366,118.15133415734412,
	118.01936908082759,117.88736523512823,117.75532266790552,117.62324142695536,117.4911215602113,
	117.35896311574575,117.22676614177114,117.0945306866412,116.96225679885207,116.82994452704372,
	116.69759392000111,116.56520502665546,116.43277789608571,116.30031257751962,116.16780912033528,
	116.03526757406233,115.90268798838355,115.77007041313594,115.63741489831246,115.50472149406326,
	115.3719902506973,115.23922121868362,115.10641444865308,114.97356999139976,114.84068789788257,
	114.7077682192268,114.57481100672578,114.44181631184252,114.30878418621128,114.17571468163948,
	114.0426078501092,113.90946374377914,113.77628241498627,113.64306391624775,113.50980830026283,
	113.37651561991464,113.24318592827225,113.10981927859262,112.9764157243226,112.84297531910104,
	112.70949811676091,112.57598417133143,112.44243353704026,112.30884626831583,112.17522241978968,
	112.04156204629867,111.90786520288754,111.77413194481129,111.64036232753789,111.50655640675065,
	111.37271423835104,111.23883587846139,111.10492138342762,110.97097080982222,110.83698421444711,
	110.70296165433673,110.56890318676108,110.43480886922893,110.30067875949105,110.16651291554368,
	110.0323113956319,109.89807425825316,109.76380156216102,109.62949336636879,109.49514973015344,
	109.36077071305972,109.22635637490393,109.09190677577841,108.95742197605573,108.82290203639327,
	108.68834701773768,108.55375698132974,108.41913198870915,108.28447210171966,108.1497773825142,
	108.01504789356026,107.88028369764538,107.74548485788297,107.61065143771803,107.4757835009333,
	107.3408811116556,107.20594433436227,107.07097323388773,106.93596787543062,106.80092832456069,
	106.66585464722647,106.53074690976267,106.3956051788981,106.2604295217639,106.12522000590191,
	105.98997669927353,105.85469967026847,105.71938898771438,105.58404472088627,105.44866693951668,
	105.31325571380589,105.17781111443277,105.0423332125657,104.90682207987425,104.77127778854086,
	104.6357004112733,104.50009002131736,104.36444669247012,104.22877049909357,104.0930615161288,
	103.95731981911072,103.82154548418333,103.68573858811544,103.54989920831706,103.41402742285636,
	103.2781233104773,103.1421869506178,103.00621842342863,102.87021780979319,102.73418519134758,
	102.5981206505019,102.46202427046214,102.3258961352526,102.18973632973982,102.05354493965666,
	101.91732205162786,101.78106775319627,101.64478213285004,101.50846528005107,101.37211728526434,
	101.23573823998832,101.0993282367867,100.96288736932127,100.82641573238583,100.68991342194182,
	100.55338053515486,100.41681717043295,100.28022342746607,100.14359940726729,100.00694521221531,
	99.87026094609898,99.73354671416311,99.5968026231563,99.46002878138047,99.32322529874249,
	99.18639228680753,99.04952985885458,98.91263812993422,98.77571721692826,98.63876723861235,
	98.50178831572005,98.36478057101026,98.22774412933671,98.09067911772046,97.9535856654248,
	97.81646390403341,97.67931396753144,97.54213599238969,97.4049301176519,97.26769648502572,
	97.13043523897687,96.99314652682733,96.8558304988568,96.71848730840863,96.58111711199946,
	96.44372006943327,96.3062963439199,96.16884610219763,96.03136951466158,95.89386675549594,
	95.75633800281193,95.61878343879101,95.48120324983338,95.34359762671257,95.20596676473579,
	95.06831086391037,94.9306301291169,94.79292477028883,94.65519500259909,94.5174410466538,
	94.37966312869364,94.24186148080263,94.10403634112537,93.96618795409222,93.82831657065347,
	93.69042244852221,93.55250585242665,93.41456705437217,93.27660633391325,93.13862397843586,
	93.00062028345081,92.86259555289784,92.72455009946182,92.58648424490063,92.4483983203857,
	92.3102926668554,92.17216763538173,92.0340235875511,91.8958608958594,91.75767994412188,
	91.61948112789867,91.48126485493611,91.34303154562477,91.20478163347462,91.06651556560792,
	90.92823380327043,90.78993682236182,90.65162511398572,90.51329918501995,90.37495955870818,
	90.23660677527302,90.09824139255187,89.95986398665613,89.82147515265413,89.68307550527929,
	89.54466567966386,89.40624633209912,89.26781814082298,89.12938180683591,88.990938054746,
	88.85248763364409,88.71403131800989,88.57556990865,88.43710423366892,88.2986351494741,
	88.16016354181546,88.02169032686135,87.88321645231098,87.74474289854507,87.60627067981548,
	87.46780084547464,87.32933448124645,87.19087271053908,87.05241669580091,86.91396763992101,
	86.77552678767454,86.63709542721493,86.4986748916129,86.36026656044412,86.22187186142625,
	86.08349227210601,85.94512932159758,85.80678459237306,85.66845972210572,85.53015640556704,
	85.39187639657794,85.25362151001526,85.11539362387357,84.97719468138324,84.83902669318485,
	84.7008917395603,84.56279197272093,84.42472961915236,84.28670698201623,84.14872644360834,
	84.01079046787297,83.87290160297245,83.73506248391142,83.59727583521452,83.45954447365749,
	83.32187131104311,83.18425935703722,83.04671172204036,82.90923162010918,82.77182237191808,
	82.63448740775908,82.49723027057671,82.36005461903326,82.22296423060101,82.08596300467565,
	81.94905496570617,81.81224426633513,81.67553519054333,81.53893215679152,81.40243972115182,
	81.26606258042122,81.12980557520767,80.9936736929803,80.85767207107305,80.72180599963158,
	80.58608092449182,80.45050244997812,80.31507634160839,80.17980852869273,80.04470510681114,
	79.90977234015571,79.77501666372153,79.64044468532988,79.50606318746723,79.37187912892179,
	79.23789964619989,79.1041320547034,78.97058384964865,78.8372627067073,78.70417648234914,
	78.57133321386625,78.43874111905801,78.3064085955561,78.17434421976908,78.04255674542553,
	77.9110551016957,77.77984839087155,77.64894588558582,77.5183570255515,77.3880914138036,
	77.25815881242687,77.12856913775343,76.9993324550167,76.8704589724488,76.74195903481116,
	76.61384311634924,76.48612181316557,76.3588058350068,76.23190599646374,76.10543320758528,
	75.97939846391172,75.85381283593415,75.72868745799123,75.60403351661753,75.47986223836143,
	75.35618487709338,75.23301270083023,75.1103569781036,74.98822896390482,74.86663988524192,
	74.74560092634843,74.62512321358595,74.50521780008646,74.3858956501836,74.26716762368346,
	74.14904446002984,74.03153676241931,73.91465498192471,73.79840940168577,73.68281012122812,
	73.56786704097102,73.45358984698571,73.3399879960651,73.22707070116533,73.1148469172783,
	73.0033253277926,72.89251433139883,72.78242202959183,72.67305621481995,72.56442435932844,
	72.45653360473999,72.34939075241128,72.24300225460077,72.13737420647806,72.03251233900033,
	71.9284220126767,71.82510821223669,71.72257554221288,71.62082822344483,71.51987009050352,
	71.41970459003383,71.32033478000518,71.22176332985742,71.12399252152433,71.02702425131248,
	70.93086003261021,70.83550099939707,70.74094791052151,70.64720115471148,70.55426075627969,
	70.462126381484,70.37079734550072,70.28027261996748,70.19055084105155,70.10163031799793,
	70.01350904211229,69.92618469613241,69.83965466394305,69.75391604058925,69.66896564254348,
	69.58480001818384,69.50141545844093,69.41880800757285,69.33697347402912,69.2559074413664,
	69.17560527918003,69.09606215401806,69.01727304024585,68.93923273083207,68.8619358480277,
	68.78537685391377,68.70955006079325,68.63444964140679,68.56006963895278,68.48640397689393,
	68.41344646853635,68.34119082636651,68.26963067113522,68.19875954067858,68.12857089846806,
	68.05905814188242,67.99021461019723,67.92203359228752,67.85450833404185,67.78763204548584,
	67.72139790761572,67.65579907894251,67.59082870174865,67.52647990806018,67.46274582533724,
	67.399619581888,67.33709431200997,67.27516316086447,67.21381928909011,67.15305587716105,
	67.09286612949693,67.03324327833151,66.97418058734628,66.91567135507746,66.85770891810235,
	66.80028665401402,66.74339798419064,66.68703637636781,66.63119534702108,66.57586846356601,
	66.52104934638395,66.46673167068002,66.41290916818117,66.35957562868118,66.30672490143972,
	66.25435089644236,66.20244758552809,66.15100900339094,66.10002924846209,66.04950248367865,
	65.99942293714493,65.94978490269202,65.90058274034162,65.8518108766789,65.80346380513994,
	65.75553608621897,65.7080223475888,65.66091728420585,65.61421565823461,65.56791229902686,
	65.52200210298209,65.47648003336627,65.4313411200795,65.38658045937646,65.34219321354345,
	65.29817461053396,65.25451994356756,65.21122457069326,65.16828391432144,65.12569346072625,
	65.08344875952108,65.04154542310957,64.99997912611433,64.9587456047853,64.91784065639015,
	64.877260138588,64.83699996878875,64.79705612349929,64.75742463765869,64.71810160396299,
	64.679083172182,64.64036554846831,64.60194499466088,64.56381782758343,64.52598041833902,
	64.48842919160198,64.45116062490803,64.41417124794319,64.3774576418328,64.34101643843077,
	64.30484431961048,64.26893801655743,64.23329430906435,64.19791002482953,64.16278203875882,
	64.12790727227151,64.09328269261093,64.05890531215974,64.02477218776089,63.99088042004371,
	63.9572271527564,63.92380957210435,63.89062490609512,63.85767042389007,63.8249434351628,
	63.79244128946474,63.760161375597804,63.72810112099456,63.69625799110586,63.664629488795875,
	63.633213153744904,63.60200656186005,63.571007324693426,63.540213088868384,63.50962153551358,
	63.47923037970485,63.449037369915196,63.419040287472335,63.38923694602454,63.35962519101411,
	63.33020289915875,63.30096797794084,63.2719183651045,63.243052028160285,63.214366963897746,
	63.18586119790557,63.157532784099274,63.12937980425653,63.10140036755984,63.0735926101467,
	63.04595469466701,63.018484809847855,62.991181170065246,62.96404201492327,62.93706560883985,
	62.91025024063974,62.88359422315426,62.857095892827715,62.83075360933068,62.80456575517945,
	62.77853073536253,62.752646976973054,62.72691292884775,62.701327061212034,62.67588786533125,
	62.650593853167926,62.625443557044974,62.600435529314844,62.57556834203415,62.55084058664433,
	62.52625087365759,62.50179783234854,62.477480110451076,62.45329637386068,62.42924530634186,
	62.405325609240826,62.38153600120318,62.35787521789643,62.33434201173768,62.310935151625884,
	62.28765342267877,62.264495625974725,62.24146057829889,62.218547111893834,62.19575407421472,
	62.17308032767733,62.15052474946831,62.128086231241376,62.10576367893819,62.08355601255168,
	62.06146216590602,62.039481086440325,62.01761173499619,61.995853085609,61.974204125302954,
	61.95266385388952,61.93123128376965,61.90990543973922,61.88868535879816,61.867570089962626,
	61.84655869408075,61.825650243651324,61.80484382264588,61.78413852633377,61.7635334611103,
	61.743027744327854,61.722620504129964,61.702310879288255,61.682098019042215,61.661981082941764,
	61.64195924069251,61.622031672003686,61.602197566438704,61.58245612326833,61.56280655132634,
	61.543248068867605,61.523779903428746,61.50440129169106,61.48511147934582,61.465909720961875,
	61.44679527985556,61.42776742796266,61.4088254457128,61.38996862190571,61.37119625358974,
	61.35250764594239,61.33390211215287,61.31537897330655,61.29693755827149,61.278577203586764,
	61.26029725335274,61.242097059123154,61.223975979798894,61.20593338152376,61.187968637581726,
	61.1700811282962,61.152270240930534,61.13453536959061,61.116875915128794,61.09929128504949,
	61.0817808934163,61.0643441607607,61.04698051399217,61.02968938630987,61.01247021711566,
	60.99532245192859,60.978245542300805,60.96123894573485,60.944302125601965,60.92743455106238,
	60.910635696986205,60.893905043875975,60.87724207779035,60.86064629026905,60.84411717825899,
	60.82765424404143,60.811256995160655,60.79492494435337,60.77865760947958,60.762454513454244,
	60.74631518418023,60.730239154482256,60.71422596204184,60.698275149333284,60.682386263560765,
	60.66655885659616,60.650792484918185,60.6350867095521,60.619441096010675,60.6038552142359,
	60.588328638541604,60.57286094755702,60.55745172417118,60.542100555478164,60.52680703272321,
	60.51157075124958,60.496391310446334,60.481268313696816,60.466201368328065,60.45119008556069,
	60.436234080459926,60.421332971886955,60.406486382451455,60.391693938464414,60.37695526989199,
	60.36227001030981,60.34763779685813,60.33305827019758,60.3185310744656,60.30405585723344,
	60.289632269463915,60.27525996546968,60.260938602872265,60.246667842561486,60.23244734865563,
	60.21827678846226,60.20415583243934,60.19008415415717,60.17606143026083,60.16208734043308,
	60.14816156735789,60.13428379668434,60.12045371699137,60.10667101975257,60.09293539930196,
	60.07924655279981,60.065604180199365,60.05200798421369,60.038457670283194,60.02495294654365,
	60.01149352379435,59.99807911546717,59.984709437595754,59.971384208785146,59.95810315018202,
	59.94486598544517,59.9316724407165,59.91852224459227,59.90541512809505,59.89235082464574,
	59.87932907003607,59.86634960240164,59.85341216219513,59.84051649215993,59.82766233730423,
	59.814849444875414,59.80207756433457,59.78934644733186,59.77665584768173,59.764005521338696,
	59.75139522637342,59.738824722949076,59.726293773298146,59.71380214169933,59.701349594454925,
	59.6889358998685,59.67656082822276,59.66422415175782,59.65192564464972,59.639665082989254,
	59.62744224476094,59.61525690982253,59.60310885988455,59.59099787849022,59.57892375099568,
	59.56688626455027,59.554885208077415,59.54292037225534,59.53099154949841,59.51909853393853,
	59.50724112140674,59.49541910941518,59.48363229713921,59.471880485386635,59.46016347663371,
	59.44848107492657,59.436833085919446,59.42521931684378,59.41363957649185,59.40209367520034,
	59.39058142483428,59.37910263877108,59.36765713188489,59.35624472053105,59.34486522253078,
	59.33351845715602,59.3222042451146,59.31092240853532,59.29967277095361,59.288455157296944,
	59.27726939387073,59.26611530834425,59.254992729736884,59.243901488404326,59.232841416025146,
	59.22181234558738,59.21081411137536,59.19984654895675,59.18890949516958,59.17800278810967,
	59.16712626711796,59.1562797727681,59.14546314685437,59.13467623237938,59.12391887354219,
	59.11319091572657,59.1024922054892,59.09182259054825,59.0811819197719,59.07057004316714,
	59.059986811868704,59.049432078127886,59.03890569530191,59.02840751784306,59.01793740128811,
	59.00749520224785,58.99708077839675,58.98669398846267,58.97633469221683,58.96600275046375,
	58.95569802503135,58.945420378761305,58.93516967549925,58.92494578008535,58.914748558344826,
	58.90457787707863,58.894433604054264,58.88431560799665,58.87422375857911,58.86415792641461,
	58.854117983046734,58.84410380094114,58.83411525347699,58.82415221493834,58.81421456050581,
	58.80430216624827,58.794414909114636,58.7845526669257,58.7747153183662,58.764902742976744,
	58.75511482114611,58.745351434103384,58.73561246391033,58.725897793453775,58.71620730643807,
	58.706540887377884,58.69689842159051,58.68727979518889,58.677684895074364,58.66811360892954,
	58.65856582521123,58.64904143314365,58.63954032271145,58.63006238465293,58.62060751045332,
	58.611175592338206,58.60176652326686,58.59238019692581,58.58301650772238,58.573675350778295,
	58.56435662192351,58.555060217689835,58.545786035304886,58.536533972685945,58.52730392843396,
	58.51809580182752,58.50890949281708,58.49974490201898,58.49060193070982,58.48148048082063,
	58.472380454931226,58.46330175626473,58.45424428868192,58.44520795667578,58.43619266536615,
	58.42719832049432,58.41822482841763,58.409272096104445,58.40034003112873,58.39142854166508,
	58.38253753648351,58.37366692494453,58.364816616994055,58.35598652315861,58.34717655454028,
	58.33838662281205,58.32961664021295,58.320866519543216,58.31213617415985,58.30342551797181,
	58.29473446543544,58.28606293154999,58.277410831853054,58.268778082416205,58.26016459984051,
	58.25157030125223,58.24299510429845,58.23443892714287,58.22590168846155,58.21738330743867,
	58.20888370376251,58.20040279762124,58.19194050969887,58.18349676117126,58.175071473702204,
	58.166664569439334,58.15827597101032,58.149905601519,58.14155338454152,58.133219244122586,
	58.12490310477172,58.11660489145944,58.108324529613746,58.10006194511636,58.091817064299136,
	58.08358981394055,58.0753801212621,58.06718791392483,58.059013120025874,58.050855668094975,
	58.042715487091165,58.034592506399306,58.02648665582683,58.01839786560038,58.010326066362566,
	58.002271189168724,57.994233165483735,57.98621192717874,57.978207406528156,57.97021953620638,
	57.96224824928483,57.95429347922889,57.94635515989472,57.93843322552649,57.93052761075314,
	57.92263825058576,57.914765080414284,57.90690803600498,57.899067053497305,57.8912420694012,
	57.883433020594296,57.87563984431904,57.86786247817996,57.860100860141024,57.852354928522836,
	57.84462462199998,57.83690987959835,57.82921064069259,57.82152684500335,57.81385843259485,
	57.8062053438722,57.79856751957896,57.79094490079451,57.783337428931716,57.7757450457343,
	57.768167693274464,57.76060531395055,57.75305785048445,57.74552524591941,57.738007443617555,
	57.730504387257625,57.72301602083259,57.715542288647384,57.70808313531668,57.70063850576254,
	57.69320834521228,57.685792599196176,57.67839121354531,57.671004134389406,57.6636313081546,
	57.65627268156142,57.648928201622574,57.641597815640885,57.63428147120725,57.62697911619847,
	57.619690698775344,57.612416167380516,57.60515547073657,57.59790855784398,57.59067537797913,
	57.58345588069241,57.57625001580626,57.569057733413196,57.561878983873974,57.554713717815666,
	57.54756188612978,57.540423439970446,57.53329833075254,57.526186510149856,57.51908793009333,
	57.5120025427692,57.50493030061732,57.49787115632925,57.490825062846646,57.48379197335948,
	57.47677184130426,57.4697646203625,57.4627702644588,57.45578872775932,57.44881996467016,
	57.44186392983557,57.43492057813639,57.4279898646885,57.42107174484108,57.41416617417513,
	57.40727310850184,57.40039250386101,57.3935243165196,57.38666850297005,57.379825019928845,
	57.372993824335,57.36617487334849,57.35936812434885,57.35257353493368,57.34579106291712,
	57.339020666328466,57.332262303410694,57.32551593261908,57.31878151261972,57.312059002288166,
	57.30534836070804,57.29864954716957,57.29196252116843,57.285287242404095,57.2786236707787,
	57.271971766395694,57.265331489558356,57.25870280076867,57.25208566072591,57.24548003032537,
	57.2388858706571,57.232303143004636,57.22573180884369,57.21917182984093,57.21262316785276,
	57.20608578492401,57.19955964328686,57.193044705359476,57.18654093374485,57.180048291229674,
	57.17356674078307,57.167096245542666,57.16063676886511,57.154188274246614,57.14775072537451,
	57.14132408611281,57.13490832050113,57.12850339275348,57.12210926725724,57.11572590857191,
	57.10935328142829,57.102991350727066,57.09664008153796,57.090299439098615,57.083969388813486,
	57.07764989625282,57.071340927151596,57.06504244740856,57.05875442308506,57.05247682040417,
	57.04620960574959,57.0399527456647,57.03370620685145,57.02746995616957,57.02124396063539,
	57.01502818742101,57.00882260385319,57.002627177412556,56.996441875732565,56.990266666598515,
	56.984101517946726,56.97794639786348,56.9718012745842,56.96566611649251,56.95954089211928,
	56.9534255701418,56.94732011938277,56.94122450880961,56.93513870753332,56.929062684807825,
	56.922996410029,56.91693985273387,56.91089298259962,56.90485576944293,56.89882818321902,
	56.89281019402083,56.886801772078215,56.880802887757056,56.874813511558585,56.8688336141184,
	56.86286316620577,56.85690213872281,56.85095050270366,56.84500822931375,56.839075289848985,
	56.83315165573492,56.8272372985261,56.82133218990525,56.815436301682446,56.80954960579446,
	56.80367207430391,56.797803679398676,56.79194439339096,56.78609418871677,56.780253037934955,
	56.77442091372667,56.76859778889466,56.76278363636238,56.75697842917346,56.75118214049092,
	56.74539474359653,56.73961621189005,56.73384651888859,56.72808563822593,56.722333543651786,
	56.71659020903128,56.710855608344104,56.705129715683924,56.699412505257804,56.69370395138546,
	56.68800402849856,56.68231271114028,56.67662997396444,56.670955791735025,56.665290139325506,
	56.659632991718205,56.653984324003645,56.648344111380034,56.642712329152545,56.637088952732796,
	56.63147395763813,56.6258673194912,56.62026901401916,56.61467901705325,56.609097304528106,
	56.6035238524812,56.59795863705233,56.592401634482904,56.58685282111553,56.58131217339335,
	56.575779667859464,56.57025528115645,56.56473899002573,56.55923077130711,56.553730601938135,
	56.54823845895361,56.542754319485034,56.53727816076005,56.531809960102,56.526349694929216,
	56.52089734275473,56.51545288118555,56.51001628792224,56.504587540758436,56.49916661758022,
	56.49375349636571,56.488348155184546,56.48295057219734,56.477560725655195,56.4721785938993,
	56.46680415536027,56.46143738855782,56.4560782721002,56.45072678468371,56.445382905092245,
	56.44004661219684,56.43471788495516,56.429396702411076,56.42408304369409,56.418776888019075,
	56.41347821468559,56.408187003077614,56.402903232662965,56.3976268829929,56.3923579337017,
	56.38709636450614,56.381842155205156,56.3765952856793,56.37135573589037,56.366123485881005,
	56.360898515774174,56.355680805772806,56.350470336159354,56.345267087295355,56.34007103962104,
	56.33488217365495,56.329700469993405,56.3245259093102,56.31935847235621,56.31419813995889,
	56.30904489302195,56.303898712524926,56.2987595795228,56.29362747514562,56.288502380598004,
	56.283384277158895,56.278273146181135,56.27316896909099,56.26807172738786,56.26298140264388,
	56.257897976503564,56.252821430683355,56.24775174697134,56.24268890722682,56.237632893379974,
	56.232583687431514,56.227541271452246,56.2225056275828,56.217476738033206,56.212454585082575,
	56.20743915107873,56.20243041843786,56.19742836964417,56.19243298724954,56.18744425387316,
	56.182462152201204,56.177486664986525,56.17251777504822,56.167555465271384,56.16259971860677,
	56.15765051807039,56.152707846743276,56.14777168777104,56.14284202436368,56.13791883979515,
	56.1330021174031,56.12809184058851,56.12318799281544,56.11829055761062,56.11339951856323,
	56.10851485932452,56.10363656360754,56.09876461518683,56.09389899789806,56.08903969563784,
	56.08418669236328,56.07933997209179,56.074499518900744,56.06966531692717,56.064837350367526,
	56.06001560347727,56.05520006057071,56.05039070602067,56.04558752425813,56.04079049977207,
	56.035999617109056,56.03121486087304,56.02643621572506,56.02166366638297,56.016897197621105,
	56.01213679427009,56.00738244121651,56.00263412340266,55.99789182582625,55.9931555335402,
	55.98842523165226,55.98370090532486,55.97898253977478,55.974270120272905,55.96956363214395,
	55.96486306076624,55.9601683915714,55.955479610044115,55.95079670172194,55.94611965219489,
	55.941448447105394,55.93678307214789,55.9321235130686,55.92746975566532,55.92282178578722,
	55.91817958933445,55.91354315225806,55.908912460559634,55.90428750029113,55.89966825755462,
	55.89505471850201,55.890446869334866,55.885844696304126,55.88124818570995,55.87665732390138,
	55.87207209727615,55.867492492280526,55.86291849540897,55.85835009320395,55.8537872722558,
	55.84923001920236,55.84467832072884,55.84013216356756,55.835591534497745,55.83105642034535,
	55.826526807982745,55.82200268432858,55.81748403634756,55.81297085105016,55.80846311549251,
	55.80396081677613,55.79946394204776,55.79497247849904,55.79048641336648,55.78600573393108,
	55.78153042751823,55.77706048149754,55.77259588328244,55.76813662033023,55.76368268014169,
	55.75923405026102,55.75479071827553,55.750352671815484,55.74591989855391,55.74149238620642,
	55.737070122530966,55.732653095327706,55.72824129243879,55.723834701748125,55.71943331118128,
	55.715037108705175,55.71064608232803,55.706260220099054,55.70187951010835,55.697503940486655,
	55.69313349940525,55.68876817507571,55.68440795574967,55.6800528297188,55.675702785314506,
	55.67135781090777,55.66701789490901,55.662683025767834,55.658353191972985,55.65402838205202,
	55.64970858457125,55.6453937881355,55.64108398138799,55.63677915301013,55.63247929172133,
	55.62818438627892,55.62389442547783,55.61960939815063,55.61532929316714,55.61105409943447,
	55.60678380589667,55.602518401534724,55.59825787536629,55.59400221644559,55.589751413863205,
	55.585505456745935,55.581264334256694,55.57702803559421,55.57279654999308,55.56856986672337,
	55.56434797509072,55.5601308644359,55.55591852413493,55.551710943598735,55.54750811227314,
	55.543310019638554,55.539116655209945,55.53492800853668,55.53074406920233,55.52656482682454,
	55.522390271054874,55.518220391578694,55.51405517811501,55.50989462041629,55.50573870826839,
	55.501587431490336,55.49744077993423,55.49329874348512,55.48916131206077,55.48502847561166,
	55.48090022412069,55.47677654760317,55.472657436106665,55.468542879710775,55.464432868527034,
	55.46032739269881,55.45622644240117,55.4521300078407,55.44803807925541,55.44395064691456,
	55.4398677011186,55.43578923219893,55.431715230517895,55.42764568646854,55.423580590474565,
	55.419519932990156,55.415463704499864,55.41141189551843,55.40736449659079,55.403321498291795,
	55.39928289122619,55.395248666028436,55.3912188133626,55.38719332392227,55.38317218843032,
	55.379155397638954,55.375142942329454,55.371134813312054,55.36713100142594,55.36313149753901,
	55.359136292547795,55.35514537737738,55.35115874298123,55.3471763803411,55.34319828046685,
	55.33922443439653,55.33525483319595,55.3312894679589,55.32732832980675,55.323371409888544,
	55.31941869938077,55.31547018948726,55.31152587143914,55.30758573648066,55.30364977592554,
	55.29971798107153,55.295790343257636,55.29186685384958,55.28794750423966,55.284032285846635,
	55.28012119011571,55.27621420851829,55.27231133255198,55.26841255374043,55.26451786363324,
	55.260627253805836,55.25674071585944,55.25285824142087,55.248979822142445,55.24510544970202,
	55.24123511580266,55.237368812172726,55.23350653056569,55.22964826276005,55.225794000559226,
	55.22194373579148,55.21809746030972,55.214255165991595,55.21041684473923,55.20658248847914,
	55.20275208916223,55.19892563876361,55.19510312928257,55.19128455274237,55.18746990119028,
	55.18365916669739,55.17985234135859,55.17604941729236,55.172250386640826,55.16845524156956,
	55.16466397426749,55.16087657694691,55.1570930418432,55.15331336121496,55.14953752734378,
	55.14576553253414,55.141997369113376,55.138233029431575,55.134472505861496,55.13071579079845,
	55.12696287666023,55.123213755887036,55.11946842094137,55.11572686430794,55.1119890784936,
	55.10825505602724,55.104524789459745,55.10079827136383,55.09707549433401,55.09335645098653,
	55.08964113395926,55.085929535911575,55.082221649524314,55.0785174674997,55.074816982561266,
	55.07112018745368,55.06742707494282,55.063737637815564,55.06005186887978,55.05636976096418,
	55.0526913069183,55.049016499612414,55.04534533193741,55.041677796804755,55.03801388714641,
	55.034353595914745,55.03069691608243,55.027043840642435,55.023394362607846,55.0197484750119,
	55.01610617090783,55.01246744336881,55.00883228548793,55.005200690378,55.00157265117161,
	54.997948161020965,54.99432721309784,54.99070980059352,54.98709591671874,54.983485554703506,
	54.979878707797184,54.97627536926828,54.972675532404494,54.96907919051251,54.96548633691808,
	54.96189696496584,54.95831106801924,54.95472863946055,54.95114967269074,54.9475741611294,
	54.94400209821468,54.940433477403246,54.93686829217019,54.933306536008985,54.9297482024313,
	54.926193284967155,54.92264177716465,54.91909367258998,54.915548964827366,54.912007647479015,
	54.908469714164944,54.904935158523095,54.901403974209046,54.89787615489622,54.89435169427549,
	54.890830586055415,54.88731282396199,54.88379840173867,54.88028731314626,54.876779551962876,
	54.87327511198388,54.86977398702179,54.86627617090625,54.862781657483936,54.85929044061858,
	54.85580251419074
	}}
};
table1d_imp<2001> tubetable2_EF86[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	38840.92200373405,38790.250291968056,38739.70269456312,38689.27882998362,38638.97831824558,
	38588.80078090969,38538.74584107299,38488.81312336283,38439.00225392773,38389.31286043391,
	38339.74457205505,38290.29701946772,38240.969834842326,38191.76265183875,38142.67510559772,
	38093.706832734075,38044.85747133202,37996.126660935086,37947.51404254281,37899.019258602144,
	37850.641953001505,37802.38177106335,37754.23835953946,37706.21136660364,37658.30044184326,
	37610.505236256075,37562.82540224273,37515.26059359837,37467.81046550867,37420.47467454405,
	37373.252878651,37326.144737146766,37279.14991071495,37232.26806139664,37185.49885258594,
	37138.84194902306,37092.2970167901,37045.86372330218,36999.5417373023,36953.33072885767,
	36907.23036935164,36861.240331476576,36815.360289231896,36769.58991791378,36723.928894113014,
	36678.3768957071,36632.93360185457,36587.5986929911,36542.37185082112,36497.252758314105,
	36452.24109969767,36407.336560454336,36362.538827312776,36317.847588243494,36273.26253245437,
	36228.783350384525,36184.40973369746,36140.14137527818,36095.977969225365,36051.91921084753,
	36007.964796657034,35964.114424365354,35920.367792876015,35876.724602282535,35833.18455385978,
	35789.747350060745,35746.412694511106,35703.18029200235,35660.04984849055,35617.02107108682,
	35574.093668055,35531.267348805246,35488.541823889806,35445.91680499806,35403.392004951136,
	35360.967137696396,35318.64191830297,35276.41606295787,35234.28928896048,35192.26131471581,
	35150.33185973237,35108.50064461715,35066.76739106771,35025.13182187152,34983.59366089875,
	34942.15263309793,34900.80846449139,34859.56088217179,34818.409614294906,34777.35439007781,
	34736.394939791164,34695.53099475903,34654.76228734889,34614.08855097179,34573.50952007502,
	34533.024930139734,34492.63451767409,34452.33802021092,34412.13517630155,34372.025725513064,
	34332.0094084227,34292.08596661492,34252.25514267446,34212.51668018548,34172.87032372409,
	34133.31581885625,34093.85291213247,34054.481351083945,34015.20088421839,33976.01126101503,
	33936.912231922586,33897.90354835216,33858.98496267592,33820.15622822095,33781.41709926622,
	33742.76733103814,33704.206679706294,33665.73490238121,33627.35175710779,33589.05700286171,
	33550.850399547715,33512.73170799429,33474.700689947684,33436.75710807155,33398.900725941676,
	33361.13130804109,33323.44861975725,33285.85242737744,33248.34249808763,33210.91859996338,
	33173.580501972676,33136.32797396573,33099.16078667628,33062.07871171484,33025.081521567554,
	32988.168989588885,32951.340890001695,32914.59699789094,32877.9370892022,32841.3609407361,
	32804.868330146324,32768.45903593427,32732.132837447334,32695.889514873998,32659.728849242143,
	32623.650622412097,32587.654617077966,32551.740616759827,32515.908405801514,32480.157769369256,
	32444.488493445646,32408.90036482754,32373.393171122567,32337.966700744255,32302.620742911946,
	32267.35508764431,32232.16952575709,32197.063848860864,32162.037849355576,32127.09132042965,
	32092.224056054158,32057.4358509828,32022.726500745335,31988.09580164639,31953.543550761908,
	31919.069545935658,31884.673585776112,31850.355469653623,31816.114997697216,31781.951970791273,
	31747.866190571047,31713.857459424114,31679.925580480827,31646.070357616547,31612.291595446066,
	31578.589099321,31544.9626753278,31511.412130282664,31477.937271730192,31444.537907940132,
	31411.213847904393,31377.964901333165,31344.790878653715,31311.691591005514,31278.66685023935,
	31245.716468912626,31212.840260287623,31180.038038328068,31147.309617696137,31114.654813750603,
	31082.073442543384,31049.565320815545,31017.13026599738,30984.768096202028,30952.47863022613,
	30920.2616875441,30888.117088307932,30856.044653342582,30824.04420414385,30792.115562876686,
	30760.258552369996,30728.472996116972,30696.758718270008,30665.11554363949,30633.543297690263,
	30602.04180653976,30570.61089695437,30539.250396348107,30507.960132779033,30476.739934946436,
	30445.589632189614,30414.509054484046,30383.498032438984,30352.55639729542,30321.683980923393,
	30290.8806158192,30260.146135103118,30229.480372516817,30198.883162420618,30168.354339791316,
	30137.893740220476,30107.50119991011,30077.176555671882,30046.919644923557,30016.730305688005,
	29986.608376588785,29956.553696849718,29926.566106291026,29896.64544532811,29866.791554967793,
	29837.00427680765,29807.283453032393,29777.628926411577,29748.040540298025,29718.51813862514,
	29689.061565904234,29659.67066722272,29630.345288241682,29601.085275193516,29571.890474879514,
	29542.760734667758,29513.695902491454,29484.695826845393,29455.76035678525,29426.8893419237,
	29398.08263242927,29369.34007902493,29340.661532983566,29312.046846127872,29283.49587082722,
	29255.008459995996,29226.584467090925,29198.223746108848,29169.92615158543,29141.691538592375,
	29113.519762735355,29085.410680151836,29057.36414750961,29029.380022002908,29001.45816135338,
	28973.59842380513,28945.800668123906,28918.06475359509,28890.3905400216,28862.777887720644,
	28835.226657524596,28807.736710775294,28780.307909325187,28752.940115532645,28725.63319226258,
	28698.38700288241,28671.201411261358,28644.07628176744,28617.011479266068,28590.006869118024,
	28563.06231717788,28536.177689791264,28509.35285379346,28482.58767650719,28455.882025741317,
	28429.23576978784,28402.648777420687,28376.120917894532,28349.652060941276,28323.242076768824,
	28296.89083605953,28270.598209969245,28244.364070123127,28218.188288615664,28192.07073800689,
	28166.011291323906,28140.009822055792,28114.06620415261,28088.180312024935,28062.352020539995,
	28036.581205022114,28010.867741248567,27985.211505449137,27959.612374305172,27934.070224945164,
	27908.584934945564,27883.15638232774,27857.78444555665,27832.469003538503,27807.209935619474,
	27782.007121584404,27756.860441654127,27731.76977648426,27706.735007163432,27681.756015211777,
	27656.83268257796,27631.964891640153,27607.15252520116,27582.395466488706,27557.69359915401,
	27533.046807267827,27508.454975321918,27483.917988224857,27459.435731301193,27435.008090290583,
	27410.634951344553,27386.316201026668,27362.05172630882,27337.841414571412,27313.685153601666,
	27289.58283158978,27265.53433713019,27241.539559217963,27217.59838724856,27193.710711014493,
	27169.876420705867,27146.09540690655,27122.3675605951,27098.692773140556,27075.070936302804,
	27051.501942230152,27027.98568345802,27004.522052906566,26981.110943881034,26957.752250067813,
	26934.445865534555,26911.19168472847,26887.98960247375,26864.839513971496,26841.7413147965,
	26818.694900897546,26795.70016859423,26772.757014576786,26749.8653359032,26727.025029999415,
	26704.23599465618,26681.49812802866,26658.811328633827,26636.175495350384,26613.590527416323,
	26591.05632442733,26568.57278633645,26546.13981345058,26523.75730643085,26501.425166290865,
	26479.143294394722,26456.911592454835,26434.729962532656,26412.598307034707,26390.516528712942,
	26368.484530662674,26346.50221632072,26324.56948946547,26302.68625421287,26280.852415017467,
	26259.067876669233,26237.332544293975,26215.646323349767,26194.009119627008,26172.420839246253,
	26150.881388657956,26129.390674639195,26107.948604293706,26086.55508505025,26065.210024661184,
	26043.913331199492,26022.66491306089,26001.46467895883,25980.31253792488,25959.208399307197,
	25938.152172769547,25917.143768288308,25896.183096152752,25875.27006696315,25854.4045916289,
	25833.586581368014,25812.815947705076,25792.092602469907,25771.416457796837,25750.787426122435,
	25730.205420185146,25709.670353022422,25689.182137971733,25668.740688666177,25648.345919035994,
	25627.997743305787,25607.696075992717,25587.44083190645,25567.231926146756,25547.06927410298,
	25526.952791451742,25506.882394156397,25486.85799846565,25466.8795209119,25446.946878309558,
	25427.05998775491,25407.21876662343,25387.423132569656,25367.673003524244,25347.968297694926,
	25328.30893356311,25308.694829883425,25289.12590568246,25269.60208025742,25250.123273174664,
	25230.689404268265,25211.300393638914,25191.956161652743,25172.65662893898,25153.401716390654,
	25134.191345161213,25115.025436664484,25095.903912572772,25076.82669481522,25057.793705578242,
	25038.804867302162,25019.860102679926,25000.959334658386,24982.102486433814,24963.28948145205,
	24944.520243407715,24925.7946962419,24907.11276414112,24888.474371536446,24869.879443101316,
	24851.327903751815,24832.819678643165,24814.354693170437,24795.93287296578,24777.55414389809,
	24759.218432071557,24740.92566382362,24722.675765724016,24704.46866457494,24686.304287407107,
	24668.182561479964,24650.103414280653,24632.066773522063,24614.072567141382,24596.12072329952,
	24578.211170379458,24560.343836983942,24542.518651936647,24524.735544277755,24506.99444326515,
	24489.295278371446,24471.637979284536,24454.022475903486,24436.448698340453,24418.916576916443,
	24401.42604216213,24383.97702481543,24366.56945582053,24349.20326632636,24331.878387685767,
	24314.594751453285,24297.352289384828,24280.150933435874,24262.990615759914,24245.87126870736,
	24228.792824824686,24211.75521685192,24194.758377722465,24177.802240561618,24160.886738683977,
	24144.01180559416,24127.177374983523,24110.383380730043,24093.62975689681,24076.916437729793,
	24060.24335765757,24043.610451289624,24027.017653415,24010.46489900061,23993.95212319005,
	23977.479261302804,23961.04624883195,23944.65302144342,23928.29951497466,23911.985665432825,
	23895.711408993444,23879.47668199999,23863.281420961208,23847.125562550176,23831.009043603404,
	23814.931801118993,23798.893772255084,23782.894894329012,23766.93510481592,23751.01434134622,
	23735.13254170566,23719.289643832875,23703.48558581909,23687.720305905317,23671.993742481533,
	23656.305834086448,23640.65651940414,23625.045737263164,23609.47342663655,23593.939526638285,
	23578.443976523697,23562.98671568681,23547.567683658635,23532.186820107643,23516.844064836136,
	23501.539357780108,23486.272639007646,23471.043848716185,23455.852927233136,23440.69981501276,
	23425.584452635674,23410.506780806663,23395.466740353622,23380.464272226003,23365.49931749301,
	23350.571817342792,23335.681713080325,23320.828946126323,23306.01345801481,23291.235190393112,
	23276.49408501922,23261.790083760443,23247.123128591888,23232.493161595743,23217.90012495816,
	23203.34396096946,23188.824612020842,23174.34202060406,23159.89612930966,23145.486880825538,
	23131.114217933977,23116.778083512112,23102.47842052909,23088.215172045377,23073.988281209335,
	23059.797691257976,23045.643345514018,23031.525187383937,23017.443160357423,23003.39720800549,
	22989.387273978293,22975.41330200315,22961.47523588485,22947.573019501568,22933.706596805143,
	22919.875911818064,22906.08090863263,22892.32153140882,22878.59772437281,22864.90943181574,
	22851.256598090626,22837.639167612444,22824.057084854732,22810.510294349246,22796.99874068402,
	22783.522368499966,22770.081122491883,22756.674947404445,22743.303788031564,22729.96758921422,
	22716.666295838517,22703.399852835042,22690.168205175392,22676.971297871914,22663.80907597421,
	22650.68148456982,22637.588468779264,22624.52997375733,22611.505944688713,22598.516326787605,
	22585.56106529556,22572.64010547954,22559.753392630024,22546.900872059035,22534.08248909826,
	22521.298189097586,22508.547917422624,22495.83161945319,22483.14924058095,22470.50072620816,
	22457.886021745184,22445.305072608386,22432.757824218865,22420.244221999787,22407.76421137486,
	22395.31773776586,22382.90474659133,22370.525183264097,22358.178993189085,22345.86612176141,
	22333.586514364906,22321.340116369247,22309.126873128305,22296.946729977793,22284.7996322337,
	22272.685525189125,22260.604354114206,22248.55606425134,22236.540600814653,22224.557908988052,
	22212.607933922085,22200.6906207326,22188.805914497654,22176.953760256314,22165.134103005617,
	22153.346887699252,22141.592059243765,22129.86956249833,22118.179342270327,22106.5213433154,
	22094.89551033253,22083.301787964443,22071.740120792485,22060.21045333693,22048.71273005251,
	22037.246895327615,22025.812893480448,22014.410668758115,22003.040165332448,21991.701327299354,
	21980.394098675308,21969.118423394917,21957.874245308827,21946.661508180543,21935.480155684847,
	21924.330131403814,21913.211378826178,21902.123841343033,21891.067462245635,21880.042184723643,
	21869.047951861183,21858.084706635134,21847.15239191177,21836.250950444126,21825.380324870115,
	21814.54045770822,21803.73129135627,21792.95276808731,21782.204830047354,21771.48741925271,
	21760.80047758649,21750.143946796532,21739.51776849111,21728.921884137446,21718.356235057534,
	21707.820762425745,21697.315407265258,21686.84011044564,21676.394812678678,21665.979454516593,
	21655.593976347,21645.238318391497,21634.91242070096,21624.61622315323,21614.34966544896,
	21604.112687108976,21593.90522746979,21583.72722568129,21573.578620702432,21563.45935129769,
	21553.369356033927,21543.308573276114,21533.276941184056,21523.274397708636,21513.300880587205,
	21503.35632734085,21493.440675269747,21483.553861449767,21473.695822727113,21463.866495715785,
	21454.065816792656,21444.293722093324,21434.550147507445,21424.83502867516,21415.14830098194,
	21405.48989955473,21395.859759256233,21386.257814681983,21376.684000153884,21367.138249716318,
	21357.620497131134,21348.130675872417,21338.66871912166,21329.23455976243,21319.82813037476,
	21310.449363230768,21301.09819028802,21291.774543184427,21282.47835323299,21273.209551415108,
	21263.96806837522,21254.753834414638,21245.566779485303,21236.406833183642,21227.273924743928,
	21218.16798303178,21209.08893653746,21200.03671336881,21191.011241244494,21182.012447486995,
	21173.0402590144,21164.094602333873,21155.1754035334,21146.282588274444,21137.416081782736,
	21128.57580884172,21119.76169378247,21110.97366047638,21102.211632325343,21093.47553225312,
	21084.765282696077,21076.08080559354,21067.422022377632,21058.788853964295,21050.18122074193,
	21041.599042561564,21033.042238725357,21024.510727976754,21016.004428487766,21007.523257847795,
	20999.06713305228,20990.63597048935,20982.229685928272,20973.84819450539,20965.491410712682,
	20957.159248381282,20948.85162067078,20940.568440052357,20932.30961829552,20924.075066451907,
	20915.864694840933,20907.678413033056,20899.516129833733,20891.37775326683,20883.263190556907,
	20875.172348112093,20867.105131506163,20859.06144545924,20851.041193819547,20843.044279543472,
	20835.070604675653,20827.120070328823,20819.19257666225,20811.288022860717,20803.406307112746,
	20795.547326587326,20787.71097741147,20779.897154646398,20772.10575226392,20764.336663121037,
	20756.589778935555,20748.864990259965,20741.162186455702,20733.481255665996,20725.822084789084,
	20718.184559450132,20710.568563973713,20702.973981354655,20695.40069322926,20687.848579845453,
	20680.317520033695,20672.80739117603,20665.318069175704,20657.849428426678,20650.401341781908,
	20642.973680522715,20635.56631432681,20628.179111237027,20620.81193762981,20613.46465818408,
	20606.13713584844,20598.829231812106,20591.54080547275,20584.2717144063,20577.02181433765,
	20569.790959111408,20562.579000663198,20555.385788992433,20548.211172136907,20541.054996147006,
	20533.917105062494,20526.797340891844,20519.69554359094,20512.611551046914,20505.545199062442,
	20498.4963213433,20491.464749489667,20484.450312988716,20477.452839213707,20470.472153424533,
	20463.508078774055,20456.560436318865,20449.62904503486,20442.713721839205,20435.81428161769,
	20428.930537259195,20422.06229969675,20415.209377957253,20408.371579217957,20401.54870887322,
	20394.740570609873,20387.946966492276,20381.167697059922,20374.402561434075,20367.65135743847,
	20360.91388173169,20354.18992995372,20347.479296887035,20340.78177663198,20334.097162798313,
	20327.425248714444,20320.765827652787,20314.118693072618,20307.483638885085,20300.860459733914,
	20294.24895129964,20287.648910622363,20281.06013644807,20274.48242959635,20267.915593350834,
	20261.35943387294,20254.813760640634,20248.278386907037,20241.753130189012,20235.237812774125,
	20228.732262256337,20222.236312091805,20215.749802181454,20209.272579474302,20202.804498594465,
	20196.34542248868,20189.89522309517,20183.453782031545,20177.02099129914,20170.596754004855,
	20164.18098509601,20157.773612106663,20151.3745759137,20144.9838314995,20138.60134871667,
	20132.227113055953,20125.86112640626,20119.503407812423,20113.153994219076,20106.812941199853,
	20100.48032366761,20094.156236560226,20087.840795496835,20081.534137401493,20075.236421086684,
	20068.947827795146,20062.66856169095,20056.39885029695,20050.138944876093,20043.88912074543,
	20037.64967752416,20031.420939308686,20025.203254770633,20018.996997172202,20012.80256430061,
	20006.620378311098,20000.450885482456,19994.294555878034,19988.151882913342,19982.02338282867,
	19975.909594065026,19969.811076544604,19963.728410856937,19957.662197350288,19951.61305513426,
	19945.581620989717,19939.56854819792,19933.57450528729,19927.60017470226,19921.646251404673,
	19915.713441408043,19909.802460254363,19903.914031439377,19898.048884793963,19892.207754829335,
	19886.391379054643,19880.600496272295,19874.835844864076,19869.09816107327,19863.388177291134,
	19857.706620357763,19852.05420988534,19846.431656609788,19840.83966078184,19835.278910601322,
	19829.75008070399,19824.25383070901,19818.790803828157,19813.36162554661,19807.966902378197,
	19802.607220702703,19797.283145681842,19791.995220266566,19786.74396428881,19781.529873647018,
	19776.353419582767,19771.215048049547,19766.11517917347,19761.054206808403,19756.032498179553,
	19751.050393617872,19746.108206380846,19741.20622256045,19736.344701069575,19731.523873710114,
	19726.74394531578,19722.00509396562,19717.30747126718,19712.651202699384,19708.036388019576,
	19703.463101720263,19698.931393540868,19694.44128902078,19689.99279009985,19685.585875747653,
	19681.220502634675,19676.896605825124,19672.61409949658,19668.372877680584,19664.172815019745,
	19660.013767535456,19655.89557340888,19651.818053764317,19647.781013459335,19643.784241869766,
	19639.827513679,19635.91058965641,19632.033217430537,19628.195132255027,19624.396057758826,
	19620.635706687,19616.913781623596,19613.22997570441,19609.583973304674,19605.975450715516,
	19602.404076796956,19598.869513613026,19595.371417048264,19591.909437398703,19588.48321994757,
	19585.09240551367,19581.736630984797,19578.415529823567,19575.12873255592,19571.8758672357,
	19568.656559892373,19565.47043495142,19562.317115639034,19559.196224366842,19556.107383093895,
	19553.05021367083,19550.024338165884,19547.029379171778,19544.06496009685,19541.130705432606,
	19538.226241014298,19535.351194255898,19532.505194377733,19529.687872611023,19526.89886239493,
	19524.13779955707,19521.404322477887,19518.698072247716,19516.018692808022,19513.3658310822,
	19510.739137093085,19508.138264076468,19505.562868573525,19503.012610525868,19500.48715335113,
	19497.986164018323,19495.50931310908,19493.056274873496,19490.626727276725,19488.220352044606,
	19485.83683469531,19483.475864568507,19481.137134848643,19478.820342583418,19476.52518869521,
	19474.251377990022,19471.998619157708,19469.766624775868,19467.55511130181,19465.363799064773,
	19463.192412254717,19461.040678905596,19458.90833088363,19456.79510385945,19454.700737287443,
	19452.624974382994,19450.56756209415,19448.528251070773,19446.506795635814,19444.502953750944,
	19442.516486984518,19440.547160474187,19438.594742893063,19436.65900640906,19434.73972664953,
	19432.836682659105,19430.949656862518,19429.07843502161,19427.222806195834,19425.382562700477,
	19423.557500062994,19421.747416982667,19419.952115286007,19418.171399888284,19416.405078744636,
	19414.65296281272,19412.91486600657,19411.190605154206,19409.47999995631,19407.7828729432,
	19406.099049431286,19404.42835748181,19402.77062785861,19401.125693986913,19399.493391910855,
	19397.8735602535,19396.266040175353,19394.670675334888,19393.08731184818,19391.515798247015,
	19389.955985445064,19388.407726693582,19386.870877545498,19385.345295818282,19383.830841554613,
	19382.327376987363,19380.834766503325,19379.352876603087,19377.881575870437,19376.420734937354,
	19374.970226443977,19373.52992501027,19372.099707201323,19370.679451491378,19369.269038235034,
	19367.868349631623,19366.47726969856,19365.095684233806,19363.723480790984,19362.360548646313,
	19361.006778770537,19359.66206379691,19358.32629799782,19356.99937724948,19355.681199012102,
	19354.37166229668,19353.070667639797,19351.778117079524,19350.493914124992,19349.21796373756,
	19347.950172299803,19346.690447591693,19345.438698773065,19344.19483634812,19342.958772154354,
	19341.730419331656,19340.509692301704,19339.296506748746,19338.09077959487,19336.892428979663,
	19335.701374237746,19334.517535885676,19333.34083558615,19332.171196146668,19331.008541487055,
	19329.85279662645,19328.703887663316,19327.56174175394,19326.42628710273,19325.29745293141,
	19324.17516947438,19323.059367955866,19321.949980572586,19320.84694047923,19319.750181770625,
	19318.659639468027,19317.575249501784,19316.496948697637,19315.424674757487,19314.358366251414,
	19313.297962597935,19312.243404054632,19311.194631697508,19310.151587410714,19309.114213879988,
	19308.082454564126,19307.056253697807,19306.035556270173,19305.020308013405,19304.01045539214,
	19303.005945592264,19302.006726503452,19301.012746717937,19300.023955507535,19299.04030282214,
	19298.061739271303,19297.08821612208,19296.119685276757,19295.156099274096,19294.19741127425,
	19293.243575044176,19292.29454495672,19291.350275977384,19290.410723651126,19289.475844096876,
	19288.545594000992,19287.619930601344,19286.698811686016,19285.78219557577,19284.870041127033,
	19283.962307715337,19283.05895522561,19282.15994405404,19281.2652350896,19280.374789713722,
	19279.48856978606,19278.60653764567,19277.728656094972,19276.85488839821,19275.985198271177,
	19275.119549878746,19274.2579078218,19273.40023713534,19272.546503279245,19271.696672135276,
	19270.850709995706,19270.008583562252,19269.17025993696,19268.335706611928,19267.504891476998,
	19266.677782799783,19265.854349224108,19265.034559768235,19264.218383818727,19263.405791118123,
	19262.596751768924,19261.791236218767,19260.989215269292,19260.190660052423,19259.3955420418,
	19258.603833040528,19257.815505175015,19257.03053089368,19256.248882963042,19255.47053445732,
	19254.695458763013,19253.92362956611,19253.155020849823,19252.389606896828,19251.627362273863,
	19250.868261835392,19250.112280722842,19249.359394348587,19248.609578401054,19247.862808840593,
	19247.119061894664,19246.378314049438,19245.640542053035,19244.90572290813,19244.173833870456,
	19243.444852440913,19242.718756369937,19241.995523645634,19241.27513249662,19240.55756138539,
	19239.84278900698,19239.130794286422,19238.421556369078,19237.71505462843,19237.011268657436,
	19236.3101782592,19235.61176345908,19234.91600448663,19234.222881784368,19233.532375993596,
	19232.84446796441,19232.159138744275,19231.476369575892,19230.79614189774,19230.118437343677,
	19229.443237733227,19228.77052507009,19228.100281552248,19227.432489548453,19226.767131614408,
	19226.10419048105,19225.44364905431,19224.785490414062,19224.12969780919,19223.47625465887,
	19222.825144545823,19222.176351219336,19221.529858590482,19220.88565073004,19220.24371186779,
	19219.604026385292,19218.966578824584,19218.331353874048,19217.698336376954,19217.06751131916,
	19216.438863839398,19215.8123792169,19215.18804287505,19214.565840378036,19213.94575742974,
	19213.327779870437,19212.711893678257,19212.09808496324,19211.486339969677,19210.876645071436,
	19210.268986776606,19209.66335171283,19209.059726640287,19208.458098441322,19207.858454121728,
	19207.260780811754,19206.66506575794,19206.071296330327,19205.479460007416,19204.88954439591,
	19204.3015372075,19203.7154262708,19203.131199527907,19202.548845029854,19201.968350935756,
	19201.3897055136,19200.81289714151,19200.237914298705,19199.66474556902,19199.093379642512,
	19198.52380530811,19197.956011457874,19197.389987080318,19196.82572126587,19196.263203201157,
	19195.702422165537,19195.1433675385,19194.586028792026,19194.030395486887,19193.47645728132,
	19192.924203922812,19192.373625247506,19191.824711180176,19191.27745173508,19190.731837011084,
	19190.187857193465,19189.645502555984,19189.10476344879,19188.5656303128,19188.028093667403,
	19187.492144112406,19186.95777232915,19186.424969077092,19185.89372519793,19185.364031604768,
	19184.835879293798,19184.309259334692,19183.784162867603,19183.260581116956,19182.738505371606,
	19182.21792699826,19181.69883743431,19181.181228185662,19180.66509083324,19180.150417024703,
	19179.637198476485,19179.12542697408,19178.61509437034,19178.106192585517,19177.598713605646,
	19177.092649479117,19176.587992322413,19176.084734316155,19175.582867703022,19175.08238478744,
	19174.58327793845,19174.08553958103,19173.58916220869,19173.09413836764,19172.60046066857,
	19172.1081217787,19171.617114424498,19171.127431389257,19170.63906551162,19170.152009691694,
	19169.666256880235,19169.181800086917,19168.698632373897,19168.21674685912,19167.736136708463,
	19167.25679515396,19166.778715466444,19166.3018909757,19165.826315060818,19165.351981153446,
	19164.87888273579,19164.4070133397,19163.9363665431,19163.466935979235,19162.99871532358,
	19162.531698303912,19162.065878693702,19161.601250316395,19161.137807035582,19160.675542768564,
	19160.21445147343,19159.754527154637,19159.29576386315,19158.838155693957,19158.381696780787,
	19157.926381309335,19157.472203500925,19157.01915762616,19156.567237993826,19156.116438956014,
	19155.666754903606,19155.21818027202,19154.770709533877,19154.324337211754,19153.879057851944,
	19153.43486605644,19152.991756455092,19152.54972371821,19152.108762562304,19151.66886773141,
	19151.23003401858,19150.79225624273,19150.355529267625,19149.91984798964,19149.485207346428,
	19149.051602306543,19148.619027874887,19148.18747909158,19147.756951038722,19147.327438821856,
	19146.898937589525,19146.471442520487,19146.044948825875,19145.619451757204,19145.194946590153,
	19144.771428636286,19144.34889324697,19143.92733579635,19143.506751692494,19143.08713637782,
	19142.66848532591,19142.250794038955,19141.83405804967,19141.418272927356,19141.003434262333,
	19140.589537685544,19140.17657884822,19139.76455343558,19139.35345716107,19138.94328576812,
	19138.534035028668,19138.12570074053,19137.718278732566,19137.311764861177,19136.906155010594,
	19136.501445087884,19136.097631038338,19135.694708820633,19135.292674433604,19134.891523888746,
	19134.491253238495,19134.091858545606,19133.693335913376,19133.295681461594,19132.898891336277,
	19132.502961715232,19132.107888794937,19131.713668796634,19131.32029796704,19130.92777258142,
	19130.53608893127,19130.145243337312,19129.755232146996,19129.366051724053,19128.977698457926,
	19128.590168763854,19128.203459075005,19127.817565856978,19127.432485586873,19127.048214768824,
	19126.664749928677,19126.2820876165,19125.900224403948,19125.51915687813,19125.138881654573,
	19124.75939537047,19124.380694677726,19124.002776252935,19123.625636793517,19123.249273018053,
	19122.873681667916,19122.49885949494,19122.124803283503,19121.751509825248,19121.37897594873,
	19121.007198486044,19120.636174295803,19120.265900252187,19119.89637325029,19119.527590210986,
	19119.159548064166,19118.792243760043,19118.425674274382,19118.059836590004,19117.694727720354,
	19117.330344688893,19116.966684541298,19116.603744333155,19116.241521141234,19115.88001208422,
	19115.519214250722,19115.15912477963,19114.799740824405,19114.441059546793,19114.083078125903,
	19113.725793765345,19113.36920367826,19113.013305094344,19112.65809526894,19112.30357145974,
	19111.94973095063,19111.596571040172,19111.244089035572,19110.892282269044,19110.541148079905,
	19110.190683830875,19109.840886897066,19109.49175466619,19109.143284561356,19108.795473953156,
	19108.448320324904,19108.101821106935,19107.755973766907,19107.410775785196,19107.066224651648,
	19106.722317873573,19106.379052975863,19106.036427492756,19105.69443897414,19105.353084986684,
	19105.01236310144,19104.672270917297,19104.33280603548,19103.993966076865,19103.65574867153,
	19103.318151465497,19102.981172115156,19102.64480829664,19102.309057688668,19101.973917994022,
	19101.63938692158,19101.305462193206,19100.972141549024,19100.639422729186,19100.30730350073,
	19099.97578163661,19099.644854916492,19099.31452114737,19098.984778132068,19098.65562369195,
	19098.327055668928,19097.999071893868,19097.67167024054,19097.34484856744,19097.01860475278,
	19096.692936699787,19096.367842305062,19096.043319480832,19095.71936616002,19095.395980271267,
	19095.073159770014,19094.750902610624,19094.42920676709,19094.10807022073,19093.787490958694,
	19093.467466989023,19093.147996325497,19092.82907698907,19092.510707011716,19092.192884442058,
	19091.875607332306,19091.55887375347,19091.242681774165,19090.927029483264,19090.611914977664,
	19090.29733636273,19089.98329175275,19089.669779273394,19089.35679705965,19089.04434326119,
	19088.73241602772,19088.421013521558,19088.110133920844,19087.799775410687,19087.489936180198,
	19087.18061442863,19086.871808376913,19086.563516234473,19086.255736238443,19085.948466623526,
	19085.64170563827,19085.335451540348,19085.029702595904,19084.724457073553,19084.419713265863,
	19084.115469459757,19083.811723954143,19083.508475058294,19083.205721093444,19082.903460384256,
	19082.601691266245,19082.30041207896,19081.999621178442,19081.699316916638,19081.399497669947,
	19081.100161810034,19080.801307718742,19080.502933793665,19080.20503843007,19079.90762004025,
	19079.610677036522,19079.314207845222,19079.018210897557,19078.722684627304,19078.427627488578,
	19078.133037936044,19077.838914427888,19077.545255430996,19077.252059430743,19076.959324909447,
	19076.667050353317,19076.375234264513,19076.083875153836,19075.792971532093,19075.5025219238,
	19075.212524852217,19074.92297885366,19074.633882475482,19074.345234260676,19074.057032767432,
	19073.769276564508,19073.48196421252,19073.19509429881,19072.908665402938,19072.622676116494,
	19072.33712503065,19072.05201076104,19071.76733191023,19071.48308709645,19071.19927494416,
	19070.915894085192,19070.632943155997,19070.350420799787,19070.068325666427,19069.78665641208,
	19069.50541169893,19069.224590194757,19068.94419057543,19068.664211519994,19068.384651719334,
	19068.105509862577,19067.82678465715,19067.54847479293,19067.270578998654,19066.993095980994,
	19066.716024471934,19066.439363195408,19066.163110880865,19065.88726627937,19065.61182813051,
	19065.336795190848,19065.062166219934,19064.78793998001,19064.514115239457,19064.240690769293,
	19063.967665359698,19063.69503778989,19063.422806853483,19063.150971352494,19062.879530080303,
	19062.608481853746,19062.337825483384,19062.067559785075,19061.79768358945,19061.52819571905,
	19061.259095014095,19060.990380310242,19060.722050457618,19060.45410430486,19060.186540705166,
	19059.919358516945,19059.652556613448,19059.38613385886,19059.120089132743,19058.854421315176,
	19058.589129294414,19058.324211950596,19058.05966819162,19057.79549691349,19057.5316970199,
	19057.268267422452,19057.005207033155,19056.74251477162,19056.480189568367,19056.21823034573,
	19055.956636043644,19055.69540559361,19055.434537940288,19055.174032036488,19054.913886827857,
	19054.65410127804,19054.39467433625,19054.135604981322,19053.876892175205,19053.618534898276,
	19053.360532125866,19053.102882839452,19052.845586027503,19052.58864068645,19052.332045814004,
	19052.075800400205,19051.81990346062,19051.56435400037,19051.30915103259,19051.054293572983,
	19050.799780644258,19050.545611280104,19050.29178450101,19050.038299340118,19049.785154845602,
	19049.53235005122,19049.27988400592,19049.027755758034,19048.77596436572,19048.52450888773,
	19048.273388384885,19048.022601919318,19047.772148562926,19047.522027392784,19047.272237481164,
	19047.022777920323,19046.773647784485,19046.524846165787,19046.276372163586,19046.028224864964,
	19045.780403374956,19045.53290679724,19045.285734242127,19045.038884819583,19044.792357642487,
	19044.54615183011,19044.300266509545,19044.05470080472,19043.809453840953,19043.564524754707,
	19043.3199126813,19043.075616763188,19042.83163614568,19042.587969971977,19042.3446173936,
	19042.101577564943,19041.858849642045,19041.61643279084,19041.37432616808,19041.13252895187,
	19040.89104029687,19040.649859395955,19040.408985416594,19040.16841754194,19039.928154953726,
	19039.6881968389,19039.44854239411,19039.209190807513,19038.970141279697,19038.731393009813,
	19038.492945199585,19038.2547970577,19038.01694779655,19037.7793966249,19037.542142760954,
	19037.30518542316,19037.06852383193,19036.8321572164,19036.596084801495,19036.360305818434,
	19036.124819506826,19035.889625097203,19035.654721835213,19035.420108960385,19035.18578572025,
	19034.951751365028,19034.7180051456,19034.484546317715,19034.251374142328,19034.018487871348,
	19033.785886779,19033.553570124936,19033.32153717854,19033.089787219084,19032.858319512485,
	19032.627133337144,19032.39622798327,19032.165602726014,19031.935256851382,19031.705189649438,
	19031.475400411073,19031.245888434525,19031.01665301293,19030.787693447463,19030.559009039138,
	19030.330599089142,19030.102462913917,19029.87459981413,19029.64700911331,19029.41969011535,
	19029.192642143884,19028.96586452049,19028.739356564773,19028.513117608618,19028.287146971008,
	19028.06144398851,19027.836007994876,19027.61083831873,19027.38593431064,19027.161295298396,
	19026.936920631288,19026.71280965619,19026.488961722185,19026.265376166597,19026.042052363835,
	19025.81898965031,19025.596187395582,19025.373644947398,19025.151361683205,19024.929336957583,
	19024.707570133363,19024.486060591593,19024.264807701584,19024.043810829862,19023.823069357175,
	19023.602582664513,19023.382350129763,19023.162371137783,19022.942645071314,19022.723171320395,
	19022.503949267506,19022.28497831879,19022.06625785758,19021.847787284853,19021.629565994175,
	19021.411593391447,19021.193868876093,19020.976391855533,19020.759161741888,19020.54217792894,
	19020.325439848057,19020.108946898647,19019.892698501913,19019.67669407121,19019.460933035687,
	19019.245414810688,19019.030138817405,19018.815104483845,19018.60031124705,19018.385758523735,
	19018.17144575834,19017.957372373807,19017.743537812996,19017.529941514364,19017.316582919277,
	19017.10346146249,19016.89057659714,19016.677927761746,19016.46551440868,19016.253335987967,
	19016.041391949475,19015.829681749576,19015.61820484411,19015.406960685,19015.195948737975,
	19014.985168464173,19014.77461932736,19014.564300783724,19014.35421231387,19014.144353379386,
	19013.934723452432,19013.72532200536,19013.516148507362,19013.307202445976,19013.09848329281,
	19012.889990523905,19012.681723627473,19012.473682085507,19012.265865383153,19012.05827300244,
	19011.850904436877,19011.643759182312,19011.43683671612,19011.230136546845,19011.023658166312,
	19010.817401066244,19010.611364750654,19010.405548723957,19010.19995247929,19009.994575531236,
	19009.78941737801,19009.58447752682,19009.379755495953,19009.175250784774,19008.970962912917,
	19008.766891395,19008.56303574506,19008.359395479245,19008.15597011786,19007.952759181288,
	19007.74976219455,19007.54697868141,19007.344408166064,19007.14205016969,19006.93990422984,
	19006.73796987642,19006.536246629854,19006.334734040585,19006.133431637685,19005.932338948252,
	19005.731455519282,19005.5307808893,19005.33031459541,19005.1300561874,19004.930005208746,
	19004.73016119575,19004.530523703375,19004.331092281434,19004.131866473945,19003.932845836778,
	19003.734029925243,19003.535418287727,19003.33701048243,19003.13880607018,19002.940804609098,
	19002.743005653712,19002.545408774422,19002.34801352703,19002.15081948141,19001.95382620123,
	19001.75703325489,19001.56044021044,19001.36404663785,19001.167852112558,19000.971856198543,
	19000.776058480315,19000.580458533725,19000.385055922827,19000.189850241604,18999.994841061838,
	18999.80002796683,18999.605410539785,18999.41098836209,18999.2167610214,18999.022728104057,
	18998.828889198867,18998.635243892073,18998.44179177458,18998.24853244312,18998.055465487196,
	18997.8625904969,18997.669907077012,18997.477414817564,18997.285113319216,18997.093002185524,
	18996.9010810102,18996.709349398883,18996.51780696275,18996.326453292262,18996.135287993955,
	18995.944310686227,18995.753520971215,18995.562918459837,18995.372502763883,18995.182273489994,
	18994.992230254375,18994.802372673876,18994.612700360663,18994.4232129359,18994.233910012197,
	18994.044791217206,18993.855856155,18993.667104471624,18993.478535767623,18993.29014967677,
	18993.10194582283,18992.91392383123,18992.72608333344,18992.538423953607,18992.350945320726,
	18992.163647070236,18991.97652883232,18991.789590238473,18991.6028309224,18991.41625052321,
	18991.229848674036,18991.043625012506,18990.857579184754,18990.671710815375,18990.486019555756,
	18990.300505053114,18990.11516693801,18989.93000486209,18989.745018473033,18989.5602074097,
	18989.37557132827,18989.19110986684,18989.006822682266,18988.822709424447,18988.63876973909,
	18988.45500329031,18988.271409723413,18988.08798869512,18987.90473985981,18987.72166287923,
	18987.538757404982,18987.3560231022,18987.173459627964,18986.99106664509,18986.80884381115,
	18986.62679079108,18986.444907251094,18986.26319285382,18986.081647264993,18985.900270154823,
	18985.719061190342,18985.5380200453,18985.357146380313,18985.17643986924,18984.99590018524,
	18984.81552699937,18984.635319992816,18984.455278831174,18984.27540319685,18984.095692766514,
	18983.916147211425,18983.736766213482,18983.557549452562,18983.37849661357,18983.19960737076,
	18983.020881418717,18982.842318424155,18982.663918079787,18982.48568007358,18982.307604086043,
	18982.129689811263,18981.95193692961,18981.7743451366,18981.596914114496,18981.419643562087,
	18981.242533167428,18981.065582622177,18980.888791617464,18980.712159852163,18980.535687016793,
	18980.35937281385,18980.18321694509,18980.007219088406,18979.83137895453,18979.655696244023,
	18979.480170663206,18979.304801892384,18979.129589659056,18978.954533650216,18978.779633570008,
	18978.60488913594
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	38840.92200373405,38790.250291968056,38739.702694562955,38689.27882998339,38638.97831824562,
	38588.800780909856,38538.74584107314,38488.81312336283,38439.00225392815,38389.31286043391,
	38339.744572054995,38290.29701946772,38240.96983484238,38191.76265183891,38142.67510559772,
	38093.706832734366,38044.85747133211,37996.126660935086,37947.51404254296,37899.019258602144,
	37850.641953001505,37802.381771063076,37754.23835953946,37706.211366603275,37658.30044184326,
	37610.50523625615,37562.825402242306,37515.26059359837,37467.810465508745,37420.47467454405,
	37373.252878650994,37326.144737146766,37279.14991071509,37232.26806139664,37185.49885258587,
	37138.84194902319,37092.29701679051,37045.86372330217,36999.5417373023,36953.33072885767,
	36907.23036935164,36861.240331477115,36815.360289231896,36769.589917913916,36723.92889411327,
	36678.37689570689,36632.93360185504,36587.598692991036,36542.37185082083,36497.25275831395,
	36452.241099697814,36407.336560454336,36362.53882731266,36317.847588243414,36273.262532454224,
	36228.78335038454,36184.40973369723,36140.14137527805,36095.977969225394,36051.91921084763,
	36007.964796657274,35964.114424365005,35920.36779287619,35876.724602282586,35833.184553860265,
	35789.747350060665,35746.412694510625,35703.18029200231,35660.0498484907,35617.02107108649,
	35574.093668054935,35531.267348805486,35488.54182389007,35445.916804998466,35403.39200495102,
	35360.96713769625,35318.64191830297,35276.41606295779,35234.28928896026,35192.26131471578,
	35150.33185973267,35108.50064461731,35066.767391068046,35025.131821871815,34983.59366089839,
	34942.15263309773,34900.808464491834,34859.56088217182,34818.40961429484,34777.35439007748,
	34736.39493979131,34695.53099475862,34654.762287348385,34614.08855097169,34573.50952007498,
	34533.02493013973,34492.63451767421,34452.33802021071,34412.13517630117,34372.02572551302,
	34332.00940842273,34292.08596661464,34252.25514267431,34212.51668018531,34172.87032372422,
	34133.31581885629,34093.85291213214,34054.481351083734,34015.20088421814,33976.01126101505,
	33936.91223192241,33897.90354835236,33858.9849626758,33820.15622822086,33781.41709926613,
	33742.767331037896,33704.206679706374,33665.73490238092,33627.35175710751,33589.057002861584,
	33550.85039954791,33512.73170799399,33474.700689947604,33436.75710807174,33398.90072594165,
	33361.13130804127,33323.448619757015,33285.85242737789,33248.34249808739,33210.91859996366,
	33173.58050197237,33136.327973965526,33099.160786676075,33062.078711715214,33025.081521567445,
	32988.168989588776,32951.34089000173,32914.59699789092,32877.93708920233,32841.36094073637,
	32804.86833014618,32768.45903593422,32732.132837447123,32695.889514873877,32659.72884924191,
	32623.65062241215,32587.65461707781,32551.74061675961,32515.908405801383,32480.157769369067,
	32444.488493445773,32408.900364827456,32373.393171122367,32337.966700743942,32302.620742911804,
	32267.35508764413,32232.16952575714,32197.063848860704,32162.037849355485,32127.09132042938,
	32092.224056054092,32057.43585098276,32022.726500745077,31988.095801646035,31953.54355076165,
	31919.06954593537,31884.673585775723,31850.355469653703,31816.11499769734,31781.951970791135,
	31747.866190571156,31713.857459423867,31679.92558048077,31646.070357616278,31612.29159544571,
	31578.5890993211,31544.962675327562,31511.41213028235,31477.937271729785,31444.537907940165,
	31411.213847904128,31377.9649013331,31344.79087865336,31311.69159100543,31278.666850239446,
	31245.71646891247,31212.840260287405,31180.0380383278,31147.309617695788,31114.654813750585,
	31082.073442542922,31049.56532081556,31017.1302659971,30984.768096201864,30952.478630225734,
	30920.261687543956,30888.117088307616,30856.044653342135,30824.04420414377,30792.115562876264,
	30760.258552369472,30728.472996116554,30696.75871826962,30665.115543638876,30633.543297689946,
	30602.041806539066,30570.610896954095,30539.25039634761,30507.960132778513,30476.739934945817,
	30445.589632189287,30414.509054483602,30383.49803243834,30352.556397294753,30321.683980922873,
	30290.880615818845,30260.146135102616,30229.480372516075,30198.88316241958,30168.354339790632,
	30137.893740219675,30107.50119990926,30077.176555670656,30046.919644922713,30016.730305687022,
	29986.608376587712,29956.553696848616,29926.56610629017,29896.645445326867,29866.79155496668,
	29837.004276806554,29807.28345303116,29777.62892641026,29748.04054029678,29718.518138623775,
	29689.0615659029,29659.670667221384,29630.345288240376,29601.08527519194,29571.89047487796,
	29542.76073466629,29513.695902489606,29484.695826843683,29455.760356783394,29426.889341921502,
	29398.08263242734,29369.340079022888,29340.66153298139,29312.046846125577,29283.49587082515,
	29255.00845999362,29226.584467088516,29198.223746106254,29169.926151583117,29141.69153858976,
	29113.519762732623,29085.410680148907,29057.36414750609,29029.38002199955,29001.458161350045,
	28973.598423801654,28945.800668120446,28918.06475359121,28890.3905400175,28862.777887716657,
	28835.226657520237,28807.736710770823,28780.30790932019,28752.940115527817,28725.63319225748,
	28698.387002877313,28671.20141125609,28644.076281761787,28617.01147926005,28590.00686911222,
	28563.062317171538,28536.17768978483,28509.352853786673,28482.587676500512,28455.88202573388,
	28429.235769780375,28402.648777412884,28376.120917886386,28349.652060932356,28323.24207675976,
	28296.890836050236,28270.598209959553,28244.36407011341,28218.188288605066,28192.07073799614,
	28166.011291312716,28140.00982204384,28114.066204140465,28088.18031201244,28062.35202052688,
	28036.581205008377,28010.867741234113,27985.211505434385,27959.612374289638,27934.070224929153,
	27908.584934928833,27883.156382310484,27857.784445538586,27832.46900351944,27807.209935599967,
	27782.00712156402,27756.860441633067,27731.76977646244,27706.735007140513,27681.75601518785,
	27656.83268255346,27631.964891614563,27607.15252517447,27582.395466461177,27557.69359912515,
	27533.04680723813,27508.45497529109,27483.9179881926,27459.435731267906,27435.00809025577,
	27410.634951308326,27386.316200988964,27362.05172626957,27337.841414530983,27313.685153559356,
	27289.582831546177,27265.534337084806,27241.53955917092,27217.598387199563,27193.71071096332,
	27169.876420652705,27146.09540685146,27122.36756053781,27098.69277308099,27075.070936241085,
	27051.501942165825,27027.98568339109,27004.52205283712,26981.110943808682,26957.7522499927,
	26934.44586545629,26911.1916846473,26887.989602389327,26864.8395138837,26841.741314705552,
	26818.694900802795,26795.70016849572,26772.757014474257,26749.86533579709,26727.025029889275,
	26704.23599454166,26681.498127909512,26658.81132850999,26636.175495221574,26613.590527282526,
	26591.05632428845,26568.572786191817,26546.13981330024,26523.757306274907,26501.425166128884,
	26479.143294226174,26456.911592279772,26434.729962350353,26412.5983068453,26390.516528516142,
	26368.48453045837,26346.502216108613,26324.56948924483,26302.6862539836,26280.8524147792,
	26259.067876421803,26237.33254403675,26215.64632308254,26194.00911934914,26172.420838957518,
	26150.88138835774,26129.39067432731,26107.9486039697,26086.555084713604,26065.21002431089,
	26043.913330835927,26022.66491268305,26001.464678566066,25980.312537516886,25959.208398883402,
	25938.152172329043,25917.14376783067,25896.183095676945,25875.270066468798,25854.404591115224,
	25833.586580834228,25812.81594715051,25792.09260189355,25771.416457197887,25750.78742550031,
	25730.205419538564,25709.67035235075,25689.182137273336,25668.740687940735,25648.345918282226,
	25627.997742522344,25607.696075178832,25587.44083106063,25567.231925267963,25547.06927318979,
	25526.952790502513,25506.882393170235,25486.857997441115,25466.879519847247,25446.94687720322,
	25427.059986605396,25407.218765428875,25387.423131328334,25367.673002234562,25347.968296354673,
	25328.308932170556,25308.694828436233,25289.125904178927,25269.60207869517,25250.123271551485,
	25230.689402581473,25211.300391886216,25191.956159831476,25172.65662704659,25153.40171442432,
	25134.19134311801,25115.025434541636,25095.90391036684,25076.82669252343,25057.793703196883,
	25038.804864827343,25019.860100108785,25000.959331986793,24982.10248365766,24963.289478567658,
	24944.520240410602,24925.794693127653,24907.11276090525,24888.474368174117,24869.879439607914,
	24851.32790012181,24832.819674871393,24814.35468925124,24795.932868893586,24777.55413966682,
	24759.218427674896,24740.92565925516,24722.675760977447,24704.468659642993,24686.304282282505,
	24668.18255615521,24650.1034087479,24632.0667677731,24614.07256116794,24596.12071709307,
	24578.211163930504,24560.343830283382,24542.518644974192,24524.73553704345,24506.99443574839,
	24489.295270561237,24471.637971169148,24454.02246747115,24436.448689578785,24418.916567812692,
	24401.426032702795,24383.977014986765,24366.569445607984,24349.20325571508,24331.878376659908,
	24314.594739997097,24297.352277481194,24280.15092106747,24262.990602908485,24245.87125535403,
	24228.792810949602,24211.755202435215,24194.758362742767,24177.80222499663,24160.886722511197,
	24144.011788789612,24127.17735752273,24110.38336258739,24093.629738045314,24076.916418142042,
	24060.243337304913,24043.610430142144,24027.017631441457,24010.464876168713,23993.95209946626,
	23977.479236652187,23961.046223218316,23944.652994829274,23928.299487320568,23911.985636698642,
	23895.711379137,23879.4766509769,23863.281388726187,23847.125529055527,23831.00900880025,
	23814.93176495606,23798.89373467905,23782.894855285067,23766.93506424585,23751.01429919093,
	23735.132497903123,23719.28959831874,23703.485538525987,23687.72025676367,23671.993691419648,
	23656.30578102892,23640.656464272706,23625.045679976865,23609.473367111117,23593.939464786232,
	23578.443912253726,23562.98664890404,23547.567614265103,23532.18674800122,23516.843989910827,
	23501.539279925182,23486.27255810829,23471.04376465373,23455.852839883646,23440.6997242473,
	23425.584358320702,23410.506682803018,23395.466638517013,23380.46416640632,23365.499207534536,
	23350.571703083264,23335.68159435122,23320.828822752228,23306.01332981443,23291.235057177168,
	23276.49394659098,23261.78993991567,23247.122979118874,23232.49300627368,23217.899963558033,
	23203.343793252574,23188.824437739975,23174.34183950187,23159.895941119063,23145.486685268203,
	23131.114014721385,23116.777872344246,23102.478201093945,23088.214944018488,23073.988044254133,
	23059.797445024502,23045.64308963816,23031.52492148776,23017.44288404756,23003.396920873725,
	22989.386975599635,22975.412991936944,22961.474913672162,22947.572684665964,22933.706248851184,
	22919.875550230834,22906.080532877342,22892.321140929052,22878.59731859104,22864.909010130817,
	22851.256159878536,22837.638712224103,22824.056611615717,22810.50980255902,22796.998229613666,
	22783.521837392425,22770.080570559978,22756.674373830418,22743.303191964922,22729.966969771576,
	22716.66565210127,22703.39918384866,22690.16750994785,22676.970575371695,22663.808325130027,
	22650.680704266924,22637.587657860295,22624.52913101827,22611.505068878774,22598.51541660656,
	22585.560119391812,22572.639122448578,22559.752371011647,22546.899810335388,22534.08138569204,
	22521.2970423692,22508.54672566763,22495.83038090037,22483.14795338917,22470.499388463264,
	22457.884631457928,22445.303627710786,22432.75632256182,22420.242661349035,22407.762589407987,
	22395.316052069233,22382.902994655986,22370.52336248167,22358.17710084872,22345.86415504528,
	22333.584470343867,22321.337991998596,22309.12466524312,22296.944435288126,22284.797247319966,
	22272.683046497023,22260.601777948363,22248.55338677105,22236.53781802733,22224.555016743932,
	22212.604927906956,22200.687496462095,22188.802667310494,22176.950385306955,22165.130595257226,
	22153.3432419158,22141.588269982767,22129.865624101956,22118.175248857708,22106.517088772867,
	22094.891088305212,22083.29719184614,22071.735343716275,22060.205488164287,22048.707569363094,
	22037.241531407806,22025.807318311636,22014.40487400481,22003.034142330092,21991.695067040953,
	21980.387591797335,21969.11166016451,21957.867215607825,21946.654201491434,21935.472561073977,
	21924.322237505738,21913.20317382618,21902.11531295926,21891.058597711264,21880.03297076653,
	21869.03837468524,21858.07475189857,21847.142044706274,21836.240195272207,21825.369145621647,
	21814.528837636484,21803.719213052744,21792.94021345505,21782.191780275138,21771.4738547855,
	21760.786378096785,21750.129291153273,21739.502534729014,21728.906049422974,21718.33977565541,
	21707.803653662977,21697.29762349465,21686.821625006563,21676.375597858358,21665.959481507212,
	21655.57321520415,21645.21673798822,21634.88998868196,21624.59290588583,21614.325427973778,
	21604.087493086612,21593.879039128,21583.700003757516,21573.550324385596,21563.429938167992,
	21553.338781999057,21543.2767925059,21533.243906042266,21523.240058682328,21513.265186213353,
	21503.319224129944,21493.40210762658,21483.513771590555,21473.65415059468,21463.823178891136,
	21454.020790401555,21444.246918711426,21434.501497061345,21424.784458338396,21415.095735068182,
	21405.43525940705,21395.802963131362,21386.198777630354,21376.622633895728,21367.074462512435,
	21357.554193649245,21348.061757048727,21338.597082015713,21329.16009740826,21319.75073162634,
	21310.36891260008,21301.014567778966,21291.687624119946,21282.388008075264,21273.115645579812,
	21263.870462038652,21254.65238231417,21245.461330711787,21236.297230966928,21227.160006230453,
	21218.04957905428,21208.965871375927,21199.9088045036,21190.878299099684,21181.874275166185,
	21172.89665202546,21163.945348305137,21155.02028191953,21146.12137005293,21137.24852913868,
	21128.401674842007,21119.580722040362,21110.785584803074,21102.016176369983,21093.272409132376,
	21084.55419460997,21075.861443428974,21067.19406529971,21058.551968994074,21049.935062320597,
	21041.34325210094,21032.77644414563,21024.234543227725,21015.71745305774,21007.225076256993,
	20998.757314331036,20990.314067641393,20981.89523537919,20973.500715535098,20965.130404871812,
	20956.78419889407,20948.461991819226,20940.163676546694,20931.889144628116,20923.638286236186,
	20915.41099013346,20907.207143641263,20899.026632607973,20890.869341377464,20882.735152757334,
	20874.62394798717,20866.535606706748,20858.470006924646,20850.4270249875,20842.40653554791,
	20834.408411535354,20826.432524125583,20818.478742712028,20810.546934876955,20802.63696636557,
	20794.748701058394,20786.88200094853,20779.03672611704,20771.21273471342,20763.409882935142,
	20755.628025012025,20747.867013191342,20740.126697726635,20732.406926869644,20724.707546865586,
	20717.028401951735,20709.369334362007,20701.730184333093,20694.110790119157,20686.510988008555,
	20678.930612349184,20671.369495578754,20663.827468262003,20656.304359135935,20648.799995162623,
	20641.314201590758,20633.846802026157,20626.397618512332,20618.96647162158,20611.55318055693,
	20604.157563265624,20596.779436566474,20589.418616288614,20582.074917426366,20574.748154307243,
	20567.438140775685,20560.14469039416,20552.867616660642,20545.60673324324,20538.361854235565,
	20531.132794428373,20523.919369604093,20516.72139685064,20509.538694896324,20502.371084467854,
	20495.218388669648,20488.08043338671,20480.95704771124,20473.84806439127,20466.75332030575,
	20459.672656960174,20452.605921009977,20445.552964803643,20438.51364695343,20431.487832924333,
	20424.475395649533,20417.476216165505,20410.490184266208,20403.517199179245,20396.557170256783,
	20389.61001768468,20382.675673204147,20375.754080845814,20368.845197672763,20361.948994531485,
	20355.065456803444,20348.19458516062,20341.336396316005,20334.49092376705,20327.65821853014,
	20320.838349858008,20314.031405939593,20307.237494574216,20300.45674381926,20293.68930260316,
	20286.935341299348,20280.195052257448,20273.468650286606,20266.7563730834,20260.05848160262,
	20253.375260363486,20246.707017688685,20240.054085869066,20233.416821252715,20226.79560425149,
	20220.190839263603,20213.60295450867,20207.032401769935,20200.47965604578,20193.94521510463,
	20187.429598944876,20180.933349157756,20174.457028193476,20168.001218532525,20161.566521761313,
	20155.15355755677,20148.762962581517,20142.395389292436,20136.051504667284,20129.731988856,
	20123.437533759374,20117.168841541436,20110.92662308544,20104.71159639511,20098.52448495393,
	20092.366016045984,20086.236919050167,20080.13792371294,20074.06975841052,20068.033148407827,
	20062.02881412372,20056.057469410116,20050.119819854193,20044.21656111217,20038.348377280352,
	20032.515939315366,20026.71990350711,20020.960910010323,20015.23958144584,20009.556521573806,
	20003.912314042478,19998.30752122057,19992.74268311663,19987.21831638404,19981.734913421915,
	19976.292941566004,19970.892842377125,19965.535031021995,19960.21989575291,19954.947797479854,
	19949.719069436964,19944.53401694193,19939.392917243753,19934.296019460136,19929.243544595374,
	19924.23568564551,19919.272607773935,19914.354448565253,19909.481318346585,19904.653300574035,
	19899.87045228027,19895.132804578276,19890.44036321237,19885.793109164857,19881.190999294384,
	19876.633967017926,19872.121923025905,19867.654756022977,19863.23233349397,19858.854502490933,
	19854.521090436498,19850.231905937882,19845.98673961086,19841.785364908777,19837.627538953842,
	19833.513003366563,19829.44148509336,19825.412697226184,19821.426339813897,19817.48210066279,
	19813.579656125537,19809.7186718734,19805.89880365433,19802.119698032606,19798.38099311006,
	19794.682319228064,19791.023299647193,19787.40355120833,19783.82268496984,19780.280306823137,
	19776.77601808569,19773.30941607148,19769.880094637294,19766.487644708744,19763.13165477966,
	19759.811711393704,19756.527399598064,19753.27830337968,19750.064006077755,19746.88409077512,
	19743.7381406684,19740.62573941852,19737.546471479953,19734.4999224143,19731.485679179834,
	19728.503330407988,19725.55246665852,19722.632680658444,19719.743567528134,19716.884724986994,
	19714.055753546283,19711.25625668864,19708.485841029527,19705.74411647149,19703.030696341164,
	19700.34519751371,19697.687240530824,19695.056449702806,19692.452453200807,19689.874883143017,
	19687.323375667274,19684.79757099425,19682.297113488097,19679.82165170293,19677.370838424238,
	19674.944330703674,19672.54178988514,19670.16288163176,19667.80727593288,19665.474647119725,
	19663.16467386965,19660.877039203635,19658.611430486657,19656.367539414205,19654.145062001127,
	19651.943698567156,19649.763153715918,19647.60313631303,19645.46335946108,19643.34354046864,
	19641.24340082294,19639.162666159,19637.10106621734,19635.058334814425,19633.0342098028,
	19631.028433028638,19629.040750294324,19627.07091131233,19625.118669664233,19623.183782756092,
	19621.26601177321,19619.36512163191,19617.480880935636,19615.613061927375,19613.761440440325,
	19611.925795851974,19610.105911033294,19608.301572304736,19606.512569384624,19604.738695338172,
	19602.97974653471,19601.23552259482,19599.50582634335,19597.790463762132,19596.08924393923,
	19594.401979022812,19592.728484174382,19591.068577521142,19589.422080105924,19587.78881584598,
	19586.168611483172,19584.56129653924,19582.966703270387,19581.38466662249,19579.81502418713,
	19578.257616157418,19576.71228528433,19575.178876835205,19573.65723854893,19572.147220596977,
	19570.648675541106,19569.1614582909,19567.685426067153,19566.220438360247,19564.76635688949,
	19563.3230455702,19561.890370467463,19560.46819976887,19559.056403737944,19557.654854686334,
	19556.26342693315,19554.88199677001,19553.51044243099,19552.148644053468,19550.796483647388,
	19549.453845062595,19548.1206139567,19546.7966777623,19545.481925654534,19544.17624852603,
	19542.879538951718,19541.591691158297,19540.312601001053,19539.04216592918,19537.780284962053,
	19536.526858658017,19535.28178909344,19534.044979826507,19532.81633588166,19531.595763714744,
	19530.383171194346,19529.1784675762,19527.98156347346,19526.792370842013,19525.610802947613,
	19524.436774350892,19523.27020087814,19522.11099960492,19520.959088830146,19519.814388059163,
	19518.676817977208,19517.546300433885,19516.422758420027,19515.306116048512,19514.196298537467,
	19513.0932321868,19511.99684436475,19510.90706348251,19509.823818982895,19508.747041322255,
	19507.676661946614,19506.612613281963,19505.554828716955,19504.503242577397,19503.457790125278,
	19502.418407530677,19501.38503186153,19500.35760106719,19499.33605396548,19498.32033022419,
	19497.31037035298,19496.306115679286,19495.307508347785,19494.31449129391,19493.327008240078,
	19492.34500367885,19491.368422858875,19490.397211773114,19489.4313171515,19488.47068643913,
	19487.515267794468,19486.565010070663,19485.61986280577,19484.679776215395,19483.744701175343,
	19482.814589217174,19481.88939251313,19480.96906386467,19480.053556700088,19479.142825054158,
	19478.236823566705,19477.335507467455,19476.438832569667,19475.546755260068,19474.65923248662,
	19473.776221757307,19472.897681123504,19472.023569173438,19471.15384502424,19470.28846831915,
	19469.42739920621,19468.57059834312,19467.718026881535,19466.869646467552,19466.025419221063,
	19465.185307739925,19464.34927508987,19463.517284794147,19462.689300825958,19461.865287607416,
	19461.04520999791,19460.229033289783,19459.416723197286,19458.608245856805,19457.80356781625,
	19457.00265602894,19456.205477848023,19455.412001021516,19454.622193686177,19453.836024358963,
	19453.053461932916,19452.274475676728,19451.499035218898,19450.72711055235,19449.958672021596,
	19449.193690321765,19448.43213649179,19447.673981909837,19446.91919828963,19446.167757674037,
	19445.419632428504,19444.67479524014,19443.93321911193,19443.194877356083,19442.459743589305,
	19441.72779173565,19440.998996010032,19440.273330925676,19439.550771282225,19438.83129216745,
	19438.11486894284,19437.40147725514,19436.691093018824,19435.983692419384,19435.2792519069,
	19434.577748195563,19433.87915825205,19433.183459303855,19432.490628823605,19431.80064453818,
	19431.113484410558,19430.42912665018,19429.747549699925,19429.068732238837,19428.39265317705,
	19427.719291649697,19427.04862701959,19426.380638870854,19425.71530700361,19425.052611434385,
	19424.39253239425,19423.735050321786,19423.080145862936,19422.427799869223,19421.777993392967,
	19421.130707683325,19420.485924189124,19419.843624549037,19419.203790597072,19418.56640435243,
	19417.93144801978,19417.298903990297,19416.668754832262,19416.040983297145,19415.41557231218,
	19414.792504974095,19414.171764555507,19413.55333450347,19412.937198416716,19412.323340081042,
	19411.711743427535,19411.102392556582,19410.495271727377,19409.89036535348,19409.287658006167,
	19408.687134408934,19408.08877943595,19407.492578110694,19406.898515606197,19406.30657723603,
	19405.7167484649,19405.12901489104,19404.543362258948,19403.959776451444,19403.37824348356,
	19402.79874950973,19402.221280814858,19401.645823818802,19401.07236507051,19400.50089124247,
	19399.931389142133,19399.36384569608,19398.79824795971,19398.234583108388,19397.672838435075,
	19397.113001357473,19396.555059411956,19395.99900024378,19395.44481162386,19394.892481427483,
	19394.34199765133,19393.793348393847,19393.24652186867,19392.701506402085,19392.158290416584,
	19391.616862450406,19391.07721114211,19390.539325236903,19390.00319357796,19389.468805111934,
	19388.93614888686,19388.405214047998,19387.875989836546,19387.34846559396,19386.822630756265,
	19386.2984748498,19385.775987499008,19385.255158417964,19384.735977415054,19384.218434383194,
	19383.702519307015,19383.188222264474,19382.675533410133,19382.1644429938,19381.654941346405,
	19381.147018885327,19380.640666105275,19380.135873591815,19379.632632006244,19379.130932090302,
	19378.630764666694,19378.132120638347,19377.634990985793,19377.13936676207,19376.64523910257,
	19376.15259921413,19375.66143837726,19375.17174794785,19374.683519357724,19374.196744107165,
	19373.711413766097,19373.22751997815,19372.745054456886,19372.26400898374,19371.784375409065,
	19371.30614564882,19370.829311686746,19370.35386557527,19369.879799428592,19369.40710542977,
	19368.93577581909,19368.46580290892,19367.997179066188,19367.52989672725,19367.06394838213,
	19366.599326589523,19366.13602396164,19365.67403317593,19365.213346960772,19364.75395811269,
	19364.295859479553,19363.839043966454,19363.383504535228,19362.929234209536,19362.4762260553,
	19362.024473210022,19361.573968851666,19361.124706216076,19360.67667859498,19360.229879329687,
	19359.784301818243,19359.339939501737,19358.89678587775,19358.45483449392,19358.014078949163,
	19357.574512886305,19357.136130006395,19356.698924048862,19356.26288880745,19355.828018121345,
	19355.39430588037,19354.961746016266,19354.53033250461,19354.1000593755,19353.670920695724,
	19353.242910581546,19352.816023194977,19352.390252736674,19351.96559345498,19351.54203963664,
	19351.119585620156,19350.698225775883,19350.277954521356,19349.85876631665,19349.440655655773,
	19349.023617085,19348.607645180648,19348.1927345637,19347.778879891433,19347.36607586574,
	19346.95431722179,19346.543598733973,19346.133915221337,19345.725261526106,19345.31763254552,
	19344.911023200297,19344.505428451786,19344.10084330167,19343.697262783335,19343.294681966116,
	19342.893095956275,19342.492499887132,19342.092888942305,19341.694258325653,19341.296603284598,
	19340.899919085652,19340.50420105147,19340.1094445153,19339.715644858188,19339.32279748616,
	19338.930897838745,19338.539941388808,19338.149923640125,19337.76084012615,19337.372686416013,
	19336.98545810423,19336.59915081678,19336.213760211365,19335.829281976567,19335.44571182551,
	19335.063045510837,19334.68127879913,19334.300407503593,19333.92042745139,19333.541334505346,
	19333.163124550574,19332.78579350857,19332.409337320692,19332.03375196295,19331.65903342655,
	19331.285177745525,19330.912180967898,19330.540039174397,19330.16874846865,19329.798304980548,
	19329.428704867696,19329.059944313445,19328.69201952459,19328.3249267339,19327.958662195935,
	19327.59322219825,19327.228603040337,19326.864801058102,19326.50181260487,19326.139634057334,
	19325.77826181919,19325.417692314404,19325.057921994972,19324.69894732678,19324.34076480922,
	19323.983370956554,19323.62676231023,19323.270935430497,19322.915886900017,19322.56161332893,
	19322.20811133873,19321.85537758367,19321.503408726716,19321.152201466542,19320.801752514566,
	19320.452058598792,19320.10311647672,19319.754922920863,19319.407474726668,19319.06076870886,
	19318.714801703398,19318.36957056302,19318.02507215736,19317.681303388963,19317.33826116325,
	19316.99594241486,19316.654344096383,19316.313463172315,19315.973296636766,19315.63384149403,
	19315.295094769426,19314.95705350686,19314.61971476987,19314.283075636187,19313.947133204718,
	19313.61188459046,19313.27732692532,19312.943457360223,19312.61027306299,19312.27777121648,
	19311.945949025125,19311.61480370363,19311.284332491403,19310.95453263929,19310.625401411326,
	19310.296936095074,19309.969133994757,19309.64199241871,19309.3155087086,19308.98968020757,
	19308.664504281347,19308.339978308413,19308.01609968873,19307.692865827717,19307.370274155444,
	19307.048322109607,19306.727007148693,19306.406326741362,19306.086278375347,19305.76685954846,
	19305.448067778685,19305.129900594504,19304.812355538063,19304.495430167335,19304.179122056332,
	19303.863428789864,19303.54834796668,19303.23387720326,19302.92001412388,19302.606756371035,
	19302.29410159561,19301.98204747232,19301.670591676862,19301.359731905268,19301.04946586391,
	19300.73979127696,19300.430705869796,19300.122207394365,19299.81429360554,19299.506962280255,
	19299.200211198062,19298.894038155086,19298.588440963544,19298.28341743881,19297.9789654159,
	19297.675082745038,19297.37176727337,19297.06901687669,19296.766829434066,19296.465202841388,
	19296.16413499388,19295.86362381614,19295.56366722858,19295.264263172445,19294.965409600118,
	19294.667104468324,19294.369345750027,19294.07213142763,19293.775459499237,19293.479327965095,
	19293.18373484453,19292.888678157804,19292.594155952975,19292.30016627006,19292.006707167708,
	19291.713776717723,19291.42137299589,19291.129494093188,19290.838138111223,19290.547303159197,
	19290.256987353365,19289.96718882681,19289.67790571889,19289.389136182326,19289.100878369765,
	19288.813130455637,19288.525890618246,19288.239157048483,19287.952927933748,19287.66720149518,
	19287.38197594345,19287.09724950777,19286.813020416383,19286.529286918303,19286.246047274337,
	19285.963299736995,19285.681042583336,19285.399274091313,19285.117992555617,19284.837196274442,
	19284.55688355516,19284.277052709393,19283.997702061602,19283.71882995693,19283.44043472252,
	19283.162514719104,19282.8850683027,19282.608093838295,19282.331589705762,19282.055554286384,
	19281.779985973437,19281.504883167807,19281.230244273436,19280.956067715488,19280.682351907788,
	19280.40909529282,19280.136296302127,19279.8639533887,19279.59206501545,19279.320629625392,
	19279.04964570872,19278.779111740765,19278.509026204436,19278.239387592283,19277.97019441041,
	19277.701445168048,19277.433138376804,19277.165272564307,19276.89784626026,19276.63085800454,
	19276.364306335312,19276.098189818138,19275.832507001094,19275.567256458933,19275.30243675485,
	19275.038046483063,19274.77408421951,19274.510548567574,19274.247438124483,19273.984751495365,
	19273.722487302846,19273.460644162686,19273.199220702707,19272.938215562514,19272.677627378445,
	19272.417454802628,19272.15769648444,19271.898351090433,19271.639417283375,19271.380893739177,
	19271.122779138594,19270.86507217058,19270.607771519637,19270.350875890945,19270.094383986896,
	19269.838294516125,19269.582606203083,19269.327317767536,19269.072427938056,19268.817935450446,
	19268.56383904318,19268.310137463806,19268.05682947173,19267.803913818385,19267.551389272543,
	19267.29925460299,19267.047508586107,19266.79615000635,19266.54517764575,19266.29459030172,
	19266.04438676994,19265.794565858494,19265.545126370784,19265.296067128722,19265.047386954517,
	19264.79908466703,19264.551159104307,19264.303609097533,19264.056433487636,19263.809631133638,
	19263.56320087815,19263.317141576237,19263.071452104014,19262.826131319536,19262.58117809776,
	19262.33659132329,19262.092369872895,19261.848512638055,19261.605018516206,19261.36188639668,
	19261.119115191486,19260.876703807502,19260.634651152377,19260.39295615784,19260.151617731484,
	19259.91063481443,19259.67000632665,19259.42973122071,19259.189808430358,19258.95023689869,
	19258.711015585028,19258.47214344206,19258.233619434068,19257.995442519725,19257.757611674773,
	19257.520125875493,19257.2829840934,19257.046185321044,19256.809728543296,19256.573612744916,
	19256.337836935425,19256.1024001103,19255.86730127309,19255.632539441256,19255.398113622436,
	19255.16402283346,19254.93026610299,19254.69684245413,19254.463750917464,19254.23099053711,
	19253.998560345048,19253.766459384038,19253.534686705476,19253.303241361315,19253.07212240544,
	19252.84132889529,19252.6108599082,19252.380714493742,19252.150891738474,19251.92139071549,
	19251.69221049982,19251.463350177524,19251.23480883948,19251.006585572428,19250.778679478044,
	19250.551089651948,19250.323815192303,19250.096855217882,19249.870208827662,19249.6438751431,
	19249.4178532802,19249.19214235945,19248.966741511267,19248.74164985684,19248.51686653784,
	19248.292390685267,19248.068221443027,19247.84435794799,19247.620799352895,19247.39754480815,
	19247.174593464428,19246.951944484255,19246.729597023746,19246.50755025518,19246.28580334089,
	19246.06435544965,19245.843205766338,19245.622353452436,19245.4017977057,19245.181537711334,
	19244.961572648677,19244.741901708476,19244.52252409199,19244.303438999614,19244.084645626575,
	19243.866143178635,19243.647930864317,19243.430007899515,19243.21237349398,19242.995026862813,
	19242.777967231108,19242.561193825866,19242.344705865817,19242.128502586376,19241.91258321853,
	19241.696946998534,19241.481593170396,19241.266520971898,19241.051729646173,19240.837218454802,
	19240.622986629958,19240.409033433392,19240.195358131157,19239.981959973753,19239.768838227374,
	19239.555992160924,19239.34342103734,19239.131124132164,19238.919100723873,19238.707350087996,
	19238.495871495717,19238.28466424301,19238.073727608644,19237.863060889824,19237.65266336391,
	19237.442534338035,19237.232673106417,19237.02307896716,19236.813751225603,19236.604689184147,
	19236.39589214942,19236.187359442545,19235.979090361776,19235.771084236563,19235.563340374872,
	19235.35585810702,19235.148636751397,19234.941675637096,19234.734974098134,19234.528531453652,
	19234.32234705127,19234.116420218466,19233.910750297102,19233.70533663531,19233.500178569197,
	19233.295275451088,19233.09062662801,19232.88623145699,19232.682089280184,19232.47819946382,
	19232.274561369137,19232.0711743552,19231.868037782107,19231.66515102142,19231.462513438484,
	19231.260124409935,19231.057983304352,19230.85608949927,19230.654442368468,19230.453041308654,
	19230.251885681126,19230.050974889626,19229.850308306457,19229.649885331382,19229.44970535568,
	19229.249767771176,19229.050071974983,19228.850617369433,19228.651403355234,19228.452429324978,
	19228.253694702813,19228.05519887629,19227.856941268634,19227.658921291782,19227.461138363877,
	19227.263591881696,19227.06628128721,19226.869205981777,19226.672365406837,19226.47575897152,
	19226.279386109254,19226.083246251197,19225.887338830966,19225.69166326719,19225.49621901668,
	19225.301005500376,19225.106022163847,19224.91126844635,19224.71674379972,19224.522447655472,
	19224.32837946978,19224.13453869267,19223.940924776016,19223.747537167153,19223.554375325773,
	19223.36143871351,19223.168726783668,19222.976238999287,19222.783974823204,19222.591933722422,
	19222.400115158554,19222.208518611136,19222.017143539946,19221.825989424702,19221.635055739807,
	19221.444341955113,19221.253847553664,19221.06357202187,19220.87351483172,19220.683675469012,
	19220.494053422783,19220.30464817526,19220.115459225428,19219.926486054384,19219.737728165328,
	19219.549185035346,19219.360856181607,19219.172741089154,19218.98483926268,19218.797150201983,
	19218.609673413393,19218.422408401348,19218.235354661898,19218.048511720197,19217.86187908054,
	19217.67545625719,19217.489242759784,19217.30323809704,19217.117441801332,19216.931853383798,
	19216.74647236415,19216.561298259836,19216.37633060881,19216.19156891866,19216.007012726877,
	19215.822661564533,19215.638514956296,19215.454572434905,19215.270833532195,19215.087297789865,
	19214.9039647348,19214.720833913627,19214.53790486228,19214.35517712752,19214.172650239136,
	19213.990323750557,19213.808197207567,19213.626270161803,19213.444542157267,19213.263012737887,
	19213.08168146675,19212.900547896268,19212.719611575587,19212.538872065175,19212.358328920942,
	19212.177981706147,19211.99782997514,19211.81787330402,19211.638111242744,19211.45854336035,
	19211.279169227,19211.09998840679,19210.92100047296,19210.742204994647,19210.56360154815,
	19210.385189706456,19210.20696903594,19210.02893912337,19209.85109955021,19209.67344988371,
	19209.4959897172,19209.318718626146,19209.141636193923,19208.964742007363,19208.788035655303,
	19208.611516722838,19208.4351848009,19208.259039481145,19208.083080347536,19207.90730700199,
	19207.731719039075,19207.55631605032,19207.38109763022,19207.20606338855,19207.031212918635,
	19206.856545822946,19206.682061697273,19206.5077601553,19206.333640797668,19206.159703229823,
	19205.985947058245,19205.8123718928,19205.638977350336,19205.465763030963,19205.292728551194,
	19205.119873532047,19204.947197577774,19204.7747003118,19204.602381356905,19204.430240320882,
	19204.25827682419,19204.086490491853,19203.914880950502,19203.74344781331,19203.572190716783,
	19203.401109279086,19203.23020313657,19203.05947189824,19202.888915215473,19202.71853270818,
	19202.548324008323,19202.37828875036,19202.208426573394,19202.038737102215,19201.86921998698,
	19201.699874854014,19201.53070134754,19201.361699106837,19201.19286776956,19201.024206980794,
	19200.85571638659,19200.68739563177,19200.5192443492,19200.35126220689,19200.183448835403,
	19200.015803888786,19199.848327016894,19199.681017875006,19199.513876111443,19199.346901376062,
	19199.180093330535,19199.01345162502,19198.8469759232,19198.68066587248,19198.514521137025,
	19198.348541376,19198.18272625027,19198.01707541954,19197.851588545534,19197.686265298238,
	19197.52110533811,19197.356108333574,19197.191273952067,19197.026601854974,19196.862091715695,
	19196.69774320678,19196.533555991624,19196.36952975444,19196.205664153425,19196.04195887284,
	19195.878413585422,19195.71502796399,19195.551801688696,19195.388734439377,19195.225825889083,
	19195.06307572305,19194.90048361833,19194.738049259136,19194.575772331904,19194.413652506497,
	19194.251689475546,19194.0898829329,19193.928232556344,19193.766738037266,19193.605399056392,
	19193.444215312284,19193.283186491193,19193.122312284955,19192.96159238613,19192.80102648404,
	19192.64061427833,19192.48035545664,19192.32024972575,19192.160296772832,19192.00049629887,
	19191.84084799769,19191.681351578423,19191.522006737072,19191.362813171203,19191.203770587726,
	19191.044878683017,19190.886137165333,19190.727545744136,19190.56910411559,19190.410811990303,
	19190.252669081845,19190.09467508718,19189.93682972253,19189.779132689335,19189.62158371119,
	19189.46418248895,19189.306928742622,19189.14982217377,19188.992862518426,19188.83604946728,
	19188.679382750208,19188.52286207399,19188.366487169427,19188.210257742718,19188.05417351624,
	19187.898234214816,19187.742439554473,19187.58678925678,19187.431283036607,19187.27592063788,
	19187.12070176141,19186.965626151854,19186.810693514162,19186.65590359342,19186.50125610419,
	19186.346750775254,19186.192387346327,19186.03816553417,19185.88408507148,19185.73014569301,
	19185.576347126556,19185.422689112864,19185.26917137099,19185.11579364799,19184.962555669314,
	19184.809457178806,19184.6564979026,19184.503677585475,19184.350995964174,19184.198452778113,
	19184.046047761676,19183.89378065344,19183.74165120796,19183.589659144018,19183.43780422534,
	19183.2860861882
	}}
};
