/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.spi.htmlreport;

import org.apiguardian.api.API;
import org.immutables.value.Value.Default;
import org.immutables.value.Value.Immutable;

import java.util.List;
import java.util.Optional;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * A titled section to be rendered in the HTML report.
 *
 * @since 0.2.0
 */
@Immutable
@API(status = EXPERIMENTAL, since = "0.2.0")
public interface Section {

	/**
	 * Builder for {@link Section}.
	 */
	class Builder extends ImmutableSection.Builder {
		Builder() {
		}
	}

	/**
	 * {@return a new builder for {@link Section}}
	 */
	static Builder builder() {
		return new Builder();
	}

	/**
	 * {@return the title of this section}
	 */
	String getTitle();

	/**
	 * {@return the meta information of this section}
	 *
	 * <p>This may, for example, contain a timestamp.
	 */
	Optional<String> getMetaInfo();

	/**
	 * {@return the blocks in this section}
	 */
	List<Block<?>> getBlocks();

	/**
	 * {@return the order of this section}
	 *
	 * <p>This is used to sort the all {@linkplain Contributor contributed}
	 * sections in the HTML report.
	 */
	@Default
	default int getOrder() {
		return 0;
	}

}
