#!/bin/sh
#
# Copyright (C) 2010 Yann Pouillon
#
# This file is part of the LibPSML software package. For license information,
# please see the COPYING file in the top-level directory of the source
# distribution.
#

#
# IMPORTANT NOTE:
#
#   For maintainer use only!
#
#   PLEASE DO NOT EDIT THIS FILE, AS IT COULD CAUSE A SERIOUS LOSS OF DATA.
#   *** YOU HAVE BEEN WARNED! ***
#

# Check that we are in the right directory
if test ! -s "./configure.ac" -o ! -s "src/m_psml.F90"; then
  echo "wipeout: Cowardly refusing to remove something from here!"
  exit 1
fi

# Fix permissions
chmod -R u+w .

# Remove temporary directories and files
echo "Removing temporary directories and files..."
rm -rf tmp*
find . -depth -name 'tmp-*' -exec rm -rf {} \;
find src -name '*.~[0-9]~' -exec rm -f {} \;
echo "done."

# Remove autotools files
echo "Removing autotools files..."
find src -depth -name '.deps' -exec rm -rf {} \;
find src -depth -name '.libs' -exec rm -rf {} \;
find . -name '*.pc' -exec rm {} \;
rm -f core config.log config.status stamp-h1 config.h config.h.in*
rm -rf aclocal.m4 autom4te.cache configure confstat*
(test -e config/gnu && cd config/gnu && rm -f compile config.guess config.sub depcomp install-sh ltmain.sh missing)
(test -e config/m4 && cd config/m4 && rm -f libtool.m4 ltoptions.m4 ltsugar.m4 ltversion.m4 lt~obsolete.m4)
echo "done."

# Remove Makefiles and machine-generated files
echo "Removing generated makefiles and libtool scripts..."
rm -f libtool
find . -name Makefile -exec rm {} \;
find . -name Makefile.in -exec rm {} \;
echo "done."

# Remove object files, libraries and programs
echo "Removing object files, libraries and programs..."
find src -name '*.a' -o -name '*.o' -exec rm {} \;
find src -name '*.la' -o -name '*.lo' -exec rm {} \;
find src -name '*.mod' -exec rm {} \;
find src -name '*.x' -exec rm {} \;
echo "done."

# Remove distribution files
echo "Removing distribution files..."
rm -rf libpsml-[0-9].[0-9].[0-9].[0-9]*
echo "done."
