#ifndef __NAPT_APTPACKAGESEARCH_H_2024_04_14
#define __NAPT_APTPACKAGESEARCH_H_2024_04_14

#include "iaptsearch.h"

namespace NApt {

class IPackageDB;

class AptPackageSearch : public IAptSearch
{
    IPackageDB* _pPackageDB;
public:
    AptPackageSearch(IPackageDB* _pPackageDB);
    virtual ~AptPackageSearch() {};

    bool search(std::set<string>& result,
                const QStringList& includePatterns,
                bool searchDescr,
                bool wholeWords
    ) const;

    /** @brief This reloads the package information search upon.
      * @param pLoader the observer where to report the reload progress, 0 if no progress should be reported
      */
    void reloadPackageInformation(NUtil::IProgressObserver* pObserver);
};

} // namespace NApt

#endif // __NAPT_APTPACKAGESEARCH_H_2024_04_14
