// Copyright (C) 2023 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use size file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

export class Icons {
  static readonly ExternalLink = 'open_in_new'; // Could be undefined
  static readonly UpdateSelection = 'call_made'; // Could be 'open_in_new'
  static readonly ChangeViewport = 'query_stats'; // Could be 'search'
  static readonly ContextMenu = 'arrow_drop_down'; // Could be 'more_vert'
  static readonly Menu = 'menu';
  static readonly Copy = 'content_copy';
  static readonly Delete = 'delete';
  static readonly SortedAsc = 'arrow_upward';
  static readonly SortedDesc = 'arrow_downward';
  static readonly GoBack = 'chevron_left';
  static readonly GoForward = 'chevron_right';
  static readonly Add = 'add';
  static readonly Close = 'close';
  static readonly Hide = 'visibility_off';
  static readonly Filter = 'filter_list';
  static readonly BlankCheckbox = 'check_box_outline_blank';
  static readonly Checkbox = 'check_box';
  static readonly IndeterminateCheckbox = 'indeterminate_check_box';
  static readonly ExpandDown = 'expand_more';
  static readonly ExpandUp = 'expand_less';
  static readonly Pin = 'push_pin';
  static readonly LibraryAddCheck = 'library_add_check';
  static readonly SelectAll = 'select_all';
  static readonly Deselect = 'deselect';
  static readonly Star = 'star';
  static readonly ChangeTab = 'tab';
  static readonly Crashed = 'warning';
  static readonly Change = 'change_circle';
  static readonly GoTo = 'arrow_forward';
  static readonly ContextMenuAlt = 'more_vert';
  static readonly Info = 'info';
  static readonly Warning = 'warning';
  static readonly Help = 'help';
  static readonly Download = 'download';
  static readonly Check = 'check';
  static readonly Search = 'search';
  static readonly Save = 'save';
  static readonly Undo = 'undo';
  static readonly Redo = 'redo';

  // Page control
  static readonly NextPage = 'chevron_right';
  static readonly PrevPage = 'chevron_left';
  static readonly LastPage = 'last_page';
  static readonly FirstPage = 'first_page';

  // Sorting
  static readonly SortAsc = 'arrow_upward';
  static readonly SortDesc = 'arrow_downward';
  static readonly ResetState = 'restart_alt';
  static readonly Remove = 'clear';

  // Data analysis
  static readonly Analyze = 'analytics';
  static readonly Chart = 'bar_chart';
  static readonly Pivot = 'pivot_table_chart';
  static readonly ApplyFunction = 'function';

  static readonly Play = 'play_arrow';
  static readonly Edit = 'edit';
  static readonly DragHandle = 'drag_indicator';
}
