% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cutpointr.R
\name{plot_cutpointr}
\alias{plot_cutpointr}
\title{General purpose plotting function for cutpointr or roc_cutpointr objects}
\usage{
plot_cutpointr(
  x,
  xvar = cutpoint,
  yvar = sum_sens_spec,
  conf_lvl = 0.95,
  aspect_ratio = NULL
)
}
\arguments{
\item{x}{A \code{cutpointr} or \code{roc_cutpointr} object.}

\item{xvar}{A function, typically \code{cutpoint} or a metric function.}

\item{yvar}{A function, typically a metric function.}

\item{conf_lvl}{(numeric) If bootstrapping was run and x is a cutpointr object,
a confidence interval at the level of conf_lvl can be plotted. To plot no
confidence interval set conf_lvl = 0.}

\item{aspect_ratio}{(numeric) Set to 1 to obtain a quadratic plot, e.g. for
plotting a ROC curve.}
}
\description{
Flexibly plot various metrics against all cutpoints or any other metric.
The function can plot any metric based on a \code{cutpointr} or \code{roc_cutpointr}
object. If \code{cutpointr} was run with bootstrapping, bootstrapped confidence
intervals can be plotted. These represent the quantiles of the distribution
of the y-variable grouped by x-variable over all bootstrap repetitions.
}
\details{
The arguments to \code{xvar} and \code{yvar} should be metric functions. Any metric
function that is suitable for \code{cutpointr} can also be used in \code{plot_cutpointr}.
Anonymous functions are also allowed.
To plot all possible cutpoints, the utility function \code{cutpoint} can be used.

The functions for \code{xvar} and \code{yvar} may accept any or all of the arguments
\code{tp}, \code{fp}, \code{tn}, or \code{fn} and return a numeric vector,
a matrix or a \code{data.frame}.
For more details on metric functions see \code{vignette("cutpointr")}.

Note that confidence intervals can only be correctly plotted if the values of \code{xvar}
are constant across bootstrap samples. For example, confidence intervals for
\code{tpr} by \code{fpr} (a ROC curve) cannot be plotted, as the values of the false positive
rate vary per bootstrap sample.
}
\examples{
set.seed(1)
oc <- cutpointr(suicide, dsi, suicide, boot_runs = 10)

plot_cutpointr(oc, cutpoint, F1_score)

## ROC curve
plot_cutpointr(oc, fpr, tpr, aspect_ratio = 1)

## Custom function
plot_cutpointr(oc, cutpoint, function(tp, tn, fp, fn, ...) tp / fp) +
  ggplot2::ggtitle("Custom metric") + ggplot2::ylab("value")

}
\seealso{
Other cutpointr plotting functions: 
\code{\link{plot.cutpointr}()},
\code{\link{plot_cut_boot}()},
\code{\link{plot_metric}()},
\code{\link{plot_metric_boot}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()},
\code{\link{plot_x}()}
}
\concept{cutpointr plotting functions}
